PROGRAM Sort_Conference_Participation_Tracker_Database;
{$M 5120,0,655360}
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I-} {disable I/O checking - trap errors by checking IOResult}
USES CRT, DOS, NUMDAYS, CPT_COMN;

VAR SavedExitProc: Pointer;

{===========================================================================}

procedure CustomExit; far;
{---- Always exit through here ----}
const
  progdesc = 'CPT-Sort - Free DOS utility: Sort CPT Database.';
  usage    = 'Usage: CPT-Sort <CPT file> <sort order(s) [see below]>';
  name_a   = '    name     = sort by first name, ascending (A to Z)';
  name_d   = '   -name     = sort by first name, descending (Z to A)';
  sent_a   = '    sent     = sort by messages sent, ascending (fewest messages at top)';
  sent_d   = '   -sent     = sort by messages sent, descending (most messages at top)';
  oldest_a = '    oldest   = sort by oldest message, ascending (new people at end)';
  oldest_d = '   -oldest   = sort by oldest message, descending (new people at top)';
  newest_a = '    newest   = sort by newest message, ascending (current posters at end)';
  newest_d = '   -newest   = sort by newest message, descending (current posters at top)';
  example1 = 'Example:  CPT-Sort cnf_100.dat -sent';
  example2 = 'Example:  CPT-Stat 67.mem -sent name';

begin
  ExitProc := SavedExitProc;
  cursorOn;
  if (ExitCode > 0) then begin
    writeln(progdesc);
    writeln(author);    writeln;
    writeln(usage);     writeln;
    writeln(name_a);    writeln(name_d);
    writeln(sent_a);    writeln(sent_d);
    writeln(oldest_a);  writeln(oldest_d);
    writeln(newest_a);  writeln(newest_d);  writeln;
    writeln(example1);
    writeln(example2);  writeln;
  end;
  if ErrorAddr <> nil then
  begin
    writeln('An unanticipated error occurred, please contact DDA with the following data:');
    writeln('Address = ', Seg(ErrorAddr^), ':', Ofs(ErrorAddr^));
    writeln('Code    = ', Exitcode);
    ErrorAddr := nil;
  end
  else
    if (ExitCode > 0) and (ExitCode < 255) then
      WriteError(ExitCode);
end;
{===========================================================================}

VAR MemberInfo  : MemLink;
    Members     : word;
    MemFileName : pathstr;
    PCount      : byte;

BEGIN
  SavedExitProc := ExitProc;
  ExitProc := @CustomExit;

  if ParamCount < 2 then halt(255);

  MemFileName:=GetMFN(ParamStr(1));
  if NOT fileexists(MemFileName) then halt(1);
  writeln('CPT-Sort resorting ',MemFileName);
  Members:=BuildList(MemberInfo, MemFileName); writeln;

  if MemberInfo <> nil then begin
    for PCount := ParamCount downto 2 do begin
      GetSortField(ParamStr(Pcount));
      SortLinkedList(MemberInfo); writeln;
    end;
    WriteList(MemberInfo, MemFileName, Members); writeln;
  end;
  writeln('Mission accomplished!');
END.
