PROGRAM Conference_Participation_Tracker;
{$M 5120,0,409600}  { 400k reserved for data }
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I-} {disable I/O checking - trap errors by checking IOResult}
USES CRT, DOS, NUMDAYS, CPT_COMN;

VAR SavedExitProc: Pointer;

{===========================================================================}

procedure CustomExit; far;
{---- Always exit through here ----}
const
  progdesc = 'CPT - Free DOS utility: Conference Participation Tracker.';
  usage    = 'Usage: CPT <QWKfile(s)> <CPT file>';
  note1    = 'Note:  <CPT file>  is any DOS filename, with an embedded conference number,';
  note2    = '                   and with or without a file extension.';
  examples = 'Examples:';
  example1 = '    CPT \qwks\kandy.qwk 123';
  example2 = '    CPT channel1.qw* cnf_456.mem';
  example3 = '    CPT c:\qwk\lun*.qwk c:\conf\mem_78.dat';
  example4 = '    CPT *.qwk 90';

begin
  ExitProc := SavedExitProc;
  cursorOn;
  if (ExitCode > 0) then begin
    writeln(progdesc);
    writeln(author);    writeln;
    writeln(usage);     writeln;
    writeln(note1);     writeln(note2);     writeln;
    writeln(examples);  writeln;
    writeln(example1);
    writeln(example2);
    writeln(example3);
    writeln(example4);  writeln;
  end;
  if ErrorAddr <> nil then
  begin
    writeln('An unanticipated error occurred, please contact DDA with the following data:');
    writeln('Address = ', Seg(ErrorAddr^), ':', Ofs(ErrorAddr^));
    writeln('Code    = ', Exitcode);
    ErrorAddr := nil;
  end
  else
    if (ExitCode > 0) and (ExitCode < 255) then
      WriteError(ExitCode);
end;
{===========================================================================}

VAR MemberInfo  : MemLink;
    Members     : word;
    MemFileName : pathstr;

    QWKpath    : pathstr;    { QWK file path.          }
    QWKdir     : dirstr;     { QWK file dir.           }
    dirinfo    : searchrec;  { contains filespec info. }

BEGIN
  SavedExitProc := ExitProc;
  ExitProc := @CustomExit;

  if ParamCount <> 2 then halt(255);
  GetSortField('NAME');
  InitArcQWK;

  MemFileName:=GetMFN(ParamStr(2));
  writeln('CPT - Conference Participation Tracker');
  writeln('CPT ', version, ' updating ',MemFileName);
  write('Reserving 400k lower memory for data ... done!'); WriteMemAvail;
  Members:=BuildList(MemberInfo, MemFileName); WriteMemAvail;
  QWKdir:=GetQWKdir(ParamStr(1), QWKpath);

  findfirst(QWKpath, archive, dirinfo); if doserror <> 0 then halt(2);
  while doserror = 0 do
  begin
    write('Reading ',QWKdir+dirinfo.name,' ... ');
    EraseFile(DATFileName);
    if ExtractDAT(QWKdir+dirinfo.name, DATFileName) then begin
      if CONFname = '' then
        CONFname:=GetCONFname(QWKdir+dirinfo.name, CNFFileName);
      Members:=Members+ReadDAT(MemberInfo, DATFileName);
        write('done!');  WriteMemAvail;
      EraseFile(DATFileName);
    end
    else
      writeln('bad QWK - skipping.');
    findnext(dirinfo);
  end;

  if MemberInfo <> nil then begin
    SortLinkedList(MemberInfo); WriteMemAvail;
    WriteList(MemberInfo, MemFileName, Members); WriteMemAvail;
  end;
  writeln('Mission accomplished!');
END.
