{$X- function calls may not be discarded}
UNIT NumDays;

INTERFACE

  CONST DaysPerYear = 365;
  TYPE Month = (Jan, Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec);
       Date = RECORD
                da: 1..31;
                mo: Month;
                yr: 1..9999
              END;

   VAR maxDay: ARRAY [Month] OF INTEGER;
       daysBefore: ARRAY [Month] OF INTEGER;

  PROCEDURE MonthsInit;
  FUNCTION NumOfDays(CONST d: Date): LONGINT;
{ contains FUNCTION IsLeapYear(Const yr: INTEGER): BOOLEAN;   }
  FUNCTION Num_Days(CONST d: string): LONGINT;

IMPLEMENTATION

  PROCEDURE MonthsInit;
    VAR mo: Month;
  BEGIN
    maxDay[Jan] := 31;
    maxDay[Feb] := 28;  (* adjust for leap years later *)
    maxDay[Mar] := 31;
    maxDay[Apr] := 30;
    maxDay[May] := 31;
    maxDay[Jun] := 30;
    maxDay[Jul] := 31;
    maxDay[Aug] := 31;
    maxDay[Sep] := 30;
    maxDay[Oct] := 31;
    maxDay[Nov] := 30;
    maxDay[Dec] := 31;

    daysBefore[Jan] := 0;
    FOR mo := Jan TO Nov DO
      daysBefore[Month(ORD(mo)+1)] := daysBefore[mo] + maxDay[mo]
  END;

  FUNCTION NumOfDays(CONST d: Date): LONGINT;
    (* NumOfDays returns an ordinal value for the date
       with January 1, 0001 assigned the value 1.    *)

    FUNCTION IsLeapYear(Const yr: INTEGER): BOOLEAN;
    BEGIN
      IsLeapYear := ((yr MOD 4 = 0) AND (yr MOD 100 <> 0)) OR (yr MOD 400 = 0)
    END;

    VAR result, lYr: LONGINT;
  BEGIN
    WITH d DO BEGIN
      lYr:=yr-1;
      result := (da);
      INC(result, daysBefore[mo]);
      INC(result,lYr * DaysPerYear);
      INC(result, ((lYr DIV 4) - (lYr DIV 100) + (lYr DIV 400)));
      IF (mo > Feb) AND IsLeapYear(yr) THEN INC(result)
    END;
    NumOfDays := result
  END;

  FUNCTION Num_Days(CONST d: string): LONGINT;
  VAR
    dateRec : Date;
    Tmonth,
    VErr    : integer;
  BEGIN
    with dateRec do begin
      Val(Copy(d,4,2),da,VErr);
      Val(Copy(d,1,2),Tmonth,VErr);
      mo := Month(TMonth-1);
      Val(Copy(d,7,2),yr,VErr);
      yr :=1900+yr;
    end;
    Num_Days:=NumOfDays(dateRec);
  END;

BEGIN
  MonthsInit         { for NumDays procedure }
END.
