/***************************************************************************/
/*                                                                         */
/* MaxUserREXX script to Set Expiry Information                            */
/*                                                                         */
/* This script needs a command line argument, the name of the LASTUSxx.BBS */
/* file for the node that the user you want to work with is on.            */
/*                                                                         */
/* From a menu selection use something like:                               */
/*                                                                         */
/*  Multi-Node:                                                            */
/*                                                                         */
/*   ReRead  Xtern_Dos  SetExp.Cmd_LASTUS%K.BBS  Disgrace  "Upgrade Me"    */
/*                                                                         */
/*  Single Node:                                                           */
/*                                                                         */
/*   ReRead  Xtern_Dos  SetExp.Cmd_LASTUSER.BBS  Disgrace  "Upgrade Me"    */
/*                                                                         */
/* From a mecca file:                                                      */
/*                                                                         */
/*   [xtern_dos]@D:\Max\SetExp.Cmd LASTUS%K.BBS                            */
/*                                                                         */
/***************************************************************************/

'@echo off'

Parse Arg LastUserBBS .

Call RxFuncAdd 'UserLoadFuncs', 'MaxUser', 'UserLoadFuncs'
Call UserLoadFuncs

Signal On Syntax Name SyntaxError

uPriv   = 'NORMAL'          /* Priviledge level to give user */
xType   = 'DAYS'            /* Expiry time will be in days */
xTime   = 30                /* Give them 30 days to play */
xAction = 'DEMOTE'          /* We want to demote user priv after expiry */
xPriv   = 'DISGRACE'        /* Priviledge to demote to after trial period */

userCount = OpenUserFile(LastUserBBS)

if userCount <> 'ERROR' Then Do
    Call SetUserPriviledge 0, uPriv
    Call SetUserExpiryInfo 0, xType, xTime, xAction, xPriv
    Call CommitUser 0
    Call CloseUserFile
End

SyntaxError:
Call UserDropFuncs
Exit 0
