/***********************************************************************\
 *                              WPS2PC2.c                              *
 *              Copyright (C) by Stangl Roman, 1994, 1995              *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed, under the conditions indicated in the documentation.       *
 *                                                                     *
 * WPS2PC2.C    PC/2's interface to the WPS. This WPS DLL allows you   *
 *              to drag WPS objects onto, which are then converted     *
 *              into a format understandable by PC/2. This newly       *
 *              structure can then be dropped onto PC/2's Setup dialog *
 *              to add Menuentries corresponding to the dropped WPS    *
 *              objects to PC/2's Popup Menu. E.g. this allows you to  *
 *              create a Menuentry that is equivalent to a WPS DOS     *
 *              program object, inclusive any DOS settings.            *
 *                                                                     *
 * SOMObject                                                           *
 *    WPObject                                                         *
 *       WPAbstract                                                    *
 *                                                                     *
\***********************************************************************/

include         <wpabs.sc>

class:          Wps2Pc2,
                external stem   = Wps2Pc2,
                local,
                external prefix = Wps2Pc2X_,
                classprefix     = Wps2Pc2C_,
                major version   = 1,
                minor version   = 1,
                file stem       = Wps2Pc2;

parent:         WPAbstract;

passthru:       C.ph;
endpassthru;

#
# Pass to .ih file
#
passthru:       C.ih;
static char RCSID[]="@(#) $Header: WPS2PC2.c Version 1.80 01,1995 $ (LBL)";

#define         _FILE_  "PC/2 - WPS2PC2.c V1.80"

#include        "PC2.h"                 /* User include files */

#define         INCL_WPCLASS
#define         INCL_WPFOLDER
#include        <pmwp.h>

                                        /* Menu ID for "Open->WPS 2 PC/2" */
#define ID_WPS2PC2OPENMENU      (WPMENUID_USER+1)
                                        /* Menuitem ID for "Open->WPS 2 PC/2" */
#define ID_WPS2PC2OPEN          (WPMENUID_USER+2)
#define DebugBox(title, text) \
                              \
           WinMessageBox(     \
              HWND_DESKTOP,   \
              HWND_DESKTOP,   \
              (PSZ) text,     \
              (PSZ) title,    \
              20,             \
              MB_OK | MB_INFORMATION | MB_MOVEABLE)
endpassthru;

#
# Pass to .h file
#
passthru:       C.h, after;
MRESULT EXPENTRY WPS2PC2_MainWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
void            FillList2Listbox(WPSOBJECTLIST *pListRoot,
                                 ULONG ulRecursionLevel);
WPSOBJECTLIST  *ConvertObject2MenuData(WPObject *pwpObject,
                                       ULONG ulRecursionLevel);
PBYTE           AllocateSharedMem(void);
PBYTE           GetFreeSharedMem(ULONG ulSharedMemSize);
void            DeAllocateSharedMem(void);
#pragma linkage(_Exception, System)
ULONG           _Exception(PEXCEPTIONREPORTRECORD pExcRepRecord,
                           PEXCEPTIONREGISTRATIONRECORD pExcRegRecord,
                           PCONTEXTRECORD pCtxRecord,
                           PVOID  pVoid);
endpassthru;

#
# Define instance data
#
data:
VOID           *pVoid;                  /* Define some data to force a (dummy) GetData */

#
# Define new methods
#
methods:
/*--------------------------------------------------------------------------------------*\
 * Instance override methods.                                                           *
\*--------------------------------------------------------------------------------------*/
override        wpDragOver;
--
-- OVERRIDE: wpDragOver                                                     ( ) Private
--                                                                          (x) Public
-- DESCRIPTION:
--      Called when a WPS Object is dragged over the WPS 2 PC2 icon. Accept object if
--      rendering method DRM_OBJECT and format DRF_OBJECT.
--
override        wpDrop;
--
-- OVERRIDE: wpDrop                                                         ( ) Private
--                                                                          (x) Public
-- DESCRIPTION:
--      Called when a WPS Object was dropped over the WPS 2 PC2 icon. Query all objects
--      dropped, allocate a unnamed shared memory, copy object data into and allow this
--      shared memory to be dragged to PC/2, which will add Menuentries according to
--      the objects dropped.
--

override        wpModifyPopupMenu;
--
-- OVERRIDE: wpModifyPopupMenu                                              ( ) Private
--                                                                          (x) Public
-- DESCRIPTION:
--      Overwrite to add the "Open->WPS 2 PC/2" menuitem to the "Open->" context menu.
--
override        wpMenuItemHelpSelected;
--
-- OVERRIDE: wpMenuItemHelpSelected                                         ( ) Private
--                                                                          (x) Public
-- DESCRIPTION:
--      Called when receiving an help event from our menuitem we added to the context menu.
--
override        wpMenuItemSelected;
--
-- OVERRIDE: wpMenuItemSelected                                             ( ) Private
--                                                                          (x) Public
-- DESCRIPTION:
--      Called when receiving an event from our menuitem we added to the context menu.
--
override        wpOpen;
--
-- OVERRIDE: wpOpen                                                         ( ) Private
--                                                                          (x) Public
-- DESCRIPTION:
--      Called when the WPS2PC2 WPS icon gets opened via the context menu.
--
/*--------------------------------------------------------------------------------------*\
 * Class override methods.                                                              *
\*--------------------------------------------------------------------------------------*/
override        wpclsQueryIconData, class;
--
-- OVERRIDE: wpclsQueryIconData                                             ( ) Private
--                                                                          (x) Public
-- DESCRIPTION:
--      Called when querying the class's icon.
--
override        wpclsInitData, class;
--
-- OVERRIDE: wpclsInitData                                                  ( ) Private
--                                                                          (x) Public
-- DESCRIPTION:
--      Called during class initalization.
--
override        wpclsUnInitData, class;
--
-- OVERRIDE: wpclsUnInitData                                                ( ) Private
--                                                                          (x) Public
-- DESCRIPTION:
--      Called during class termination.
--
override        wpclsQueryDefaultHelp, class;
--
-- OVERRIDE: wpclsQueryDefaultHelp                                          ( ) Private
--                                                                          (x) Public
-- DESCRIPTION:
--      Add default halp panels for WPS2PC2.
--
override        wpclsQueryDefaultView, class;
--
-- OVERRIDE: wpclsQueryDefaultView                                          ( ) Private
--                                                                          (x) Public
-- DESCRIPTION:
--      Returns the default view for a new instance of this object, but WPS2PC2 should
--      be used only once, we just tell what the default open view is.
--
override        wpclsQueryStyle, class;
--
-- OVERRIDE: wpclsQueryStyle                                                ( ) Private
--                                                                          (x) Public
-- DESCRIPTION:
--      Returns the default style, used to inhibit creation of shadows, copies or
--      templates because WPS 2 PC/2 supports only one instance systemwide.
--

