/* REXX */
/*
     OS/2 WARP REXX script to redial a PPP provider when busy. 

      Written by: Don Russell (c) April 1995
      send email to drussell@direct.ca

Change log: (most recent first)
     15 April 1995  Version 2.1
                    Fix trapping of hung connection (dropped
                       by V2.0 changes)
     14 April 1995: Version 2.0
                    Recognize CARRIER ... response from some 28.8 modems
                    Support multiple phone numbers
                    Get userid/password from dialer
                    Get timing info from modem instead of "hard coded"
                    Support response after login
      8 April 1995: Original

A note about distribution.... This script may be distributed freely provided
I am given credit for it. Please do not alter my name or email address
nor the manner in which they are displayed.

If you have comments regarding this script let me know by email. I'll
support it as time permits, and my ability ;-)

NOTE: I've tested this as well as I can with a single provider. Given the many
providers and configurations, this may not work properly the first time.

pause

Specific things to watch for are the EXACT prompts used when the host
system is asking for a userid and password. (see line 93/94 in pppdial.cmd)

After the script has been placed in the correct directory...

       - start the "dial other internet provider"
       - use modify entry (or add entry)
       - in the 'Login sequence:' field enter
               pppdial.cmd <pause | *> <response file>
            where <pause> is the number of seconds to wait between dial
            attempts. The default is 10 seconds.
                  <response file> is referred to after a successful connection.
                   see below for file format
       - save the changes
       - installation complete

pause

ADVANCED FEATURES:  (at least my wife didn't understand :-)

MULTIPLE PHONE NUMBERS
The "phone number" specified in the dialer field may be a list separated
by spaces. i.e 555-1212 800-123-4567, or it may be a file name which contains
a list of phone numbers, one on each line.

pause
RESPONSE FILE
Format of the "response file":

The response file is useful for systems that present a menu or
require further interaction after entering a userid and password.

The first line of the response file is a "synchronization" keyword to
indicate whether we are to wait for a prompt, or do we need to start by
sending. The keyword must be either GO or WAIT

Lines in the file are used in pairs: assuming we wait for a prompt after
logging in, the first line will be WAIT, the second line is what we wait
for, the third line is what we send in response...

If WE must "start" the conversation after logging in, the first line
in the file will be GO and the second line will be sent right away. 
We will wait for the system to reply with what we have in line 3 and
so on.

pause
FUTURE ENHANCEMENTS

The only changes I have PLANNED are to be able to start other programs
by use of the "response file". I'm having problems with the SysStartObject
API when used within the dialer app for some reason, so I don't know when
I'll get to this.

stop-----------------------------------------------------------------*/

/* ************************************************************** */
/*   YOU MAY NEED TO CHANGE THE FOLLOWING CONFIGURATION VARIABLES.   */
/*                                                                                                         */

ModemResetCommand = 'ATH0Z'
ModemEscapeSequence = '+++'
LoginPrompt = 'ogin:'
PasswordPrompt = 'ssword:'

/*                                                                                                         */
/* DO NOT CHANGE ANYTHING AFTER THIS POINT. */
/*   (unless you are familiar with REXX and do not use the IBM Dialer)      */
/* **************************************************************** */

/* A note to users of my first version of this script: */
/* I used to support the dial command, userid and password as parameters */
/* or coded here as k1=, k2= and k3= */
/* I did not like this because I felt it better to get them from the dialer */
/* where it is a little more intuitive and easier for people who know nothing of REXX */

/* For those of you who wish to use this script withOUT the dialer... */
/* change the next line to say UseDialer=0 (false) and define the appropriate labels */
/* (When UseDialer is 1, these variables are reassigned later from the dialer info) */

UseDialer = 1    /* yes, we're using the IBM "Dial Other..." */
prefix = 'ATDT'       /* add any other commands required */
PhoneNumber = 'xxx-xxxx'   /* may be a blank delimited list, or file name */
LoginId = 'userid'
Password = 'password'

/*                                                                                                         */
/* DO NOT CHANGE ANYTHING AFTER THIS POINT. */
/* **************************************************************** */

call rxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

parse upper source . . MyDrivePathName
etcDrivePath = translate( value( 'etc',,'OS2ENVIRONMENT') )
iniFile = etcDrivePath || '\TCPOS2.INI'

/* before we get too carried away, let's see what we're doing... */

if RxFuncQuery( 'ppp_com_input' ) = 1 then do
   if RxFuncQuery( 'slip_com_input' ) = 0 then do
      call lineout ,'This script is for PPP only.'
      call lineout ,'Your dialer is set for SLIP.'
      call lineout ,'Change your dialer and try again.'
      call sysSleep 60
      exit 0
   end  /* Do */
   
   call NotFromDialer
   exit 0
end  /* Do */

parse arg interface , port , . , pause , RFile

if ((pause = '') | (pause = '*')) then pause = 10
if \datatype( pause, 'N' ) then do
   call lineout , 'invalid time delay specified - 10 sec assumed'
   pause = 10
end  /* Do */

pause = max( 2, pause )       /* A 2 sec min is required to guarantee dial tone */

if RFile \= '' then do
   RFile = stream( RFile, 'C', 'QUERY EXISTS' )
   if RFile = '' then do
       call lineout , 'Response file not found.'
       call lineout , 'Processing ended.'
       exit 8
   end  /* Do */
   
   x = linein( RFile )
   select
      when x = 'GO' then ResponseToggle = 1
      when x = 'WAIT' then ResponseToggle = 0
   otherwise do
         call lineout , 'First line of response file must be START or WAIT'
         call lineout , 'Processing ended.'
         exit 8
      end /* otherwise */
   end  /* select */
end  /* Do */

/*--------------------------------------------------------------------------*/
/*                   Initialization and Main Script Code                    */
/*--------------------------------------------------------------------------*/

/* Set some definitions for easier COM strings */
cr='0d'x
crlf='0d0a'x

UsePhoneNumberFile = 0
UsePhoneNumberList = 0
init1 = ''
init2 = ''
Disable = 0

if UseDialer then do

    /* Get userid/password from the dialer */
    ConnectTo = SysIni( iniFile, 'CONNECTION', 'CURRENT_CONNECTION' )

    Init1 = Strip( SysIni( iniFile, ConnectTo, 'INIT' ), 'T', '00'x )
    Init2 = Strip( SysIni( iniFile, ConnectTo, 'INIT2' ), 'T', '00'x )
    Prefix = Strip( SysIni( iniFile, ConnectTo, 'PREFIX' ), 'T', '00'x )
    PhoneNumber = Strip( SysIni( iniFile, ConnectTo, 'PHONE_NUMBER' ), 'T', '00'x )
    LoginId = Strip( SysIni( iniFile, ConnectTo, 'LOGIN_ID' ), 'T', '00'x )
    Password = Strip( SysIni( iniFile, ConnectTo, 'PWD' ), 'T', '00'x )
    Disable = Strip( SysIni( who, ConnectTo, 'DISABLE' ), 'T', '00'x )
    DisableSequence = Strip( SysIni( who, ConnectTo, 'DISABLE_SEQUENCE' ), 'T', '00'x )

    Disable = ( Disable = 'TRUE' )
end /* Do */

/* The "phone number" may be a list of numbers, or a file spec of a list of numbers. */
if words( PhoneNumber ) > 1 then do
   /* Yup, it's a list itself... */
   UsePhoneNumberList = 1
   PhoneNumberList = PhoneNumber
   PhoneNumberListSize = words( PhoneNumber )
end  /* Do */
else do
   PhoneNumberFile = stream( PhoneNumber, 'C', 'QUERY EXISTS' )
   if PhoneNumberFile \= '' then do
      UsePhoneNumberFile = 1
   end  /* Do */
   else /* it's not a list or a (found) file... */
       DialCmd = BuildDialCmd( 0 )
   end /* else */

/* Flush any stuff left over from previous COM activity */
call flush_receive

call ResetModem

/* How long will the modem wait for carrier? */
/* We have to wait a bit longer for a response then... */

call lineout , 'Determining modem timeout value...'
call send 'ATS7?' || cr  
x = GetResult( 2 )
parse var x ModemRegS7 '0d'x .
if \datatype( ModemRegS7, 'N') then
   ModemRegS7 = 60

FirstTime = 1
do count = 1 by 1

    connected = 0

    if (UsePhoneNumberList | UsePhoneNumberFile) then do
        DialCmd = BuildDialCmd( count )
    end /* Do */

    if \FirstTime then do
       call lineout , 'Waiting' pause 'seconds before try' count
       call lineout , '  PPPDIAL V2.1 by: Don Russell (c) Apr 1995'
       call lineout , '                   drussell@direct.ca'
       call sysSleep pause
    end  /* Do */
    FirstTime = 0

    /* Dial the remote server */
    call charout , 'Dialing...'

    /* Wait for connection */
    call send dialcmd || cr
 
    do until left( ResultCode, 7) \= 'RINGING'
       ResultCode = getresult( ModemRegS7 + 10 )
    end /* Do until */

    select
       when left( ResultCode, 4 ) = 'BUSY' then nop
       when left( ResultCode, 7 ) = 'CONNECT' then connected = 1
       when left( ResultCode, 7 ) = 'CARRIER' then connected = 1 
       when left( ResultCode, 10 ) = 'NO CARRIER' then nop
       when left( ResultCode, 5 ) = 'ERROR' then exit 8
    otherwise call ResetModem  /* I don't know if the modem is on/off hook here :-(  */
    end  /* select */

    if \connected then do
       iterate
    end
   
   /* I have problems where I get connected, but then the host doesn't */
   /* prompt for a login id/password... :-(                   */

   call waitfor LoginPrompt, 30
   if result = 1 then do
      call lineout , 'Host is not responding.'
      call ResetModem
      iterate
   end  /* Do */
   
   call send loginId || cr

   call waitfor PasswordPrompt, 30
   if result = 1 then do
      call lineout , 'Host is not asking for password.'
      call ResetModem
      iterate
   end  /* Do */
   
   call send password || cr

   /* We've logged on successfully... is there a response file to */
   /* process? */
   RFileProcessed = 1    /* we'll assume success :-)  */
   if RFile \= '' then do
       do while lines( RFile ) & RFileProcessed
          x = linein( RFile )
          if left(x, 5) = 'START' then
              x   /* give the start command to OS/2 */
          else do
             if ResponseToggle then
                 call send x || cr
             else do
                 waitfor x, 20
                 if result = 1 then do
                     call lineout , 'Host not responding'
                     RFileProcessed = 0   /* terminate processing and dial again :-(  */
                 end /* Do */
             end /* Do */
             ResponseToggle = \ResponseToggle
          end  /* Do */
       end /* While */
       call lineout RFile /* close the file */
   end  /* Do */
   
   if RFileProcessed then
      leave                   /* force the end of the loop */
end /* do */

if UsePhoneNumberFile then
   call lineout PhoneNumberFile  /* close the phone number file */

call beep 262, 250
call beep 294, 250

exit 0

BuildDialCmd:
   Parse arg item
   DialCmd = Prefix
   If Disable then
      DialCmd = DialCmd || DisableSequence
     
   /* The phone number may be a group... get the next in the list/file */
   select
      when UsePhoneNumberList then do
          x = (item // PhoneNumberListSize) + 1
          num = word( PhoneNumberList, x )
      end  /* Do */
      when UsePhoneNumberFile then do
         FileWrapped = 0
         do until num \= ''
             num = linein( PhoneNumberFile )
             if num = '' then do
                if FileWrapped then do
                   call lineout ,'Phone number file appears empty.'
                   exit 8
                end  /* Do */
                call linein PhoneNumberFile, 1, 0 /* re-point to start */
                FileWrapped = 1
             end  /* Do */
         end  /* Do until */
      end /* Do when */
   otherwise
      num = PhoneNumber
   end  /* select */

   DialCmd = DialCmd || num
   return DialCmd

ResetModem:
    call lineout , 'Initializing modem...'
    if init1 \= '' then do
       call send init1 || cr
       ResultCode = GetResult( 6 )
    end  /* Do */
    if init2 \= '' then do
       call send init2 || cr
       ResultCode = GetResult( 6 )
    end  /* Do */

    if ((init1 = '') & (init2 = '')) then do
       call send ModemResetCommand || cr
       ResultCode = GetResult( 6 )
    end  /* Do */
    
    if left(ResultCode , 2) \= 'OK' then do
        call lineout , 'Modem not resetting... Trying again'
        call sysSleep 2
        call send ModemEscapeSequence
        call waitfor crlf, 5
        call send 'ATH0Z' || cr
        call getresult 3
    end /* Do */
    call flush_receive 'echo'
return

/* Routine to send a modem command. */

send:
   parse arg AtCmd
   call flush_receive
   call ppp_com_output interface , AtCmd

   return


/*--------------------------------------------------------------------------*/
/*                    getresult( [timeout] )                                */
/*                                                                          */
/* Waits for any modem response, and returns the string.    */

/* If timeout is specified, it says how long to wait if data stops showing  */
/* up on the COM port (in seconds).                                                         */
/*                                                                          */
/*--------------------------------------------------------------------------*/

getresult:

   parse arg timeout

   call waitfor crlf, timeout
   if result = 0 then
      call waitfor crlf, timeout

   if result = 1 then /* timed out */
      return '*timedout*'
   else
      return waitfor_buffer


/*--------------------------------------------------------------------------*/
/*                    waitfor ( waitstring , [timeout] )                    */
/*                                                                          */
/* Waits for a specific string from the modem. */
/* Timeout is specified in seconds.  */

waitfor:

   parse arg waitstring , timeout

   if timeout = '' then do
      timeout = 90    /* 1.5 minutes if delay not specified */
   end

   waitfor_buffer = ''
   done = -1
   curpos = 1

   if (remain_buffer = 'REMAIN_BUFFER') then do
      remain_buffer = ''
   end

   call time 'E'
   do while (done = -1)
      if (remain_buffer \= '') then do
         line = remain_buffer
         remain_buffer = ''
       end
       else do
         line = ppp_com_input(interface,,10)
      end
      waitfor_buffer = waitfor_buffer || line
      index = pos(waitstring,waitfor_buffer)
      if (index > 0) then do
         remain_buffer = substr(waitfor_buffer,index+length(waitstring))
         waitfor_buffer = delstr(waitfor_buffer,index+length(waitstring))
         done = 0
      end
      call charout , substr(waitfor_buffer,curpos)
      curpos = length(waitfor_buffer)+1
      if ((done \= 0) & (time('E')>timeout)) then do
        call lineout , ' WAITFOR: timed out '
        done = 1
       end
   end

 return done

/*--------------------------------------------------------------------------*/
/*                             flush_receive()                             */
/*                                                                          */
/* Routine to flush any pending characters to be read from the COM port.    */
/* Reads everything it can until nothing new shows up for 100ms, at which   */
/* point it returns.                                                        */
/*                                                                          */
/*--------------------------------------------------------------------------*/

flush_receive:

   parse arg echo

   /* If echoing the flush - take care of waitfor remaining buffer */
   if (echo \= '') & (length(remain_buffer) > 0) then do
      call charout , remain_buffer
      remain_buffer = ''
   end

   /* Read anything left in the modem or COM buffers */
   /* Stop when nothing new appears for 100ms.      */

   do until line = ''
     line = ppp_com_input(interface,,100)
     if echo \= '' then
        call charout , line
   end

   return

NotFromDialer:
    parse upper source . . MyDrivePathName
    MyDrive = filespec( 'D', MyDrivePathName )
    MyPath = filespec( 'P', MyDrivePathName )
    MyDrivePath = MyDrive || MyPath

    etcDrivePath = translate( value( 'etc',,'OS2ENVIRONMENT') )
    binDrive = filespec( 'D', etcDrivePath )
    binPath = filespec( 'P', etcDrivePath ) || 'BIN\'
    binDrivePath = binDrive || binPath

    EraseFile = 0
    if binDrivePath \= MyDrivePath then do
        say 'This script will be moved to' binDrivePath
        say 'Do you wish to continue? (y/n)'
        say '(Saying no will still show help)'
        answer = translate( sysGetKey( 'ECHO' ) )
        if answer = 'Y' then do
            'COPY' MyDrivePathName binDrivePath
            if rc = 0 then do
               say MyDrivePathName 'will be erased after displaying help'
               EraseFile = 1
            end
           '@PAUSE'
           call sysCls
        end /* Do */
    end  /* Do */

    call sysCls
    stop = 0
    do i = 3 by 1 until stop
       x = sourceline( i )
       if left( x, 5 ) = 'pause' then do
          '@PAUSE'
          call sysCls
          iterate
       end  /* Do */
       
       if left( x, 4 ) \= 'stop'  then
          say x
       else
          stop = 1
    end /* do */
    '@PAUSE'
    if EraseFile then
        'ERASE' MyDrivePathName
return
