#include "ctype.h" 
#include "csa.h" 
#include "csdb.h" 

#define NAME_LENGTH	 40 
#define ADDRESS_LENGTH	 30 
#define CITY_LENGTH	 20 

////////// Indexes to be used with the 'order()' function./////////////
#define UNSORTED	 0
#define NAME_INDEX	 1 
#define ADDRESS_INDEX	 2 
#define CITY_INDEX	 3 

typedef struct 
{
   char   _name[NAME_LENGTH+1]; 
   char   _address[ADDRESS_LENGTH+1]; 
   char   _city[CITY_LENGTH+1]; 
   long   __birthday; 
   float  _salary; 
} nac_record;

class NAC
{
 protected:

   nac_record rec;
   nac_record *recp;

   long current;
   int  dirty;
   int  is_open;


   void (NAC::*skip_fun)(int delta);
   void (NAC::*top_fun)(void);
   void (NAC::*bottom_fun)(void);
   int  (NAC::*search_fun)(void *k);

   TBASE  db;
   BTREEa in1;		//Index on field name  
   BTREEa in2;		//Index on field address  
   BTREEa in3;		//Index on field city  

   DATE  _birthday;

   void top0(void)	{ current=1; }
   void top1(void)	{ in1.min_dat(&current); }
   void top2(void)	{ in2.min_dat(&current); }
   void top3(void)	{ in3.min_dat(&current); }

   void bottom0(void)	{ current=db.numrec(); }
   void bottom1(void)	{ in1.max_dat(&current); }
   void bottom2(void)	{ in2.max_dat(&current); }
   void bottom3(void)	{ in3.max_dat(&current); }

   int  search0(void * )	{ return TRUE; } 
   int  search1(void *k)	{ return in1.search_dat_ge(k,&current); }
   int  search2(void *k)	{ return in2.search_dat_ge(k,&current); }
   int  search3(void *k)	{ return in3.search_dat_ge(k,&current); }

   void skip0(int delta)	{ current=max(min(current+delta,db.numrec()),1); }
   void skip1(int delta)	{ in1.skip_dat(delta,&current); }
   void skip2(int delta)	{ in2.skip_dat(delta,&current); }
   void skip3(int delta)	{ in3.skip_dat(delta,&current); }

   void in1_ins_tok(void *s)	{ in1.insert(s,&current); }
   void in1_del_tok(void *s)	{ in1.delet(s,&current); }

   void tokenize(char *s,void(NAC::*fun)(void *));

 public:

 //////////////////////////////// class constructor ////////////////////////////
   NAC(void); 

 //////////////////////////////// class destructor /////////////////////////////
   ~NAC(void)  { close(); }

 //////////////////////////////// current record number ////////////////////////
   long curr_rec(void)   { return current; }

 //////////////////////////////// define ///////////////////////////////////////
   void define(void);  

 //////////////////////////////// open & close ////////////////////////////////
   void open(void);  
   void close(void);  

 //////////////////////////////// delete //////////////////////////////////////
   int  is_delet(void)  { return db.is_delet(current); } 
   void undelet(void)   { db.undelet(current); }         
   void delet(void)     { db.delet(current); }           

 //////////////////////////////// number of records ///////////////////////////
   long numrec(void)         { return db.numrec(); } 

 //////////////////////////////// import/export ///////////////////////////////
   int  import(char *s);
   int  export(char *s);
   int  to_DBASE(char *s);

 //////////////////////////////// read/write current record ///////////////////

   void write_rec2(void);
   void write_rec(void) { if(dirty) write_rec2(); }

   void read_rec(void) 
   {
        recp=(nac_record *)db.locate_rec(current); 
        rec=*recp; 
        _birthday.sem_jul(rec.__birthday); 
   }

 //////////////////////////////// reindexing //////////////////////////////////
   void reindex(void); 

 //////////////////////////////// append //////////////////////////////////////
   void append(void);        //Indexes are NOT updated.
   void append_blank(void);  //Indexes ARE updated.

 //////////////////////////////// pack ////////////////////////////////////////
   void pack(void);

 //////////////////////////////// set active index ////////////////////////////
   void order(int nr);    

 //////////////////////////////// relocating //////////////////////////////////
   void skip(int del)    { write_rec(); (this->*skip_fun)(del); read_rec(); }  
   void bottom(void)     { write_rec(); (this->*bottom_fun)(); read_rec(); }  
   void top(void)        { write_rec(); (this->*top_fun)(); read_rec(); }  
   void search(void *k)  { write_rec(); if(!(this->*search_fun)(k)) bottom(); read_rec(); }
   void go_to(long n)    { write_rec(); current=max(min(n,db.numrec()),1); read_rec(); }

 /////////////////////////reading fields //////////////////////////////////////
    char * name(void)           { return rec._name; } 
    char * address(void)        { return rec._address; } 
    char * city(void)           { return rec._city; } 
    char * birthday(void)       { return (char *)_birthday; } 
    float  salary(void)         { return rec._salary; } 

 /////////////////////////writing fields //////////////////////////////////////
 // Note: when writing strings there are NO checks on the 
 //       length. A string which is longer then the definition 
 //       of the field indicates, will OVERWRITE other data!!     
 //   
    void   name(char *s)        { strcpy(rec._name,s); dirty=TRUE; } 
    void   address(char *s)     { strcpy(rec._address,s); dirty=TRUE; } 
    void   city(char *s)        { strcpy(rec._city,s); dirty=TRUE; } 
    void   birthday(char *s)    { _birthday=s; dirty=TRUE; } 
    void   salary(float f)      { rec._salary=f; dirty=TRUE; } 

};