#include "stdio.h"
#include "stdlib.h"
#include "conio.h"
#include "string.h"
#include "cskeys.h"
#include "csmenu.h"



/***********************************************************************

                                       CSA Library, Release 1.5.d 


			   The CSA Library.
		   A demonstration of the MENU class.

                                          Copyright(c) 1994,1995 
                                          Combis 
                                          The Netherlands   
***********************************************************************/



void main(void)
{


  int choice;
  int rc;

//////////////////////////// Declare all the (sub) menu's  //////////////

 MENU m1,m2,m3,m4,m5,m6,m7;


/////////////////////////// Define the options for menu 1  //////////////


 m1.add_option("   ~File  ",     ALT_F );
 m1.add_option("   ~Edit  ",     ALT_E );
 m1.add_option("   ~Printen  ",  ALT_P );
 m1.add_option("   ~Database  ", ALT_D );
 m1.add_option("   ~Utilities  ",ALT_U );
 m1.add_option("   ~Setup  ",    ALT_S );


/////////////////////////// Define the options for menu 2  //////////////

 m2.add_option("  ~Load      F3 "  ,F3);
 m2.add_option("  ~Delete    "     ,F4);
 m2.add_option("  ~Save      F2 "  ,F2);
 m2.add_option("  ~Re-Start  "     ,F9);
 m2.add_option("  ~Exit   ALT_X "  ,ALT_X );


////////////////////////// Define the options for menu 3  ///////////////


 m3.add_option(" Free Memory ALT_M ",ALT_M );
 m3.add_option(" Removing under scores ",501 );

////////////////////////// Define the options for menu 4  ///////////////


 m4.add_option(" Directories ",502 );
 m4.add_option(" Colors "     ,503 );
 m4.add_option(" Save Setup"  ,504 );

////////////////////////// Define the options for menu 5  ///////////////


 m5.add_option(" ~References  "       , 505 );
 m5.add_option(" Reference ~Numbers >", 506 );
 m5.add_option(" ~Maintenance "       ,507 );

////////////////////////// Define the options for menu 6  ///////////////


 m6.add_option(" ~Searching ALT_C ",ALT_C );
 m6.add_option(" s~Et "            ,508 );

////////////////////////// Define the options for menu 7 ////////////////


 m7.add_option(" P~ages " , 509 );
 m7.add_option(" P~rinten ",510 );

///////////////// Make menu 1 'special' (main menu) ////////////////////


  m1.type(MENU_HOR);		     // Display options horizontally
  m1.hold(MENU_HOLD);		     // Make it 'always visible'
  m1.border(BORDER_NONE);	     // No border
  m1.width(80); 		     // Set the width to the full screen


//////////////////////////// Define the colors //////////////////////////


  int bor_col;
  int scr_col;
  int opt_col;
  int key_col;


  if(is_color())
  {
    bor_col=make_color(WHITE,CYAN);
    scr_col=make_color(WHITE,CYAN);
    opt_col=make_color(WHITE,RED);
    key_col=make_color(YELLOW,CYAN);
  }
  else
  {
    bor_col=make_color(LIGHTGRAY,BLACK);
    scr_col=bor_col;
    opt_col=make_color(BLACK,WHITE);
    key_col=make_color(WHITE,BLACK);
  }


/////////////////////////////// Set the colors of each (Sub) menu /////////

//  m1.color(bor_col,make_color(YELLOW,RED),key_col,key_col);

  m1.color(bor_col,scr_col,opt_col,key_col);
  m2.color(bor_col,scr_col,opt_col,key_col);
  m3.color(bor_col,scr_col,opt_col,key_col);
  m4.color(bor_col,scr_col,opt_col,key_col);
  m5.color(bor_col,scr_col,opt_col,key_col);
  m6.color(bor_col,scr_col,opt_col,key_col);
  m7.color(bor_col,scr_col,opt_col,key_col);

///////////////////////// Set the postions of the menu's ////////////////////

  m1.coord(1,1);
  m2.coord(2,1);
  m3.coord(2,40);
  m4.coord(2,53);
  m5.coord(2,28);
  m6.coord(4,36);
  m7.coord(1,1);
  m7.relative_pos(TO_CURSOR);	// You can also define the position relative
				// to the cursor.

////////////// Create the entire menu by connecting the sub-menu's //////////

  m1.connect(1,m2);
  m1.connect(3,m7);
  m1.connect(5,m3);
  m1.connect(6,m4);
  m1.connect(4,m5);
  m5.connect(2,m6);


///////////////////  Start the demo   ////////////////////////////////


 WINDOW bckgrnd;
 bckgrnd.border(BORDER_NONE);
 bckgrnd.activate();

 clrscr();


 WINDOW hello;


 hello.head(" Hello ");
 hello.set_dim(-1,-1,22,60);

 hello.activate();

 cprintf("\n\r              Welcome to the CSMENU demo. ");
 cprintf("\n\r                                          ");
 cprintf("\n\r                                          ");
 cprintf("\n\r    This demo is intended to give you     ");
 cprintf("\n\r    a brief look at the possibilities     ");
 cprintf("\n\r    of the MENU class.                    ");
 cprintf("\n\r                                          ");
 cprintf("\n\r    The demo consists of two parts:       ");
 cprintf("\n\r                                          ");
 cprintf("\n\r    a) A simple straightforward menu      ");
 cprintf("\n\r       which let you browse through       ");
 cprintf("\n\r       its options.                       ");
 cprintf("\n\r                                          ");
 cprintf("\n\r    b) An application style menu which    ");
 cprintf("\n\r       let you choose an option directly  ");
 cprintf("\n\r       by hitting a predefined key,       ");
 cprintf("\n\r       or by browsing the menus.          ");
 cprintf("\n\r                                          ");
 cprintf("\n\r              Hit a key to start.         ");



 cskey();

////////////////////////////////// Demo 1 ////////////////////////////

 hello.clear();
 hello.head("");
 hello.set_dim(18,10,6,60);
 hello.adjust();

 cprintf("\n\r    - Use cursor keys to manoeuvre.       ");
 cprintf("\n\r    - Hit ENTER to make a choice.         ");
 cprintf("\n\r    - Leave by selecting 'Exit' from      ");
 cprintf("\n\r      the menu.                           ");

 win_default();


  do
  {
    m1.choose(choice);
    gotoxy(10,14);
    cprintf("\n\r Return Value: %d ",choice);
  } while(choice!=ALT_X);

 m1.standby();

 clrscr();

 hello.head(" Last Demo ");
 hello.set_dim(-1,-1,20,54);
 hello.adjust();
 hello.clear();

 cprintf("\n\r            The second & last demo.       ");
 cprintf("\n\r                                          ");
 cprintf("\n\r    In many applications you wish to provide   ");
 cprintf("\n\r    the user with two ways to select an option:");
 cprintf("\n\r      1) Directly hit a function-key.     ");
 cprintf("\n\r      2) Browse the menu.                 ");
 cprintf("\n\r                                          ");
 cprintf("\n\r    In this example there are three       ");
 cprintf("\n\r    options which work in that way:       ");
 cprintf("\n\r    'load' = F3                           ");
 cprintf("\n\r    'Save' = F2                           ");
 cprintf("\n\r    'Reference ..' = ALT_C                ");
 cprintf("\n\r                                          ");
 cprintf("\n\r    Leave the demo by ALT_X.              ");
 cprintf("\n\r                                          ");
 cprintf("\n\r              Hit a key to start.         ");


 cskey();


  hello.head("");
  hello.set_dim(17,-1,7,62);
  hello.adjust();
  hello.clear();

  cprintf("     F2:    Save \n\r");
  cprintf("     F3:    Load \n\r");
  cprintf("     ALT_C: Reference Number \n\r");
  cprintf("     ESC:   Browse Menu \n\r");
  cprintf("     ALT_X: Exit");

  win_default();


  int key;
  char regel[200];

  do
  {
    m1.standby();	   // Finally display something.
			   // In the loop because we use
			   // choose_hold();
    gotoxy(10,10);
    cprintf(" Make your choice:"); clreol();

    key=cskey();	   // Read a key.
			   // ESC means browse through the menus.

    if(key==ESC) m1.choose_hold(key); // Browse through the menu.
    else	 m1.show(key);	      // Display the option directly.
    switch(key)
    {
      case F3:	      // LOAD
	   // Both the menu's are now being
	   // displayed.
	   // The option 'load' is highlighted.
	   //
	    gotoxy(10,10);
	    cprintf(" Loading file...."); clreol();
	   waitkb(3000);
	   //
	   break;
      case F2:	      // SAVE
	   // some
	   // code to
	   // save.
	   gotoxy(10,10);
	   cprintf(" Saving file......"); clreol();
	   waitkb(3000);
	   break;
      case ALT_C:     // Reference Number
	   gotoxy(10,10);
	   cprintf(" Search for reference number......");
	   clreol();
	   waitkb(3000);
	   break;
    }

  } while (key!=ALT_X);  // Use ALT_X to terminate demo.



  hello.set_dim(-1,-1,10,46);
  hello.head(" The End ");
  hello.adjust();
  hello.clear();

  cprintf("\n\n\r   Thank you for watching ");
  cprintf("\n\r   this demo.               ");
  cprintf("\n\r");
  cprintf("\n\r         Have a nice day.   ");

  waitkb(6000);
  m1.remove();

  empty_kb();




}
