
/***********************************************************************

                                      CSDB Library, Release 1.5.d 

       BTREE classes.

                                          Copyright(c) 1994,1995 
                                          Combis 
                                          The Netherlands   
***********************************************************************/

#ifndef __CSBTREE_H
#define __CSBTREE_H


#ifndef __CSTBASE_H
#include "cstbase.h"
#endif


#pragma warn -sig

/////////////////////////////////////////////////////////////////////////////////


typedef U32 BPOINT;

class BTREE: public TBASE
{

   protected:


       typedef struct
       {
	  BPOINT up;	// Up pointer
	  U8	 nr;	// Number of keys
	  BPOINT tr;	// This Record
	  BPOINT lnr;	// Record number of left neighbour
	  BPOINT rnr;	// .................right .........
       } d_block;

       typedef struct
       {
	  U8	 nr;	// Number of data elements
	  BPOINT lnr;	// Record number of left neighbour (Previous)
	  BPOINT rnr;	// .................right ......... (Next)
       } m_block;


    protected:

      BPOINT root;	 // Points to the root of the btree
      BPOINT empt;	 // Empty block chain
      BPOINT *paal;	 // PAth ALlocation
      BPOINT *path;	 // Path from the root to the leave
      BPOINT mk_empt;	 // mk_ Empty data frames.
      int    levels;	 // Number of levels in the btree, including DATA layer
      int    datlen;	 // Length of data field
      int    keylen;	 // Length of key field
      int    kdlen;	 // Length of key- and data field combined.
      int    kdmklen;	 // Length of key- and data field and mk combined.
      int    kplen;	 // Length of keyfield and BPOINT combined.
      int    pml;	 // Path Max Length
      int    mulkey;	 // Multiple keys allowed.
      void   *tmp_key;	 // Storage for temporary keys
      long   num_key;	 // Number of Keys in Btree.
      BPOINT curr_block; // The current block
      int    curr_nr;	 // The current number in the block
      BPOINT curr_mk_f;  // The current frame
      int    curr_mk_n;  // The current number in the frame


    protected:

    /////////////////////// Multiple Key Support //////////////////////
    //	mdf:	Multiple Data Frame

      int   nimdf;     // Number of data elements In a mdf.
      int   mkop;      // Number of Multiple data frames on a page.
      int   somdf;     // Size Of a mdf. (Number of bytes in a mdf.)
      int   mk_shift;
      int   mk_and;

      int   mk_oib_a;
      int   mk_oimdf_a;

      int   mk_oib(int n)	   { return mk_oib_a+n*somdf; }
      int   mk_oimdf(int n)	   { return mk_oimdf_a+n*datlen; }

      CSCHAR *mk_p2cp(void *p,int n) { return (CSCHAR *)p+mk_oib(n); }

      BPOINT &mk_n_mdf(void *p)   { return (((m_block *)p)->rnr); }
      BPOINT  mk_n_mdf(BPOINT b)  { return mk_n_mdf(mk_p2mdf(b)); }
      BPOINT &mk_n_mdfd(BPOINT b) { return mk_n_mdf(mk_p2mdfd(b)); }
      BPOINT &mk_p_mdf(void *p)   { return (((m_block *)p)->lnr); }
      BPOINT  mk_p_mdf(BPOINT b)  { return mk_p_mdf(mk_p2mdf(b)); }
      BPOINT &mk_p_mdfd(BPOINT b) { return mk_p_mdf(mk_p2mdfd(b)); }

      void   mk_connect(BPOINT l,BPOINT r) { if(l) mk_n_mdfd(l)=r; if(r) mk_p_mdfd(r)=l; }
      void   mk_empty(BPOINT b);
      void   mk_new_page(void);

      BPOINT mk_new_frame(void);
      BPOINT mk_2mkp(BPOINT b,int i) { return ((b<<mk_shift)|i); }

      CSCHAR  *mk_p2mdf(BPOINT b)  { return p2cp(b>>mk_shift)+mk_oib(b&mk_and);  }
      CSCHAR  *mk_p2mdfd(BPOINT b) { return p2cpd(b>>mk_shift)+mk_oib(b&mk_and); }

      CSCHAR  *mk_dataif(void *p,int i) { return (CSCHAR *)p+mk_oimdf(i); }

      CSCHAR  *mk_data_l(void *p)	{ return mk_dataif(p,mk_nr(p)); }
      CSCHAR  *mk_search(BPOINT &b,void *dat, int &nr);
      CSCHAR  *mk_insert(BPOINT &b,void *dat);

      int   mk_delet(BPOINT &b,void *dat);

      void  mk_free_chain(BPOINT b);
      void  mk_zap(void);
      void  mk_define(void)	 { set_nill(head->cl.BTREE.btr_mk_emp); }
      void  mk_close(void)	 { head->cl.BTREE.btr_mk_emp=mk_empt;	}
      void  mk_open(void);
      void  mk_last(BPOINT b)	 { curr_mk_n=mk_nr(mk_p2mdf(curr_mk_f=mk_p_mdf(b))); }
      void *mk_last_p(BPOINT b);

      U8    &mk_nr(void *p)   { return (((m_block *)p)->nr); }


    /////////////////////// Accessing Header Block ////////////////////

	 U8 &DNR(void *p)  { return (((d_block *)(p))->nr);  }
     BPOINT &DLNR(void *p) { return (((d_block *)(p))->lnr); }
     BPOINT &DRNR(void *p) { return (((d_block *)(p))->rnr); }
     BPOINT &BTR(void *p)  { return (((d_block *)(p))->tr);  }

    /////////////////////// Splitting Data Block //////////////////////

      int   dmnk;      // Data Max Number of Keys
      int   dnbc;      // Data Number of Bytes Copied
      int   dsco;      // Data Source Copy Offset
      int   ddco;      // Data Destination Copy Offset
      U8    dnnr;      // Data New NumbeR; the higher keys
      U8    donr;      // Data Old NumbeR; the lower keys

    /////////////////////// Splitting Index Block //////////////////////

      int   imnk;      // Index Max Number of Keys
      int   inbc;      // Index Number of Bytes Copied
      int   isco;      // Index Source Copy Offset
      int   idco;      // Index Destination Copy Offset
      U8    innr;      // Index New NumbeR; the higher keys
      U8    ionr;      // Index Old NumbeR; the lower keys

      int a_oiib;      // Offset in indexblock calculation
      int b_oiib;

      int a_oidb;      // Offset in datablock calculation
      int b_oidb;

 protected:

     int  moving_min(BPOINT &b,int &n,int delta,void *&bp);
     int  moving_plus(BPOINT &b,int &n,int delta,void *&bp);

     int  moving_plus(void *&bp,int &n);
     int  moving_min(void *&bp,int &n);

     int  prev_u(int n,void *&key,void *&data);
     int  prev(int n,void *&bp);
     int  next(int n,void *&bp);
     int  next_u(int n,void *&key,void *&data);

    /////////////////////// Skipping fields  within a Block //////////////////
      CSCHAR   *skfidb(void *p)     { return (((CSCHAR *)p)+keylen); }
      BPOINT *s2fidb(void *p)	    { return (BPOINT *)(((CSCHAR *)p)+kdlen); }
      CSCHAR   *skfiib(void *p)     { return (((CSCHAR *)p)+keylen); }
      CSCHAR   *spfiib(void *p)     { return (((CSCHAR *)p)+sizeof(BPOINT));  }
      CSCHAR   *fkiib(void *p)	    { return (((CSCHAR *)p)+sizeof(d_block)); }
      CSCHAR   *lkiib(void *p)	    { return (((CSCHAR *)p)+oiib(DNR(p)));    }
      CSCHAR   *nkiib(void *p,int n)  { return (CSCHAR *)p+oiib(n); }

      CSCHAR   *lkidb(void *p)	    { return (CSCHAR *)p+oidb(DNR(p)); }
      CSCHAR   *nkidb(void *p,int n)  { return (CSCHAR *)p+oidb(n);}
      CSCHAR   *fkidb(void *p)	    { return (CSCHAR *)p+sizeof(d_block); }

    /////////////////////// Identify type of database ////////////////////////
      virtual void check_id(U32 id);
      virtual void set_id(void);

    /////////////////////// Copying /////////////////////////////////////////
      void  copy_dat(void *d,void *s)	{ memcpy(d,s,datlen); }
      void  copy_key(void *d,void *s)	{ memcpy(d,s,keylen); }
      void  copy_poi(void *d,BPOINT &s) { *(BPOINT *)d=s; }

    /////////////////////// Delete Aid //////////////////////////////////////
      void  delet(void *b,void *KeyPos,int KeyNr);

    /////////////////////// Create/Free Block //////////////////////////////////
      void  c_root(void *keyl,BPOINT l,void *keyr,BPOINT r);
      void  c_root(void *keyl,BPOINT l);
      CSCHAR *c_block(void);
      void  f_block(void *p);

    /////////////////////// Connecting blocks //////////////////////////////
      void  connect(void *l,void *r)   { DRNR(l)=BTR(r); DLNR(r)=BTR(l); }
      void  connect(BPOINT l,void *r);
      void  connect(void *l,BPOINT p);
      void  connect(BPOINT l,BPOINT p);

    /////////////////////// Splitting blocks ////////////////////////////////
      void  calc_split_info(int ig,int dg);
      void  split_data(void *lb,CSCHAR *&hb);
      void  split_index(void *b,CSCHAR *&c);

    /////////////////////// Removing key from block /////////////////////////
      int   rkajib(void *b,void *KeyPos,int KeyNr);
      void  rkajdb(void *b,void *KeyPos,int KeyNr);
      void  rkfib(void *block,void *KeyPos,int KeyNr);
      void  rkfdb(void *block,void *KeyPos,int KeyNr);

    /////////////////////// Insert key in block ////////////////////////////////
      void  ikasdb(void *b,CSCHAR *kp,int nr,void *key,void *data);
      void  ikiib(void *b,CSCHAR *kp,int nr,void *key,BPOINT dat);
      void  ikidb(void *b,CSCHAR *kp,int nr,void *key,void *data);
      void  insert_index(void *key,BPOINT dow);

    /////////////////////// Searching for a key ////////////////////////////////
      CSCHAR *ski2ib(void *b,void *key,int &nr);
      CSCHAR *skiib(void *b,void *key,int &nr);
      CSCHAR *ski2ib(void *b,void *key) { int nr; return ski2ib(b,key,nr); }
      CSCHAR *skiib(void *b,void *key)	{ int nr; return skiib(b,key,nr);  }
      CSCHAR *skidb(void *b,void *key)	{ int nr; return skidb(b,key,nr);  }
      CSCHAR *skidb(void *b,void *key,int &nr);

    /////////////////////// Reading from file //////////////////////////////////
      CSCHAR *p2cpd(BPOINT p)	      { return (CSCHAR *)locate_rec_d(p); }
      CSCHAR *p2cp(BPOINT p)	      { return (CSCHAR *)locate_rec(p); }
      CSCHAR *p2cpl(BPOINT p)	      { return (CSCHAR *)locate_rec_l(p); }

    /////////////////////// Comparing keys /////////////////////////////////////////////
      virtual int t_key(void *a,void *b)=0;
      int  t_dat(void *a,void *b) { return memcmp(a,b,datlen); }

    /////////////////////// Dirty /////////////////////////////////////////////
      void  block_dirty(void *block) { TBASE::dirty(block); }

    /////////////////////// Miscellaneous /////////////////////////////////////
      void   reporter(FILE *fp,BPOINT p,int lev);
      void   expand(void *key,void *data);

      int    oiib(int n)	 { return a_oiib+n*b_oiib; }
      int    oidb(int n)	 { return a_oidb+n*b_oidb; }

      int    nill(BPOINT &p)	 { return !p; }
      int    index_full(void *p) { return (DNR(p)==imnk); }
      int    data_full(void *p)  { return (DNR(p)==dmnk); }
      int    data_low(void *p)	 { return (DNR(p)<=donr); }
      int    index_low(void *p)  { return (DNR(p)<=ionr); }
      BPOINT set_nill(BPOINT &p) { return (p=0); }
      BPOINT sdb(void *key);

      void   nill_mk(void *kp)	 { if(multiple_keys()) set_nill(*s2fidb(kp)); }

      int    search_gt(void *key,void *&kp);
      int    search_ge(void *key,void *&kp);
      int    search_le_u(void *key,void *&kp,void *&da);
      int    search_lt_u(void *key,void *&kp,void *&da);



////////////////////////////////////////////////////////////////////////
////////////////////// PUBLIC FUNCTIONS ////////////////////////////////
////////////////////////////////////////////////////////////////////////

    public:


      BTREE(void );
      ~BTREE(void );


//////////////////////// Definition //////////////////////////////////////////
      void  define(CSCHAR *name, int key_l,int dat_l);

//////////////////////// Open & Close ////////////////////////////////////////
      int   open(CSCHAR *name, int kb_buff);
      int   open(void)	  { return already_open(); }
      void  close(void);

////////////////////////// Deleting ////////////////////////////////////////////
      int   delet(void *key);
      int   delet(void *key,void *data);

////////////////////////// Inserting ///////////////////////////////////////////
      void  insert(void *key,void *data);

////////////////////////  First and Last entrie ///////////////////////////////
      int   min(void);
      int   min(void *Key,void *Data);
      int   min_dat(void *Data);
      int   min_key(void *Key);

      int   max(void);
      int   max(void *Key,void *Data);
      int   max_dat(void *Data);
      int   max_key(void *Key);

//////////////////////// Checking for Existence //////////////////////////////
      int   find(void *key,void *data);
      int   find(void *key);

//////////////////////// Searching ////////////////////////////////////////////
      int   search(void *key,void *Data);

      int   search_gt(void *key,void *Key,void *Data);
      int   search_ge(void *key,void *Key,void *Data);
      int   search_lt(void *key,void *Key,void *Data);
      int   search_le(void *key,void *Key,void *Data);

      int   search_dat_gt(void *key,void *Data);
      int   search_dat_ge(void *key,void *Data);
      int   search_dat_lt(void *key,void *Data);
      int   search_dat_le(void *key,void *Data);

      int   search_key_gt(void *key,void *Key);
      int   search_key_ge(void *key,void *Key);
      int   search_key_lt(void *key,void *Key);
      int   search_key_le(void *key,void *Key);


//////////////////////// Skipping /////////////////////////////////////////////
      int   prev(void);
      int   prev(int n);
      int   prev_key(int n,void *Key);
      int   prev_dat(int n,void *Data);
      int   prev(int n,void *Key,void *Data);

      int   next(void);
      int   next(int n);
      int   next_key(int n,void *Key);
      int   next_dat(int n,void *Data);
      int   next(int n,void *Key,void *Data);

      int   skip(int n) { return ((n>0) ? next(n): -prev(-n)); }

      int   skip(int n,void *Key,void *Data)
	    {  if(n>0) return  next( n,Key,Data);
	       else    return -prev(-n,Key,Data); }
      int   skip_key(int n,void *Key)
	    {  if(n>0) return  next_key( n,Key);
	       else    return -prev_key(-n,Key); }
      int   skip_dat(int n,void *Dat)
	    {  if(n>0) return  next_dat( n,Dat);
	       else    return -prev_dat(-n,Dat); }

//////////////////////// Current location /////////////////////////////////////
      int   current(void *Key,void *Data);
      int   current_key(void *Key);
      int   current_dat(void *Data);

//////////////////////// Report Writing //////////////////////////////////////
      void  report(CSCHAR *rname,int sub=1);
      void  report(FILE *fp,int sub=1);

//////////////////////// Number of Keys //////////////////////////////////////
      long  numkey(void)  { return num_key; }

////////////////////////// Miscellaneous ///////////////////////////////////////
      int   pack(void);
      void  zap(void);
      void  info(void );
      void  empty(void);
      void  multiple_keys(int TrueOrFalse);
      void  multiple_keys_YES(void)	   { multiple_keys(TRUE);  }
      void  multiple_keys_NO(void)	   { multiple_keys(FALSE); }
      int   multiple_keys(void	)	   { return mulkey; }
      virtual int class_ID(void)	   { return CS_CLID_BTREE; }


};



/////////////////////////////////////////////////////////////////////////////////
class BTREEb: public BTREE
{
    virtual int t_key(void *a,void *b) { return memcmp(a,b,keylen);}
    virtual int class_ID(void)	{ return CS_CLID_BTREEb; }
};
/////////////////////////////////////////////////////////////////////////////////
class BTREEi: public BTREE
{

   virtual int t_key(void *a,void *b)
    {
      if(*(int *)a < *(int *)b) return -1;
      if(*(int *)a > *(int *)b) return	1;
      return 0;
    }


//  You can use this for integers between -16000 & +16000
//  virtual int t_key(void *a,void *b) { return *(int *)a-*(int *)b; }

    virtual int class_ID(void)	{ return CS_CLID_BTREEi; }

};
/////////////////////////////////////////////////////////////////////////////////
class BTREEc: public BTREE
{
    virtual int t_key(void *a,void *b) { return ((int)*(S8 *)a)-((int)*(S8 *)b); }
    virtual int class_ID(void)	{ return CS_CLID_BTREEc; }
};
/////////////////////////////////////////////////////////////////////////////////
class BTREEl: public BTREE
{
   virtual int t_key(void *a,void *b)
    {
      if(*(long *)a < *(long *)b) return -1;
      if(*(long *)a > *(long *)b) return  1;
      return 0;
    }
   virtual int class_ID(void)  { return CS_CLID_BTREEl; }

};
/////////////////////////////////////////////////////////////////////////////////
class BTREEf: public BTREE
{
    virtual int t_key(void *a,void *b)
    {
      if(*(float *)a < *(float *)b) return -1;
      if(*(float *)a > *(float *)b) return  1;
      return 0;
    }
    virtual int class_ID(void)	{ return CS_CLID_BTREEf; }
};
/////////////////////////////////////////////////////////////////////////////////
class BTREEd: public BTREE
{
    virtual int t_key(void *a,void *b)
    {
      if(*(double *)a < *(double *)b) return -1;
      if(*(double *)a > *(double *)b) return  1;
      return 0;
    }
    virtual int class_ID(void)	{ return CS_CLID_BTREEd; }
};
/////////////////////////////////////////////////////////////////////////////////
class BTREEa: public BTREE
{
    virtual int t_key(void *a,void *b) { return strnicmp((CSCHAR *)a,(CSCHAR *)b,keylen);}
    virtual int class_ID(void)	{ return CS_CLID_BTREEa; }
};


#pragma warn .sig

#endif
