/***********************************************************************

                                       CSA Library, Release 1.5.d 

       Collection of general purpose functions.
       Mainly intended to support the other functions
       and classes.

                                          Copyright(c) 1994,1995 
                                          Combis 
                                          The Netherlands   
***********************************************************************/

#ifndef __CSTOOLS_H
#define __CSTOOLS_H

#ifndef __CSTYPES_H
#include "cstypes.h"
#endif

#ifndef __BIOS_H
#include <bios.h>
#endif

#ifndef __STRING_H
#include <string.h>
#endif

#ifndef __CONIO_H
#include <conio.h>
#endif

#ifndef __CSBORDER_H
#include "csborder.h"
#endif

#ifndef __CSMALLOC_H
#include "csmalloc.h"
#endif


///////////////// String functions /////////////////////////////////////

void  filter_string(CSCHAR *s,CSCHAR *p);
void  lower_upper(CSCHAR *ptr);
char *notabs(CSCHAR *s);
char *remove_space(CSCHAR *s);
void  trim_string(CSCHAR *s);
void  str_left(CSCHAR *s,CSCHAR *d,int len);
void  str_split(CSCHAR *src,CSCHAR ch,CSCHAR *frst,CSCHAR *last);
void  str_strip(CSCHAR *s,CSCHAR *f);
inline int str_equal(CSCHAR *s,CSCHAR *s2) { return !strcmp(s,s2); }
char *string_replace_ones(CSCHAR *s,CSCHAR *d,CSCHAR *r);
int   string_replace(CSCHAR *s,CSCHAR *d,CSCHAR *r);

///////////////// Screen functions /////////////////////////////////////

void  box(int row,int col,int h,int w,int border,int color);
void  desktop(void);
void  disp_r_xy(int x,int y,CSCHAR c, CSCHAR color);
void  disp_xy(int x,int y,CSCHAR c, CSCHAR color);
void  disp_r_xy(int x,int y,CSCHAR c);
void  disp_xy(int x,int y,CSCHAR c);
inline void gotoyx(int y,int x) { gotoxy(x,y); }
int   is_color(void);
inline int  make_color(int txt,int backg) {return txt|((backg&7)<<4); }

///////////////// User interface ////////////////////////////////////////
void  empty_kb(void);
void  wait(long msec);
void  waitkb(long msec);

///////////////// Numerical functions ///////////////////////////////////
long  csrand(long);
int   csrand(int);
unsigned long sqrtl(unsigned long l);
unsigned int  sqrti(unsigned int i);
size_t next_prime(size_t n);
long  lrandom(long amount);


///////////////// File related //////////////////////////////////////////
long  filesize(CSCHAR *name);
int   disk(CSCHAR *s);
char *file_ext(CSCHAR *naam,CSCHAR *ext);
int   file_exist(CSCHAR *fnaam);
int   add_path(CSCHAR *filen,CSCHAR *path);
int   cstmpname(CSCHAR *name);


///////////////// Miscellaneous /////////////////////////////////////////
char *add2point(void *p,long l);
long  time_stamp(void);
int   bit_masks(U32 l,U32 &off,U16 &shift);


#ifndef TRUE
#define TRUE	  1
#endif

#ifndef FALSE
#define FALSE	  0
#endif


#define ABS(x)	   MAX(x,-(x))
#define MAX(x,y)   (( ((x)>(y)) ? (x):(y)))
#define MIN(x,y)   (( ((x)<(y)) ? (x):(y)))


#pragma warn -sig

////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Inline versions of 'max' and 'min' which return an
//  appropriate variable type.
//  Useful for calling polymorphic functions.
//
////////////////////////////////////////////////////////////////////////////

inline size_t min(size_t x,size_t y)	      { return (x<y) ? x: y; }
inline int    min(int	 x,size_t y)	      { return (x<y) ? x: y; }
inline long   min(long	 x,size_t y)	      { return (x<y) ? x: y; }
inline size_t min(ulong  x,size_t y)	      { return (x<y) ? x: y; }
inline int    min(size_t x,int	  y)	      { return (x<y) ? x: y; }
inline int    min(int	 x,int	  y)	      { return (x<y) ? x: y; }
inline long   min(long	 x,int	  y)	      { return (x<y) ? x: y; }
inline int    min(ulong  x,int	  y)	      { return (x<y) ? x: y; }
inline long   min(size_t x,long   y)	      { return (x<y) ? x: y; }
inline long   min(int	 x,long   y)	      { return (x<y) ? x: y; }
inline long   min(long	 x,long   y)	      { return (x<y) ? x: y; }
inline long   min(ulong  x,long   y)	      { return (x<y) ? x: y; }
inline size_t min(size_t x,ulong  y)	      { return (x<y) ? x: y; }
inline int    min(int	 x,ulong  y)	      { return (x<y) ? x: y; }
inline long   min(long	 x,ulong  y)	      { return (x<y) ? x: y; }
inline ulong  min(ulong  x,ulong  y)	      { return (x<y) ? x: y; }


inline size_t max(size_t x,size_t y)	      { return (x>y) ? x: y; }
inline size_t max(int	 x,size_t y)	      { return (x>y) ? x: y; }
inline long   max(long	 x,size_t y)	      { return (x>y) ? x: y; }
inline ulong  max(ulong  x,size_t y)	      { return (x>y) ? x: y; }
inline size_t max(size_t x,int	  y)	      { return (x>y) ? x: y; }
inline int    max(int	 x,int	  y)	      { return (x>y) ? x: y; }
inline long   max(long	 x,int	  y)	      { return (x>y) ? x: y; }
inline ulong  max(ulong  x,int	  y)	      { return (x>y) ? x: y; }
inline long   max(size_t x,long   y)	      { return (x>y) ? x: y; }
inline long   max(int	 x,long   y)	      { return (x>y) ? x: y; }
inline long   max(long	 x,long   y)	      { return (x>y) ? x: y; }
inline ulong  max(ulong  x,long   y)	      { return (x>y) ? x: y; }
inline ulong  max(size_t x,ulong  y)	      { return (x>y) ? x: y; }
inline ulong  max(int	 x,ulong  y)	      { return (x>y) ? x: y; }
inline ulong  max(long	 x,ulong  y)	      { return (x>y) ? x: y; }
inline ulong  max(ulong  x,ulong  y)	      { return (x>y) ? x: y; }


#pragma warn .sig


#endif
