#if defined (_MSC_VER) 
#define _Cdecl __cdecl
#endif

#if !defined (XMS_H)
#define XMS_H

#ifdef __cplusplus
extern "C"{
#endif


    enum error {                            // XMS error codes ...
        NOT_IMPLEMENTED                     = 0x80,
        VDISK_DETECTED                      = 0x81,
        A20_ERROR                           = 0x82,
        GENERAL_DRIVER_ERROR                = 0x8E,
        UNRECOVERABLE_DRIVER_ERROR          = 0x8F,
        NO_MORE_MEMORY                      = 0xA0,
        NO_MORE_HANDLES                     = 0xA1,
        BAD_HANDLE                          = 0xA2,
        BAD_SRC_HANDLE                      = 0xA3,
        BAD_SRC_OFFSET                      = 0xA4,
        BAD_DST_HANDLE                      = 0xA5,
        BAD_DST_OFFSET                      = 0xA6,
        BAD_LENGTH                          = 0xA7,
        OVERLAP_ERROR                       = 0xA8,
        PARITY_ERROR                        = 0xA9,
        BLOCK_LOCKED                        = 0xAB,
        LOCK_OVERFLOW                       = 0xAC,
        LOCK_FAIL                           = 0xAD
    };


typedef unsigned int XMShandle;

struct EMMMoveStruct {
    unsigned long int   TransferLength;
    XMShandle           SourceHandle;
    unsigned long int   SourceOffset;
    XMShandle           DestHandle;
    unsigned long int   DestOffset;
};

unsigned int far _Cdecl XMS_Setup(void);    // Initialization routine
                                            // Must be called first

unsigned char far _Cdecl XMS_FreeMem(   // returns free and total extended
         unsigned int far *freemem,     // free extended memory in K
         unsigned int far *totmem);     // total extended memory in K

unsigned char far _Cdecl XMS_Version(   // Returns version information
         unsigned int far *version,     // BCD protocol version
         unsigned int far *internal,    // BCD internal version number
         unsigned int far *HMA);        // Does the HMA exist?

unsigned char far _Cdecl XMS_AllocEMB(  // Allocate extended momory
         unsigned int mysize,           // size in K needed
         XMShandle    far *handle);     // handle for this EMB

unsigned char far _Cdecl XMS_FreeEMB(   // Release an EMB
         XMShandle    handle);          // handle to release

unsigned char far _Cdecl XMS_MoveEMB(       // Move between real memory and
         struct EMMMoveStruct far *MoveRec);// extended memory.

unsigned char far _Cdecl XMS_LockEMB(   // make sure a memory block doesn't
         XMShandle    handle,           // move.
         void far *address);    // LINEAR memory address for this block

unsigned char far _Cdecl XMS_UnlockEMB( // unlock
         XMShandle    handle);

unsigned char far _Cdecl XMS_GetEMBHandleInfo(   // info on a handle
         XMShandle    handle,               // handle info wanted on
         unsigned char far *LockCount,      // number of locks enabled
         unsigned char far *EMBHandlesFree, // total handles free in system
         unsigned int far *EMBlength);      // size of this handle in K

unsigned char far _Cdecl XMS_ReallocEMB(    // Try to change the size of
         XMShandle    handle,               // this block.
         unsigned int newsize);             // new size in K
#ifdef __cplusplus
}
#endif
#endif // XMS_H
