$COMPILE EXE "DEMO.EXE"
$LINK "BAGOTRX1.PBL"
$INCLUDE"BAGOTRX1.INC"
DEFINT A-Z

'WIDTH 80,43        'Note that the fancy buttons are available in both
                    '25 line and 43/50 line screen modes!

Menu.Main=&H70     ' Optional Menu Colors specified
Menu.HighL =&H7F   ' If they're not defined, Bag O'Tricks
Menu.HighL2=&H7E   ' will try to come up with a suitable
Menu.Bar=&H47      ' color scheme for you.
Menu.BarHighL=&H4F '

IF (FileNameOK%("DEMO.DAT")=1) OR (FileNameOK%("BAGOTRX1.DOC")=1) THEN
	PRINT "The files DEMO.DAT and BAGOTRX1.DOC need to be in"
    PRINT "this directory in order to run the demo."
    END
END IF

DocPlace$="BAGOTRX1.DOC"

MouseInit     'Both of these are optional, but no harm is done
MakeButtons   'if they are run on incompatible systems

DIM Topic$(0:77),CHKText$(0:1)
ChkText$(0)="View text on this subject"  'Text for the check boxes
ChkText$(1)="Run demo (if available)"    '

TD%=3                                    'sets original state of check boxes

OPEN "DEMO.DAT" FOR INPUT AS #1
FOR X%=0 TO 77
	LINE INPUT #1,Topic$(X%)             'Read the topics for the pick list
NEXT X%
CLOSE #1

FillScreen 177,&H19                      'A nice fill on the screen

COLOR 7,1
QPrint 25,9,"  Bag o' Tricks for Power Basic v3.0 (c) 1994 by Dan Hunting.  "
OpenWin 5,5,15,58,&H1F,12,"Bag O' Tricks Demo"
COLOR 14,1
QPrint 5,28,"Bag o' Tricks is a shareware"
QPrint 6,28,"library for Power Basic users."
QPrint 7,28,"Most of the routines listed"
QPrint 8,28,"at left have demos which will"
QPrint 9,28,"show off the features of the"
QPrint 10,28,"package."
COLOR 15,1
KeyCode%=300                             'Draws all the controls and then
                                         'returns to the top of loop.
NumOfControls%=3                         'How many Controls?
                                         'Here's the meat of the program ....
DO
	PickList 2,3,13,Topic$(),Choice%,KeyCode%
	IF KeyCode%=13 THEN
		GOSUB PickChoice         'Do something if a choice was made
	END IF
	Check 2,28,TD%,ChkText$(),0,KeyCode%    'Checkboxes for options
	UserButton 12,28,"Push to QUIT",KeyCode%  'a big button to exit
LOOP UNTIL KeyCode%=13
CloseWin
UNMakeButtons                            'Reset the video
END
'-------------------------------------------------------------------
PickChoice:
PushCursor

IF (TD% AND 1) THEN
	Index%=(Choice%+1)*2
	Z$=GetDelimStr$(DocPlace$,Index%,"-*-")
	Z$=LTRIM$(Z$,ANY CHR$(13,10))
	COLOR 0,7
	BrowseStr 3,3,10,73,Z$,Topic$(Choice%)
	Z$=""
END IF

IF (TD% AND 2) THEN

    SELECT CASE Choice%
		CASE 3,7,14,32,47,52,53,57,59,64,75,76  'Control Demo
			ControlDemo
            REDIM Msg$(1:1)
		CASE 5,13,18,51,71,73         'Key status demos
			OpenWin 9,40,9,32,&H5F,12,"Key Status"
			QPrint 1,2,"Press Shift, Alt, Ctrl, Scroll"
			QPrint 2,2,"Lock Num Lock and Caps Lock."
			QPrint 3,2,"Press Esc to Exit"
			DO
				IF ShiftKey% THEN
					QPrint 4,2,"Shift key is Pressed"
				ELSE
					QPrint 4,2,"                    "
				END IF
				IF AltKey% THEN
					QPrint 5,2,"Alt key is Pressed"
				ELSE
					QPrint 5,2,"                  "
				END IF
				IF CtrlKey% THEN
					QPrint 6,2,"Ctrl key is Pressed"
				ELSE
					QPrint 6,2,"                   "
				END IF
				IF NumLockStat% THEN
					QPrint 7,2,"Num Lock is ON "
				ELSE
					QPrint 7,2,"Num Lock is OFF"
				END IF
				IF CapsLockStat% THEN
					QPrint 8,2,"Caps Lock is ON "
				ELSE
					QPrint 8,2,"Caps Lock is OFF"
				END IF
				IF ScrollLockStat% THEN
					QPrint 9,2,"Scroll Lock is ON "
				ELSE
					QPrint 9,2,"Scroll Lock is OFF"
				END IF

				A$=INKEY$
			LOOP UNTIL A$=CHR$(27)
			CloseWin
			REDIM Msg$(1:1)
			Msg$(1)=""
		CASE 9                                'BrowseFile
			COLOR 15,4
			BrowseFile 3,5,15,55,DocPlace$,"Browsing BAGOTRX1.DOC"
			REDIM Msg$(1:1)
			Msg$(1)=""
		CASE 10,28
			REDIM Msg$(1:4)
			Msg$(1)="The text desribing each routine"
			Msg$(2)="was retrieved from BAGOTRX1.DOC"
			Msg$(3)="using GetDelimStr$, and displayed"
			Msg$(4)="with BrowseStr.
		CASE 15                                'CheckWin
			REDIM Item$(0:2),Msg$(0:2)
			Msg$(0)="Title":Msg$(1)="A Test":Msg$(2)="Of CheckWin"
			Item$(0)="Mustard":Item$(1)="Onions":Item$(2)="Jalapenos"
			St%=1
            IF CheckWin% (5,25,&H4F,Msg$(),St%,Item$()) THEN
                REDIM Msg$(1:2)
				Msg$(1)="Here's what you picked, bit-encoded:"
				Msg$(2)=BIN$(St%)
			ELSE
                REDIM Msg$(1:1)
				Msg$(1)="You press Esc, or clicked on the Escape spot"
	        	END IF
		CASE 19,20,21,22,30                 'Date Demo
			REDIM Msg$(0:1)
			Msg$(0)="Date demo"
			Msg$(1)="Input a date:"
			DT$="  /  /    "
			Dummy%=NumEditWin%(4,25,&H4F,Msg$(),DT$,0)
			REDIM Msg$(0:1)
			Msg$(0)="Date demo"
			IF DateOK%(DT$) THEN
				REDIM Msg$(0:4)
				Msg$(0)="Date demo"
				Msg$(1)=DT$+" is a valid date."
				Msg$(2)="Julian date for "+DT$+" is:"+STR$(Date2Jul&(DT$))
				Msg$(3)=DT$+" falls on a "+DayofWeek$(Dt$)
				Msg$(4)="There are "+STR$(Daysbetween&(Date$,Dt$))+_
				" days between "+DT$+" and today."
			ELSE
				REDIM Msg$(0:1)
				Msg$(0)="Date demo"
				Msg$(1)=DT$+" is an invalid date."
			END IF

		CASE 24,27                           'Disk Space
			REDIM Msg$(1:2)
            Msg$(1)="Total space on drive C:"+STR$(DiskSize&&("C"))
            Msg$(2)="Bytes available on Drive C:"+STR$(FreeSpace&&("C"))
		CASE 25                             'FileName validation
			REDIM Msg$(1:1)
			Msg$(1)="Input a filename"
			Dummy%=LineEditWin%(4,25,&H4F,Msg$(),Fil$,25,4)
			Dummy%=FileNameOK%(Fil$)
			SELECT CASE Dummy%
				CASE 0
					Msg$(1)=Fil$+" is NOT a valid file name."
				CASE -1
					Msg$(1)=Fil$+" is a valid file name, and it already exists."
				CASE 1
					Msg$(1)=Fil$+" is a valid file name, and it does not already exists."
			END SELECT
		CASE 31                              'KeyOrMouse
			OpenWin 3,3,5,45,&H4F,11,"KeyOrMouse Demo"
			QPrint 1,1,"Press some keys and click the mouse."
			QPrint 2,1,"Press Esc to Quit"
			DO
				CALL KeyOrMouse(KeyCode%,MRow%,MCol%)
				QPrint 3,1,"                                       "
				SELECT CASE KeyCode%
					CASE <0
						QPrint 3,1,"You Pressed an Extended Key"
					CASE 0 to 254
						QPrint 3,1,"You Pressed the "+CHR$(KeyCode%)+" key!"
					CASE 320
						QPrint 3,1,"Alt key was pressed all by itself"
					CASE 260
						QPrint 3,1,"Left mouse click at: "+STR$(MRow%)+","+STR$(MCol%)
					CASE 261
						QPrint 3,1,"Left mouse double click at: "+STR$(MRow%)+","+STR$(MCol%)
					CASE 264
						QPrint 3,1,"Right mouse click at: "+STR$(MRow%)+","+STR$(MCol%)
					CASE 265
						QPrint 3,1,"Right mouse double click at: "+STR$(MRow%)+","+STR$(MCol%)
				END SELECT
			LOOP UNTIL KeyCode%=27
			CloseWin
			REDIM Msg$(1:1)
			Msg$(1)=""
		CASE 33                               'LineEditWin%
			REDIM Msg$(0:2)
			Msg$(0)="LineEditWin% Demo":Msg$(1)="Note how the text scrolls..."
			Msg$(2)="All letters are forced to upper case."
			Opt%=4
			Text$="EDIT THIS LINE OF TEXT!"
			IF LineEditWin% (4,15,&H4F,Msg$(),Text$,25,Opt%) THEN
				REDIM Msg$(1:2)
				Msg$(1)="You Typed:"
				Msg$(2)= LEFT$(Text$,60)
			ELSE
				REDIM Msg$(1:1)
				Msg$(1)="You Pressed Esc"
			END IF
		CASE 34,74      'MakeButtons and UnMakeButtons
			REDIM Msg$(0:12)
			Msg$(0)="MakeButtons Demo"
			Msg$(1)="If your end user has EGA/VGA capability, fancy buttons"
			Msg$(2)="can be drawn by Bag o' Tricks. Users with lesser systems"
			Msg$(3)="are not penalized, the *same program* running on Mono/CGA"
			Msg$(4)="will simply substitute standard ASCII charcters."
			Msg$(5)=" "
			Msg$(6)="                EGA/VGA      Mono/CGA"
			Msg$(7)="Radio Buttons: "+CHR$(128,129,130,32,32,128,131,130)+"      ( )      ()"
			Msg$(8)="Check Boxes:   "+CHR$(132,133,134,32,32,132,135,134)+"      [ ]      [X]"
			Msg$(9)="Yes Icons:     "+CHR$(136,137,138,32,32,139,140,141)+"      <Yes>    (Yes)"
			Msg$(10)="No Icons:      "+CHR$(142,143,144,32,32,145,146,147)+"      <No>     (No)"
			Msg$(11)="OK Icons:      "+CHR$(148,149,150,32,32,151,152,153)+"      <OK>     (OK)"
			Msg$(12)="Cancel Icons:  "+CHR$(154,155,156,157,32,158,159,160,161)+"     <Cancel> (Cancel)"

		CASE 35,36      'MoreColrOn and MoreColrOff
			MoreColrOn
			IF ISTRUE BIT(BagStat%,4) THEN
				Attr%=&H80
				FOR Row%=3 to 13 STEP 10
					FOR Col%=3 TO 57 STEP 18
						OpenWin Row%,Col%,7,14,Attr%,11,""
						QPrint 1,1,"High-intensity"
						QPrint 2,1,"backgrounds."
						QPrint 4,1,"This window"
						QPrint 5,1,"has attribute:
						QPrint 6,1,"&H"+HEX$(Attr%)
						QPrint 7,1,"Press any key."
						Attr%=Attr%+&H10
					NEXT Col%
				NEXT Row%
				KeyOrMouse K%,Row%,Col%  'all dummy args: this is just a pause.
				FOR X%=1 TO 8
					CLoseWin
				NEXT X%
				REDIM Msg$(1:1)
				Msg$(1)=""
			ELSE
				REDIM Msg$(1:2)
				Msg$(1)="You must have an EGA or VGA system"
				Msg$(2)="to make use of MoreColrOn."
			END IF
			MoreColrOff
		CASE 37 TO 46                         'Mouse
			REDIM Msg$(0:4)
			Msg$(0)="Mouse Routines"
			Msg$(1)="Although a full range of stand-alone mouse routines"
			Msg$(2)="are included in the package, you will probably find"
			Msg$(3)="easier to use just one routine, KeyOrMouse, for most"
			Msg$(4)="of your mouse handling. See the demo under KeyOrMouse."
		CASE 48                                'NumEditWin%
			REDIM Msg$(0:3)
			Msg$(0)="NumEditWin% Demo":Msg$(1)="Numeric string formatted"
			Msg$(2)="for a phone number.":Msg$(3)="Auto-exit when field is full."
			Opt%=4
			Text$="(   )   -    "
			IF NumEditWin% (4,15,&H4F,Msg$(),Text$,Opt%) THEN
				REDIM Msg$(1:2)
				Msg$(1)="You Typed:"
				Msg$(2)= Text$
			ELSE
				REDIM Msg$(1:1)
				Msg$(1)="You Pressed Esc"
			END IF
		CASE 54     'OKWin%
			DIM Msg$(0:1)
			Msg$(0)="OkWin% Demo":Msg$(1)="Thanks for using this product"
			IF OKWin% (4,12,&H4F,Msg$()) THEN
				Msg$(0)=""
				Msg$(1)= "You Picked OK"
			ELSE
				Msg$(0)=""
				Msg$(1)="You Pressed Esc"
			END IF

		CASE 55   'OKCancelWin%
			DIM Msg$(0:1)
			Msg$(0)="OKCancelWin% Demo":Msg$(1)="Would you like to continue?"
		        SELECT CASE OKCancelWin (4,12,&H4F,Msg$())
		              CASE 1
				Msg$(0)=""
				Msg$(1)="You Picked OK"
		              CASE 0
				Msg$(0)=""
				Msg$(1)="You Picked Cancel"
		              CASE -1
				Msg$(0)=""
                		Msg$(1)="You Picked Esc"
		        END SELECT

		CASE 58    	'PickFileWin$
			REDIM Msg$(0:2)
			Msg$(0)="PickFileWin$ Demo!":Msg$(1)="Choose a file via the"
			Msg$(2)="keyboard or mouse, or press Esc."
            Z$=PickFileWin$ (3,20,&H30,Msg$(),"*.*",8,7)
            IF LEN(Z$) THEN
				REDIM Msg$(1:2)
				Msg$(1)="You Picked:"
				Msg$(2)= Z$
				Z$=""
			ELSE
				REDIM Msg$(1:1)
				Msg$(1)="You Pressed Esc"
			END IF
		CASE 60  	'PickListWin%
			REDIM Item$(1:11),Msg$(0:2)
			Msg$(0)="PickListWin$ Demo"
			Msg$(1)="Which is your favorite"
			Msg$(2)="early American President?"
			Item$(1)="Washington"
			Item$(2)="Adams"
			Item$(3)="Jefferson"
			Item$(4)="Madison"
			Item$(5)="Monroe"
			Item$(6)="J.Q. Adams"
			Item$(7)="Jackson"
			Item$(8)="Polk"
			Item$(9)="W.H. Harrison"
			Item$(10)="Taylor"
			Item$(11)="Buchanan"
			Z$= PickListWin$(3,20,&H30,Msg$(),Item$())

			IF LEN(Z$) THEN
				REDIM Msg$(1:2)
				Msg$(1)="You Picked:"
				Msg$(2)= Z$
				Z$=""
			ELSE
				REDIM Msg$(1:1)
				Msg$(1)="You Pressed Esc"
			END IF

		CASE 65    'RadioWin%
			REDIM Item$(0:2),Msg$(0:1)
			Item$(0)="Fast":Item$(1)="Cheap":Item$(2)="Correctly"
			Msg$(0)="RadioWin% Demo":Msg$(1)="How should I do the job?"
			Stat%=1
			IF RadioWin%(4,25,&H70,Msg$(),Stat%,Item$()) THEN
				REDIM Msg$(1:2)
				Msg$(1)="You Picked:"
				FOR X%= 0 TO 15
					IF BIT(Stat%,X%) THEN
						Msg$(2)=Item$(X%)
						EXIT FOR
					END IF
				NEXT X%
			ELSE
				REDIM Msg$(1:1)
				Msg$(1)="You pressed Esc"
			END IF
		CASE 77   'YesNoWin%
			DIM Msg$(0:1)
			Msg$(0)="YesNoWin% Demo":Msg$(1)="Would you like to continue?"
		        SELECT CASE YesNoWin% (4,12,&H4F,Msg$())
		              CASE 1
                          Msg$(0)=""
                          Msg$(1)="You Picked Yes"
		              CASE 0
                          Msg$(0)=""
                          Msg$(1)="You Picked No"
		              CASE -1
                          Msg$(0)=""
                          Msg$(1)="You Picked Esc"
		      END SELECT
		CASE ELSE
			REDIM Msg$(0:2)
			Msg$(1)="No demo is available"
			Msg$(2)="   for this topic."
		END SELECT
	IF LEN(Msg$(1)) THEN
		Dummy&=OkWin%(3,3,&H5F,Msg$())
	END IF
	ERASE Msg$(),Item$()   'Clear up a little memory
END IF
PopCursor
ConTrolCount%=-1       'These lines make sure we return
KeyCode%=-15           'to the PickList

RETURN
'-------------------------------------------------------------------------
SUB ControlDemo ()
 DIM Menu$(0:17),Srt$(0:4),Info$(0:2)

 Menu$(1)="~`File"     'The ~ indicates that this item is on the horiz. menu
 Menu$(2)="`Save"      'and the ` precedes the highlighted hot-key
 Menu$(3)="Save `As"
 Menu$(4)="`Load"
 Menu$(5)="-"          'A single hyphen draws a separating line in the menu.
 Menu$(6)="`About"
 Menu$(7)="~`Edit"
 Menu$(8)="Cu`t"
 Menu$(9)="`Copy"
 Menu$(10)="`Paste"
 Menu$(11)="`Delete"
 Menu$(12)="~`Search"
 Menu$(13)="`Find"
 Menu$(14)="`Replace"
 Menu$(15)="`Search Again"
 Menu$(16)="-"
 Menu$(17)="`Goto Line Number"

 Srt$(0)="Unsorted"
 Srt$(1)="Name"
 Srt$(2)="Extension"
 Srt$(3)="Size"
 Srt$(4)="Date"

 Info$(0)="Extended File Info"
 Info$(1)="List Directories"
 Info$(2)="List Drives"

 SortBy%=2                    'Information for the
 ExtdInfo%=3                  'PickAFile Routine
 OK%=1
 Mask$="*.*"
 Txt$="Text in this field can be as long as the current string segment will allow."
 FixNum$="   0.00"
 FloatNum$="       "
 PhoneNum$="(602)495-1493"

 CALL OpenWin(1,1,23,76,&H1F,1,"Controls Demo")
 PushCursor
 COLOR 14,1
 QPrint 1,22,CHR$(27)+" Bar Menu"
 QPrint 3,26,CHR$(27)+" Fixed-length text field."
 QPrint 4,14,CHR$(27)+"Radio buttons. "+CHR$(25)+" Check Boxes."
 QPrint 9,2,CHR$(25)+"PickFile is a special case of PickList"
 QPrint 17,20,CHR$(27)+" Variable-length text field."
 QPrint 18,10,CHR$(27)+" Fixed-point numeric field."
 QPrint 19,10,CHR$(27)+" Floating-point numeric field."
 QPrint 20,16,CHR$(27)+" Numeric field, formatted for a phone #."
 QPrint 21,15,CHR$(27)+" OK/Cancel icons."
 QPrint 23,15,CHR$(27)+" Yes/No icons."
 COLOR 12,1
 QPrint 6,51,"Notice how you can move"
 QPrint 7,51,"to another field to with"
 QPrint 8,51,"TAB, SHIFT-TAB or by"
 QPrint 9,51,"clicking the mouse."
 QPrint 10,51,"Ctrl-Home and Ctrl-End"
 QPrint 11,51,"will take you to the top"
 QPrint 12,51,"or bottom of the screen."
 QPrint 14,51,"Access the Bar Menu with"
 QPrint 15,51,"the mouse or by pressing"
 QPrint 16,51,"ALT, then one of the high-"
 QPrint 17,51,"lighted letters."
 PopCursor
 QPrint 3,2,"File Mask:"

 KeyCode%=300        'Always put this line before the control loop.
 NumOfControls%=12   'Also indicate the number of controls

 DO
	BarMenu 1,1,MenuIndex%,Menu$(),KeyCode%
	COLOR 0,3
	CALL LineEdit(3,13,Mask$,12,5,KeyCode%)
	COLOR 15,1
	CALL Radio(4,2,SortBy%,Srt$(),0,KeyCode%)
	CALL CHECK(5,18,ExtdInfo%,Info$(),0,KeyCode%)
	IF ExtdInfo%<> OldExtdInfo% THEN   'We have to clear an area
		ScrollUP 10,2,6,39,0      'of the screen if the ExtdInfo% changes.
	END IF
	CALL PickAFile(10,2,6,Mask$,SortBy%,ExtdInfo%,C$,KeyCode%)
	OldExtdInfo%=ExtdInfo%
	COLOR 0,7
	CALL LineEdit(17,2,Txt$,17,0,KeyCode%)
	CALL NumEdit(18,2,FixNum$,4,KeyCode%)
	CALL NumEdit(19,2,FloatNum$,7,KeyCode%)
	CALL NumEdit(20,2,PhoneNum$,0,KeyCode%)
	COLOR 15,1
	CALL OKCancel(21,2,OK%,1,KeyCode%)
	CALL YesNo(23,2,Yes%,1,KeyCode%)
	CALL UserButton (21,36,"Push this user defined button to QUIT.",KeyCode%)
 LOOP UNTIL (KeyCode%=13)
 CloseWin
END SUB   'ControlDemo
