'  Type structure to save user records as.


TYPE dbase
	user     AS STRING * 20
	realname AS STRING * 40
	address  AS STRING * 40
	hobbies  AS STRING * 30
	radio    AS STRING * 10
	food     AS STRING * 20
	age      AS STRING * 2
	sex      AS STRING * 1
	rsmfile  AS STRING * 8
END TYPE

CONST YES = -1
CONST NO = 0

DECLARE SUB Main ()
DECLARE SUB readfile ()
DECLARE SUB addfile ()
DECLARE FUNCTION RTRM$ (txt$)
DECLARE SUB showres (filename$)


'$INCLUDE: 'MDM.INC'
'$INCLUDE: 'DOOR.INC'

ON ERROR GOTO trap   '   Prevent any chances of Lock-Ups.

lin$ = COMMAND$      '   Get the Door file type.  You will run this door like
										 '   USERINFO CHAIN.TXT for chain.txt, USERINFO DOOR.SYS
										 '   for door.sys and so on....  if there is no command
										 '   line then it will default to local mode.

'  *******  Look for a known Drop File type **********

df% = 0
IF INSTR(lin$, "CHAIN.TXT") THEN df% = 1
IF INSTR(lin$, "DOOR.SYS") THEN df% = 2
IF INSTR(lin$, "DORINFO1.DEF") THEN df% = 3

' *******  Set up variables.  ************************


SELECT CASE df%
	CASE 0                            ' No Drop file, Local mode
		baud = 0
		lcl = -1
		LUser.useransi = -1
		LUser.handle = "SysOp"
		U.Time.Secs& = 3600
		LUser.systemn = "Generic BBS"
	CASE 1                             '  Read CHAIN.TXT drop file
		rd.chain.txt
		baud = LUser.commrate
		IF LUser.baudrate = 0 THEN
			baud = 0
			lcl = -1
		END IF
		IF LUser.commrate > 2400 THEN HandShake% = 3
	CASE 2                             '  Read DOOR.SYS drop file
		rd.door.sys
		baud = LUser.commrate
		IF LUser.baudrate = 0 THEN
			baud = 0
			lcl = -1
		END IF
		IF LUser.commrate > 2400 THEN HandShake% = 3
	CASE 3                             '  Read DORINFO1.DEF dropfile
		rd.dorinfox.def 1
		baud = LUser.baudrate
		IF LUser.baudrate = 0 THEN
			baud = 0
			lcl = -1
		END IF
END SELECT

IF LUser.port = 0 THEN LUser.port = 2     ' Set the comport to a default of
																					' COM2 (change for your system)


Using.ANSI% = LUser.useransi              ' Set the global ANSI variable to
																					' know weather or not the user has
																					' ANSI

InitTime U.Time.Secs&                     ' Initialize the users time online
																					' U.Time.Secs& was read from the
																					' Drop file.

Door.Name$ = "User Information Center   " ' Program Name to appear on the
																					' Status Bar.

Dir.Scr.Wrt% = -1                         ' Use Direct Screen Writes

Sta.Bar% = -1                             ' Allow a status Bar

port% = LUser.port                        ' Set the port to the User's Port.

FOSSIL% = 0                               ' Don't use a fossil driver

Err.Msg$ = ""                             ' clear the error message variable

Parity% = 0                               ' use default parity for specified
																					' com port.

WordLen% = 8                              ' 8 bits

IRQ% = 0                                  ' use defualt irq for specified port

InitPort                                  ' initialize the com port.

StatusBar                                 ' Turn On the Status Bar

Main                                      ' Call the main SUB

goodbye:                                  ' Label for Error Trap

ExitProgram                               ' Terminate Program.


trap:                                     ' Generic Error trap
RESUME goodbye                            ' Any error will cause it to end.

DEFSNG A-Z
SUB addfile

 clearscr                                       'Clear the Screan

 Send "1Now you can fill out the information for yourself 8" + RTRM$(LUser.handle)

 nl 2                                           ' Send two line feeds

 ' ******  Create a Yes No Prompt with hot keys ********

 InComm "", "9Continue (2Y/N9) ? ", yesno$, -1, "YyNn"

 nl 2
 IF UCASE$(yesno$) = "N" THEN EXIT SUB
 XSend "9If you do not want to answer the question just hit enter.", NO, YES
 XSend "9and it will be marked as Unknown.", NO, YES
 DIM record AS dbase
 filenum = FREEFILE
 OPEN "INFOCTR.DAT" FOR RANDOM ACCESS READ WRITE SHARED AS #filenum LEN = LEN(record)
 numberofrecords = LOF(filenum) \ LEN(record)
 
 '**  Test to see if user was previously in the database. **

 FOR fall = 1 TO numberofrecords
	 GET filenum, fall, record
	 IF UCASE$(RTRM$(record.user)) = UCASE$(RTRM$(LUser.handle)) THEN
		 usernum% = fall
		 EXIT FOR
	 END IF
 NEXT fall
 IF usernum% = 0 THEN
	 usernum% = numberofrecords + 1
 END IF

 '************************************************************

 record.rsmfile = ""
 CLOSE #filenum
 record.user = LUser.handle
 docr

 '  ******** Use the InComm function to create a 40 long field ***********
 InComm "", "1Your Real Name : 2", dat$, 40, ""
 '  **********************************************************************

 IF dat$ = "" THEN
	 record.realname = "<<UNKNOWN>>"
 ELSE
	 record.realname = dat$
 END IF
 docr
 InComm "", "1Your Address : 2", dat$, 40, ""
 IF dat$ = "" THEN
	 record.address = "<<UNKNOWN>>"
 ELSE
	 record.address = dat$
 END IF
 docr
 InComm "", "1Your Hobbies : 2", dat$, 30, ""
 IF dat$ = "" THEN
	 record.hobbies = "<<UNKNOWN>>"
 ELSE
	 record.hobbies = dat$
 END IF
 docr

 '============================== M A S K E D   I N P U T ======================

 '  ************** Allow only these characters! *****************
 mask$ = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"
 '  *************************************************************

 InComm "", "1Your Favorite Radio Station (4 Call Letters) : 2", dat$, 4, mask$
 '                                                                            |
 ' Use the characters defined above, user can only pick from them ____________|

 '==============================================================================

 IF dat$ = "" THEN
	 record.radio = "????"
 ELSE
	 record.radio = UCASE$(dat$)
 END IF
 docr
 InComm "", "1Your Favorite Food : 2", dat$, 20, ""
 IF dat$ = "" THEN
	 record.food = "<<UNKNOWN>>"
 ELSE
	 record.food = dat$
 END IF
 docr
 mask$ = "1234567890"
 InComm "", "1Your Age : 2", dat$, 2, mask$
 IF dat$ = "" THEN
	 record.age = ""
 ELSE
	 record.age = dat$
 END IF
 docr
 mask$ = "MmFfUu"
 InComm "", "1Your Sex / Gender : 2", dat$, -1, mask$
 IF UCASE$(dat$) = "U" THEN
	 record.sex = ""
 ELSE
	 record.sex = UCASE$(dat$)
 END IF
 docr
 mask$ = "YyNn"
 InComm "", "9Write a small Resume Describing yourself (2Y/N9) ?2", dat$, -1, mask$
 IF UCASE$(dat$) = "Y" THEN
		 record.rsmfile = "INFO" + LTRIM$(STR$(usernum%))
		 file4 = FREEFILE
		 OPEN RTRM$(record.rsmfile) + ".RSM" FOR OUTPUT AS #file4
		 Send "2You may now write up to 6222 lines describing yourself.  8/S2 = Save"
		 docr
		 Send "9" + STRING$(80, "-") + "0"
		 docr
		 FOR lin = 1 TO 22
			 txt$ = getline$("", 60, 78)
			 docr
			 IF UCASE$(LEFT$(txt$, 2)) = "/S" THEN EXIT FOR
			 PRINT #file4, txt$
		 NEXT lin
		 docr
		 Send "2Saving File....."
		 ansicd 0
		 CLOSE #file4
 ELSE
		 record.rsmfile = "^___^"
 END IF
 docr
 Send "9Saving to database......"
 nl 3
 Pause
 ansicd 0

 '  ***  Save to Disk ****

 filenum = FREEFILE
 OPEN "INFOCTR.DAT" FOR RANDOM ACCESS READ WRITE SHARED AS #filenum LEN = LEN(record)
 numberofrecords = LOF(filenum) \ LEN(record)
 PUT #filenum, usernum%, record
 CLOSE #filenum
END SUB

SUB Main
	'  NOTICE the  <-- Heart Codes they will change the colors as follows;
	'
	'  1 = CYAN
	'  2 = YELLOW
	'  3 = MAGENTA
	'  4 = WHITE on BLUE
	'  5 = DARK GREEN
	'  6 = FLASHING RED
	'  7 = BLUE
	'  8 = WHITE
	'  9 = BRIGHT GREEN
	'  0 = NORMAL GREY
	'
	DO
	 clearscr
	 Send "9Hello 2" + RTRM$(LUser.handle) + "9,"
	 docr
	 lin1$ = addspace$("8Welcome to the 1" + RTRM$(LUser.systemn) + "'s 8User Info Center.")
	 Send lin1$
	 nl 9
	 Send "                     21.  1Add/Edit Your Info to Database."
	 docr
	 Send "                     22.  1Read Database Records."
	 docr
	 Send "                     23.  1Quit to " + RTRM$(LUser.systemn)
	 nl 3
	 InComm "", "                             9Your Choice : 2", choice$, -1, "123"
	 SELECT CASE choice$
			CASE "1"
				addfile
			CASE "2"
				readfile
			CASE "3"
				ansicd 0
				ClearStatusBar
				clearscr
				EXIT SUB
	 END SELECT
	LOOP
END SUB

SUB readfile
 clearscr

 DIM record AS dbase
 filenum = FREEFILE
 OPEN "INFOCTR.DAT" FOR RANDOM ACCESS READ WRITE SHARED AS #filenum LEN = LEN(record)
 numberofrecords = LOF(filenum) \ LEN(record)
 DO
	 Send "               8Find User's by Handle,  <CR> returns to main menu."
	 nl 3
	 Send "9Ok " + RTRM$(LUser.handle) + ", enter a username to look up ? 2"
	 handle$ = getline$("", 60, 0)
	 FixCase handle$
	 IF handle$ = "" THEN
		 ansicd 0
		 CLOSE #filenum
		 EXIT SUB
	 END IF
	 loct = 0
	 FOR a = 1 TO numberofrecords
		 GET #filenum, a, record
		 postn = 0
		 postn = INSTR(UCASE$(RTRM$(record.user)), UCASE$(RTRM$(handle$)))
		 IF postn <> 0 THEN loct = 3: EXIT FOR
	 NEXT a
	 IF loct <> 3 THEN
		 clearscr
		 Send "2" + handle$ + "9 Not Found"
		 docr
	 ELSE
		 clearscr
		 lin$ = addspace$("3" + RTRM$(LUser.systemn) + "5 User Information Center")
		 Send lin$
		 nl 7
		 Send SPACE$(27) + "2Handle : "
		 Send "1" + record.user
		 docr
		 Send SPACE$(27) + "2Real Name : "
		 IF RTRM$(record.realname) = "<<UNKNOWN>>" THEN
				 lin$ = "3" + record.realname + "0"
		 ELSE
				 lin$ = "1" + record.realname
		 END IF
		 Send lin$
		 docr
		 Send SPACE$(27) + "2Address : "
		 IF RTRM$(record.address) = "<<UNKNOWN>>" THEN
				 lin$ = "3" + record.address + "0"
		 ELSE
				 lin$ = "1" + record.address
		 END IF
		 Send lin$
		 docr
		 Send SPACE$(27) + "2Hobbies : "
		 IF RTRM$(record.hobbies) = "<<UNKNOWN>>" THEN
				 lin$ = "3" + record.hobbies + "0"
		 ELSE
				 lin$ = "1" + record.hobbies
		 END IF
		 Send lin$
		 docr
		 Send SPACE$(27) + "2Favorite Radio Station : "
		 IF RTRM$(record.radio) = "????" THEN
				 lin$ = "3" + record.radio + "0"
		 ELSE
				 lin$ = "1" + record.radio
		 END IF
		 Send lin$
		 docr
		 Send SPACE$(27) + "2Favorite Food : "
		 IF RTRM$(record.food) = "<<UNKNOWN>>" THEN
				 lin$ = "3" + record.food + "0"
		 ELSE
				 lin$ = "1" + record.food
		 END IF
		 Send lin$
		 docr
		 Send SPACE$(27) + "2Age : "
		 IF RTRM$(record.age) = "" THEN
				 lin$ = "3Hmmm. ???0"
		 ELSE
				 lin$ = "1" + record.age
		 END IF
		 Send lin$
		 docr
		 Send SPACE$(27) + "2Sex : "
		 IF UCASE$(RTRM$(record.sex)) = "" THEN
				 lin$ = "3Undiscovered0"
		 ELSE
				 lin$ = "1" + record.sex
		 END IF
		 Send lin$
		 nl 6
		 IF RTRM$(LTRIM$(record.rsmfile)) <> "" AND exist(RTRM$(record.rsmfile) + ".RSM") THEN
				InComm "", "9View Resume for 2" + LTRIM$(RTRM$(record.user)) + "9 (2Y/N9) ? 0", answer$, -1, "YyNn"
				IF UCASE$(answer$) = "Y" THEN showres RTRM$(record.rsmfile) + ".RSM"
		 END IF
	 END IF
	 Pause
	 clearscr
 LOOP
END SUB

' Similar to RTRM$ but shaves NUL Characters too.
FUNCTION RTRM$ (st$)
	ol = LEN(st$)
	st1$ = st$
	FOR a = 1 TO ol
		IF RIGHT$(st1$, 1) = " " THEN
			st1$ = LEFT$(st1$, (LEN(st1$) - 1))
		ELSEIF ASC(RIGHT$(st1$, 1)) = 0 THEN
			st1$ = LEFT$(st1$, (LEN(st1$) - 1))
		ELSE
			EXIT FOR
		END IF
	NEXT a
	RTRM$ = st1$
END FUNCTION

SUB showres (filename$)
 clearscr
 nl 2
 IF exist(filename$) THEN
	 file3 = FREEFILE
	 OPEN filename$ FOR INPUT AS #file3
	 ansicd 0
	 lin = 0
	 DO
		 lin = lin + 1
		 INPUT #file3, txt$
		 Send txt$
		 docr
	 LOOP UNTIL EOF(file3)
	 CLOSE #file3
	 docr
 ELSE
	 Send "6File Not found0"
 END IF
 docr
END SUB

