/* LORDLOCK.C
** LORD's locking routines translated to C
**
** Pascal version copyright is held by Seth Able Robinson
**
** C version - Copyright 1995 by John Hutton.  All rights reserved.
** You have my permission to include this code in your own programs
** whether commercial or noncommercial.
**
** Note that this module does not run on it's own.  It's meant to be
** part of a larger project.  Refer to Borland's documentation on
** project files
*/

#include <dir.h>
#include <dos.h>
#include <io.h>
#include <stdio.h>
#include <string.h>
#include "lordlock.h"


/* This function expects to be passed the name of the file that you want
** access to. For example... 
**
** get_access_hard( "PLAYER.DAT" );
**
** It checks for the presence of a locking semaphore file, PLAYER.DAX in
** this case, waits up to three seconds if it finds one, and overwrites
** it, or if it doesn't find one, creates it immediately.
*/

void get_access_hard( char *file_name )
  {
  char temp[128];
  struct ffblk ffblk;
  int done, counter = 0;
  FILE *f;

  strcpy( temp, file_name );
  temp[ strlen( temp ) - 1] = 'X';

  done = findfirst( temp, &ffblk,0);
  while ((!done) && (counter < 3))
    {
    sleep( 1 );
    done = findfirst( temp, &ffblk, 0);
    counter++;
    }

  f = fopen( temp, "w");          /* create the semaphore file */
  fclose( f );

  }

/* This function deletes the locking semaphore file, signaling that
** other nodes may access the file now.  It expects the name of the
** data file to release.  For example...
**
** unlock_file( "PLAYER.DAT" );
*/

void unlock_file( char *file_name )
  {
  char temp[128];

  strcpy( temp, file_name);
  temp[ strlen( temp ) - 1] = 'X';

  unlink( temp );
  }

/* This is just a quicky file copy function.  You need to use this, or
** something like it, anytime the operation that you're going to perform
** on a data file could reasonably be expected to take more than an 
** an instant.  Commonly, if a player is browsing a data file, it's not
** going to be quick and you need to copy the data file so they can look
** at their leisure.
**
** This function expects the name of the data file and the player's
** record number.  For example...
**
** copy_file( "PLAYER.DAT", 12 );
**
** This copies the contents of PLAYER.DAT to TEMP12 (remember to delete
** the temporary file when you're done so you don't clutter up the LORD 
** directory).
*/

int copyfile( char *from_file, int player_num)
  {
  char temp[128];
  FILE *f, *g;
  int holder;
  struct ffblk ffblk;

  sprintf( temp, "TEMP%d", player_num);

  f = fopen( from_file, "rb" );
  g = fopen( temp, "wb" );

  do
    {
    holder = fgetc( f );
    fputc( holder, g );
    } while (holder != EOF);

  fclose( f );
  fclose( g );

  return !findfirst( temp, &ffblk, 0 );  /* return status - did it work? */

  }
