/* CALLERS.CMD - Program to count Callers in one day. 
    version 1.0, 5 March, 1995 by Elliott Goodman 

I run this from my LOG.CMD program, run nightly during
Lora's 'auto-maint' phase, the only time the logfile is free.
If you are going to use LOG.CMD to run it, place it as follows:

        say 'Door Tracker....'                   
        call Door_tracker                        
                                                 
        say "Running MSGCNT.CMD. Please wait...."
        call "d:\lora\lang\msgcnt.cmd"

        say "Running CALLERS.CMD...."
        call "d:\lora\lang\callers.cmd"
                                                 
        say 'Remove routine....'                 
        call remove_stuff                        

Locate the two routines above and place it between them as
shown with correct drive/path info.

Feel free to modify as needed.

Donations for this program may be sent to:

     Elliott Goodman        
     PO Box 500038          
     Palmdale, CA 93591-0038
*/

/* trace ?a */

/* load if not already loaded */
if RxFuncQuery('SysLoadFuncs') then
do
        call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
        call SysLoadFuncs
end

/* save directory info */       
old_dir = directory()           
                                
/* modify as necessary */       
call directory('D:\LORA\LANG')  

/* initialize variables */
phrase1 = 'off-line.'

in_name = 'lora.log'
out_name = 'CALLERS.TXT'
user_names = 0
temp_name = ' '
temp_count = 0
total_count = 0

/* remove previous Output file, if present */
call SysFileDelete(out_name)

drop callers.

/* Initialize Output file with date/time */
m_txt = 'User Count v1.0 by Elliott Goodman'
call lineout out_name, m_txt
m_txt = '  '
call lineout out_name, m_txt
m_txt = 'Callers yesterday'
call lineout out_name, m_txt
time_string = time('C')
date_string = date('N')
m_txt = 'Current time:' time_string || ',' date_string
call lineout out_name, m_txt
m_txt = '  '
call lineout out_name, m_txt

/* cycle thru LORA.LOG */
do until lines(in_name) = 0
    work_line = linein(in_name)

    j = wordpos(phrase1, work_line)
    if j \= 0 then do

/* break up line into elements */
        parse var work_line . . first last stuff

caller_tag = first last

/* search thru array for area tag and increment if found */
            found = 0
            do index = 1 to user_names
                if callers.index = caller_tag then do
                    callers.index.count = callers.index.count + 1
                    found = 1
                    leave
                    end /* if */
                end /* do index = 1 to user_names */

/* area tag not found; add to array */
             if found = 0 then do
                 user_names = user_names + 1
                 callers.user_names = caller_tag
                 callers.user_names.count = 1
                 end /* if found = 0 */
        end /* if j \= */
    end /* do until lines() = 0 */

/* sort routine - not fast but it works */
swap = 1
do until swap = 0
    swap = 0
    do index = 1 to user_names -1
        t_index = index + 1
        if callers.t_index.count > callers.index.count then do
            temp_name = callers.index
            temp_count = callers.index.count
            callers.index = callers.t_index
            callers.index.count = callers.t_index.count
            callers.t_index = temp_name
            callers.t_index.count = temp_count
            swap = 1
            end /* if */
        end /* do */
    end /* do until */

/* Now output sorted results after formatting a little */
do index = 1 to user_names
   m_txt = trunc(callers.index.count) '-' callers.index
   call lineout out_name, m_txt
   total_count = total_count + callers.index.count
   end

m_txt = '  '
call lineout out_name, m_txt

m_txt = space('Total' total_count,8,'.')
call lineout out_name, m_txt

/* close files, return to starting directory, copy output to
bulletin file */
call lineout in_name
call lineout out_name

'@copy' out_name 'd:\lora\misc\BULLET8.BBS 1>NUL 2>&1'
call directory(old_dir)
