' $segment
' $linesize:132
' $title: 'MESSAGES.BAS 17.4/CDor, Copyright 1994 by Daniel T. Drinnon'
'  RBBS-PC Copyright 1992 by D. Thomas Mack, all rights reserved.
'  Name ...............: MESSAGES.BAS
'  First Released .....: October 7, 1993
'  Subsequent Releases.: 
'  Copyright ..........: 1993,1994
'  Purpose.............: Message Handling calls for RBBS-PC
'  Parameters..........: Most parameters are passed via a COMMON statement.
'
' Subroutine or Function             Purpose
'  PrintMsg                           Process message for DL/Print/XPost
'  MessageHeader                      Formats message display header
'
' $INCLUDE: 'RBBS-VAR.BAS'

TYPE MsgHeader
   FromUser  AS STRING * 36
   ToUser    AS STRING * 36
   Subject   AS STRING * 72
   DateTime  AS STRING * 20
   TimesRead AS INTEGER
   DestNode  AS INTEGER
   OrigNode  AS INTEGER
   Cost      AS INTEGER
   OrigNet   AS INTEGER
   DestNet   AS INTEGER
   DestZone  AS INTEGER
   OrigZone  AS INTEGER
   DestPoint AS INTEGER
   OrigPoint AS INTEGER
   ReplyTo   AS INTEGER
   Attribute AS INTEGER
   NextReply AS INTEGER
END TYPE

'
' LineEditMessage
'
2121 SUB LineEditMessage (MsgParm,WasL)
     IF MsgParm = 1 THEN
        GOTO 2300
     END IF
     '* "Enter Your {MH {LM Lines max{CRPress [ENTER] on Empty line for Menu"
     LineNum = 68
     GOSUB 49000
     GOSUB 12975
     GOSUB 3200

2125 ZLinesInMsg = ZLinesInMsg + 1

2127 IF ZRemoteEcho OR ZLocalUser THEN
        ZOutTxt$ = RIGHT$(STR$(ZLinesInMsg),3) + ": " + ZOutTxtAra$(ZLinesInMsg)
     ELSE
        ZOutTxt$ = ZOutTxtAra$(ZLinesInMsg)
     END IF
     GOSUB 12978
     CALL LineEdit(ZLinesInMsg,ZRightMargin + 1)
     IF ZWaitExpired THEN
        GOTO 2300
     ELSEIF ZSubParm = -1 THEN
        EXIT SUB
     END IF
     CALL FindFKey
     IF ZSubParm < 0 THEN
        EXIT SUB
     END IF
     IF ZOutTxtAra$(ZLinesInMsg) = "" THEN
        ZLinesInMsg = ZLinesInMsg - 1
        GOTO 2300
     END IF

2140 WasJ = ZLinesInMsg
     GOSUB 2200
     IF WasX THEN
        GOTO 2300
     END IF
     GOTO 2125

2200 WasX = 0
     IF WasJ < (ZMaxMsgLines - 2) THEN
        RETURN
     END IF
     '* "Warning: 2 Lines Left!{RC"
     '* "Warning: Last Line!{RC"
     '* "Warning: No More Lines!{RC"
     LineNum = 69 + WasJ - (ZMaxMsgLines - 2)
     GOSUB 49000
     WasX = (WasJ > (ZMaxMsgLines - 1))

2210 GOSUB 12979
     RETURN

2300 CALL SkipLine (1)
     IF ZExpertUser THEN
        GOTO 2315
     END IF

2302 IF ZSysop OR ZLocalUser THEN
        '* "A)bort, B)atch import, C)ontinue adding, D)elete lines, E)dit a line"
        LineNum = 72
     ELSE
        '* "A)bort, C)ontinue adding, D)elete lines, E)dit a line"
        LineNum = 73
     END IF
     GOSUB 49000
     CALL TopPrompt
     '* "I)nsert lines, L)ist, M)argin change, R)evise subj, S)ave msg, ?)help"
     LineNum = 74
     GOSUB 49000
     CALL TopPrompt

2315 IF ZSysop OR ZLocalUser THEN
        '* "Edit Function <A,B,C,D,E,I,L,M,R,S,?>"
        LineNum = 75
     ELSE
        '* "Edit Function <A,C,D,E,I,L,M,R,S,?>"
        LineNum = 76
     END IF
     GOSUB 49000
     GOSUB 12930
     IF ZWasQ = 0 THEN
        GOTO 2315
     END IF
     CALL AraAllCaps (ZUserInAra$(),ZAnsIndex)
     ZWasZ$ = ZUserInAra$(ZAnsIndex)

2330 '* "ABCDEILMRS?"
     LineNum = 77
     GOSUB 49030
     WasX = INSTR(Strng$,ZWasZ$)
     SELECT CASE WasX
        CASE 1          ' Abort
           GOTO 2400
        CASE 2          ' Import
           GOTO 2335
        CASE 3          ' Continue
           GOTO 2332
        CASE 4          ' Delete Line
           GOTO 2500
        CASE 5          ' Edit a line
           GOTO 2600
        CASE 6          ' Insert Line
           GOTO 2800
        CASE 7          ' List Message
            GOTO 3000
        CASE 8          ' Margin Change
            GOTO 3100
        CASE 9          ' Revise Subject
           GOTO 2440
        CASE 10         ' Save Message
           ZSubParm = 1
           EXIT SUB
        CASE 11         ' Help
           GOTO 2345
        CASE ELSE
           GOTO 2300
     END SELECT
'
' *****  CONTINUE MESSAGE  ****
'
2332 IF ZLinesInMsg < 1 THEN _
        ZLinesInMsg = 1
     GOTO 2127
'
' *****  IMPORT TEXT  ****
'
2335 WasX = ZLinesInMsg
     CALL MsgImport (ZMaxMsgLines,ZRightMargin,ZLinesInMsg,ZOutTxtAra$())
     IF ZLinesInMsg > WasX THEN
        GOSUB 3200
        IF WasL = 0 THEN
           WasL = 1
        END IF
        GOTO 3000
     ELSE
        GOTO 2300
     END IF
'
' *****  DISPLAY MESSAGE SUBCOMMANDS HELP FILE   ****
'
2345 CALL GraphicDisplayFile (ZHelp$(4))
     GOTO 2302
'
' ****  ABORT MESSAGE   ***
'
2400 GOSUB 2435
     IF NOT ZYes THEN
        GOTO 2300
     END IF
     ZSubParm = 2
     EXIT SUB
2435 '* "Really Abort Your {MH? (Y,[N])"
     LineNum = 79
     GOSUB 49000
     GOSUB 12930
     RETURN
'
' *****  SET/CHANGE SUBJECT FOR A MESSAGE   ***
'
2440 '* "Change subject to{EX"
     LineNum = 63
     GOSUB 49000
     ZMacroMin = 99
     ZParseOff = ZTrue
     GOSUB 12932
     IF LEN(ZUserIn$) > 25 THEN
        '* "Subject must be LESS than 25 Characters!"
        LineNum = 65
        GOSUB 49000
        GOSUB 12979
        GOTO 2440
     END IF
     IF ZWasQ THEN
        ZSubject$ = UCASE$(ZUserIn$)
        OrigSubject$ = ZSubject$
     END IF
     GOTO 2300
'
' *****  (BLOCK) DELETE MESSAGE LINE(S)  *****
'
2500 '* "Delete From"
     LineNum = 80
     GOSUB 49000
     GOSUB 3300
     IF ZWasQ = 0 AND Mark1 = 0 THEN
        GOTO 2300
     END IF
     Mark1 = ZTestedIntValue
     IF ZAnsIndex < ZLastIndex AND ZUserInAra$(ZAnsIndex+1) = "-" THEN _
           ZAnsIndex = ZAnsIndex + 1 _
     ELSE Temp = INSTR(ZUserInAra$(ZAnsIndex),"-") : _
             IF Temp > 0 AND Temp < LEN(ZUserInAra$(ZAnsIndex)) THEN _
                ZUserInAra$(ZAnsIndex) = MID$(ZUserInAra$(ZAnsIndex),Temp+1) : _
                ZAnsIndex = ZAnsIndex - 1
2520 '* "Through Line #"
     LineNum = 81
     GOSUB 49030
     Temp$ = Strng$
     CALL ChangeInt (ZFalse,Temp$,0,Mark1,ZLinesInMsg)
     IF ZWasQ = 0 THEN _
        Mark2 = Mark1 _
     ELSE Mark2 = ZTestedIntValue
     CALL SkipLine(1)
     GOTO 2530
2522 FOR WasX = Mark1 TO Mark2
        CALL AskMore ("",ZTrue,ZTrue,WasXX,ZFalse)
        IF ZNo OR ZRet THEN _
           WasX = Mark2 + 1 _
        ELSE ZOutTxt$ = ZOutTxtAra$(WasX) : _
           GOSUB 12977
     NEXT
     CALL SkipLine(1)
2530 ' * "Delete lines"
     LineNum = 82
     GOSUB 49000
     '* "{SP(Y,[N],L)ist"
     LineNum = 83
     GOSUB 49030
     ZOutTxt$ = ZOutTxt$ + STR$(Mark1) + "-" + MID$(STR$(Mark2),2) + Strng$
     GOSUB 12930
     Temp$ = UCASE$(ZUserInAra$(ZAnsIndex))
     IF Temp$ = "L" THEN GOTO 2522
     IF NOT ZYes THEN
        '* "NOT Deleted"
        LineNum = 84
        GOSUB 49000
        GOSUB 12979
        GOTO 2555
     END IF
2550 ZBlockSize = (Mark2 - Mark1) + 1
     EndOfBuffer = ZLinesInMsg + 1
     ZLinesInMsg = ZLinesInMsg - ZBlockSize
     FOR WasX = Mark1 TO ZLinesInMsg
        ZOutTxtAra$(WasX) = ZOutTxtAra$(WasX + ZBlockSize)
     NEXT
     FOR WasX = (ZLinesInMsg + 1) TO (EndOfBuffer)
        ZOutTxtAra$(WasX) = ""
     NEXT
     '* "{SPLine(s) Deleted."
     LineNum = 85
     GOSUB 49030
     ZOutTxt$ = MID$(STR$(ZBlockSize), 2) + Strng$
     GOSUB 12979
2555 Mark1 = 0
     Mark2 = 0
     GOTO 2300
'
' ****  EDIT MESSAGE LINE  ***
'
2600 '* "Edit"
     LineNum = 86
     GOSUB 49000
     GOSUB 3300
     IF ZWasQ <> 0 THEN _
        CALL EditALine (ZTestedIntValue)
     IF ZSubParm < 0 THEN
        EXIT SUB
     END IF
     GOTO 2300
'
' **** INSERT LINE ***
'
2800 IF ZLinesInMsg >= ZMaxMsgLines AND NOT ZSysop THEN
        '* "Message is Full."
        LineNum = 87
        GOSUB 49000
        GOSUB 12979
        GOTO 2300
     END IF
2820 '* "Insert Before"
     LineNum = 88
     GOSUB 49000
     GOSUB 3300
2830 WasLL = ZLinesInMsg
     WasK = ZLinesInMsg - ZTestedIntValue
     FOR WasX = ZTestedIntValue TO ZLinesInMsg
        ZUserInAra$(WasX + 1 - ZTestedIntValue) = ZOutTxtAra$(WasX)
        ZOutTxtAra$(WasX) = ""
     NEXT
     ZLinesInMsg = ZTestedIntValue
2840 ZOutTxt$ = RIGHT$(STR$(ZLinesInMsg),3) + _
          ": " + ZOutTxtAra$(ZLinesInMsg)
     GOSUB 12978
     CALL LineEdit(ZLinesInMsg,ZRightMargin + 1)
     IF ZOutTxtAra$(ZLinesInMsg) = "" THEN _
        GOTO 2920
2870 ZLinesInMsg = ZLinesInMsg + 1
     WasJ = ZLinesInMsg + WasK - 1
     GOSUB 2200
     IF NOT WasX THEN _
        GOTO 2840
2920 FOR WasX = 1 TO WasK + 1
        ZOutTxtAra$(ZLinesInMsg + WasX - 1) = ZUserInAra$(WasX)
     NEXT
     REDIM ZUserInAra$(ZMsgDim)
     ZLinesInMsg = WasLL + ZLinesInMsg - ZTestedIntValue
     GOTO 2300
'
' *****  LIST MESSAGE CONTENTS   ****
'
3000 GOSUB 3010
     GOTO 2300

3010 ZStopInterrupts = ZFalse
     CALL SkipLine (1)
     IF (ZWasQ = 1 OR ZMsgFwd) AND NOT ZGetExtDesc THEN
        WasL = 1
        '* "{CCTo: {MT {CBRe: {SM{RC"
        LineNum = 89
        GOSUB 49000
        GOSUB 12979
        CALL QuickTPut (MID$(SPACE$(4),1,-4 * (NOT ZRemoteEcho)),0)
        GOSUB 3200
     END IF
3020 IF ZGetExtDesc THEN WasL = 1
     FOR WasX = WasL TO ZLinesInMsg 
        CALL AskMore ("",ZTrue,ZTrue,WasXX,ZFalse)
        IF ZNo OR ZRet THEN _
           WasX = ZLinesInMsg + 1 _
        ELSE ZOutTxt$ = RIGHT$(STR$(WasX),3) + _
                  ": " + _
                  ZOutTxtAra$(WasX) : _
             GOSUB 12979
     NEXT
     RETURN
'
' *****  CHANGE MARGIN WIDTH   ****
'
3100 '* "Right Margin"
     LineNum = 90
     GOSUB 49030
     CALL ChangeInt (ZTrue,Strng$,ZRightMargin,8,72)
     IF ZWasQ <> 0 THEN _
        ZRightMargin = ZTestedIntValue
     GOTO 2300
'
' ***** PRINT TOP DASHED LINE ****
'
3200 ZOutTxt$ = CHR$(91-((ZWasGR>0)*104)) + _
          STRING$(ZRightMargin - 2,45-((ZWasGR>0)*151)) + _
          CHR$(93-((ZWasGR>0)*87))
     IF ZRemoteEcho OR ZLocalUser THEN _
        ZOutTxt$ = SPACE$(4) + _
             ZOutTxt$
     GOSUB 12975
     RETURN

3300 '* "{SPLine #"
     LineNum = 91
     GOSUB 49030
     Temp$ = ZOutTxt$ + Strng$
     Temp = MsgLockLines + 1
     CALL SkipLine (-(ZAnsIndex >= ZLastIndex))
     CALL ChangeInt (ZFalse,Temp$,0,Temp,ZLinesInMsg)
     IF ZSubParm = -1 THEN
        EXIT SUB
     END IF
     RETURN

12930 ZTurboKey = -ZTurboKeyUser
12932 CALL PopCmdStack
      GOTO 12983
12975 ZSubParm = 1
      GOTO 12981
12977 ZSubParm = 3
      GOTO 12981
12978 ZSubParm = 4     ' no cr/lf
      GOTO 12981
12979 ZSubParm = 5     ' cr/lf
      GOTO 12981
12981 CALL TPut
12983 IF ZSubParm < 0 THEN
         EXIT SUB
      END IF
      RETURN

49000 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
      RETURN
'
' * Get external string for QuickTPut
'
49010 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZTrue,CRCount,"")
      RETURN
'
' * Get external string for UpdtCalr
'
49020 CALL FormatString (LineNum,ZFalse,ZTrue,CRCount,ZFalse,0,"")
      RETURN
'
' * Get external string for Strng$
'
49030 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      RETURN

      END SUB
'
' ***** FIND FIDO USER NAME
'
3400 SUB FindFidoUser (Found)
     Found = ZTrue
     ZUserIn$ = ""
     IF ZNetMailUserLst$ = "" AND ZLocalNetMailUserLst$ = "" THEN
        GOTO 3415
     END IF
     NumDots = 0
     '* "Searching for NetMail Address of {MT {CE({CO<Ctrl-X>{RC {CEAborts){RC"
     CALL FormatString (1136,ZFalse,ZFalse,0,ZTrue,0,"")
     CALL FindFile(ZLocalNetMailUserLst$,Found)
     IF Found THEN
        SearchFile$ = ZLocalNetMailUserLst$
        GOTO 3410
     END IF
3405 CALL FindFile(ZNetMailUserLst$,Found)
     IF NOT Found THEN
        GOTO 3415
     END IF
     SearchFile$ = ZNetMailUserLst$
3410 CALL OpenRSeq (8,SearchFile$,HighRec&,WasX,62)
     FIELD 8, 45 AS WholeName$, _
              15 AS Address$, _
              2 AS CrLf$
     FOR WasX& = 1 TO HighRec&
         GET 8, WasX&
         IF INSTR(MID$(WholeName$,2),",") THEN
            LastName$ = MID$(WholeName$,1,INSTR(WholeName$,",")-1)
            FirstName$ = MID$(WholeName$,INSTR(WholeName$,",")+1)
         ELSE
            FirstName$ = MID$(WholeName$,2)
            LastName$ = ""
         END IF
         CALL Trim (LastName$)
         CALL Trim (FirstName$)
         IF LEFT$(UCASE$(FirstName$ + SPACE$(1) + LastName$),LEN(ZMsgTo$)) = UCASE$(ZMsgTo$) THEN
            ZToAddr$ = Address$
            CALL Trim (ZToAddr$)
            DO
               '* "Send to{SP"
               CALL FormatString (817,ZFalse,ZFalse,0,ZFalse,0,Strng$)
               CALL SkipLine(1)
               ZOutTxt$ = Strng$ + FirstName$ + SPACE$(1) + LastName$ + _
                           " @ " + ZToAddr$ + ZYesPrompt$
               ZTurboKey = -ZTurboKeyUser
               CALL PopCmdStack
               IF ZSubParm < 0 THEN _
                  EXIT SUB
               ZWasZ$ = UCASE$(ZUserInAra$(ZAnsIndex))
            LOOP UNTIL ZWasQ = 0 OR INSTR("YN",ZWasZ$) <> 0
            IF ZWasQ = 0 OR ZWasZ$ = "Y" THEN
               ZUserIn$ = ZToAddr$
               IF SearchFile$ = ZNetMailUserLst$ AND ZLocalNetMailUserLst$ <> "" THEN
                  SaveWholeName$ = WholeName$
                  SaveAddress$ = Address$
                  CALL OpenRSeq (8,ZLocalNetMailUserLst$,HighRec&,WasX,62)
                  FIELD 8, 45 AS WholeName$, _
                           15 AS Address$, _
                            2 AS CrLf$
                  LSET WholeName$ = SaveWholeName$
                  LSET Address$ = SaveAddress$
                  LSET CrLf$ = ZCrLf$
                  PUT 8, HighRec& + 1
                  CLOSE 8
               END IF
               EXIT SUB
            ELSE
               ZUserIn$ = ""
               NumDots = 0
               '* "Searching for NetMail Address of {MT"
               CALL FormatString (1136,ZFalse,ZFalse,0,ZTrue,0,"")
            END IF
         END IF
         CALL MarkTime (NumDots)
         CALL CheckKBStop
         IF ZRet THEN
            ZUserIn$ = ZToAddr$
            CLOSE 8
            GOTO 3415
            EXIT SUB
         END IF
     NEXT WasX&
     IF SearchFile$ <> ZNetMailUserLst$ THEN
        GOTO 3405
     END IF
     CLOSE 8
3415 CALL SkipLine(1)
     Found = ZFalse
     END SUB
'
' ***** ADD FIDO USER NAME
'
3420 SUB AddToFidoUser
     IF ZLocalNetMailUserLst$ = "" THEN
        EXIT SUB
     END IF
     CALL FindFile(ZLocalNetMailUserLst$,Found)
     IF NOT Found THEN
        EXIT SUB
     END IF
     CALL OpenRSeq (8,ZLocalNetMailUserLst$,HighRec&,WasX,62)
     FIELD 8, 45 AS WholeName$, _
              15 AS Address$, _
               2 AS CrLf$

     IF INSTR(ZMsgTo$," ") THEN
        FirstName$ = MID$(ZMsgTo$,1,INSTR(ZMsgTo$," ")-1)
        LastName$  = MID$(ZMsgTo$,INSTR(ZMsgTo$," ")+1)
        FullName$  = LastName$ + ", " + FirstName$
     ELSE
        FullName$ = ", " + ZMsgTo$
     END IF
     CALL NameCaps (FullName$)
     LSET WholeName$ = FullName$ + SPACE$(45-LEN(FullName$))
     IF LEN(ZUserIn$) < 15 THEN
        ZUserIn$ = SPACE$(15-LEN(ZUserIn$)) + ZUserIn$
     END IF
     LSET Address$ = ZUserIn$
     LSET CrLf$ = ZCrLf$
     PUT 8, HighRec& + 1
     CLOSE 8
     END SUB
'
' ***** SAVE NETMAIL MESSAGE
'
3530 SUB SaveNetMail (MsgTo$)
     DIM MsgHeader as MsgHeader
     MsgNum = 1
     FILESPEC$ = ZNetMailPath$ + "*.MSG"
     MatchFile$ = DIR$(FILESPEC$)
     IF MatchFile$ <> "" THEN
        CALL BreakFileName (MatchFile$,Drive$,Body$,Ext$,ZTrue)
        IF VAL(Body$) => MsgNum THEN
           MsgNum = VAL(Body$) + 1
        END IF
        MatchFile$ = DIR$
        DO WHILE MatchFile$ <> ""
           CALL BreakFileName (MatchFile$,Drive$,Body$,Ext$,ZTrue)
           IF VAL(Body$) => MsgNum THEN
              MsgNum = VAL(Body$) + 1
           END IF
           MatchFile$ = DIR$
        LOOP
     END IF
     MsgFile$ = ZNetMailPath$ + LTRIM$(STR$(MsgNum)) + ".MSG"
     FromUser$ = ZActiveUserName$ + STRING$(36-LEN(ZActiveUserName$),0) + CHR$(0)
     CALL NameCaps(FromUser$)
     MsgHeader.FromUser = FromUser$
'
' *** Handle UUCP Addressing Kludges Here
'
     IF INSTR(MsgTo$,"@") > 0 AND INSTR(MsgTo$,".") > 0 THEN
        IF ZInternetMsgTo$ <> "" THEN
           IF LEFT$(UCASE$(ZOutTxtAra$(1)),3) <> "TO:" THEN
              ZOutTxtAra$(1) = "TO:" + MsgTo$ + ZCrLf$ + ZCrLf$ + ZOutTxtAra$(1)
           END IF
           MsgTo$ = ZInternetMsgTo$
           IF LEN(MsgTo$) < 36 THEN
              MsgTo$ = MsgTo$ + STRING$(36-LEN(MsgTo$),0)
           END IF
           MsgHeader.ToUser = MsgTo$ + CHR$(0)
        ELSE
           ToUser$ = RTRIM$(MID$(ZMsgTo$,1,22)) + STRING$(36-LEN(ZMsgTo$),0) + CHR$(0)
           CALL NameCaps(ToUser$)
           MsgHeader.ToUser = ToUser$
        END IF
     ELSE
        ToUser$ = RTRIM$(MID$(ZMsgTo$,1,22)) + STRING$(36-LEN(ZMsgTo$),0) + CHR$(0)
        CALL NameCaps(ToUser$)
        MsgHeader.ToUser = ToUser$
     END IF
'
     Subject$ = ZSubject$ + STRING$(72-LEN(ZSubject$),0) + CHR$(0)
     CALL NameCaps(Subject$)
     MsgHeader.Subject = Subject$
     MYear$  = STR$(VAL(RIGHT$(DATE$,2)))
     MMonth$ = MID$("JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVEDEC",(VAL(LEFT$(DATE$,2))-1)*3+1,3)
     MDay$   = LTRIM$(STR$(VAL(MID$(DATE$,4,2))))
     IF VAL(MDay$) < 10 THEN
        MDay$ = "0" + MDay$
     END IF
     MsgHeader.DateTime = MDay$ + " " + MMonth$ + MYear$ + "  " + TIME$ + CHR$(0)
     MsgHeader.TimesRead = 0
     FromPointStart = INSTR(ZFromAddr$,".")
     IF FromPointStart THEN
        MsgHeader.OrigPoint = VAL(MID$(ZFromAddr$,FromPointStart+1))
     ELSE
        MsgHeader.OrigPoint = 0
     END IF
     ToPointStart = INSTR(ZToAddr$,".")
     IF ToPointStart THEN
        MsgHeader.DestPoint = VAL(MID$(ZToAddr$,ToPointStart+1))
     ELSE
        MsgHeader.DestPoint = 0
     END IF
     ToNodeStart = INSTR(ZToAddr$,"/")
     IF ToNodeStart THEN
        IF ToPointStart THEN
           MsgHeader.DestNode = VAL(MID$(ZToAddr$,ToNodeStart+1,ToPointStart-1))
        ELSE
           MsgHeader.DestNode = VAL(MID$(ZToAddr$,ToNodeStart+1))
        END IF
     ELSE
        EXIT SUB
     END IF
     FromNodeStart = INSTR(ZFromAddr$,"/")
     IF FromNodeStart THEN
        IF FromPointStart THEN
           MsgHeader.OrigNode = VAL(MID$(ZFromAddr$,FromNodeStart+1,FromPointStart-1))
        ELSE
           MsgHeader.OrigNode = VAL(MID$(ZFromAddr$,FromNodeStart+1))
        END IF
     ELSE
        EXIT SUB
     END IF
     MsgHeader.Cost     = 0
     FromNetStart = INSTR(ZFromAddr$,":")
     IF FromNetStart THEN
        MsgHeader.OrigNet = VAL(MID$(ZFromAddr$,FromNetStart+1,FromNodeStart-1))
     ELSE
        EXIT SUB
     END IF
     IF INSTR(ZToAddr$,":") = 0 THEN
        IF INSTR(ZNetMailAddr$,":") <> 0 THEN
           ZToAddr$ = MID$(ZNetMailAddr$,1,INSTR(ZNetMailAddr$,":")) + ZToAddr$
        END IF
     END IF
     ToNetStart = INSTR(ZToAddr$,":")
     IF ToNetStart THEN
        MsgHeader.DestNet = VAL(MID$(ZToAddr$,ToNetStart+1,ToNodeStart-1))
     ELSE
        EXIT SUB
     END IF
     IF ToNetStart > 1 THEN
        MsgHeader.DestZone = VAL(MID$(ZToAddr$,1,ToNetStart-1))
     END IF
     IF FromNetStart > 1 THEN
        MsgHeader.OrigZone = VAL(MID$(ZFromAddr$,1,FromNetStart-1))
     END IF
     MsgHeader.ReplyTo  = 0
     MsgHeader.Attribute = ZNetMailAttr
     MsgHeader.NextReply = 0
     CLOSE 2
     OPEN MsgFile$ FOR BINARY AS #2
     IF ZErrCode THEN
        ZErrCode = 0
        EXIT SUB
     END IF
     PUT #2,, MsgHeader
     IF MsgHeader.DestPoint <> 0 THEN
        TOPT$ = CHR$(1) + "TOPT" + STR$(MsgHeader.DestPoint) + ZCrLf$
        PUT #2,, TOPT$
     END IF
     IF MsgHeader.OrigPoint <> 0 THEN
        FMPT$ = CHR$(1) + "FMPT" + STR$(MsgHeader.OrigPoint) + ZCrLf$
        PUT #2,, FMPT$
     END IF
     IF MsgHeader.DestZone <> 1 THEN
        INTL$ = CHR$(1) + _
                "INTL " + _
                ZToAddr$ + " " + _
                ZFromAddr$ + ZCrLf$
        PUT #2,, INTL$
     END IF
     MYear  = VAL(MYear$)
     MMonth = VAL(LEFT$(DATE$,2))
     MDay   = VAL(MDay$)
     ID1    = MYear * 512 + MMonth * 32 + MDay
     MHour   = VAL(LEFT$(TIME$,2))
     MMinute = VAL(MID$(TIME$,4,2))
     MSecond = VAL(MID$(TIME$,7,2))
     ID2     = MHour * 2048 + MMinute * 32 + MSecond / 2
     MSGID$ = CHR$(1) + "MSGID: " + ZFromAddr$ + " " + LCASE$(HEX$(ID1)) + LCASE$(HEX$(ID2)) + ZCrLf$
     PUT #2,, MSGID$
     FOR icount = 1 TO ZLinesInMsg
        IF RIGHT$(ZOutTxtAra$(icount),1) = CHR$(227) THEN
           OutStr$ = LEFT$(ZOutTxtAra$(icount),LEN(ZOutTxtAra$(icount))-1) + ZCrLf$
        ELSEIF ZOutTxtAra$(icount) <> CHR$(227) THEN
           OutStr$ = ZOutTxtAra$(icount) + ZCrLf$
        ELSE
           OutStr$ = ZCrLf$
        END IF
        PUT #2,, OutStr$
     NEXT icount
     PUT #2,,ZCrLf$
     IF ZPrintOrigin THEN
        OutStr$ = "---RBBS-PC v" + ZVersionID$ + ZCrLf$ + _
                  " * Origin: " + ZOrigRBBSName$ + " (" + ZFromAddr$ + ")" + _
                  ZCrLf$
        PUT #2,, OutStr$
     END IF
     CLOSE 2
     END SUB
'
' ***** Print/Download/CrossPost A Message
'
     SUB PrintMsg(OutNum$,OutFrom$,OutTo$,OutRe$,OutDate$,OutRcvd$,OutStatus$,OutRec,OutNumRecs,ToDownload,ToXPost,MsgLockLines)
4615 IF ToDownload OR ToXPost THEN
        ToPrint$ = ZNodeWorkDrvPath$ + OutNum$ + ".MSG"
        CALL KillWork (ToPrint$)
        GOTO 4617
     END IF
     IF ZSysop THEN
        '* "{RCOutput to What File{EX"
        LineNum = 751
        GOSUB 4624
        IF ZUserIn$ = "" THEN _
           EXIT SUB
        ToPrint$ = ZUserIn$
        CALL AllCaps (ToPrint$)
        '* "CON:AUX:NUL:COM1:COM2:SCRN:KYBD:CONS:CLOCK$:"
        CALL FormatString (752,ZFalse,ZFalse,0,ZFalse,0,Strng$)

        IF INSTR(Strng$,ToPrint$) <> 0 OR _
           INSTR(ToPrint$,SPACE$(1)) <> 0 THEN
           '* "Bad Filename!"
           CALL FormatString (753,ZFalse,ZFalse,0,ZTrue,1,"")
           GOTO 4615
        END IF
4617    CALL OpenWorkA(2,ToPrint$)
        IF ZErrCode THEN
           '* "Could Not Open{SP"
           CALL FormatString (754,ZFalse,ZFalse,0,ZFalse,0,Strng$)
           CALL QuickTPut1 (Strng$ + ToPrint$)
           EXIT SUB
        END IF
        IF ToXPost THEN
           IF ZSysop THEN
              '* "Message was from {MF, change to {AN? (Y,[N])"
              LineNum = 134
              GOSUB 4624
              IF ZYes THEN
                 MsgFrom$ = ZActiveUserName$
              ELSE
                 MsgFrom$ = ZMsgFrom$
              END IF
           ELSE
              MsgFrom$ = ZMsgFrom$
           END IF
           '* "Edit Message Before CrossPosting ([Y],N)"
           LineNum = 975
           GOSUB 4624
           IF ZYes OR ZWasQ = 0 THEN
              ZYes = ZTrue
              '* "message"
              LineNum = 60
              GOSUB 4628
              ZMsgHeader$ = Strng$
              ImportFromEd = ZFalse
              ZLinesInMsg = ZLinesInMsg - 1
              CALL WordWrap (ZRightMargin,ZLinesInMsg,ZOutTxtAra$())
              IF ZLinesInMsg > ZMsgDim THEN
                 ZLinesInMsg = ZMsgDim
              END IF
              IF NOT ZFullScreenEditor THEN
                 '* "Use the Full Screen Editor? (Y,[N])"
                 LineNum = 226
                 GOSUB 4624
              END IF
              IF NOT ZYes THEN
                 CALL LineEditMessage (0,0)
              ELSE
                 CALL ANSIEd (OutTo$,OutRe$,MsgLockLines)
              END IF
              IF ZSubParm < 1 OR ZSubParm = 2 THEN
                 GOTO 4622
              ELSE
                 ImportFromEd = ZTrue
              END IF
           END IF
           CALL PrintWorkA (2,MsgFrom$)
           CALL PrintWorkA (2,OutRe$)
           IF ImportFromEd THEN
              OutRecStart = 1
              '* "TO:"
              LineNum = 986
              GOSUB 4628
              WHILE LEFT$(UCASE$(ZOutTxtAra$(OutRecStart)),3) = Strng$
                 CALL PrintWorkA (2,ZOutTxtAra$(OutRecStart))
                 OutRecStart = OutRecStart + 1
              WEND
              OutRecStart = OutRecStart - 1
           END IF
           CALL PrintWorkA (2,STRING$(72,"-"))
           '* "Message Cross-Posted From {CN by {NC"
           LineNum = 987
           GOSUB 4628
           CALL PrintWorkA (2,Strng$)
           CALL PrintWorkA (2,STRING$(72,"-"))
           CALL PrintWorkA (2,"")
        END IF
        IF NOT ToXPost THEN
           CALL PrintWorkA (2,STRING$(74,CHR$(196)))
        END IF
        '* "{SPBBS:{SP"
        LineNum = 988
        GOSUB 4628
        CALL PrintWorkA (2,Strng$+ZOrigRBBSName$)
        '* "Date:{SP"
        LineNum = 989
        GOSUB 4628
        CALL PrintWork (Strng$+OutDate$+SPACE$(33-LEN(OutDate$)))
        '* "Number:{SP"
        LineNum = 990
        GOSUB 4628
        CALL PrintWorkA (2,Strng$+OutNum$)
        '* "From:{SP"
        LineNum = 991
        GOSUB 4628
        CALL PrintWork (Strng$+OutFrom$+SPACE$(33-LEN(OutFrom$)))
        '* "Status:{SP"
        LineNum = 992
        GOSUB 4628
        CALL PrintWorkA (2,Strng$+OutStatus$)
        '* "{SP To:{SP"
        LineNum = 993
        GOSUB 4628
        CALL PrintWork (Strng$+OutTo$+SPACE$(33-LEN(OutTo$)))
        '* "{SP Rcvd:{SP"
        LineNum = 994
        GOSUB 4628
        CALL PrintWork (Strng$)
        IF OutRcvd$ = STRING$(6,0) OR _
           OutRcvd$ = SPACE$(6) THEN
           '* "-NO-"
           LineNum = 995
           GOSUB 4628
           CALL PrintWorkA (2,Strng$)
        ELSE
           Year$ = RIGHT$(STR$(ASC(MID$(OutRcvd$,1,1))),2) + _
                   "-" + _
                   RIGHT$(STR$(ASC(MID$(OutRcvd$,2,1))),2) + _
                   "-" + _
                   RIGHT$(STR$(ASC(MID$(OutRcvd$,3,1))),2)
           FOR WasI = 1 TO LEN(Year$)
              IF MID$(Year$,WasI,1) = SPACE$(1) THEN _
                 MID$(Year$,WasI,1) = "0"
           NEXT
           CALL PrintWorkA (2, Year$)
        END IF
        '* "Subj:{SP"
        LineNum = 996
        GOSUB 4628
        CALL PrintWork (Strng$+OutRe$+SPACE$(33-LEN(OutRe$)))
        '* "{SP Conf:{SP"
        LineNum = 997
        GOSUB 4628
        CALL PrintWorkA (2,Strng$+ZConfName$)
        CALL PrintWorkA (2,STRING$(72,45-(151*(ToXPost=0))))
        IF NOT ImportFromEd THEN
           POut$ = ""
           FOR PrintLoop = OutRec + 1 TO OutRec + OutNumRecs - 1
              GET 1,PrintLoop
              FOR Loop1 = 1 TO LEN(ZMsgRec$)
                 IF MID$(ZMsgRec$,Loop1,1) <> CHR$(227) THEN
                    POut$ = POut$ + MID$(ZMsgRec$,Loop1,1)
                 ELSE
                    CALL Remove(POut$,CHR$(1))
                    CALL PrintWorkA (2,POut$)
                    POut$ = ""
                 END IF
              NEXT Loop1
           NEXT PrintLoop
        ELSE
           FOR PrintLoop = 1 + OutRecStart TO ZLinesInMsg
              CALL PrintWorkA (2,ZOutTxtAra$(PrintLoop))
           NEXT PrintLoop
        END IF
        IF NOT ToXPost THEN
           CALL PrintWorkA (2,CHR$(10))
        END IF
        CLOSE #2
     END IF
     IF ToDownload THEN
        CALL SkipLine (1)
        CALL KillWork (ZNodeWorkFile$)
        ZErrCode = 0
        ZFileName$ = ToPrint$
        CALL BreakFileName (ZFileName$,Drive$,Body$,Ext$,ZTrue)
        ZFileNameHold$ = Body$ + Ext$
        CALL XFerType (1,ZTrue)
        IF ZWasQ = 0 THEN
           CALL KillWork (ZFileName$)
           CALL SkipLine (1)
           EXIT SUB
        END IF
        CALL CheckCarrier
        IF ZSubParm = -1 THEN
           EXIT SUB
        END IF
        '* "Downloaded {FH"
        CALL FormatString (962,ZFalse,ZTrue,1,ZFalse,0,"")
        ZTransferFunction = 1
        IF ZProtoMacro$ <> "" THEN
           ZGSRAra$(1) = MID$("DU ",ZTransferFunction,1)
           CALL MacroExe (ZProtoMacro$)
        END IF
        CALL Transfer
        CALL KillWork ("XFER-" + ZNodeID$ + ".DEF")
        CALL KillWork (ZFileName$)
        CALL SkipLine (1)
        IF ZWasGR = 4 THEN
           CALL BufFile (ZWelcomeFileDrvPath$ + "RIPWINM.RIP",WasX)
        END IF
     END IF
     IF ToXPost AND ZXPostAvail THEN
        XPostBatch$ = "XPOST" + ZDefaultBatchExt$
4620    '* "{RCSelect Conference to CrossPost this message to L)ist{EX"
        LineNum = 971
        GOSUB 4624
        IF UCASE$(ZUserIn$) = "L" THEN
           FileName$ = ZWelcomeFileDrvPath$ + "XPOST.MNU"
           CALL FindFile (FileName$,ZOK)
           IF ZOK THEN
              CALL GraphicDisplayFile (ZWelcomeFileDrvPath$ + "XPOST.MNU")
           ELSE
              CALL GraphicDisplayFile (ZConfMenu$)
           END IF
           GOTO 4620
        END IF
        IF ZWasQ = 0 OR ZUserIn$ = "" THEN
           GOTO 4622
        END IF
        MessageBase$ = UCASE$(ZUserIn$)
        InList = ZFalse
        CALL BreakFileName (ZConfMailList$,Drive$,Body$,Ext$,ZTrue)
        XFileList$ = Drive$ + "XPOST.LST"
        CALL FindIt (XFileList$)
        IF ZOK THEN
           WHILE NOT EOF(2) AND NOT InList
              CALL ReadAny
              GOSUB 4627
           WEND
           CLOSE 2
        ELSE
           ZOutTxt$ = ZConfMailList$
           GOSUB 4627
        END IF
        IF NOT InList THEN
           GOTO 4620
        END IF
        '* "{RCEnter WHO this Message is TO (ABORT quits) [ENTER = ALL]"
        LineNum = 972
        ZSemiOnly = ZTrue
        GOSUB 4624
        '* "ALL"
        LineNum = 1000
        GOSUB 4628
        ALLStr$ = Strng$
        IF ZWasQ = 0 THEN
           WhoTo$ = ALLStr$
        ELSE
           WhoTo$ = ZUserIn$
        END IF
        '* "ABORT"
        LineNum = 386
        GOSUB 4628
        IF UCASE$(ZUserIn$) = Strng$ THEN
           CALL KillWork (ToPrint$)
           EXIT SUB
        END IF
        Template$ = " " + ToPrint$ + " " + MessageBase$ + " " + SecMsg$
        IF WhoTo$ <> ALLStr$ THEN
           SelectStr$ = "UA"
           IF AllowPrivate THEN
              SelectStr$ = SelectStr$ + "R"
           END IF
           DO
              '* "Make msg"
              LineNum = 290
              GOSUB 4628
              ZOutTxt$ = Strng$
              '* "{SPp[U]blic,"
              LineNum = 1097
              GOSUB 4628
              ZOutTxt$ = ZOutTxt$ + Strng$
              IF AllowPrivate THEN
                 '* "{SPp(R)ivate,"
                 LineNum = 1098
                 GOSUB 4628
                 ZOutTxt$ = ZOutTxt$ + Strng$
              END IF
              '* "{SPA)bort
              LineNum = 1099
              GOSUB 4628
              ZOutTxt$ = ZOutTxt$ + Strng$
              GOSUB 4626
           LOOP UNTIL ZWasQ = 0 OR INSTR(SelectStr$,UCASE$(ZUserIn$)) <> 0
           IF UCASE$(ZUserIn$) = "A" THEN
              CALL KillWork (ToPrint$)
              EXIT SUB
           END IF
           IF UCASE$(ZUserIn$) = "R" THEN
              Template$ = Template$ + " " + "/PRI"
           END IF
        END IF
        Template$ = Template$ + " " + WhoTo$
        HoldOrigFirstName$ = OrigFirstName$
        HoldZLastName$ = ZLastName$
        First = INSTR(WhoTo$," ")
        IF First THEN
           OrigFirstName$ = MID$(WhoTo$,1,First-1)
           ZLastName$     = MID$(WhoTo$,First+1)
        ELSE
           OrigFirstName$ = ""
           ZLastName$     = WhoTo$
        END IF
        ZDoorDropFile$ = "D"
        CALL DoorInfo
        OrigFirstName$ = HoldOrigFirstName$
        ZLastName$     = HoldZLastName$
        CALL ShellExit (XPostBatch$ + Template$)
        CALL DelayTime (1)
        ZUserIn$ = ZWorkAra$(2)
        '* "Message {CM CrossPosted to {ZU"
        CALL FormatString (973,ZFalse,ZTrue,1,ZTrue,1,"")
4622    CALL KillWork (ToPrint$)
     END IF
     EXIT SUB
4624 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
4626 ZSubParm = 1
     CALL TGet
     IF ZSubParm = -1 THEN
        CALL KillWork (ToPrint$)
        EXIT SUB
     END IF
     RETURN
4627 CALL OpenWork (8,ZOutTxt$)
     InList = ZFalse
     WHILE NOT EOF(8) AND NOT InList
        CALL ReadParmsX(8,ZWorkAra$(),10,1)
        IF (UCASE$(ZWorkAra$(2)) = MessageBase$ OR _
           UCASE$(ZWorkAra$(1)) = MessageBase$) AND _
           ZUserSecLevel >= VAL(ZWorkAra$(5)) THEN
           IF ZWorkAra$(1) = MessageBase$ THEN
              MessageBase$ = ZWorkAra$(2)
           END IF
           SecMsg$ = ZWorkAra$(5)
           MessageBase$ = ZWorkAra$(9)
           AllowPrivate = (UCASE$(ZWorkAra$(6)) = "R")
           InList = ZTrue
        END IF
     WEND
     CLOSE 8
     RETURN
4628 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
     RETURN
     END SUB
'
' * Download a File Attach
'
5000 SUB DownloadFileAttach (FileAttachName$)
     CALL BreakFileName (FileAttachName$,Drive$,Body$,Ext$,ZTrue)
     ZFileNameHold$ = Body$ + Ext$
     CALL SkipLine (1)
     DO
        '* "Download {FH File Attach ([Y],N)"
        CALL FormatString (1158,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
        ZSubParm = 1
        CALL TGet
        IF ZSubParm < 0 THEN
           EXIT SUB
        END IF
        ZUserIn$ = UCASE$(ZUserIn$)
     LOOP UNTIL ZWasQ = 0 OR INSTR("YN",ZUserIn$) <> 0
     IF ZUserIn$ = "N" THEN
        CALL SkipLine (1)
        EXIT SUB
     END IF
     CALL KillWork (ZNodeWorkFile$)
     ZErrCode = 0
     ZFileName$ = ZFileAttachPath$ + FileAttachName$
     CALL BreakFileName (ZFileName$,Drive$,Body$,Ext$,ZTrue)
     ZFileNameHold$ = Body$ + Ext$
     CALL XFerType (1,ZTrue)
     IF ZWasQ = 0 THEN
        CALL SkipLine (1)
        EXIT SUB
     END IF
     CALL CheckCarrier
     IF ZSubParm = -1 THEN
        EXIT SUB
     END IF
     '* "{Downloaded {FH"
     CALL FormatString (962,ZFalse,ZTrue,1,ZFalse,0,"")
     ZTransferFunction = 1
     IF ZProtoMacro$ <> "" THEN
        ZGSRAra$(1) = MID$("DU ",ZTransferFunction,1)
        CALL MacroExe (ZProtoMacro$)
     END IF
     CALL Transfer
     CALL KillWork ("XFER-" + ZNodeID$ + ".DEF")
     CALL SkipLine (1)
     END SUB
'
' * View a File Attach
'
5010 SUB ViewFileAttach (FileAttachName$)
     CALL SkipLine (1)
     ZFileName$ = FileAttachName$
     CALL GetArc (ZFalse,ZTrue)
     END SUB
'
' * FORMAT MESSAGE HEADER INFORMATION FOR DISPLAY
'
8000 SUB MessageHeader (OrigSubject$,WasSJ$, _
                        ReadMsgs,JustReplied,MsgSec,SubInHeader$, _
                        QuickScanMsgs,ScanMsgs,MsgToCaller,MsgFromCaller, _
                        CurrHeaderRecNum,Flushed,FileAttachName$)


'
8020 '* "ALL"
     LineNum = 1000
     GOSUB 8090
     IF MID$(ZMsgRec$,37,5) = Strng$ + SPACE$(2) THEN
        ZMsgTo$ = Strng$
        GOTO 8040
     END IF
     ZMsgTo$ = MID$(ZMsgRec$,37,22)
     '* "NEWUSER"
     LineNum = 32
     GOSUB 8090
     IF (ZNewUserDGS AND INSTR(ZMsgTo$,Strng$)) THEN
        ZMsgTo$ = ZActiveUserName$
     END IF
     CALL SmartText(ZMsgTo$,ZFalse,ZFalse,ZTrue)
     CALL Trim (ZMsgTo$)
     IF ZNumHeaders > 1 THEN
        '* "{MT et al."
        LineNum = 849
        GOSUB 8090
        ZMsgTo$ = Strng$
     END IF
8040 IF LEN(ZMsgTo$) < 23 THEN
        ZMsgTo$ = ZMsgTo$ + SPACE$(23 - LEN(ZMsgTo$))
     END IF
     ZSubject$ = UCASE$(MID$(ZMsgRec$,76,25))
     CALL Trim (ZSubject$)
     Strng4$ = ""
     FileAttachName$ = ""
     IF ZAllowFileAttach THEN
        Attach = INSTR(ZSubject$,"@")
        IF Attach > 1 THEN
           FileAttachName$ = UCASE$(MID$(ZSubject$,Attach+1))
           CALL Trim (FileAttachName$)
           CALL FindFile (ZFileAttachPath$ + FileAttachName$,Found)
           IF Found THEN
              '* "ALL"
              LineNum = 1000
              GOSUB 8090
              IF ((RTRIM$(ZMsgTo$) = ZActiveUserName$) OR _
                 (RTRIM$(ZMsgFrom$) = ZActiveUserName$) OR _
                 ((RTRIM$(ZMsgTo$) <> Strng$) AND (ZUserSecLevel >= ZOptSec(23))) OR _
                 ((RTRIM$(ZMsgTo$) = Strng$) AND (ZUserSecLevel >= ZOptSec(19)))) THEN
                 '* {C3 File: {CB"
                 LineNum = 1162
                 GOSUB 8090
                 Strng4$ = Strng$
                 Strng4$ = ZCrLf$ + Strng4$ + FileAttachName$
              END IF
              ZSubject$ = MID$(ZSubject$,1,Attach-1)
           END IF
        END IF
     END IF
     OrigSubject$ = ZSubject$
     IF ZPswdFailed THEN
        ZSubject$ = WasSJ$
     END IF
     ZMsgFrom$ = MID$(ZMsgRec$,6,31)
     IF ReadMsgs THEN
        IF (ZBBSOptions AND 1024) > 0 AND _
           ZWasGR > 1 AND NOT JustReplied THEN
           CALL QuickTPut1 (CHR$(27) + "[2J")
           CALL Line25
        ELSE
           CALL SkipLine (1)
        END IF
     END IF
     CALL Trim (ZMsgFrom$)
     IF LEN(ZMsgFrom$) < 23 THEN
        ZMsgFrom$ = ZMsgFrom$ + SPACE$(23 - LEN(ZMsgFrom$))
     END IF
     Year$ = MID$(STR$(ZMsgPtr(ZActiveMessages,2)),2)
     CALL Trim (Year$)
     IF ZUserSecLevel >= ZSecChangeMsg THEN
        '* "{SP{SPSL:"
        LineNum = 850
        GOSUB 8090
        Year$ = Year$ + Strng$ + STR$(MsgSec)
        CALL Trim (year$)
     END IF
     IF MID$(ZMsgRec$,101,1) = "!" THEN
        MID$(ZMsgRec$,1,1) = "!"
     END IF
     Year2$ = MID$(ZMsgRec$,2,4)
     CALL Trim (Year2$)
     IF LEFT$(ZMsgRec$,1) = SPACE$(1) THEN
        '* "Public"
        LineNum = 111
     ELSEIF LEFT$(ZMsgRec$,1) = STRING$(1,42) THEN
        '* "Private"
        LineNum = 112
     ELSE
        '* "Password"
        LineNum = 113
     END IF
     GOSUB 8090
     Year3$ = Strng$
     '* "{C2Msg #: {CA"
     LineNum = 851
     GOSUB 8090
     Strng1$ = Strng$
     '* "{C2 of {CA"
     LineNum = 852
     GOSUB 8090
     Strng2$ = Strng$
     '* "{C2Area: {CA{CN"
     LineNum = 853
     GOSUB 8090
     Strng3$ = Strng$

     ZOutTxt$ = Strng1$ + Year2$ + Strng2$ + _
                Year$ + SPACE$(39-LEN(Year$)-LEN(Year2$)) + Strng3$
     '* "{C3Sent: {CB"
     LineNum = 854
     GOSUB 8090
     Year$ = Strng$ +_
             MID$(ZMsgRec$,68,8) + _
             SPACE$(1) + _
             MID$(ZMsgRec$,59,5)
     IF NOT ZRet THEN
        IF ReadMsgs THEN
           CALL QuickTPut (ZFG9$ + STRING$(74,45-(151*(ZWasGR>0))) + ZEmphasizeOff$,1)
           CALL QuickTPut1 (ZOutTxt$)
           WasX$ = ZMsgFrom$
           CALL NameCaps(WasX$)
           CALL CheckColor (WasX$,SubInHeader$,ZFGB$)
           '* "{C3 From: {CB"
           LineNum = 855
           GOSUB 8090
           CALL QuickTPut1 (Strng$ + WasX$ + SPACE$(43-LEN(ZMsgFrom$)) + Year$)
           GOSUB 8076
           WasX$ = ZMsgTo$
           CALL NameCaps(WasX$)
           CALL CheckColor (WasX$,SubInHeader$,ZFGD$)
           '* "{C5  To: {CD"
           LineNum = 856
           GOSUB 8090
           Strng1$ = Strng$
           '* "{C5"
           LineNum = 958
           GOSUB 8090
           Strng2$ = Strng$
           CALL QuickTPut1 (Strng1$ + WasX$ + SPACE$(2) + Strng2$ + + SPACE$(41-LEN(ZMsgTo$)) + Year$)
           CALL NameCaps(ZSubject$)
           '* "{C4 Subj: {CC{SM"
           LineNum = 857
           GOSUB 8090
           Strng1$ = Strng$
           '* "{C4Status: {CC"
           LineNum = 858
           GOSUB 8090
           Strng2$ = Strng$
           ZOutTxt$ = Strng1$ + _
                      SPACE$(41-LEN(ZSubject$)) + _
                      Strng2$ + Year3$ + Strng4$ + ZEmphasizeOff$
           CALL CheckColor (ZOutTxt$,SubInHeader$,ZFGC$)
           ZSubject$ = UCASE$(ZSubject$)
        ELSE
           '* "{C2"
           LineNum = 859
           GOSUB 8090
           Strng1$ = Strng$
           '* "{CB"
           LineNum = 860
           GOSUB 8090
           Strng2$ = Strng$
           '* "{CE"
           LineNum = 861
           GOSUB 8090
           Strng3$ = Strng$
           '* "{CF ->{SP"
           LineNum = 862
           GOSUB 8090
           Strng4$ = Strng$
           '* "{CD"
           LineNum = 863
           GOSUB 8090
           Strng5$ = Strng$
           '* "{CC"
           LineNum = 864
           GOSUB 8090
           Strng6$ = Strng$
           ZOutTxt$ = Strng1$ + LEFT$(ZMsgRec$,5) + _
                  SPACE$(1) + _
                  Strng2$ + MID$(ZMsgRec$,68,5) + _
                  SPACE$(1) + _
                  Strng3$ + LEFT$(ZMsgFrom$,18) + _
                  Strng4$ + _
                  Strng5$ + LEFT$(ZMsgTo$,19) + _
                  SPACE$(1) + _
                  Strng6$ + LEFT$(ZSubject$,24) + ZEmphasizeOff$
             CALL CheckColor (ZOutTxt$,SubInHeader$,"")
             GOTO 8080
        END IF
     END IF
     IF QuickScanMsgs OR _
        ScanMsgs THEN _
           GOTO 8080 _
     ELSE GOTO 8077
8076 IF MID$(ZMsgRec$,123,6) = STRING$(6,0) OR _
        MID$(ZMsgRec$,123,6) = SPACE$(6) THEN
           '* "Rcvd: {CD-NO-"
           LineNum = 865
           GOSUB 8090
           Year$ = Strng$
           RETURN
     END IF
     '* "ALL"
     LineNum = 1000
     GOSUB 8090
     IF UCASE$(RTRIM$(ZMsgTo$)) = Strng$ THEN
        '* "Rcvd: {CDN/A"
        LineNum = 1146
        GOSUB 8090
        Year$ = Strng$
        RETURN
     END IF
     '* "Rcvd: {CD"
     LineNum = 866
     GOSUB 8090
     Year$ = Strng$ + _
           RIGHT$(STR$(ASC(MID$(ZMsgRec$,123,1))),2) + _
           "-" + _
           RIGHT$(STR$(ASC(MID$(ZMsgRec$,124,1))),2) + _
           "-" + _
           RIGHT$(STR$(ASC(MID$(ZMsgRec$,125,1))),2) + _
           SPACE$(1) + _
           RIGHT$(STR$(ASC(MID$(ZMsgRec$,126,1))),2) + _
           ":" + _
           RIGHT$(STR$(ASC(MID$(ZMsgRec$,127,1))),2)
     FOR WasI = 7 + LEN(ZFGD$) TO 14 + LEN(ZFGD$)
        IF MID$(Year$,WasI,1) = SPACE$(1) THEN _
           MID$(Year$,WasI,1) = "0"
     NEXT
     FOR WasI = 16 + LEN(ZFGD$) TO 20 + LEN(ZFGD$)
        IF MID$(Year$,WasI,1) = SPACE$(1) THEN _
           MID$(Year$,WasI,1) = "0"
     NEXT
     RETURN
8077 IF (NOT MsgToCaller) THEN
        '* "ALL"
        LineNum = 1000
        GOSUB 8090
        ZWasA = (MID$(ZMsgRec$,37,5) = Strng$ + SPACE$(2))
        IF NOT ZWasA THEN
           GOTO 8080
        END IF
     END IF
     IF MsgFromCaller AND NOT ZSysOp THEN _
        GOTO 8080
     Year$ = DATE$
     WasWK$ = TIME$
     MID$(ZMsgRec$,123,6) = CHR$(VAL(MID$(Year$,1,2))) + _
                                   CHR$(VAL(MID$(Year$,4,2))) + _
                                   CHR$(VAL(MID$(Year$,9,2))) + _
                                   CHR$(VAL(MID$(WasWK$,1,2))) + _
                                   CHR$(VAL(MID$(WasWK$,4,2))) + _
                                   CHR$(VAL(MID$(WasWK$,7,2)))
     ZSubParm = 3
     GOSUB 8085
     PUT 1,CurrHeaderRecNum
     ZSubParm = 4
     GOSUB 8085
8080 ZSubParm = 5
     CALL TPut
     IF ReadMsgs THEN
        CALL QuickTPut (ZFG9$ + STRING$(74,45-(151*(ZWasGR>0))) + ZEmphasizeOff$,1)
     END IF
     ZOutTxt$ = ""
     EXIT SUB
8085 CALL FileLock
     IF Flushed THEN
        FIELD 1,128 AS ZMsgRec$
        Flushed = ZFalse
     END IF
     IF ZSubParm = -1 THEN
        ZSubParm = -9
        CALL FindFKey
        EXIT SUB
     END IF
     RETURN
8090 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
     RETURN
     END SUB
