/* This REXX file is used to Auto-Setup EchoMail Areas In a MAX/SQUISH environment */
CpyRite = 'MakeArea.Cmd, Copyright 1995, Herman Freeman.'
Say CpyRite
PreFile = 'NUL:'
SufFile = 'NUL:'
LogFile = 'MakeArea.Log'			/* default log */
BadPath = 'Mail\MsgBad\'			/* Where to Find Untossed Msgs */
AreaDat = 'ELArea.Dat'				/* Where to Find ELAREA.DAT file */
NewPath = 'Mail\'				/* Where to put Newly-created areas */
SqshCfg = 'Squish.Cfg'				/* Where to put new EchoArea defs for Squish*/
MaxArea = 'MsgArea.Ctl'				/* Where to put new MsgArea defs for Max */
RulPath = '.\'					/* Where to look for Rules files */
DscPath = 'NUL: '				/* Where to put Long Description Files extracted from ELAREA.DAT */
Deflags = '-$m6000 -$d6'			/* Default Number for Days to Keep Messages */	
DefPriv = 'Disgrace'				/* Default Priviledge level to access area */
SysPriv = 'AsstSysop'				/* Priv. Req'd to access restricted echoes */
DefKeys = ''					/* Keys Req'd to access echo */
ErrLevl = '0'					/* ErrorLevel for Nothing Done Exit */
DefLink = '3615/50'				/* Default Link to Area def for Squish */
WrapLen = 78					/* Wrap text lines to this length */
						/* Set it up to be able to use RexxUtils */

c = arg()					/* find out if a cfg file has been passed */
if c = 0
  then CfgFile = 'MakeArea.Cfg'			/* no command line arg, so use default cfg */
  else CfgFile = arg(1)				/* use first arg passed on command line */

rc = stream(CfgFile, 'c', 'open')		/* open the cfg file */
do until lines(CfgFile) = 0
  TempStr = space(translate(LineIn(CfgFile), ' ', '	'))
  parse value TempStr with KeyWord TempStr
  KeyWord = translate(KeyWord)
  select
    when left(KeyWord, 1) < 'A'			/* any character lower than a space is a comment line */
      then nop					/* so do nothing */
    when KeyWord = 'BADMSGDIR'
      then BadPath = TempStr
    when KeyWord = 'ELAREAFILE'
      then AreaDat = TempStr
    when KeyWord = 'LOGFILE'
      then LogFile = TempStr
    when KeyWord = 'DEFAULTMAILDIR'
      then NewPath = TempStr
    when KeyWord = 'SQUISHCFGFILE'
      then SqshCfg = TempStr
    when KeyWord = 'MSGAREACTLFILE'
      then MaxArea = TempStr
    when KeyWord = 'RULEFILEDIR'
      then RulPath = TempStr
    when KeyWord = 'DESCRIPTIONDIR'
      Then DscPath = TempStr
    when KeyWord = 'DEFAULTSQUISHFLAGS'
      then Deflags = TempStr
    when KeyWord = 'DEFAULTUSERPRIV'
      then DefPriv = TempStr
    when KeyWord = 'SYSOPUSERPRIV'
      then SysPriv = TempStr
    when KeyWord = 'DEFAULTKEYS'
      then DefKeys = TempStr
    when KeyWord = 'DEFAULTNODELINK'
      then DefLink = TempStr
    when KeyWord = 'WRAPDESCLINES'
      then WrapLen = TempStr
    when KeyWord = 'MECCAPREFIXFILE'
      then PreFile = TempStr
    when KeyWord = 'MECCASUFFIXFILE'
      then SufFile = TempStr
    otherwise
call lineout LogFile, 'Unknown Keyword in cfg file, ' || KeyWord
  end
end
rc = stream(CfgFile, 'c', 'close')

call lineout LogFile, d2c(13) || 'MakeArea Started ' || date() time()
rc  =  RxFuncQuery( 'SysLoadFuncs' )      	/* Ask if SysLoadFuncs has already been done */
if rc = 1 then					/* Nope, so do it */
  do
    rc = RxFuncAdd( 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs' )
    call SysLoadFuncs
  end

rc = stream(PreFile, 'c', 'open')			/* open the Mecca Prefix File */
rc = stream(PreFile, 'c', 'query size')		/* find out how big it is */
MeccPre = charin(Prefile, , rc)			/* read it into a variable */
rc = stream(Prefile, 'c', 'close')			/* close  it */

rc = stream(SufFile, 'c', 'open')			/* open the Mecca Suffix File */
rc = stream(SufFile, 'c', 'query size')		/* find out how big it is */
MeccSuf = charin(SufFile, , rc)			/* read it into a variable */
rc = stream(SufFile, 'c', 'close')			/* close  it */

call lineout LogFile, ' Searching ' || BadPath || ' for untossed EchoMail...'	/* Load up dir of untossed msgs int BadMsgs stem */
rc = SysFileTree( BadPath  || '*.MSG', 'BadMsgs', 'FO')
if BadMsgs.0 = 0 then do
  call lineout LogFile, ' No untossed EchoMail found.  Exiting, EL = 0'
  exit Errlevl
end /* end if BadMsgs.0 */

NewArea.0 = BadMsgs.0				/* save the count of untossed msgs */
SrchStr = ' '					/* Define Search Variable */
k = 0
call lineout LogFile, ' Retrieving Echo Tags and Uplink paths...'
do j = 1 to BadMsgs.0				/* retrieve the AREA: name from every *.msg file in the BadPath dir */
  rc = stream(BadMsgs.j, 'c', 'open')
  NewArea.j = ''
  NewLink.j = ''
  c = 0
  do while lines(BadMsgs.j) > 0
    TempStr = translate(linein(BadMsgs.j))
    if pos(d2c(0) || 'AREA:', TempStr) > 0 then
      do
        TestStr = substr(TempStr, pos(d2c(0) || 'AREA:', TempStr) + 6)
        c = pos(TestStr, SrchStr)
        if c = 0 then
          do
            SrchStr = SrchStr || TestStr || ' '
            k = k + 1
            NewArea.k = TestStr
          end
      end 
    if pos(d2c(1) || 'PATH:', TempStr) > 0 & c = 0
      then NewLink.k = substr(TempStr, lastpos(' ', TempStr) + 1)
    if lastpos('/', TempStr) < lastpos(' ', TempStr) & c = 0
      then NewLink.k = DefLink
  end
  rc = stream(BadMsgs.j, 'c', 'close')
end /* do j */
/*
  
*/
drop BadMsgs					/* drop stem variable no longer needed */
drop SrchStr

call lineout LogFile, ' Searching ELAREA.DAT for Matching Echo Tags...'
rc = stream(AreaDat, 'c', 'open')			/* open the ELAREA.DAT file */
do until lines(AreaDat) = 0
  TempStr = LineIn(AreaDat)		
  c = 0
  do until TempStr = ''
    c = c + 1
    f = 0
    if left(TempStr, 1) = '"'
      then parse value TempStr With ELField.c '",' TempStr
      else parse value TempStr With ELField.c ',' TempStr
  end /* do until TempStr */
  do j = 1 to k
    ro = (pos('READ-ONLY', translate(ELField.5)) > 0 | pos('READ ONLY', translate(ELField.5)) > 0)
    if translate(NewArea.j) = translate(strip(ELField.1, B, '"')) then
     do
       if NewLink.j = '' then NewLink.j = DefLink
       TempStr = 'EchoArea ' || translate(NewArea.j), 
                || copies(' ', 24 - length(NewArea.j)), 
                || NewPath || strip(ELField.2, B, '"'), 
                || copies(' ', 12 - length(ELField.2)), 
                || Deflags || ' ' || NewLink.j
       call lineout LogFile, '  Writing New Squish Definition for ' || ELField.1 || '"'
       call lineout SqshCfg, TempStr

       call lineout LogFile, '  Writing MsgArea Definition for ', 
                || ELField.1 || '" ' || ro || ' ' || strip(ELField.23, B, '"')
       call lineout MaxArea, '% AutoAdded by MakeArea ' || date()
       call lineout MaxArea, 'Area ' || strip(ELField.2, B, '"')
       call lineout MaxArea, '    Type Squish'
       if translate(strip(ELField.23, B, '"')) = 'Y'
         then call lineout MaxArea, '    MsgAccess ' || SysPriv || '/' || DefKeys
         else call Lineout MaxArea, '    MsgAccess ' || DefPriv || '/' || DefKeys
       call lineout MaxArea, '    MsgInfo ' || strip(ELField.4, B, '"')
       call lineout MaxArea, '    MsgName ' || strip(ELField.1, B, '"')
       call lineout MaxArea, '    EchoMail ' || NewPath || strip(ELField.2, B, '"')
       if ro = 0
         then call lineout MaxArea, '    Public Only'
         else call lineout MaxArea, '    Read-Only'
       call lineout MaxArea, 'End Area'
       call lineout MaxArea

       TempStr = space(strip(ELField.5, B, '"'))		/* remove extra spaces and leading " */
       DscFile = DscPath || strip(ELField.2, B, '"') || '.BBS'
       rc = stream(DscFile, 'c', 'open')			/* open the Desc.BBS file */
       call lineout LogFile, '  Writing Description file...' || DscFile
       call lineout DscFile, , 1
       call charout DscFile, MeccPre	/* mecca prefix */
       o = 1
       l = length(TempStr)
       do until o > l|o = l
         c = lastpos(' ', substr(TempStr, o, WrapLen + 1))
         h = lastpos('-', substr(TempStr, o, WrapLen + 1))
         if (h < WrapLen|h = WrapLen) & h > c then c = h
         call lineout DscFile, substr(TempStr, o, c - 1)
         o = o + c
       end
       call lineout DscFile, MeccSuf	/* mecca suffix */
       rc = stream(DscFile, 'c', 'close')
       ErrLevl = 1
       f = 1
       NewArea.j = ''
     end /* if translate(NewArea.j) */
    if f = 1 then leave /* do j = 1 to NewArea.0 */
  end /* do j = 1 to NewArea.0 */
end /* do until lines(AreaDat) */

call lineout LogFile, "  Couldn't Create Following Areas:"

do j = 1 to NewArea.0
  if NewArea.j > '' 
    then call lineout LogFile, '    EchoArea ' ||,
    translate(NewArea.j) || copies(' ', 24 - length(NewArea.j)) ||,
    NewPath || 'JunkArea   -$m500 -0  ' || NewLink.j

end

call SysDropFuncs			/* clean up before we leave */
call lineout LogFile, 'MakeArea Ended ' || date() time()				/* say when we finished     */
say 'MakeArea.Cmd, Ended with ErrorLevel = ' || ErrLevl
Exit Errlevl				/* Exit with ErrorLevel set */
