/* Ethereal User Editor version 1.0 */
/* FREEWARE */
/* (C) 1995 Alvin Brinson */
/* Based on AEdit (C) 1994 by Gregory Gulick */

/* ETHICAL MOANS AND GROANS: */

/* If you use this source code, please give credit to all previous */
/* authors and do not charge cash for it! If you feel you must ask for */
/* cash, write something from scratch, please! */
/* Also, please include your complete SOURCE CODE and all needed modules */
/* along with your distribution. I helped you by releasing this, just as */
/* Gregroy Gulick helped me. Help other programmers as well. */

/* TECHNICAL STUFF */

/* This source code compiles without errors in TURBO C 2.0 using the    */
/* following commandlines for compiler and linker:                      */
/* tcc -c -ml uedit.c                                                   */
/* tlink uedit,uedit.pex,,PB_SDK /N /C                                  */
/* Can't guarantee success on any other compiler.                       */

#include "pb_sdk.h"

#define CTRUE	0
#define CFALSE	-1

#define CR 1
#define NOCR 0

/* The following is a string constant that is used to print the user's*/
/* flag status.  Note the initial space.  This is so the string array*/
/* numbers coincide with Phillippe's flag numbers. (1 to 32 as opposed*/
/* to 0-31).*/

#define FLAGS   " ABCDEFGHIJKLMNOPQRSTUVWXYZ123456"
#define EXPFLAGS " ABCDEFGHIJKLMNOPQRSTUVWXYZ123456"
#define EXPFLAGSON " ABCDEFGHIJKLMNOPQRSTUVWXYZ123456"

/* Prototypes*/

void main(int argc, char **argv);               /* Read Command Line Params*/
void no_memory(void);                           /* Out of memory*/
void press_enter(void);                         /* Press enter to continue*/
void top_header(void);                          /* Title, etc.*/
void bottom_header(void);                       /* Written by...*/
void user_info(void);                           /* Print user information*/
void pline(int ln, char color, char text[80]);  /* Print line information*/
void clr_window(void);                          /* Clear text window routine*/
void menu(void);                                /* Command entry routine*/
void flagmenu(void);                            /* Flags editing routine*/
void l1(void);                                  /* GotoXY line 1*/
void l2(void);                                  /* GotoXY line 2*/
void l3(void);                                  /* GotoXY line 3*/
void search_status(int loc, int num);           /* Searching status rec num*/
bool disabled(char test[10]);                   /* Mod disabled routine*/
void fill(int y, int crstat);                   /* Fill inactive with */
void cannot_edit(void);                         /* Displayed when cannot edit*/
void clr_topscr(void);                          /* Clear Main Display Area */
void showda_flags(void);                        /* Show Flags Data */
void showhelp(void);                            /* Show Help */

/* Global Variables*/

    char ch;                                    /* Multipurpose character*/
    char dataline[100];                         /* Temporary storage of Data*/
    char params[200];                           /* Command line parameters*/
    int cur_user_num;                           /* Current user number*/
    long sysop_level;                           /* Sysop access level*/
    int x;                                      /* Generic loop variable*/

    USER_REC *rec, *recs;                       /* User record pointers*/
    USER_REC *temp_recs, *temp_rec;             /* Temp user rec pointers*/

	bool mod_name 		= TRUE;
	bool mod_alias 		= TRUE;
	bool mod_password	= TRUE;
	bool mod_level 		= TRUE;
	bool mod_state		= TRUE;
	bool mod_city		= TRUE;
	bool mod_comment	= TRUE;
	bool mod_address	= TRUE;
	bool mod_phone		= TRUE;
	bool mod_timebank	= TRUE;
	bool mod_flags		= TRUE;
	bool mod_expdate	= TRUE;
    bool mod_deluser    = TRUE;
    bool mod_explevel   = TRUE;
    bool mod_firstdate  = TRUE;  /* No flag for this yet */
    bool mod_lastdate   = TRUE;  /* No flag for this yet */
    bool mod_daflags    = TRUE;  /* No flag for this yet */
    bool mod_bdate      = TRUE;  /* No flag for this yet */

/* -------------------------------------------------------------------------*/
/* Standard PowerPEX procedures, Press Enter, No Memory, etc.*/
/* -------------------------------------------------------------------------*/

void no_memory(void)
{
	printf("\f");
	SetColor(RED);
    printf("Insufficient memory to run PEX!\n");
	press_enter();
    exit();                                     /* Abort program*/
}

void press_enter(void)
{
	GotoXY(1,22);
	SetColor(WHITE);
	printf("Press [");
	SetColor(YELLOW);
	printf("Enter");
	SetColor(WHITE);
	printf("] to Continue.\t");
}

/* -------------------------------------------------------------------------*/
/* Fancy screen function, Clear window, etc.*/
/* -------------------------------------------------------------------------*/

void cannot_edit(void)
{

    /* This function is run when the user tries to edit a field they are*/
    /* not allowed to edit, or attempts to edit their own account.*/

	clr_window();
	if (cur_user_num == UserRecNr)
		pline(1,RED,"You cannot edit your own account.");
	else if (rec->level >= sysop_level)
		pline(1,RED,"You cannot edit the SysOp's account!");
	else
		pline(1,RED,"You cannot edit this field.");
	press_enter();
}

void fill(int y, int crstat)
{
	int x;

    /* This procedure fills the field with "" if the user cannot access*/
    /* the specified field on the command line.  The variable crstat is the*/
    /* carriage return status variable.  If it is true, a new line is sent.*/
    /* If not, two spaces are printed for the purpose of seperating the*/
    /* fields correctly.*/

	for (x=1; x<=y; ++x)
		printf("\005");

	if (crstat == CR)
		printf("\n");
	else
		printf("  ");
}

void pline(int ln,char color, char text[80])
{
    switch (ln) {                               /* What line to print on?*/
		case 1 : GotoXY(1,20); break;
		case 2 : GotoXY(1,21); break;
		case 3 : GotoXY(1,22); break;
	}

	SetColor(color);
    printf("%s",text);                          /* Print text*/

}

void clr_window()                               /* Clear text window*/
{
	GotoXY(1,20); ClrEol();
	GotoXY(1,21); ClrEol();
	GotoXY(1,22); ClrEol();
}

void clr_topscr()                               /* Clear Display Area */
{
    GotoXY(1,4);
    for (x=0; x<=14; ++x)
       printf("                                                                              \n");
}

void search_status(int loc, int num)
{
	GotoXY(loc+1,20);
	printf("%d",num);
}

void l1(void)
{
	GotoXY(1,20);
}

void l2(void)
{
	GotoXY(1,21);
}

void l3(void)
{
	GotoXY(1,22);
}

/* -------------------------------------------------------------------------*/
/* Menu, User Information Procedures, Headers, etc.*/
/* -------------------------------------------------------------------------*/

void top_header(void)
{
	printf("\f");
	SetColor(MAGENTA);
	printf("\004\n");
    printf(" \007Ethereal User Editor 1.0 \004\n");
    printf("\n");
}


void showhelp(void)
{
        clr_topscr();
        GotoXY(1,4);
        printf("\003[      \006- \007Next User.\n");
        printf("\003]      \006- \007Previous User.\n");
        printf("\003CTRL-P \006- \007Post Message to User.\n");
        printf("\003CTRL-R \006- \007Redraw Screen.\n\n");
        printf("\003CTRL-B \006- \007Beginning of User Log (First User).\n");
        printf("\003CTRL-E \006- \007End of User Log (Last User).\n\n");
        printf("\003CTRL-U \006- \007Search User Log.\n");
        printf("\003CTRL-N \006- \007Repeat Last Search.\n\n");
        printf("\003CTRL-D \006- \007Delete User.\n\n");
        printf("        \002(\007C\002) \007 1995 \004 Alvin Brinson");
        printf("                   \0071\002:\007106\002/\0077008 \006 FidoNet");

        clr_window();
        press_enter();
        clr_topscr();
}

void showda_flags(void)
{
    int x;

    GotoXY(1,4);
    printf("\007[\003\007] Name  : \006%-25.25s  ",rec->name);

    GotoXY(1,5);
    printf("\007[\003A\007] Deleted : ");
    if (rec->uFlags & UFLAG_DELETED) {
        GotoXY(25,5);
        printf("\005Yes");
     }
     else {
        GotoXY(25,5);
        printf("\004No ");
     }

    GotoXY(1,6);
    printf("\007[\003B\007] Ansi Mode : ");
    if (rec->uFlags & UFLAG_ANSI) {
        GotoXY(25,6);
        printf("\005Yes");
     }
     else {
        GotoXY(25,6);
        printf("\004No ");
     }

    GotoXY(1,7);
    printf("\007[\003C\007] Pause Mode : ");
    if (rec->uFlags & UFLAG_PAUSE) {
        GotoXY(25,7);
        printf("\005Yes");
     }
     else {
        GotoXY(25,7);
        printf("\004No ");
     }

    GotoXY(1,8);
    printf("\007[\003D\007] Clear Screen : ");
    if (rec->uFlags & UFLAG_CLEAR) {
        GotoXY(25,8);
        printf("\005Yes");
     }
     else {
        GotoXY(25,8);
        printf("\004No ");
     }
    

    GotoXY(1,9);
    printf("\007[\003E\007] Hotkeys : ");
    if (rec->uFlags & UFLAG_HOTKEYS) {
        GotoXY(25,9);
        printf("\005Yes");
     }
     else {
        GotoXY(25,9);
        printf("\004No ");
     }

    GotoXY(1,10);
    printf("\007[\003F\007] IBM Graphics : ");
    if (rec->uFlags & UFLAG_NOIBM) {
        GotoXY(25,10);
        printf("\004No ");
     }
     else {
        GotoXY(25,10);
        printf("\005Yes");
     }

    GotoXY(1,11);
    printf("\007[\003G\007] Full Screen Ed : ");
    if (rec->uFlags & UFLAG_FSED) {
        GotoXY(25,11);
        printf("\005Yes");
     }
     else {
        GotoXY(25,11);
        printf("\004No ");
     }

    GotoXY(1,12);
    printf("\007[\003H\007] Don't Kill User : ");
    if (rec->uFlags & UFLAG_NOKILL) {
        GotoXY(25,12);
        printf("\005Don't Kill   ");
     }
     else {
        GotoXY(25,12);
        printf("\004Kill the Twit");
     }

    GotoXY(1,13);
    printf("\007[\003I\007] Ignore Downloads : ");
    if (rec->uFlags & UFLAG_IGNORE) {
        GotoXY(25,13);
        printf("\005Yes");
     }
     else {
        GotoXY(25,13);
        printf("\004No ");
     }

    GotoXY(1,14);
    printf("\007[\003J\007] Attention : ");
    if (rec->uFlags & UFLAG_ATTEN) {
        GotoXY(25,14);
        printf("\005Yes");
     }
     else {
        GotoXY(25,14);
        printf("\004No ");
     }

    GotoXY(1,15);
    printf("\007[\003K\007] Hide From Tops : ");
    if (rec->uFlags & UFLAG_NOTOPS) {
        GotoXY(25,15);
        printf("\005Yes");
     }
     else {
        GotoXY(25,15);
        printf("\004No ");
     }

    GotoXY(40,5);
    printf("\007[\003L\007] Hide from Lists : ");
    if (rec->uFlags & UFLAG_HIDDEN) {
        GotoXY(65,5);
        printf("\005Yes");
     }
     else {
        GotoXY(65,5);
        printf("\004No ");
     }

    GotoXY(40,6);
    printf("\007[\003M\007] Quiet : ");
    if (rec->uFlags & UFLAG_QUIET) {
        GotoXY(65,6);
        printf("\005Yes");
     }
     else {
        GotoXY(65,6);
        printf("\004No ");
     }

    GotoXY(40,7);
    printf("\007[\003N\007] Avatar : ");
    if (rec->uFlags & UFLAG_AVATAR) {
        GotoXY(65,7);
        printf("\005Yes");
     }
     else {
        GotoXY(65,7);
        printf("\004No ");
     }

    GotoXY(40,8);
    printf("\007[\003O\007] Avatar Plus : ");
    if (rec->uFlags & UFLAG_AVTPLUS) {
        GotoXY(65,8);
        printf("\005Yes");
     }
     else {
        GotoXY(65,8);
        printf("\004No ");
     }

    GotoXY(40,9);
    printf("\007[\003P\007] Guest Account : ");
    if (rec->uFlags & UFLAG_GUEST) {
        GotoXY(65,9);
        printf("\005Yes");
     }
     else {
        GotoXY(65,9);
        printf("\004No ");
     }

    GotoXY(40,10);
    printf("\007[\003R\007] Page Priority : ");
    if (rec->uFlags & UFLAG_PAGEPRI) {
        GotoXY(65,10);
        printf("\005Yes");
     }
     else {
        GotoXY(65,10);
        printf("\004No ");
     }

    GotoXY(40,11);
    printf("\007[\003S\007] Local Only : ");
    if (rec->uFlags & UFLAG_LOCALONLY) {
        GotoXY(65,11);
        printf("\005Yes");
     }
     else {
        GotoXY(65,11);
        printf("\004No ");
     }

    GotoXY(40,12);
    printf("\007[\003T\007] Multiple Logins : ");
    if (rec->uFlags & UFLAG_MULTILOGIN) {
        GotoXY(65,12);
        printf("\005Yes");
     }
     else {
        GotoXY(65,12);
        printf("\004No ");
     }

    GotoXY(40,13);
    printf("\007[\003U\007] Free Chat : ");
    if (rec->uFlags & UFLAG_FREECHAT) {
        GotoXY(65,13);
        printf("\005Yes");
     }
     else {
        GotoXY(65,13);
        printf("\004No ");
     }

    GotoXY(40,14);
    printf("\007[\003V\007] Disable RIP : ");
    if (rec->uFlags & UFLAG_NORIP) {
        GotoXY(65,14);
        printf("\005Yes");
     }
     else {
        GotoXY(65,14);
        printf("\004No ");
     }

    GotoXY(1,16);
    printf("\007[\0031\007] Number of Calls : \006%u      ",rec->timesCalled);

}

void user_info(void)
{
	int x;

	GotoXY(1,4);
	printf("\007[\003N\007] Name  : \006%-25.25s  ",rec->name);

	printf("\007[\003V\007] Voice Phone   : ");
	if (mod_phone)
		printf("\006%-16.16s\n",rec->voicePhone);
	else
		fill(16,CR);

	printf("\007[\003A\007] Alias : ");
		printf("\006%-25.25s  ",rec->alias);

	printf("\007[\003D\007] Data Phone    : ");
	if (mod_phone)
		printf("\006%-16.16s\n",rec->dataPhone);
	else
		fill(16,CR);

	printf("\007[\003P\007] Pass  : ");
	if ((mod_password) && (rec->level < sysop_level))
		printf ("\006%-25.25s  ",rec->passWord);
	else
		fill(25,NOCR);

	printf("\007[\003X\007] Fax Phone     : ");
	if (mod_phone)
		printf("\006%-16.16s\n",rec->faxPhone);
	else
		fill(16,CR);

	printf("\007[\003C\007] City  :\006 ");
		printf("%-25.25s\n",rec->city);

	printf("\007[\003S\007] State :");
		printf("\006 %-25.25s  ",rec->state);

	printf("\007[\003M\007] Time Balance  : ");
	if (mod_timebank)
		printf("\006%-16d\n",rec->tbTimeBalance);
	else
		fill(16,CR);

	printf("\007[\0031\007] Addr1 :\006 ");
	if (mod_address)
		printf("%-25.25s  ",rec->address1);
	else
		fill(25,NOCR);

    printf("\007[\003K\007] KByte Balance : ");
	if (mod_timebank)
		printf("\006%-16d\n",rec->tbKbBalance);
	else
		fill(16,CR);

	printf("\007[\0032\007] Addr2 :\006 ");
	if (mod_address)
		printf("%-25.25s\n",rec->address2);
	else
        fill(25,NOCR);

/* First Login Date - added in Beta3 */

    GotoXY(40,10);
    printf("\007[\003I\007] First Login Date :   /  /      \n");
        GotoXY(64,10);
        if (Config->europe == 0) {  /* American Date Format*/
            printf("%d/%d/%d\n",
            rec->firstDate[1],
            rec->firstDate[0],
            rec->firstDate[2]);
        }
        else                /* European Date Format*/
            printf("%d/%d/%d\n",
            rec->firstDate[0],
            rec->firstDate[1],
            rec->firstDate[2]);

/* End of First Login Date */

    printf("\007[\0033\007] Addr3 :\006 ");
    if (mod_address)
        printf("%-25.25s",rec->address3);
    else
        fill(25,CR);

    GotoXY(1,12);
    printf("\007[\003L\007] Level : \006%-5u",rec->level);

/* Birthdate - added in Beta4 */

    GotoXY(1,13);
    printf("\007[\003B\007] BirthDate :   /  /      \n");
        GotoXY(18,13);
        if (Config->europe == 0) {  /* American Date Format*/
            printf("%d/%d/%d\n",
            rec->birthDate[1],
            rec->birthDate[0],
            rec->birthDate[2]);
        }
        else                /* European Date Format*/
            printf("%d/%d/%d\n",
            rec->birthDate[0],
            rec->birthDate[1],
            rec->birthDate[2]);

/* End Added */


/* Last Login Date - added in Beta3 */

    GotoXY(40,11);
    printf("\007[\003J\007] Last Login Date  :   /  /      \n");
        GotoXY(64,11);
        if (Config->europe == 0) {  /* American Date Format*/
            printf("%d/%d/%d\n",
            rec->lastDate[1],
            rec->lastDate[0],
            rec->lastDate[2]);
        }
        else                /* European Date Format*/
            printf("%d/%d/%d\n",
            rec->lastDate[0],
            rec->lastDate[1],
            rec->lastDate[2]);

/* End of Last Login Date */

    if (rec->uFlags & UFLAG_DELETED) {
        GotoXY(40,7);
        printf("\x11[DELETED]    \n\n");
	}
	else {
        GotoXY(40,7);
        printf("\007[\002Active User\007]\n\n");
	}


    /* Added by Alvin Brinson in 1.0b3 */
    GotoXY(40,12);

    printf("\007[\003G\007] Expire To : \006%-5u",rec->expLevel);

    /* End Added */

    GotoXY(40,13);

    printf("\007[\003E\007] Expiration Date :   /  /      \n");
		GotoXY(63,13);
        if (Config->europe == 0) {  /* American Date Format*/
            printf("%d/%d/%d\n",
			rec->expDate[1],
			rec->expDate[0],
			rec->expDate[2]);
		}
        else                /* European Date Format*/
            printf("%d/%d/%d\n",
			rec->expDate[0],
			rec->expDate[1],
			rec->expDate[2]);

    printf("\007[\003F\007] Flags       : ");
	for (x=1; x<=32; ++x) {
		if (GetFlag(rec->aFlags,x) == TRUE)
			printf("\006%c",FLAGS[x]);
		else
			printf("\007-");
	}
    printf("\n");

    /* Added 1.0b2 */
    printf("\007[\003H\007] expFlagsOff : ");
    for (x=1; x<=32; ++x) {
        if (GetFlag(rec->expFlagsOff,x) == TRUE)
            printf("\006%c",EXPFLAGS[x]);
        else
            printf("\007-");
    }

    /* End Added */

    printf("\n");

/* Added 1.0b4 */

    printf("\007[\003R\007] expFlagsOn  : ");
    for (x=1; x<=32; ++x) {
        if (GetFlag(rec->expFlagsOn,x) == TRUE)
            printf("\006%c",EXPFLAGSON[x]);
        else
            printf("\007-");
    }

/* End Added */

    printf("\n");

    printf("\007[\003T\007] Comment : ");
	if (mod_comment)
		printf("\006 %-64.64s\n",rec->comment);
	else
		fill(64,CR);

    printf("                          \007[\003CTRL-F\007] Extended Edit Screen");
}



void bottom_header()
{
    GotoXY(1,19);
	printf("\007\n\n\n\n");
	printf("\004\007\n");
}

/* -------------------------------------------------------------------------*/
/* Main Procedures (Main, Menu, etc.)*/
/* -------------------------------------------------------------------------*/

bool disabled(char test[10])
{
	if (strstr(params,test) != NULL)
		return(TRUE);
	else
		return(FALSE);
}

void menu(void)
{
	char choice, search[40], temp[40], flag, buf[100], asc_value[2];
	bool match_found;
	int x, flag_num;

	strcpy(search,"");

	top_header();
	bottom_header();

	do {
		ReadUser(rec,cur_user_num);
		user_info();
		clr_window();
		GotoXY(1,20);
		SetColor(CYAN);
		printf("Current User Number : \007%d", cur_user_num+1);
		pline(3,WHITE,"(Press ? for Help) Command : ");
		choice = WaitKey();
		switch (toupper(choice)) {

            /* Next user*/

            case ']' : {
				if (cur_user_num + 1 >= NumUsers) {
				    clr_window();
				    pline(1,RED,"Cannot move forward.");
				    pline(3,WHITE,"Press [Enter] to Continue.\t");
				    clr_window();
				}
				else
				    ++cur_user_num;
				    break;
				}

            /* Previous user*/

            case '[' : {
				if (cur_user_num - 1 < 0) {
				    clr_window();
				    pline(1,RED,"Cannot move backwards.");
				    press_enter();
				    clr_window();
				}
				else
				    --cur_user_num;
				    break;
				}

       /* The following case statement takes UEdit to the last record in*/
       /* the userlog.*/

	   case KEY_CTLE : {
			cur_user_num = NumUsers-1;
			break;
			   }

        case KEY_CTLF : {
/*            printf("\f"); */
            flagmenu();
            clr_topscr();
            break;
        }

       /* The following case statement takes UEdit to the first record in*/
       /* the userlog.*/

	   case KEY_CTLB : {
			cur_user_num = 0;
			break;
			}

       /* The following case statement simply redraws the entire screen.*/

	   case KEY_CTLR : {
            printf("\f");
			top_header();
			bottom_header();
			break;
			}

	   case KEY_CTLD : {
            if ((mod_deluser == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_DELETED;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
		    }

       /* The following case statement is the routine to search the entire*/
       /* user log from the beginning.  Some things to note:*/
       /**/
       /* Notice that if the user presses enter when prompted for a search*/
       /* string, the program returns.*/
       /**/
       /* Note that the loop starts on zero and the loop continues until*/
       /* the loop variable is equal to total users minus one or until a*/
       /* match is found (simple boolean variable).  The reason for starting*/
       /* at zero is because the actual C array of the user record starts at*/
       /* 0 where the actual user log (i.e., ProConfig) starts at 1.  All*/
       /* record numbers within the program coincide with C's conventional*/
       /* first element zero.  All display to the user is incremented so as*/
       /* to coincide with Philippe's ProCfg user editor.*/
       /**/
       /* FuzzySearch uses a degree of 80%*/

	   case KEY_CTLU : {
			clr_window();
			pline(1,CYAN,"Search User Log.");
						l3();
						SetColor(WHITE);
						printf("Enter search string : ");
						Input(search,36,INPUT_UPALL);
						if (strlen(search) == 0)
							break;

						match_found = FALSE;

						clr_window();
						pline(1,WHITE,"Searching... ");
						for (x=0; x<=NumUsers-1 && match_found == FALSE; ++x) {
							search_status(13,x+1);
							ReadUser(temp_rec,x);
							strcpy(temp,strupr(temp_rec->name));
							if ((strstr(temp,search) != NULL) || (FuzzySearch(temp,search,80) >= 80)) {
								cur_user_num = x;
								match_found = TRUE;
							}
						}
						if (match_found == FALSE) {
							clr_window();
							pline(1,RED,"No match found.");
							press_enter();
						}
						break;
					   }

       /* The following case statment is nearly identical to the previous*/
       /* search routine.*/

	   case KEY_CTLN : {
						if (strlen(search) == 0)
							break;
						clr_window();

						match_found = FALSE;

						clr_window();
						pline(1,WHITE,"Searching... ");
						for (x=cur_user_num+1; x<=NumUsers-1 && match_found == FALSE; ++x) {
							search_status(13,x+1);
							ReadUser(temp_rec,x);
							strcpy(temp,strupr(temp_rec->name));
							if ((strstr(temp,search) != NULL) || (FuzzySearch(temp,search,80) >= 80)) {
								cur_user_num = x;
								match_found = TRUE;
							}
						}
						if (match_found == FALSE) {
							clr_window();
							pline(1,RED,"No match found.");
							press_enter();
						}
						break;
					   }

/* Old Post Routine

       case KEY_CTLP : {
                        WriteMSGTMP (" ");
                        MsgEd();
                        PostMessage (CurUser->name,rec->name,"Something",1,TRUE);
                        printf("\f");
                        top_header();
                        bottom_header();
                        break;
                       } */

/* New Post Routine */

       case KEY_CTLP : {
                        sprintf(dataline,"1 /T=\"%s\"",rec->name);
                        MenuFunction(MENU_WRITEMSG,dataline);
                        printf("\f");
                        top_header();
                        bottom_header();
                        break;
                    }



           case 'F' : {
						if ((mod_flags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
							clr_window();
							pline(1,CYAN,"Edit User Flags.");
							l3();
							printf("\007Enter Flag to Toggle ([\003Enter\007] to Abort) : ");
							flag = WaitKey();
							if (strchr("ABCDEFGHIJKLMNOPQRSTUVWXYZ123456",toupper(flag)) == NULL)
								break;

							sprintf(asc_value,"%d",toupper(flag));

							if ((atoi(asc_value) >= 49) && (atoi(asc_value) <= 54))
								flag_num = atoi(asc_value) - 22;
							else
								flag_num = atoi(asc_value)-64;

							if (GetFlag(rec->aFlags,flag_num) == TRUE)
									ClearFlag(rec->aFlags,flag_num)
							else
								SetFlag(rec->aFlags,flag_num)
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
            case 'H' : {
                        if ((cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                            clr_window();
                            pline(1,CYAN,"Edit Expire Off Flags.");
							l3();
							printf("\007Enter Flag to Toggle ([\003Enter\007] to Abort) : ");
							flag = WaitKey();
							if (strchr("ABCDEFGHIJKLMNOPQRSTUVWXYZ123456",toupper(flag)) == NULL)
								break;

							sprintf(asc_value,"%d",toupper(flag));

							if ((atoi(asc_value) >= 49) && (atoi(asc_value) <= 54))
								flag_num = atoi(asc_value) - 22;
							else
								flag_num = atoi(asc_value)-64;

                            if (GetFlag(rec->expFlagsOff,flag_num) == TRUE)
                                    ClearFlag(rec->expFlagsOff,flag_num)
							else
                                SetFlag(rec->expFlagsOff,flag_num)
							WriteUser(rec);
						}
                        else
							cannot_edit();
                        break;
            }

            case 'R' : {
                        if ((cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                            clr_window();
                            pline(1,CYAN,"Edit Expire On Flags.");
							l3();
							printf("\007Enter Flag to Toggle ([\003Enter\007] to Abort) : ");
							flag = WaitKey();
							if (strchr("ABCDEFGHIJKLMNOPQRSTUVWXYZ123456",toupper(flag)) == NULL)
								break;

							sprintf(asc_value,"%d",toupper(flag));

							if ((atoi(asc_value) >= 49) && (atoi(asc_value) <= 54))
								flag_num = atoi(asc_value) - 22;
							else
								flag_num = atoi(asc_value)-64;

                            if (GetFlag(rec->expFlagsOn,flag_num) == TRUE)
                                    ClearFlag(rec->expFlagsOn,flag_num)
							else
                                SetFlag(rec->expFlagsOn,flag_num)
							WriteUser(rec);
						}
                        else
							cannot_edit();
                        break;
            }

            case 'L' : {
						if ((mod_level == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                            clr_window();
							pline(1,CYAN,"Edit Security Level.");
							l3();
							printf("\007Enter NEW Security Level ([\003Enter\007] to Abort) : ");
							Input(buf,5,INPUT_DIGITS);
							if (strlen(buf) == 0)
								break;
							rec->level = atol(buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
            case 'G' : {
                        if ((mod_explevel == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
							clr_window();
                            pline(1,CYAN,"Edit Expiration Level.");
							l3();
                            printf("\007Enter NEW Expiration Level ([\003Enter\007] to Abort) : ");
							Input(buf,5,INPUT_DIGITS);
							if (strlen(buf) == 0)
								break;
                            rec->expLevel = atol(buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
                       }
            case 'N' : {
						if ((mod_name == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
							clr_window();
							pline(1,CYAN,"Edit User Name.");
							l3();
							printf("\007Enter NEW User Name ([\003Enter\007] to Abort) : ");
							Input(buf,35,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->name,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
			case 'A' : {
						if ((mod_alias == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
							clr_window();
							pline(1,CYAN,"Edit User Alias.");
							l3();
							printf("\007Enter NEW User Alias ([\003Enter\007] to Abort) : ");
							Input(buf,35,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->alias,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
			case 'P' : {
						if ((mod_password == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
						clr_window();
							pline(1,CYAN,"Edit User Password.");
							l3();
							printf("\007Enter NEW User Password ([\003Enter\007] to Abort) : ");
							Input(buf,15,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->passWord,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
			case 'C' : {
						if ((mod_city == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
							clr_window();
							pline(1,CYAN,"Edit User City.");
							l3();
							printf("\007Enter NEW User City ([\003Enter\007] to Abort) : ");
							Input(buf,25,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->city,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
						}
			case 'S' : {
						if ((mod_state == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
							clr_window();
							pline(1,CYAN,"Edit User State.");
							l3();
							printf("\007Enter NEW User State ([\003Enter\007] to Abort) : ");
							Input(buf,25,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->state,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
			case '1' : {
						if ((mod_address == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
							clr_window();
							pline(1,CYAN,"Edit User Address (Line 1).");
							l3();
							printf("\007Enter NEW User Address ([\003Enter\007] to Abort) : ");
							Input(buf,35,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->address1,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
			case '2' : {
						if ((mod_address == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
							clr_window();
							pline(1,CYAN,"Edit User Address (Line 2).");
							l3();
							printf("\007Enter NEW User Address ([\003Enter\007] to Abort) : ");
							Input(buf,35,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->address2,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
			case '3' : {
						if ((mod_address == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
							clr_window();
							pline(1,CYAN,"Edit User Address (Line 3).");
							l3();
							printf("\007Enter NEW User Address ([\003Enter\007] to Abort) : ");
							Input(buf,35,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->address3,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
			case 'T' : {
						if ((mod_comment == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
							clr_window();
							pline(1,CYAN,"Edit User Comment.");
							l2();
							printf("\007Enter NEW User Comment ([\003Enter\007] to Abort) : ");
							l3();
							Input(buf,79,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->comment,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
			case 'V' : {
				if ((mod_phone == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
					clr_window();
					pline(1,CYAN,"Edit User Voice Phone Number.");
					l3();
					printf("\007Enter NEW Phone Number ([\003Enter\007] to Abort) : ");
					Input(buf,15,INPUT_ALL);
					if (strlen(buf) == 0)
						break;
					strcpy(rec->voicePhone,buf);
					WriteUser(rec);
				}
				else
					cannot_edit();
				break;
			   }
			case 'E' : {
				if ((mod_expdate == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
				    clr_window();
				    pline(1,CYAN,"Edit Expiration Date.");
				    l3();
				    if (Config->europe == 0) {
					printf("\007Month : ");
					Input(buf,2,INPUT_DIGITS);
					rec->expDate[1] = atoi(buf);
					printf(" Date : ");
					Input(buf,2,INPUT_DIGITS);
					rec->expDate[0] = atoi(buf);
				    }
				    else {
					printf("\007 Date : ");
					Input(buf,2,INPUT_DIGITS);
					rec->expDate[0] = atoi(buf);
					printf("Month : ");
					Input(buf,2,INPUT_DIGITS);
					rec->expDate[1] = atoi(buf);
				    }
				    printf(" Year : ");
				    Input(buf,2,INPUT_DIGITS);
				    rec->expDate[2] = atoi(buf);
				    WriteUser(rec);
				}
                else
                    cannot_edit();
                break;
			    }


/* Added in beta4 - birthdate */

            case 'B' : {
                if ((mod_bdate == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
				    clr_window();
                    pline(1,CYAN,"Edit BirthDate.");
				    l3();
				    if (Config->europe == 0) {
					printf("\007Month : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->birthDate[1] = atoi(buf);
					printf(" Date : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->birthDate[0] = atoi(buf);
				    }
				    else {
					printf("\007 Date : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->birthDate[0] = atoi(buf);
					printf("Month : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->birthDate[1] = atoi(buf);
				    }
				    printf(" Year : ");
				    Input(buf,2,INPUT_DIGITS);
                    rec->birthDate[2] = atoi(buf);
				    WriteUser(rec);
				}
                else
                    cannot_edit();
                break;
                }

/* End Added */

/* Added in 1.0b3 - Edit first login date */

            case 'I' : {
                if ((mod_firstdate == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
				    clr_window();
                    pline(1,CYAN,"Edit First Login Date.");
				    l3();
				    if (Config->europe == 0) {
					printf("\007Month : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->firstDate[1] = atoi(buf);
					printf(" Date : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->firstDate[0] = atoi(buf);
				    }
				    else {
					printf("\007 Date : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->firstDate[0] = atoi(buf);
					printf("Month : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->firstDate[1] = atoi(buf);
				    }
				    printf(" Year : ");
				    Input(buf,2,INPUT_DIGITS);
                    rec->firstDate[2] = atoi(buf);
				    WriteUser(rec);
				}
                else
                    cannot_edit();
                break;
                }

/* End Added */

/* Added in 1.0b3 - Edit last login date */

            case 'J' : {
                if ((mod_lastdate == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
				    clr_window();
                    pline(1,CYAN,"Edit Last Login Date.");
				    l3();
				    if (Config->europe == 0) {
					printf("\007Month : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->lastDate[1] = atoi(buf);
					printf(" Date : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->lastDate[0] = atoi(buf);
				    }
				    else {
					printf("\007 Date : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->lastDate[0] = atoi(buf);
					printf("Month : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->lastDate[1] = atoi(buf);
				    }
				    printf(" Year : ");
				    Input(buf,2,INPUT_DIGITS);
                    rec->lastDate[2] = atoi(buf);
				    WriteUser(rec);
				}
                else
                    cannot_edit();
                break;
                }

/* End Added */

            case 'D' : {
						if ((mod_phone == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
							clr_window();
							pline(1,CYAN,"Edit User Data Phone Number.");
							l3();
							printf("\007Enter NEW Phone Number ([\003Enter\007] to Abort) : ");
							Input(buf,15,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->dataPhone,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
			case 'X' : {
						if ((mod_phone == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
							clr_window();
							pline(1,CYAN,"Edit User Data Phone Number.");
							l3();
							printf("\007Enter NEW Phone Number ([\003Enter\007] to Abort) : ");
							Input(buf,15,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->faxPhone,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
			case 'M' : {
						if ((mod_timebank == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
							clr_window();
							pline(1,CYAN,"Edit Time Balance.");
							l3();
							printf("\007Enter NEW Time Balance ([\003Enter\007] to Abort) : ");
							Input(buf,3,INPUT_DIGITS);
							if (strlen(buf) == 0)
								break;
							rec->tbTimeBalance = atoi(buf);
							WriteUser(rec);

						}
						else
							cannot_edit();
						break;
					   }
			case 'K' : {
						if ((mod_timebank == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
							clr_window();
							pline(1,CYAN,"Edit Kilobyte Balance.");
							l3();
							printf("\007Enter NEW Kilobyte Balance ([\003Enter\007] to Abort) : ");
							Input(buf,5,INPUT_DIGITS);
							if (strlen(buf) == 0)
								break;
							rec->tbKbBalance = atoi(buf);
							WriteUser(rec);

						}
						else
							cannot_edit();
						break;
					   }
			case '?' : {
                        showhelp();
                        break;
					   }

        } /* End of SWITCH statement*/
    } while (toupper(choice) != 'Q');
} /* End of FUNCTION*/

void flagmenu(void)
{
    /* The first part of flagmenu is almost a repeat of menu routine. */
    /* If change made to part of one, check the other */

    char choice, search[40], temp[40], flag, buf[100], asc_value[2];
	bool match_found;
	int x, flag_num;

	strcpy(search,"");

    top_header();
	bottom_header();

	do {
		ReadUser(rec,cur_user_num);
        showda_flags();
		clr_window();
		GotoXY(1,20);
		SetColor(CYAN);
		printf("Current User Number : \007%d", cur_user_num+1);
        pline(3,WHITE,"(Press ? for Help / Q to Return To Edit Menu) Command : ");
		choice = WaitKey();
		switch (toupper(choice)) {

            /* Next user*/

            case ']' : {
				if (cur_user_num + 1 >= NumUsers) {
				    clr_window();
				    pline(1,RED,"Cannot move forward.");
				    pline(3,WHITE,"Press [Enter] to Continue.\t");
				    clr_window();
				}
				else
				    ++cur_user_num;
				    break;
				}

            /* Previous user*/

            case '[' : {
				if (cur_user_num - 1 < 0) {
				    clr_window();
				    pline(1,RED,"Cannot move backwards.");
				    press_enter();
				    clr_window();
				}
				else
				    --cur_user_num;
				    break;
				}

       /* The following case statement takes UEdit to the last record in*/
       /* the userlog.*/

	   case KEY_CTLE : {
			cur_user_num = NumUsers-1;
			break;
			   }

       /* The following case statement takes UEdit to the first record in*/
       /* the userlog.*/

	   case KEY_CTLB : {
			cur_user_num = 0;
			break;
			}

       /* The following case statement simply redraws the entire screen.*/

	   case KEY_CTLR : {
            printf("\f");
			top_header();
			bottom_header();
			break;
			}

	   case KEY_CTLD : {
            if ((mod_deluser == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_DELETED;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
		    }

       /* The following case statement is the routine to search the entire*/
       /* user log from the beginning.  Some things to note:*/
       /**/
       /* Notice that if the user presses enter when prompted for a search*/
       /* string, the program returns.*/
       /**/
       /* Note that the loop starts on zero and the loop continues until*/
       /* the loop variable is equal to total users minus one or until a*/
       /* match is found (simple boolean variable).  The reason for starting*/
       /* at zero is because the actual C array of the user record starts at*/
       /* 0 where the actual user log (i.e., ProConfig) starts at 1.  All*/
       /* record numbers within the program coincide with C's conventional*/
       /* first element zero.  All display to the user is incremented so as*/
       /* to coincide with Philippe's ProCfg user editor.*/
       /**/
       /* FuzzySearch uses a degree of 80%*/

	   case KEY_CTLU : {
			clr_window();
			pline(1,CYAN,"Search User Log.");
						l3();
						SetColor(WHITE);
						printf("Enter search string : ");
						Input(search,36,INPUT_UPALL);
						if (strlen(search) == 0)
							break;

						match_found = FALSE;

						clr_window();
						pline(1,WHITE,"Searching... ");
						for (x=0; x<=NumUsers-1 && match_found == FALSE; ++x) {
							search_status(13,x+1);
							ReadUser(temp_rec,x);
							strcpy(temp,strupr(temp_rec->name));
							if ((strstr(temp,search) != NULL) || (FuzzySearch(temp,search,80) >= 80)) {
								cur_user_num = x;
								match_found = TRUE;
							}
						}
						if (match_found == FALSE) {
							clr_window();
							pline(1,RED,"No match found.");
							press_enter();
						}
						break;
					   }

       /* The following case statment is nearly identical to the previous*/
       /* search routine.*/

	   case KEY_CTLN : {
						if (strlen(search) == 0)
							break;
						clr_window();

						match_found = FALSE;

						clr_window();
						pline(1,WHITE,"Searching... ");
						for (x=cur_user_num+1; x<=NumUsers-1 && match_found == FALSE; ++x) {
							search_status(13,x+1);
							ReadUser(temp_rec,x);
							strcpy(temp,strupr(temp_rec->name));
							if ((strstr(temp,search) != NULL) || (FuzzySearch(temp,search,80) >= 80)) {
								cur_user_num = x;
								match_found = TRUE;
							}
						}
						if (match_found == FALSE) {
							clr_window();
							pline(1,RED,"No match found.");
							press_enter();
						}
						break;
					   }

/* "Post to User" Routine  Added Beta 3  - Old Version

       case KEY_CTLP : {
                        WriteMSGTMP (" ");
                        MsgEd();
                        PostMessage (CurUser->name,rec->name,"Something",1,TRUE);
                        printf("\f");
                        top_header();
                        bottom_header();
                        break;
                       }

end of routine */

/* New Post Routine */

       case KEY_CTLP : {
                        sprintf(dataline,"1 /T=\"%s\"",rec->name);
                        MenuFunction(MENU_WRITEMSG,dataline);
                        printf("\f");
                        top_header();
                        bottom_header();
                        break;
                    }

            case 'A' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_DELETED;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'B' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_ANSI;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'C' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_PAUSE;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'D' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_CLEAR;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'E' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_HOTKEYS;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'F' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_NOIBM;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'G' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_FSED;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'H' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_NOKILL;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'I' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_IGNORE;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'J' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_ATTEN;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'K' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_NOTOPS;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'L' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_HIDDEN;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'M' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_QUIET;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'N' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_AVATAR;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'O' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_AVTPLUS;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'P' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_GUEST;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'R' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_PAGEPRI;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'S' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_LOCALONLY;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'T' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_MULTILOGIN;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'U' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_FREECHAT;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'V' : {
            if ((mod_daflags == TRUE) && (cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                rec->uFlags ^= UFLAG_NORIP;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case '1' : {
                if ((cur_user_num != UserRecNr) && (rec->level < sysop_level)) {
                    clr_window();
                    pline(1,CYAN,"Edit # of Calls.");
                    l3();
                    printf("\007Enter # of Calls ([\003Enter\007] to Abort) : ");
                    Input(buf,6,INPUT_DIGITS);
                    if (strlen(buf) == 0)
                        break;
                    rec->timesCalled = atol(buf);
                    WriteUser(rec);
            }
            else
                cannot_edit();
            break;
        }



            case '?' : {
                        showhelp();
                        break;
					   }

        } /* End of SWITCH statement*/
	} while (toupper(choice) != 'Q');
} /* End of FUNCTION*/


void main(int argc, char **argv)
{
    /* Test for ANSI and/or AVATAR*/

    if ((CurUser->uFlags & UFLAG_ANSI) ||
	(CurUser->uFlags & UFLAG_AVATAR) ||
	(CurUser->uFlags & UFLAG_AVTPLUS)) {
	if ((rec = (USER_REC *) calloc(1,1500)) == NULL)
	    no_memory();

	if ((temp_rec = (USER_REC *) calloc(1,1500)) == NULL)
	    no_memory();

	recs = rec;
	temp_recs = temp_rec;

	sysop_level = atol(argv[1]);

    strncpy(params,argv[2],198);                /* Copy first 199 characters*/
    strupr(params);                             /* Convert to upper case*/

    if (argc > 1) {                             /* Set up exclusion areas*/
        if (disabled("NA"))                     /* Disable name mod*/
			mod_name = FALSE;
        if (disabled("AL"))                     /* Disable alias mod*/
			mod_alias = FALSE;
        if (disabled("SL"))                     /* Disable security level mod*/
			mod_level = FALSE;
        if (disabled("EL"))                     /* Disable expiration level */
            mod_explevel = FALSE;
        if (disabled("PW"))                     /* Disable password mod*/
			mod_password = FALSE;
        if (disabled("ST"))                     /* Disable state mod*/
			mod_state = FALSE;
        if (disabled("CT"))                     /* Disable city mod*/
			mod_city = FALSE;
        if (disabled("CM"))                     /* Disable comment mod*/
			mod_comment = FALSE;
        if (disabled("AD"))                     /* Disable address mod*/
			mod_address = FALSE;
        if (disabled("PH"))                     /* Disable phone mod*/
			mod_phone = FALSE;
        if (disabled("TB"))                     /* Disable time bank mod*/
			mod_timebank = FALSE;
        if (disabled("FL"))         /* Disable flags mod*/
			mod_flags = FALSE;
        if (disabled("ED"))         /* Disable exp date*/
			mod_expdate = FALSE;
        if (disabled("DL"))         /* Disable delete user*/
            mod_deluser = FALSE;
	}

	cur_user_num = 0;
	ReadUser(rec,cur_user_num);

    menu();                                     /* Acutal command entry */

	free(recs);
	free(temp_recs);
    }
    else {
    printf("\nSorry, The Ethereal User Editor requires ANSI or AVATAR.\n\n");
	press_enter();
    }
}
