{$A-,B-,D+,E-,F+,G-,I-,L+,N-,O+,R-,S-,V-,X+}
{ --------------------------------------------------------------------------- }
{ CPUTYPE.PAS  CPU type detection routines ( Intel & compatible family only ) }
{                                                                             }
{ Copyright(c) 1992-95 by B-coolWare.  Written by Bobby Z.                    }
{ --------------------------------------------------------------------------- }
{ files needed to build project:

  HEADER.ASH
  CPU_HL.ASM
  CPUSPEED.ASM
  P5INFO.ASM								      }

unit CPUType;

interface

const  i88     =  $0000;	{ Intel 8088 }
       i86     =  $0001;	{ Intel 8086 }
       V20     =  $0002;	{ NEC V20 }
       V30     =  $0003;	{ NEC V30 }
       i188    =  $0004;	{ Intel 80188 }
       i186    =  $0005;	{ Intel 80186 }
       i286    =  $0006;	{ Intel 80286 }
       i386sxr =  $0007;	{ Intel 80386sx real mode }
       i386sxv =  $0107;	{ Intel 80386sx V86 mode }
       i386dxr =  $0008;	{ Intel 80386dx real mode }
       i386dxv =  $0108;	{ Intel 80386dx V86 mode }
       i386slr =  $0009;        { IBM 80386SL real mode }
       i386slv =  $0109;        { IBM 80386SL V86 mode }
       i486sxr =  $000A;	{ Intel i486sx real mode }
       i486sxv =  $010A;	{ Intel i486sx V86 mode }
       i486dxr =  $000B;	{ Intel i486dx real mode }
       i486dxv =  $010B;	{ Intel i486dx V86 mode }
       c486slcr=  $000C;	{ Cyrix 486slc real mode }
       c486slcv=  $010C;	{ Cyrix 486slc V86 mode }
       c486r   =  $000D;	{ Cyrix 486sx/dx/dlc real mode }
       c486v   =  $010D;	{ Cyrix 486sx/dx/dlc V86 mode }
       i586r   =  $000E;	{ Intel Pentium real mode }
       i586v   =  $010E;	{ Intel Pentium V86 mode }
       cM1r    =  $000F;	{ Cyrix M1 (586) in real mode }
       cM1v    =  $010F;	{ Cyrix M1 (586) in V86 mode }
       iP24Dr  =  $0010;	{ Intel P24D in real mode }
       iP24Dv  =  $0110;	{ Intel P24D in V86 mode }

       { these CPUs reported only if tested as Intel 386 and CPU clock > 33MHz
	 because Intel does not produce such chips }
       umcU5sxr=  $0013;
       umcU5sxv=  $0113;
       umcU5dxr=  $0014;
       umcU5dxv=  $0114;

function CPU_Type : Word; far;

function CPU_TypeStr : String;

function CoPro_TypeStr : String;

function CPUSpeed : Real;

function intCPUSpeed : Integer;

function isSMMAble : Boolean; far;

function checkEmu : Boolean; far;

{ function checkAMD : Boolean; far; }

const
	_CPU  : Byte = 0;
      FPUType : Byte = $FF;

implementation

const 
      CPUFix  : LongInt = 0;
      Shift   : Word    = 2;

      CyrStr  : String[6] = 'Cyrix ';
      IntelStr: String[6] = 'Intel ';
      WeitStr : String[11]= 'Weitek 1167';
      IITStr  : String[4] = 'IIT ';
      andStr  : String[5] = ' and ';

      umcU5s  = $13;
      umcU5d  = $14;

function CPU_Type; external;

function checkEmu; external;

{ function checkAMD; external; }
{$IFDEF DPMI}
{$L CPU_TP.OBP}
{$ELSE}
{$L CPU_TP}
{$ENDIF}

function Speed(CPUId : Byte) : Word; external;
{$IFDEF DPMI}
{$L SPEED_TP.OBP}
{$ELSE}
{$L SPEED_TP}
{$ENDIF}

function CheckP5 : Word; far; external;

function GetP5Vendor : String; far; external;

function GetP5Features : Word; far; external;
{$L P5INFO}

function isSMMAble : Boolean; external;
{$L SMM}

function Vendor( CPU : Byte ) : String;
 begin
  case CPU of
   $0C,$0D,
   $0F     : Vendor := CyrStr;
   $02,$03 : Vendor := 'NEC ';
   $09     : Vendor := 'IBM ';
   $13,$14 : Vendor := 'UMC ';
  else
   Vendor := IntelStr;
  end;
  if (CPU in [7,8]) then
   if intCPUSpeed > 35 then
    Vendor := 'AMD Am'
   else
    Vendor := 'Intel 80';
 end;

procedure checkUMC;
 begin
  if _CPU >= i486sxr then
   if CheckP5 = $423 then
    if Pos('UMC',GetP5Vendor) <> 0 then
     if (GetP5Features and 1) = 1 then
      _CPU := umcU5d
     else
      _CPU := umcU5s;
 end;

const
	Models : array[0..15] of String[13] = (
	         'DX',
		 'DX',
		 'SX',
		 'DX2/Overdrive',
		 'SL',
		 'SX2',
		 '',
		 '',
		 'DX4',
		 '',
		 '',
		 '',
		 '',
		 '',
		 '',
		 '');

function CPU_TypeStr;
 var CPU : Word;
begin
 CPU := CPU_Type;
 _CPU := CPU;
 checkUMC;
 if (_CPU = $0A) and (CPU shr 12 <> 0) then
  begin
   CPU_TypeStr := 'Intel i486'+Models[CPU shr 12];
   exit;
  end;
 case CPU of
  i88      : CPU_TypeStr := Vendor(CPU)+'8088';
  i86      : CPU_TypeStr := Vendor(CPU)+'8086';
  i188     : CPU_TypeStr := Vendor(CPU)+'80188';
  i186     : CPU_TypeStr := Vendor(CPU)+'80186';
  v20      : CPU_TypeStr := Vendor(CPU)+'V20';
  v30      : CPU_TypeStr := Vendor(CPU)+'V30';
  i286     : CPU_TypeStr := Vendor(CPU)+'80286';
  i386sxr,
  i386sxv  : CPU_TypeStr := Vendor(CPU)+'386SX';
  i386slr,
  i386slv  : CPU_TypeStr := Vendor(CPU)+'80386SL';
  i386dxr,
  i386dxv  : CPU_TypeStr := Vendor(CPU)+'386DX';
  i486sxr,
  i486sxv  : CPU_TypeStr := Vendor(CPU)+'i486SX';
  i486dxr,
  i486dxv  : CPU_TypeStr := Vendor(CPU)+'i486DX';
  c486slcr,
  c486slcv : CPU_TypeStr := Vendor(CPU)+'486SLC';
  c486r,
  c486v    : CPU_TypeStr := Vendor(CPU)+'486';
  i586r,
  i586v    : CPU_TypeStr := Vendor(CPU)+'Pentium';
  cM1r,
  cM1v	   : CPU_TypeStr := Vendor(CPU)+'M1 (586)';
  umcU5sxr,
  umcU5sxv : CPU_TypeStr := Vendor(CPU)+'U5-S';
  umcU5dxr,
  umcU5dxv : CPU_TypeStr := Vendor(CPU)+'U5-D';
  iP24Dr,
  iP24Dv   : CPU_TypeStr := Vendor(CPU)+'P24D (Pentium Overdrive)';
 end;
end;

function CoPro_TypeStr;
 var C : Word;
     S : String;
 begin
  C := CPU_Type;
  case FPUType of
   0,1     : S := 'Unknown';
   2       : S := 'None';
   3       : S := WeitStr;
   4       : S := IntelStr+'8087';
   5       : S := IntelStr+'8087'+AndStr+WeitStr;
   6       : S := IntelStr+'i487sx';
   7       : S := IntelStr+'i487sx'+AndStr+WeitStr;
   8       : S := IntelStr+'80287';
   9       : S := IntelStr+'80287'+AndStr+WeitStr;
   $A      : S := CyrStr+'2C87';
   $B      : S := CyrStr+'2C87'+AndStr+WeitStr;
   $C      : S := IntelStr+'80387';
   $D      : S := IntelStr+'80387'+AndStr+WeitStr;
   $E      : S := CyrStr+'3C87';
   $F      : S := CyrStr+'3C87'+AndStr+WeitStr;
   $10     : S := 'Internal';
   $11     : S := 'Internal'+AndStr+WeitStr;
   $12     : S := CyrStr+'4C87';
   $13     : S := CyrStr+'4C87'+AndStr+WeitStr;
   $14     : S := IntelStr+'80287XL';
   $15     : S := IntelStr+'80287XL'+AndStr+WeitStr;
   $16	   : S := IITStr+'2C87';
   $17     : S := IITStr+'2C87'+AndStr+WeitStr;
   $18	   : S := IITStr+'3C87';
   $19     : S := IITStr+'3C87'+AndStr+WeitStr;
  else
   S := 'Unknown';
  end;
  if (C >= i286) and checkEmu then
   S := S+', Emulated';
  CoPro_TypeStr := S;
 end;

function CPUSpeed;
 begin
  CPUSpeed := ((LongInt(Shift)*CPUFix)/Speed(_CPU)+5)/10;
 end;

function intCPUSpeed;
 begin
  intCPUSpeed := ((LongInt(Shift)*CPUFix) div Speed(_CPU) + 5) div 10;
 end;

end.
