(*
               INTERNATIONAL DATE, TIME AND CURRENCY UNIT
                               FROM SWAG,
                              UNATTRIBUTED
*)

UNIT country;

INTERFACE

TYPE
  Str4 = STRING [4];
  
FUNCTION countryCode      : BYTE;
FUNCTION currencySymbol   : Str4;
FUNCTION dateFormat       : WORD;
FUNCTION dateSeparator    : CHAR;
FUNCTION DecimalSeparator : CHAR;
FUNCTION timeSeparator    : CHAR;


IMPLEMENTATION
USES
  DOS;

TYPE
  countryInfoRecord = RECORD
                        dateFormat     : WORD;
                        currency       : ARRAY [1..5] OF CHAR;
                        thouSep,
                        DecSep,
                        dateSep,
                        timeSep        : ARRAY [1..2] OF CHAR;
                        currencyFormat,
                        significantDec,
                        timeFormat     : BYTE;
                        CaseMapAddress : LONGINT;
                        dataListSep    : ARRAY [1..2] OF CHAR;
                        reserved       : ARRAY [1..5] OF WORD
                      END;
  
VAR
  countryRecord : countryInfoRecord;
  reg           : REGISTERS;
  
  
PROCEDURE getCountryInfo; { generic Dos call used by all Functions }

BEGIN
  
  reg. AH := $38;
  reg. AL := 0;
  reg. DS := Seg (countryRecord);
  reg. DX := Ofs (countryRecord);
  MsDos (reg)
  
END; { getCountryInfo }


FUNCTION countryCode : BYTE; { returns country code as set in Config.Sys }

BEGIN
  
  countryCode := reg. AL
  
END; { countryCode }

FUNCTION currencySymbol : Str4; { returns currency symbol }
VAR
  temp : Str4;
  i    : BYTE;

BEGIN

  WITH countryRecord DO
  BEGIN
    temp := '';
    i := 0;
    REPEAT
      Inc (i);
      IF currency [i] <> #0 THEN temp := temp + currency
    UNTIL (i = 5) OR (currency [i] = #0)
  END;
  currencySymbol := temp

END; { currencySymbol }


FUNCTION dateFormat : WORD;
{ 0 : USA    standard mm/dd/yy }
{ 1 : Europe standard dd-mm-yy }
{ 2 : Japan  standard yy/mm/dd }
BEGIN

  dateFormat := countryRecord. dateFormat

END; { dateFormat }


FUNCTION dateSeparator : CHAR; { date separator Character }

BEGIN

  dateSeparator := countryRecord. dateSep [1]

END; { dateSeparator }


FUNCTION DecimalSeparator : CHAR; { Decimal separator Character }

BEGIN
  
  DecimalSeparator := countryRecord. DecSep [1]
  
END; { DecimalSeparator }


FUNCTION timeSeparator : CHAR; { time separator Character }

BEGIN
  
  timeSeparator := countryRecord. timeSep [1]
  
END; { timeSeparator }

BEGIN
  
  getCountryInfo
  
END. { Unit country }

