{$I-} {$S-} (* Check IO with IOResult; disable stack checking *)
PROGRAM SetFileDate_Time;
USES DOS, COUNTRY;
{------------------------------------------------------------------------------

                                REVISION HISTORY

v1.00  : 1993/07/14.  First public release (as REDATE!).  DDA
v1.10  : 1993/09/07.  Added support for single field specification,
                            suggestion and assistance from Don Dougherty.  DDA
                      Added support for 20th century.
                        (In DOS, SET century=20 for 20th century dates.)  DDA
v1.10a : 1993/09/09.  Now specifying seconds is optional, default is :00  DDA
v1.11  : 1993/09/13.  Added "/p" - prompt for date, time doesn't change.  DDA
v1.15  : 1993/09/28.  Increased date & time specification flexibility.  DDA
v1.20  : 1993/10/20.  Now can stamp files not in current directory.  DDA
v1.21  : 1994/02/17.  Overlooked portion of code in making prior enhancement,
                      now fixed.  NO PUBLIC RELEASE.  DDA
v1.22  : 1994/05/22.  New name (DT), fully tested, & (hopefully) debugged. DDA
v1.23  : 1994/05/23.  Minor documentation corrections.  NO PUBLIC RELEASE. DDA
v1.24  : 1994/08/09.  Optimized source code, plus minor fixes.  DDA
v2.00  : 1995/05/05.  Added international date support.  DDA
                      Eliminated need for DOS env. var. for 20th century.  DDA
                      Eliminated need to pad date or time values with '0'. DDA
                      Added recognition of 4 digit years (e.g. '2024').  DDA

------------------------------------------------------------------------------}

VAR
  WorkingDateTime : LONGINT;
  {a global var containing the date *and* time to be stamped}
  
PROCEDURE showhelp (errornum : BYTE);
CONST
  progdesc = 'DT v2.00 - Free DOS utility: file date and time stamper.';
  author   = 'May 5, 1995. Copyright (c) 1995 by David Daniel Anderson - Reign Ware.';
  
  usage   = 'Usage: DT file(s) [<new date>] [<new time>]';
  usage2  = '  or : DT file(s) /p  (prompt for new date, file time will not be changed)';
  note    = 'Enter your dates in this format: ';
  
VAR
  message : STRING [60];
  
BEGIN
  WriteLn (progdesc);
  WriteLn (author);    WriteLn;
  WriteLn (usage);
  WriteLn (usage2);    WriteLn;
  Write (note);
  CASE dateFormat OF
    1 : WriteLn ('dd-mm-yy');
    2 : WriteLn ('yy/mm/dd');
    ELSE WriteLn ('mm/dd/yy');
  END;
  IF errornum > 0 THEN BEGIN
    CASE errornum OF
      1 : message := 'No files matching specification found.';
      2 : message := 'Too many parameters on the command line.';
      3 : message := 'Non-numeric value found in a date or time string.';
      ELSE  message := 'Unanticipated error of unknown type.';
    END;
    WriteLn;
    WriteLn (#7, 'ERROR: (#', errornum, ') - ', message);
  END;
  Halt (errornum);
END;

PROCEDURE GetTokens (TokenStr : STRING; VAR Token1, Token2, Token3 : STRING);
BEGIN
  Token1 := '0';
  Token2 := '0';
  Token3 := '0';
  
  { * Get first token * }
  WHILE (Length (TokenStr) > 0) AND (TokenStr [1] IN ['0'..'9'] ) DO BEGIN
    Token1 := Token1 + TokenStr [1];
    Delete (TokenStr, 1, 1);
  END;
  
  { * Delete first delimiter * }
  WHILE (Length (TokenStr) > 0) AND (NOT (TokenStr [1] IN ['0'..'9'] ) ) DO
    Delete (TokenStr, 1, 1);
  
  { * Get second token * }
  WHILE (Length (TokenStr) > 0) AND (TokenStr [1] IN ['0'..'9'] ) DO BEGIN
    Token2 := Token2 + TokenStr [1];
    Delete (TokenStr, 1, 1);
  END;
  
  { * Delete second delimiter * }
  WHILE (Length (TokenStr) > 0) AND (NOT (TokenStr [1] IN ['0'..'9'] ) ) DO
    Delete (TokenStr, 1, 1);
  
  { * Get third token * }
  WHILE (Length (TokenStr) > 0) AND (TokenStr [1] IN ['0'..'9'] ) DO BEGIN
    Token3 := Token3 + TokenStr [1];
    Delete (TokenStr, 1, 1);
  END;
END;

PROCEDURE parsedate (DTstr : STRING);
VAR
  date_time : DATETIME;
  Token1, Token2, Token3,
  MStr, DStr, YStr : STRING;
  
  v1, v2, v3  : INTEGER;
  century   : BYTE;
  
BEGIN
  GetTokens (DTStr, Token1, Token2, Token3);
  
  { 0 : USA    standard mm/dd/yy }
  { 1 : Europe standard dd-mm-yy }
  { 2 : Japan  standard yy/mm/dd }
  
  CASE dateFormat OF
    1 :
       BEGIN
         DStr := Token1;
         MStr := Token2;
         YStr := Token3;
       END;
    2 :
       BEGIN
         YStr := Token1;
         MStr := Token2;
         DStr := Token3;
       END;
    ELSE
       BEGIN
         MStr := Token1;
         DStr := Token2;
         YStr := Token3;
       END;
  END;
  
  UnpackTime (WorkingDateTime, date_time);
  WITH date_time DO BEGIN
    
    Val (MStr, Month, v1);
    Val (DStr, Day, v2);
    Val (YStr, Year, v3);
    
    IF ( (v1 + v2 + v3) <> 0) THEN showhelp (3);
    
    IF (Year < 80) OR (Year >= 2000) THEN
      century := 20
    ELSE
      century := 19;
    
    Year := century * 100 + (Year MOD 100);
    
  END;
  PackTime (date_time, WorkingDateTime);
END;

PROCEDURE parsetime (DTstr : STRING);
VAR
  date_time : DATETIME;
  HStr, MStr, SStr : STRING;
  
  v1, v2, v3  : INTEGER;
  
BEGIN
  GetTokens (DTStr, HStr, MStr, SStr);
  
  UnpackTime (WorkingDateTime, date_time);
  WITH date_time DO BEGIN
    Val (HStr, Hour, v1);
    Val (MStr, Min, v2);
    Val (SStr, Sec, v3);
    IF ( (v1 + v2 + v3) <> 0) THEN showhelp (3);
  END;
  PackTime (date_time, WorkingDateTime);
END;

PROCEDURE get_current_date_time;
VAR
  date_time : DATETIME;
  Y, mo, D, w,
  h, mi, s, u  : WORD;
  
BEGIN
  GetDate (Y, mo, D, w);
  GetTime (h, mi, s, u);
  WITH date_time DO BEGIN
    Year := Y;  Month := mo;  Day := D;
    Hour := h;  Min := mi;  Sec := s;
  END;
  PackTime (date_time, WorkingDateTime);
END;

FUNCTION get_fdate (fname : STRING) : STRING;
VAR
  date_time : DATETIME;
  Token1, Token2, Token3,
  HStr, MStr, SStr : STRING [4];
  
  afile : FILE;
  fdate : LONGINT;
  
BEGIN
  Assign (afile, fname);
  Reset (afile);
  IF (IOResult = 0) THEN BEGIN
    GetFTime (afile, fdate);
    Close (afile);
    
    UnpackTime (fdate, date_time);
    WITH date_time DO BEGIN
      
      { 0 : USA    standard mm/dd/yy }
      { 1 : Europe standard dd-mm-yy }
      { 2 : Japan  standard yy/mm/dd }
      
      CASE dateFormat OF
        1 :
           BEGIN
             Str (Day, Token1);
             Str (Month, Token2);
             Str (Year, Token3);
           END;
        2 :
           BEGIN
             Str (Year, Token1);
             Str (Month, Token2);
             Str (Day, Token3);
           END;
        ELSE
           BEGIN
             Str (Month, Token1);
             Str (Day, Token2);
             Str (Year, Token3);
           END;
      END;
      
      get_fdate := Token1 + '/' + Token2 + '/' + Token3;
    END;
  END
  ELSE
    get_fdate := '0';
END;

FUNCTION get_ftime (fname : STRING) : STRING;
VAR
  date_time : DATETIME;
  HStr, MStr, SStr : STRING [4];
  
  afile : FILE;
  ftime : LONGINT;
  
BEGIN
  Assign (afile, fname);
  Reset (afile);
  IF (IOResult = 0) THEN BEGIN
    GetFTime (afile, ftime);
    Close (afile);
    UnpackTime (ftime, date_time);
    WITH date_time DO BEGIN
      Str (Hour, HStr);
      Str (Min, MStr);
      Str (Sec, SStr);
      get_ftime := HStr + ':' + MStr + ':' + SStr;
    END;
  END
  ELSE
    get_ftime := '0';
END;

PROCEDURE stampfile (fname : STRING);
VAR
  afile : FILE;
BEGIN
  Assign (afile, fname);
  Reset (afile);
  IF (IOResult = 0) THEN BEGIN
    SetFTime (afile, WorkingDateTime);
    Close (afile);
    Write ('.');
  END;
END;

PROCEDURE todaysdate (fd : STRING; VAR DI : SEARCHREC);
BEGIN
  get_current_date_time;
  WHILE (DosError = 0) DO BEGIN
    stampfile (fd + DI. Name);
    FindNext (DI);
  END;
END;

PROCEDURE justdate (fd : STRING; VAR DI : SEARCHREC; datestr : STRING);
BEGIN
  parsedate (datestr);
  WHILE (DosError = 0) DO BEGIN
    parsetime (get_ftime (fd + DI. Name) );
    stampfile (fd + DI. Name);
    FindNext (DI);
  END;
END;

PROCEDURE justtime (fd : STRING; VAR DI : SEARCHREC; timestr : STRING);
BEGIN
  parsetime (timestr);
  WHILE (DosError = 0) DO BEGIN
    parsedate (get_fdate (fd + DI. Name) );
    stampfile (fd + DI. Name);
    FindNext (DI);
  END;
END;

PROCEDURE newdate (fd : STRING; VAR DI : SEARCHREC; datestr, timestr : STRING);
BEGIN
  parsedate (datestr);
  parsetime (timestr);
  WHILE (DosError = 0) DO BEGIN
    stampfile (fd + DI. Name);
    FindNext (DI);
  END;
END;

VAR
  ps1, ps2, ps3 : PATHStr;
  rdir    : DIRSTR;
  rname   : NAMESTR;
  rext    : EXTSTR;
  dirinfo : SEARCHREC;
  
BEGIN
  IF ParamCount = 0 THEN
    showhelp (0);
  FSplit (FExpand (ParamStr (1) ), rdir, rname, rext);
  ps1 := rdir + rname+ rext;
  FindFirst (ps1, Archive, dirinfo);
  IF (DosError <> 0) THEN
    showhelp (1);
  Write ('Working ');
  
  IF ParamCount >= 2 THEN
    ps2 := ParamStr (2);
  IF ParamCount >= 3 THEN
    ps3 := ParamStr (3);
  
  CASE (ParamCount) OF
    1 : todaysdate (rdir, dirinfo);
    2 :
       BEGIN
         IF (ps2 [2] IN ['p', 'P'] ) THEN BEGIN
           WriteLn;
           Write ('Enter a date in the format ');
           CASE dateFormat OF
             1 : Write ('dd-mm-yy > ');
             2 : Write ('yy/mm/dd > ');
             ELSE Write ('mm/dd/yy > ');
           END;
           ReadLn (ps2);
           justdate (rdir, dirinfo, ps2);
         END
         ELSE BEGIN
           IF (Pos (timeSeparator, ps2) > 0)
           THEN justtime (rdir, dirinfo, ps2)
           ELSE justdate (rdir, dirinfo, ps2);
         END;
       END;
    
    3 : newdate (rdir, dirinfo, ps2, ps3);
    
    ELSE
      showhelp (2);
  END;                                 { case }
  
  WriteLn (' done!');
END.
