/*--------------------------------------------------------------------
   This has similar mouse functions for DOS and OS/2
*/
#ifdef __IBMC__
/*--------------------------------------------------------------------
   This is the code for OS/2
*/
#define INCL_DOS
#define INCL_SUB
#include <os2.h>

HKBD hkbd = NULL;
KBDKEYINFO kinfo;
HMOU mousehandle;

int getch(void) {
  int x;
  if (!hkbd) KbdOpen(&hkbd);
  KbdCharIn(&kinfo,1,hkbd);
  return kinfo.chChar;
}

int init_mouse(void) {
  ULONG rc,act;
  rc = MouOpen("MOUSE$",&mousehandle);
  printf("\nmouopen rc %d\n",rc);
  if (rc) return rc;                      
  return -1;          /* -1 = success */
}
int show_mouse(void) { return 0; }
int hide_mouse(void) { return 0; }
int get_mouse(int *x,int *y) {
  USHORT event,wait=1;
  MOUEVENTINFO mloc;
  MouReadEventQue(&mloc,&wait,mousehandle);
  *x = mloc.col * 8;
  *y = mloc.row * 8;
  event = 0;
  if (mloc.fs & 6) event |= 1;
  if (mloc.fs & 24) event |= 2;
  return event;
}

#else
/*--------------------------------------------------------------------
   this is the code for DOS (Turbo C++)
*/
#define MOUSEINT 0x33
#include <dos.h>

/*
   To do various functions (input) [output] set 'a' to
    0 - test if loaded [reg.ax = $ffff]
    1 - show cursor
    2 - hide cursor
    3 - get position [b buttons, c x, d y]
    4 - set position (c x,d y)
    5 - press button   (b buttons, c x, d y) [b count]
    6 - release button (b buttons, c x, d y) [b count]
    7 - set x range  (c min, d max)
    8 - set y range  (c min, d max)
    10- text cursor  (b 0=soft 1=hard, c ?, d ?)
    15- mickeys      (c xscale, d yscale?)
*/
int mouse(int a,int *b,int *c,int *d)
{
  static union REGS regs;
  regs.x.ax = a;
  regs.x.bx = *b;
  regs.x.cx = *c;
  regs.x.dx = *d;
  int86(MOUSEINT,&regs,&regs);
  *b = regs.x.bx;
  *c = regs.x.cx;
  *d = regs.x.dx;
  return regs.x.ax;
}

int init_mouse(void) {
  int x=0;
  long *p;
  /*  this is some code to try to avoid hangs when int 33 is not
      loaded with anything. */
  p = (long*)(MOUSEINT * 4);
  if (*p==0) return 1;
  return mouse(0,&x,&x,&x);
}

int show_mouse(void) {
  int b=0; return mouse(1,&b,&b,&b);
}

int hide_mouse(void) {
  int b=0; return mouse(2,&b,&b,&b);
}

int get_mouse(int *x,int *y) {
  int b=0; mouse(3,&b,x,y); return b;
}

int set_mouse(int x,int y) {
  int b=0; return mouse(4,&b,&x,&y);
}
#endif
