@echo off
cls
echo ======== Introductory tutorial to Q calculator Ver 1.77 =========
echo.
echo This tutorial batch file will run Q with various examples.  
echo During the run of the tutor.bat,  files "A" and "C" are generated.
echo Also, the tutorial uses a data file "B.dat" supplied with it. 
echo Q is using a small file RSLT.DAT in which the last result is stored.
echo Press any key when prompt to do so and the tutorial will guide you
echo through the basic steps. To EXIT the tutorial press CTRL-break (^c).
echo.
echo Let's start with the simplest calculation. To calculate 2+3 enter: q 2+3
echo Note that every line starts with q which is the program's name.
pause
echo q 2+3
q 2+3
echo Note that each result is displayed in two formats for your convenience.
echo The last result of a calculation or solution of an equation is stored in
echo the file RSLT.DAT.  To use it include the keyword LAST in your 
echo expression.  For example last+2^last will result in 37 because LAST 
echo was 5.
pause
echo q last+2^last
q last+2^last
echo To compute -pi(3+4)5 where pi is the constant 3.14... enter: q -pi(3+4)5
pause
echo q -pi(3+4)5
q -pi(3+4)5
echo To obtain a table of x^3 with x from 0 to 100 write: q x^3 
echo To redefine this range or change the number of points use RNG().
echo e.g. q rng(20)x^3 will run through 20 point for x= 0 to 100,
echo q rng(-5,5)x^3 will make x run through 101 points from -5 to 5,
echo and q rng(-5,5,200)x^3 will make x run through 200 points from -5 to 5.
echo Using "| more" will show one page at a time.
pause
@echo on
q x^3 | more
@echo off
echo Substitution is simple. For example Jack=4; Jim=6; Jack+Jim; Jack-Jim
echo will result in ...
pause
echo q Jack=4; Jim=6;  Jack+Jim;  Jack-Jim
q Jack=4;  Jim=6;  Jack+Jim;  Jack-Jim
echo To solve an equation with x as unknown just write it. 
echo Sometimes you should use rng() to redefine the range of x in which to 
echo look for a solution. For example  rng(-10,10)2x+x^3=1/3
echo If there is more than one solution - the program will always display 
echo the smallest solution in the range. 
echo If you don't use rng, the range is 0 to 100.
pause
echo q rng(-10,10)2x+x^3=1/3
q rng(-10,10)2x+x^3=1/3
echo Let's examine the expression: q rng(0,360,361)x;sin(dr(x));cos(dr(x))
echo here sine and cosine functions are calculated for each degree (0 to 360).
echo x is in degrees from 0 to 360, defined by rng().
echo Note that dr() transfers x from degrees to radians. We have to use dr() 
echo because the sine and cosine accept only radians.
echo A semicolon ; is used to separate outputs. To write the resulting
echo table to a file "A" add the ">A" as in the following 
pause
@echo on
q rng(0,360,361)x;sin(dr(x));cos(dr(x)) > a
@echo off
echo DONE!
echo You may use \DOS\EDIT to see the file "a". 
echo Reminder: press ALT-f, x to exit when you are done.
echo The 1st column are the degrees, in the 2nd the sine and in 
echo the 3rd cosine. 
pause
echo \dos\edit a.
\dos\edit a.
echo.
echo Q provides for several methods to display the contents of a file
echo as a graph.  These are g~f, y~f and ~f where f is the filename
echo and ~ means to read a file. The file format should be compatible with
echo an output table, that is, two first lines are assumed to be headers
echo and are ignored and the data is in columns.
echo To see the sine column in file "a" as a function of the x column 
echo type: q g~a
echo This will display the second column as a function of the first.
echo Note: when done watching a graph press any key to continue.
pause
q g~a
echo To display the 3rd column as a function of the 2nd skip a column 
echo using one / and enter q g~/a. A circle (actually an ellipse) will result.
pause
q g~/a
echo to see just the cosine (column 3) in file "a" enter q y~//a, 
echo this will display the 3rd column as a function of the index.
pause
q y~//a
echo To see all columns as a function of the first column enter q ~a.
pause
q ~a
echo q 2x*y~/a will of course result in a table where y is obtained from 
echo column 2, x runs from 0 to 100.
pause
echo q 2x*y~/a
q 2x*y~/a
echo To display an output table without storing it first in a file
echo use grf(). grf() will display up to 101 points if rng() is not used..  
echo For example, to see the log of x, x running from 0.00001 to 1 through 
echo 200 points, enter q rng(0.0001,1,200)grf(log(x)):
pause
q rng(0.00001,1,200)grf(log(x))
echo To do statistics with data from a file use s~filespec. As an example
echo we prepared the file B.dat which contains school grades. 
echo Go ahead to see the contents of B.dat...
pause
type b.dat
echo The first 2 lines are always ignored by the program and may be used
echo as headers. To do statistics on the 2nd column use: q s~/b.dat
pause
echo s~/b.dat
q s~/b.dat
echo To see the high correlation between column 3 (gym) and column 4 (history)
echo we use q s~//b.dat
pause
echo q s~//b.dat
q s~//b.dat
echo To obtain a 4 slot distribution histogram of column 3 enter 
echo hstgrm(4)~//b.dat
echo If the number of points is higher then 100 use rng(points)hstgrm(slots)~ 
pause
echo q hstgrm(4)~//b.dat
q hstgrm(4)~//b.dat
echo r is a random variable in the range 0 to 1. We can use r to simulate a
echo noisy sine wave. q grf(sin(x/10)+0.3(0.5-r)) will do. 
pause
q grf(sin(x/10)+0.3(0.5-r))
echo Q enables to estimate uncertainty propagation using "Monte-Carlo" methods.
echo As an example, Suppose we have the expression a+b^2, with a=3(0.2) and
echo b=4(0.1), where the values in parentheses are the uncertainties.
echo We wish to know the uncertainty of a+b^2. The following expression
echo a=3+0.2(0.5-r)sqrt(12);b=4+0.1(0.5-r)sqrt(12);rng(1000)a+b^2
echo will generate output with the right distribution because (0.5-r)sqrt(12)
echo generates sigma=1 distribution. The final sigma is obtained using s~.
echo rng(1000) will generate 1000 random points ensuring 3% error.
echo Let's do it and send the output to file a.
pause
@echo on
q a=3+0.2(0.5-r)sqrt(12);b=4+0.1(0.5-r)sqrt(12);rng(1000)a+b^2>a
q s~a
@echo off
echo Compare the sample standard deviation to the theoretical value 0.8246...
echo.
echo Let's play more with random numbers.  The expression 2(0.5-r)
echo will generate a table of random numbers +/- 1 around zero. If we sum the 
echo numbers we get a "random walk".  Use Ysum to generate a summation of
echo a file column. The following two steps store 401 random numbers in
echo the file "a" and then a graph of the "random walk" is displayed.
pause
@echo on
q rng(401)2(0.5-r)>a 
@echo off
echo DONE!
pause
q rng(401)grf(ysum)~a
echo Q provides for change of base (2-36) and bitwise operations.
echo To read a number in a base n add [n] in from of that number.
echo To display a result in a specific base n, add [n] at the end of the 
echo expression. For example, [2]10001001000100100110101[16] will convert
echo from binary to hex bases.
pause 
echo q [2]10001001000100100110101[16]
q [2]10001001000100100110101[16]
echo to read data in a different base n from a file add [n] in front of the
echo file-name.
echo Let's prepare a binary file and read it later.
echo The following expression i;2x^3[2] will write the indexed table
echo into file C provided we use the greater than sign in front of "C".
pause 
@echo on
q i;2x^3[2] > c
@echo off
echo DONE!
echo Let's call \DOS\EDIT to see how it looks like.
pause
echo \dos\edit c
\dos\edit c
echo Now let's use it in a graph. grf(y)~/[2]c will read the data in the 2nd
echo column and plot. The program will read up to 32 bit numbers from a file.
pause
q grf(y)~/[2]c
echo Bitwise operators may be put into [] to prevent confusion.
echo For example [2]100100010001000 [_and] [2]100101010[2] will perform 
echo bitwise AND and display the result in binary format.
pause
echo q [2]100100010001000 [_and] [2]100101010[2]
q [2]100100010001000 [_and] [2]100101010[2]
echo You can test logical expressions. The convention is that 0 is FALSE
echo and anything else is TRUE.
echo For example: not( (2 GT 1) and ( 3 [EQ] 7 ) ) should result with 1. 
echo We used [] otherwise the E in EQ is confused with an exponent.
pause
echo not( (2 gt 1) and ( 3 [eq] 7 ) )
q not( (2 gt 1) and ( 3 [eq] 7 ) )
echo You may use this TUTOR.BAT batch file as a model for your batch files
echo to run multi-step calculations or prepare demos.
echo To find more about the Q calculator run it and read the help screens. 
echo For example to display the cover page enter q
echo to display the help directory enter q ? and follow the instructions.
pause
echo q ?
q ?
echo.
echo This concludes our little tour.
echo Enjoy.
echo The author.
