/*****************************************************************************
   MODULE: rput.c
  PURPOSE: recio output functions
COPYRIGHT: (C) 1994-1995, William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.12
  RELEASE: January 29, 1995
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "recio.h"

extern int _risready(REC *rp, int mode);
extern int _rputc(REC *rp, int ch);

#define rcol(rp)    ((rp)->r_colno)

/****************************************************************************/
void                         /* returns nothing                             */
    rputrec(                 /* put end-of-record (newline) to stream       */
        REC *rp)             /* record pointer                              */
/****************************************************************************/
{
    if (_risready(rp, R_WRITE)) {
        _rputc(rp, '\n');
        rcol(rp)=0;
        rfldno(rp)=0;
        rrecno(rp)++;
    }
}

/****************************************************************************/
char *                       /* return pointer to string                    */
    dtoa(                    /* convert floating point number to string     */
        double d,            /* number to convert                           */
        char  *str,          /* string buffer to use                        */
        int    dig)          /* number of significant digits                */
/****************************************************************************/
{
    sprintf(str, "%.*G", dig, d);
    return str;
}
