{$I-}
{$B-}
{$V-}
{$M 4096,0,0}

program map2mail;

{ maps a drive letter letter to a mail directory }

uses  dos,crt,novell,netware;

var
  retcode                       : integer;
  drive                         : string;
  server, account, password     : netstr;
  hexid                         : string;
  can_try_to_reattach           : boolean;


procedure attach_to_server;

begin
  if login(server,account,1,password)=0 then
    begin
      writeln('Attached to server '+server+' as '+account+'.');
      can_try_to_reattach := false;
    end
  else
    begin
      writeln('Can''t attach to server '+server+' as '+account+'.');
      halt(2);
    end;
end;


procedure set_my_server;

begin
  if setpreferredserver(getservernumber(server))=0 then
    if can_try_to_reattach then
      begin
        attach_to_server;
        set_my_server;
      end
    else
      begin
        writeln('Can''t set preferred server to '+server+'.');
        halt(3);
      end;
end;


procedure get_my_account_name;

begin
  if getconnectionname(account)<>0 then
    begin
      writeln('Can''t get my account name on '+server+'.');
      halt(4);
    end;
end;


procedure get_the_hexid;

begin
  gethexid(account,hexid,retcode);
  if retcode<>0 then
    if can_try_to_reattach then
      begin
        attach_to_server;
        get_the_hexid;
      end
    else
      begin
        writeln('Can''t get object ID for '+account+' on server '
          +server+'.');
        halt(5);
      end;
end;


procedure map_the_drive;

begin
  if mapfakeroot(drive[1],'SYS:MAIL\'+hexid)=0 then
    writeln(drive[1]+': mapped as root to SYS:MAIL\'+hexid+' on server '
      +server+'.')
  else
    begin
      if can_try_to_reattach then
        begin
          attach_to_server;
          map_the_drive;
        end
      else
        begin
          writeln('Can''t map '+drive[1]+': to SYS:MAIL\'+hexid+' on server '
            +server+'.');
          halt(6);
        end;
    end;
end;


{start of main program}

begin

  drive := paramstr(1);
  drive[1] := upcase(drive[1]);
  if not ((drive[1] in ['A'..'Z']) and (drive[2]=':')) then
    begin
      writeln('MAP2MAIL: maps a drive to a mail directory - 9 Feb 1995.');
      writeln('  by Peter Summers <peter@cardiology.medrmh.unimelb.edu.au>');
      writeln;
      writeln('SYNTAX:  MAP2MAIL <drive> [<server> [<account> [<password>]]].');
      halt(1);
    end;

  server := paramstr(2);
  account := paramstr(3);
  password := paramstr(4);

  can_try_to_reattach := (account<>'');

  if server <> '' then set_my_server;

  if account = '' then get_my_account_name;

  get_the_hexid;

  map_the_drive;

end.