{$M 4096,0,0}{$I-}
Program Convert_SPEED_savefiles_to_QWK;
Uses CRT, DOS;
Const MaxBytes = 61440;
Type  SRarray = Array[1..MaxBytes] of char;

Const cursorState : byte = 1;  {0..3}
      cursorData : array [0..3] of char = (#179, #47, #196, #92);
      lineNumb : longint = 0;
{===========================================================================}

procedure cursorOff; forward;
procedure cursorOn; forward;
function IntToStr(const vint: longint): string; forward;

procedure showhelp(const problem :byte);
{----
 If any *foreseen* errors arise, we are sent
  here to give a little help and exit (relatively) peacefully
----}
const
  progdesc = 'SRQ - Free DOS utility: Convert SPEED READ "save files" to pseud-QWK files.';
  author   = 'v1.03: June 4, 1995. (c) 1995 by David Daniel Anderson - Reign Ware.';
  usage    = 'Usage: SRQ <SPEED "save file(s)">  (DOS wildcards are permitted.)';
  example  = 'Example:  SRQ startrek.txt         (creates "STARTREK.SRQ")';
var
  message : string[79];
begin
  writeln;
  writeln(progdesc);
  writeln(author);    writeln;
  writeln(usage);     writeln;
  writeln(example);   writeln;
  if problem > 0 then begin
    case problem of
      1 : message := 'Command line error: no files matching specification found to process.';
      2 : message := 'A MESSAGES.DAT file already exists.  Move, REName, or DELete it.';
      3 : message := 'A .SRQ with the same name as the "save file" exists. Move, REName or DELete it.';
      4 : message := 'Invalid header portion encountered just above line number: '+IntToStr(lineNumb)+' - fix file!';
      5 : message := 'Error archiving MESSAGES.DAT - try archiving it manually.';
      6 : message := 'You cannot just specify a path, add "*.*" or "\*.*" for all files.';
      7 : message := 'Unexpected error reading or writing file(s), unable to continue.';
    else  message := 'Unknown error.';
    end;
    writeln (#7, 'Error encountered, number ',problem,':'); writeln (message);
  end;
  cursorOn;
  halt(problem)
end;

procedure cursorOff;assembler;asm
  mov ah,3; mov bh,0; int $10; or ch,$20; mov ah,1; int $10;
end;

procedure cursorOn;assembler;asm
  mov ah,3; mov bh,0; int $10; and ch,not $20; mov ah,1; int $10;
end;

function IntToStr(const vint: longint): string;
var s: string;
begin
  Str(vint, s);
  IntToStr := s;
end;

Function LeadingZero(w : Word) : String;
Var
  s : String[2];
Begin
  Str(w:0,s);
  if Length(s) = 1 then
    s := '0' + s;
  LeadingZero := s;
End;

procedure iocheck(const iores :byte);
begin
  if iores <> 0 then showhelp(7);
end;

function fileexists(const filename:pathstr):boolean;
var
  attr : word;
  f    : file;
begin
  assign (f, filename);
  getfattr (f, attr);
  if (DOSerror <> 0) OR ((attr and directory) = directory) then
    fileexists := FALSE
  else
    fileexists := TRUE;
end;

procedure updateCursor;  {code written by Sean Palmer, found in SWAG}
begin
  cursorState := succ(cursorState) and 3;
  write(cursorData[cursorState], ^H);
end;

Function RPad(bstr: string; Const len: byte): string;
Begin
  while (length(bstr) < len) do
    bstr := bstr + #32;
  RPad := bstr;
End;

FUNCTION RTrim(InStr: STRING): STRING;
BEGIN
  WHILE (LENGTH(InStr) > 0) AND (InStr[LENGTH(InStr)] in [#0,#9,#32]) DO
    DEC(InStr[0]);
  RTrim := InStr;
END;

Function StrToDoubleChar(SRconf: string): string;
Var
  i, VErr : integer;
Begin
  while SRconf[1] = #32 do
    SRconf := Copy(SRconf,2,length(SRconf)-1);
  Val(SRconf,i,VErr);
  if (VErr <> 0) then i := 0;
  SRconf := Chr(i mod 256) + Chr(i div 256);
  StrToDoubleChar := SRconf;
End;

Procedure PrepareFiles(var SRname: pathstr; var SRfile: text;
                       var DATname: string; var DATfile: file);
Const
  QmailLine : Array[1..128] of char =
          'Produced by Qmail...Copyright (c) 1995 by ReignWare.  All Rights'+
          ' Reserved       Above for Compatibility with Qmail              ';

Var SRnameQ: pathstr;

Begin
  DATname := 'MESSAGES.DAT';
  if fileexists(DATname) then showhelp(2);

  if NOT fileexists(SRname) then showhelp(1);
  Assign(SRfile,SRname);
  Reset(SRfile); iocheck(ioresult);

  SRnameQ := SRname;
  if (pos('.', SRnameQ) > 0) then
    SRnameQ := Copy(SRnameQ, 1, pos('.', SRnameQ) - 1);
  if fileexists(SRnameQ+'.srq') then showhelp(3);

  cursorOff;
  Write('Converting ', SRname, ' to MESSAGES.DAT, please wait ... ');
  SRname := SRnameQ;

  Assign(DATfile,DATname);
  Rewrite(DATfile,1); iocheck(ioresult);
  BlockWrite(DATfile, QmailLine, 128); iocheck(ioresult);
End;

Function GetSRtime(timestr: string): string;
Var
  SRtime: string[5];
  hours: byte;
  VErr: integer;
Begin
  SRtime := Copy(timestr,30,5);
  if (Copy(timestr,35,1) = 'p') and (Copy(SRtime,1,2) <> '12') then begin
     Val(Copy(SRtime,1,2), hours, VErr);
     hours := hours+12;
     SRtime := LeadingZero(hours)+Copy(SRtime,3,3);
  end;
  GetSRtime := SRtime;
End;

Function GetSRstat(Const Status: char): char;
Begin
  if (Status = 'u') then
   GetSRstat := #32       { unread, public }
  else
   GetSRstat := #42       { unread, private }
End;

Procedure Verify(Const control, variable: string; const offset: byte);
Begin
  if (Copy(control,offset,length(variable)) <> variable) then
    showhelp(4);
End;

Function ReadSRheader(var SRfile: text): string;
Const hyphens='---------------------------------------'+
              '----------------------------------------';
  SRpass = #32#32#32#32#32#32#32#32#32#32#32#32; { 12 spaces }
  SRchnk = #32#32#32#32#32#32;  { 6 spaces }
Var
  SRline: string;
  SRfrom, SRto, SRsubj: string[25];
  SRdate: string[8];  SRtime: string[5];
  SRnumb: string[7];  SRrfer: string[8];
  SRconf: string[5];  SRstat: char;
Begin
  readln(SRfile,SRline); iocheck(ioresult); inc(lineNumb);
    Verify(SRline,'Date:',   6); SRdate := Copy(SRline,12,8);
    Verify(SRline,'Time:',  24); SRtime := GetSRtime(SRline);
    Verify(SRline,'Number:',41); SRnumb := RPad(Copy(SRline,49,length(SRline)-48),7);
  readln(SRfile,SRline); iocheck(ioresult); inc(lineNumb);
    Verify(SRline,'From:',   6); SRfrom := Copy(SRline,12,25);
    Verify(SRline,'Refer:', 42); SRrfer := RPad(Copy(SRline,49,length(SRline)-48),8);
  readln(SRfile,SRline); iocheck(ioresult); inc(lineNumb);
    Verify(SRline,'To:',     8); SRto := Copy(SRline,12,25);
(*    Verify(SRline,'Recvd:', 65); SRstat := SRline[72];  *)
  readln(SRfile,SRline); iocheck(ioresult); inc(lineNumb);
    Verify(SRline,'Subject:',3); SRsubj := Copy(SRline,12,25);
    Verify(SRline,':',      47); SRconf := StrToDoubleChar(Copy(SRline,42,5));
    Verify(SRline,'Status:',64); SRstat := GetSRstat(SRline[73]);
  readln(SRfile,SRline); iocheck(ioresult); inc(lineNumb);  {discard hyphen line}
    Verify(SRline, hyphens, 1);

  ReadSRheader := (SRstat+SRnumb+SRdate+SRtime+SRto+SRfrom+SRsubj+ { 96 chars }
                   SRpass+SRrfer+SRchnk+#225+SRconf+#0#0#42);      { 32 chars }
End;

Function AddToArray(var SRmsg: SRarray;
                    Const offset: word; line: string): word;
Var
  index: word;
Begin
  if (offset > 128) then   { remove trailing whitespace }
    line := RTrim(line);
  if (length(line) > 0) then begin
    for index := (offset+1) to (offset+length(line)) do begin
      if (index <= MaxBytes) then
        SRmsg[index] := line[index-offset];
    end
  end
  else index := offset;
  if (offset >= 128) and (index < MaxBytes) then begin
    Inc(index);
    SRmsg[index] := #227;
  end;
  AddToArray := index;
End;

function FigureMSGsize(const bytes: word; var chunks: word): string;
var
  SRchnk : string[6];
Begin
  chunks := (bytes div 128);
  if ((bytes mod 128) <> 0) then inc(chunks);
  Str(chunks, SRchnk);
  SRchnk := RPad(SRchnk,6);
  FigureMSGsize := SRchnk;
End;

procedure InitCompressor(var Compressor: pathstr);
var
  epath, cpath  : pathstr;
    {epath & cpath are fully qualified pathnames of .exe & .cfg files}
  edir: dirstr; ename: namestr; eext: extstr;
  config        : text;
  configline    : string[80];
begin
  epath := (paramstr (0));
  fsplit(fexpand(epath),edir,ename,eext); { break up path into components }
  cpath := edir+ename+'.cfg';

  Compressor := 'pkzip -# -m';
  if fileexists(cpath) then
  begin
    assign (config, cpath);
    reset (config); iocheck(ioresult);
    repeat  { find vars }
      readln(config,configline);
      if (length(configline) > 11) and
        (copy(configline,1,11) = 'compressor=') then
        Compressor := Copy(configline,12,length(configline)-11);
    until eof(config); { loop back to read another line }
    close (config);
  end;
end;

function CompressDAT(const QWKfile, DATfile: string;
                     Const Compressor: pathstr): boolean;
var
  x,y : byte;
begin
  x:=WhereX;
  y:=WhereY;
  write('> ',Compressor);
  swapvectors;
     exec (getenv ('COMSPEC'),' /c '+compressor+' '+QWKfile+' '+DATfile);
     if doserror <> 0 then showhelp(5);
  swapvectors;
  GotoXY(x,y);
  ClrEOL;
  cursorOff;
  CompressDAT := fileexists(QWKfile)
end;
{===========================================================================}

Const SepLine='======================================='+
              '========================================';

Var
  SRname: pathstr;  DATname: string;
  SRfile: text;     DATfile: file;
  SRline: string;   SRmsg  : SRarray;
  index, bytes, chunks: word;
  Compressor : pathstr;

  dirinfo   : searchrec;  { contains filespec info.    }
  spath     : pathstr;    { source file path,          }
  sdir      : dirstr;     {             directory,     }
  sname     : namestr;    {             name,          }
  sext      : extstr;     {             extension.     }
  filesdone : word;

begin
  if paramcount <> 1 then
    showhelp(0)
  else
    spath := ParamStr(1);

  if spath[1] in ['/','-'] then showhelp(0);
  fsplit(fexpand(spath),sdir,sname,sext); if (sname = '')  then showhelp(6);
  findfirst(spath, archive, dirinfo);

  filesdone := 0;
  while (DOSerror = 0) do begin
     inc(filesdone);
     SRname := sdir+dirinfo.name;
     PrepareFiles(SRname, SRfile, DATname, DATfile);

     readln(SRfile,SRline); iocheck(ioresult); inc(lineNumb);
     repeat
       if (SRline = SepLine) and (NOT EOF(SRfile)) then begin
         bytes := 0;  updateCursor;
         SRline := ReadSRheader(SRfile);

         while (SRline <> SepLine) and (NOT EOF(SRfile)) do begin
           if (bytes < MaxBytes) then
             bytes := AddToArray(SRmsg, bytes, SRline);
           readln(SRfile,SRline); iocheck(ioresult); inc(lineNumb);
         end;
         if (bytes > MaxBytes) then bytes := MaxBytes;
         while (SRmsg[bytes]=#227) and (SRmsg[bytes-1]=#227) do
           dec(bytes);

         index := AddToArray(SRmsg, 116, FigureMSGsize(bytes, chunks));
         if (chunks > 1) then begin
           for index := (bytes+1) to (chunks*128) do
             SRmsg[index] := #32;
         end;

         BlockWrite(DATfile, SRmsg, chunks*128); iocheck(ioresult);
       end
       else begin
         readln(SRfile); iocheck(ioresult); inc(lineNumb); {discard invalid lines}
       end;
     until EOF(SRfile);

     Close(SRfile); iocheck(ioresult);
     Close(DATfile); iocheck(ioresult);
     writeln('done!');

     InitCompressor(Compressor);
     write('Compressing MESSAGES.DAT into ',SRname,'.srq ... ');
     if CompressDat(SRname+'.srq', DATname, Compressor) then
       writeln('done!')
     else
       showhelp(5);

     findnext(dirinfo);
  end;
  if (filesdone=0) then
    showhelp(1)
  else
    writeln('Processed ', filesdone, ' file(s).');

  cursorOn
end.
