{$X- function calls may not be discarded}
{$I-}
UNIT TXTQ;  (*** Common procedures for ROBOQ, SLMR and SRQ ***)

INTERFACE

USES DOS;

CONST
  MaxBytes = 61440;  {60k}

TYPE
  MsgArray = ARRAY [1..MaxBytes] OF CHAR;

  ConfRec = ^ConfDAT;
  ConfDAT = RECORD
              Name: STRING [15];
              Num : WORD;
              Next: ConfRec;
            END;

CONST
  author   = 'v1.10: July 12, 1995. (c) 1995 by David Daniel Anderson - Reign Ware.';
  cursorState: BYTE = 1;  {0..3}
  cursorData: ARRAY [0..3] OF CHAR = (#179, #47, #196, #92);
  lineNumb: LONGINT = 0;
  DATname = 'MESSAGES.DAT';
  CONname = 'CONTROL.DAT';

VAR
  ConfList: ConfRec;
  Conferences: WORD;
  UserName: STRING [25];
  BBSname: STRING;
  BBSID: STRING [8];
  INDEXPROG: STRING;
  StartDIR,
  TXTQ_DIR: PATHSTR;

{===========================================================================}

PROCEDURE WriteErr (problem: BYTE);
PROCEDURE cursorOff;
PROCEDURE cursorOn;
FUNCTION WhereX: BYTE;
FUNCTION WhereY: BYTE;
PROCEDURE GotoXY (X, Y: BYTE);
procedure WriteCharAtCursor(x: char);
Procedure ClrEol;
FUNCTION IntToStr (vint: LONGINT): STRING;
FUNCTION LeadingZero (w: WORD): STRING;
PROCEDURE iocheck;
FUNCTION DirExists (filename: PATHSTR): BOOLEAN;
FUNCTION fileexists (CONST filename: PATHSTR): BOOLEAN;
PROCEDURE EraseFile (CONST CurrentFile: STRING);
PROCEDURE EraseAllFiles;
PROCEDURE updateCursor;
FUNCTION Upper (w: STRING): STRING;
FUNCTION RPad (bstr: STRING; len: BYTE): STRING;
FUNCTION RTrim (InStr: STRING): STRING;
FUNCTION LTrim (InStr: STRING): STRING;
FUNCTION Trim (ss: STRING): STRING;
FUNCTION StrToDoubleChar (conf: STRING): STRING;
FUNCTION GetQWKname (Qname: PATHSTR; VAR Qext: EXTSTR): BOOLEAN;
PROCEDURE PrepareFiles (VAR TextName: PATHSTR; VAR TextExtension: EXTSTR;
                        VAR TextFile: TEXT; VAR MsgDAT: FILE);
PROCEDURE AddConfToList (CONST ConfNumStr, ConfName: STRING);
PROCEDURE Verify (CONST control, variable: STRING; OFFSET: BYTE);
FUNCTION AddToArray (VAR Message: MsgArray; OFFSET: WORD; Line: STRING): WORD;
FUNCTION FigureMSGsize (bytes: WORD; VAR chunks: WORD): STRING;
PROCEDURE InitConfig (VAR Compressor: PATHSTR);
FUNCTION GetDateTime: STRING;
PROCEDURE WriteControlDAT (Const CONname: STRING);
FUNCTION CompressDAT (CONST QWKfile, DATfile: STRING;
                     CONST Compressor: PATHSTR): BOOLEAN;
Function WipeDir: Boolean;
PROCEDURE Cleanup;

{===========================================================================}

IMPLEMENTATION

PROCEDURE WriteErr (problem: BYTE);
VAR
  message: STRING;
BEGIN
  IF problem > 0 THEN BEGIN
    CASE problem OF
      1: message := 'Command line error: no files matching specification found to process.';
      2: message := 'A ' + DATname+ ' file already exists.  MOVE, REName or DELete it.';
      3: message := 'Can''t create a unique *.Q?? file.  MOVE, REName or DELete some files.';
      4: message := 'Invalid header portion encountered just above line number: ' + IntToStr (lineNumb) + ' - fix file!';
      5: message := 'Error archiving ' + DATname+ ' - try archiving it manually.';
      6: message := 'You cannot just specify a path, add "*.*" or "\*.*" for all files.';
      7: message := 'Unexpected file or directory error, unable to continue.';
      ELSE  message := 'Unknown error.';
    END;
    WriteLn (#7, 'Error encountered, number ', problem, ':'); WriteLn (message);
  END;
END;

PROCEDURE cursorOff; ASSEMBLER;
(* Routine from SWAG *)
ASM
  mov AH, 3; mov BH, 0; Int $10; OR CH, $20; mov AH, 1; Int $10;
END;

PROCEDURE cursorOn; ASSEMBLER;
(* Routine from SWAG *)
ASM
  mov AH, 3; mov BH, 0; Int $10; AND CH, NOT $20; mov AH, 1; Int $10;
END;

FUNCTION WhereX: BYTE; ASSEMBLER;
(* Routine from SWAG *)
ASM
  MOV AH, 3     {Ask For current cursor position}
  MOV BH, 0     { On page 0 }
  Int 10h       { Return inFormation in DX }
  Inc DL        { Bios Assumes Zero-based. Crt.WhereX Uses 1 based }
  MOV AL, DL    { Return X position in AL For use in Byte Result }
END;

FUNCTION WhereY: BYTE; ASSEMBLER;
(* Routine from SWAG *)
ASM
  MOV AH, 3    {Ask For current cursor position}
  MOV BH, 0    { On page 0 }
  Int 10h      { Return inFormation in DX }
  Inc DH       { Bios Assumes Zero-based. Crt.WhereY Uses 1 based }
  MOV AL, DH   { Return Y position in AL For use in Byte Result }
END;

PROCEDURE GotoXY (X, Y: BYTE); ASSEMBLER;
(* Routine from SWAG *)
ASM
  MOV DH, Y    { DH = Row (Y) }
  MOV DL, X    { DL = Column (X) }
  Dec DH       { Adjust For Zero-based Bios routines }
  Dec DL       { Turbo Crt.GotoXY is 1-based }
  MOV BH, 0    { Display page 0 }
  MOV AH, 2    { Call For SET CURSOR POSITION }
  Int 10h
END;

procedure WriteCharAtCursor(x: char);
(* Routine from SWAG *)
var
  reg: registers;
begin
  reg.AH := $0A;
  reg.AL := ord(x);
  reg.BH := $00;    {* Display Page Number. * for Graphics Modes! *}
  reg.CX := 1;      {* Word for number of characters to write *}
  intr($10, reg);
end;

Procedure ClrEol;
(* Routine by DDA *)
VAR
  NumCol: WORD ABSOLUTE $0040: $004A; { Number of CRT columns (1-based) }
  x, y, DistanceToRight: byte;
BEGIN
  x := WhereX;
  y := WhereY;
  DistanceToRight := NumCol-x;
  Write('':DistanceToRight);
  WriteCharAtCursor(#32);
  GotoXY(x,y);
END;

FUNCTION IntToStr (vint: LONGINT): STRING;
VAR
  s: STRING;
BEGIN
  Str (vint, s);
  IntToStr := s;
END;

FUNCTION LeadingZero (w: WORD): STRING;
VAR
  s: STRING [2];
BEGIN
  Str (w: 0, s);
  IF Length (s) = 1 THEN
    s := '0' + s;
  LeadingZero := s;
END;

PROCEDURE iocheck;
BEGIN
  IF IOResult <> 0 THEN Halt (7);
END;

FUNCTION DirExists (filename: PATHSTR): BOOLEAN;
VAR
  Attr: WORD;
  f   : FILE;
BEGIN
  Assign (f, filename);
  GetFAttr (f, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) = Directory)
  THEN DirExists := TRUE
  ELSE DirExists := FALSE;
END;

FUNCTION fileexists (CONST filename: PATHSTR): BOOLEAN;
VAR
  Attr: WORD;
  f   : FILE;
BEGIN
  Assign (f, filename);
  GetFAttr (f, Attr);
  fileexists := (DosError = 0)
END;

PROCEDURE EraseFile (CONST CurrentFile: STRING);
VAR
  df: FILE;
BEGIN
  Assign (df, CurrentFile);
  SetFAttr (df, 0);
  Erase (df);
END;

PROCEDURE EraseAllFiles;
VAR
  JustFiles: WORD;
  DirInfo  : SEARCHREC;
BEGIN
  JustFiles := ReadOnly + Hidden + SysFile + Archive;
  FindFirst ('*.*', JustFiles, DirInfo);
  WHILE DosError = 0 DO
  BEGIN
    EraseFile(DirInfo.Name);
    FindNext (DirInfo);
  END;
END;

PROCEDURE updateCursor;
{code written by Sean Palmer, found in SWAG}
BEGIN
  cursorState := Succ (cursorState) AND 3;
  Write (cursorData [cursorState], ^H);
END;

FUNCTION Upper (w: STRING): STRING;
VAR
  cp : INTEGER;        {The position of the character to change.}
BEGIN
  FOR cp := 1 TO Length (w) DO
    w [cp] := UpCase (w [cp]);
  Upper := w;
END;

FUNCTION RPad (bstr: STRING; len: BYTE): STRING;
BEGIN
  WHILE (Length (bstr) < len) DO
    bstr := bstr + #32;
  RPad := bstr;
END;

FUNCTION RTrim (InStr: STRING): STRING;
BEGIN
  WHILE (Length (InStr) > 0) AND (InStr [Length (InStr) ] IN [#0, #9, #32]) DO
    Dec (InStr [0]);
  RTrim := InStr;
END;

FUNCTION LTrim (InStr: STRING): STRING;
BEGIN
  WHILE (Length (InStr) > 0) AND (InStr [1] IN [#0, #9, #32]) DO
    Delete (InStr, 1, 1);
  LTrim := InStr;
END;

FUNCTION Trim (ss: STRING): STRING;
BEGIN
  Trim := RTrim (LTrim (ss));
END;

FUNCTION StrToDoubleChar (conf: STRING): STRING;
VAR
  i, VErr: INTEGER;
BEGIN
  Conf := Trim (conf);
  Val (conf, i, VErr);
  IF (VErr = 0)
  THEN StrToDoubleChar := Chr (i MOD 256) + Chr (i DIV 256)
  ELSE StrToDoubleChar := #0#0
END;

FUNCTION GetQWKname (Qname: PATHSTR; VAR Qext: EXTSTR): BOOLEAN;
VAR
  letter3,
  letter4: CHAR;
  UniqueNameFound, NamesExhausted: BOOLEAN;
BEGIN
  UniqueNameFound := FALSE;
  NamesExhausted := FALSE;

  letter3 := '0';
  letter4 := '0';

  IF NOT FileExists (Qname+ '.QWK') THEN
    Qext := '.QWK'
  ELSE
    WHILE (NOT UniqueNameFound) AND (NOT NamesExhausted) DO
    BEGIN
      Qext := '.Q' + letter3 + letter4;
      IF NOT FileExists (Qname + Qext) THEN
        UniqueNameFound := TRUE
      ELSE  { incremenent extension }
        CASE letter4 OF
          'Z': BEGIN
                  letter4 := '0';
                  CASE letter3 OF
                    'Z': NamesExhausted := TRUE;
                    '9': letter3 := 'A';
                    ELSE Inc (letter3);
                  END;
                END;
          '9': letter4 := 'A';
          ELSE Inc (letter4);
        END;
    END;
  GetQWKname := (NOT NamesExhausted)
END;

PROCEDURE PrepareFiles (VAR TextName: PATHSTR; VAR TextExtension: EXTSTR;
                        VAR TextFile: TEXT; VAR MsgDAT: FILE);
CONST
  QmailLine: ARRAY [1..128] OF CHAR =
  'Produced by Qmail...Copyright (c) 1995 by SparkWare.  All Rights' +
  ' Reserved       Above for Compatibility with Qmail              ';

VAR
  QWKname: PATHSTR;

BEGIN
  IF fileexists (DATname) THEN Halt (2);

  IF NOT fileexists (TextName) THEN Halt (1);
  Assign (TextFile, TextName);
  Reset (TextFile); iocheck;

  QWKname := TextName;
  IF (Pos ('.', QWKname) > 0) THEN
    QWKname := Copy (QWKname, 1, Pos ('.', QWKname) - 1);
  IF NOT GetQWKname (QWKname, TextExtension) THEN Halt (3);

  cursorOff;
  Write ('Converting ', TextName, ' to ', DATname, ' please wait ... ');
  TextName := QWKname;

  Assign (MsgDAT, DATname);
  Rewrite (MsgDAT, 1); iocheck;
  BlockWrite (MsgDAT, QmailLine, 128); iocheck;
END;

PROCEDURE AddConfToList (CONST ConfNumStr, ConfName: STRING);
(* Routine from SWAG *)
{ This Procedure will search through an ordered linked list,
  find out where the data belongs, and insert it into the list. }

VAR
  Anchor,                        { Where we are in the list               }
  NewConf: ConfRec;              { This is what we insert our data into.  }
  ConfNum: WORD;

BEGIN
  ConfNum := Ord (ConfNumStr [1]) + (256 * (Ord (ConfNumStr [2])));

  Inc (Conferences);
  New (NewConf);
  Anchor := ConfList;            { Start at the top of the list.          }

  IF ConfList = NIL THEN
  BEGIN
    ConfList := NewConf;
    ConfList^. Name := ConfName;
    ConfList^. Num  := ConfNum;
    ConfList^. Next := NIL;
  END
  ELSE     { Check to see if it comes before the first item in the list   }
    IF ConfNum < Anchor^. Num THEN
    BEGIN
      NewConf^. Next := ConfList;  { Make the Anchor first come after Next }
      ConfList := NewConf;         { This is our new ConfList of the list  }
      ConfList^. Name := ConfName; { and insert our data value(s).         }
      ConfList^. Num  := ConfNum;
    END
  ELSE
  BEGIN

    { Here we need to go through the list, but always looking one step
    ahead of where we are, so we can maintain the links.  The method
    we'll use here is: looking at Anchor^.Next^.Name

    A way to explain that in English is "what is the data pointed to by
    Pointer Next, in the Record pointed to by Pointer Anchor."  You may
    need to run that through your List a few times before it clicks, but
    hearing it in English might make it a bit easier for some people to
    understand.                                                           }

    WHILE (ConfNum >= Anchor^. Next^. Num) AND (Anchor^. Next <> NIL) DO
      Anchor := Anchor^. Next;

    IF ConfNum = Anchor^. Num THEN  {This clause prevents duplicate numbers}
    BEGIN
      Dispose (NewConf);
      Dec (Conferences);
    END
    ELSE
    BEGIN
      NewConf^. Name := ConfName;
      NewConf^. Num  := ConfNum;
      NewConf^. Next := Anchor^. Next;
      Anchor^. Next := NewConf;
    END;
  END;
END;

PROCEDURE Verify (CONST control, variable: STRING; OFFSET: BYTE);
BEGIN
  IF (Copy (control, OFFSET, Length (variable)) <> variable) THEN
    Halt (4);
END;

FUNCTION AddToArray (VAR Message: MsgArray; OFFSET: WORD; Line: STRING): WORD;
VAR
  index: WORD;
BEGIN
  IF (OFFSET > 128) THEN   { remove trailing whitespace }
    Line := RTrim (Line);
  IF (Length (Line) > 0) THEN BEGIN
    FOR index := (OFFSET + 1) TO (OFFSET + Length (Line)) DO BEGIN
      IF (index <= MaxBytes) THEN
        Message [index] := Line [index - OFFSET];
    END
  END
  ELSE index := OFFSET;
  IF (OFFSET >= 128) AND (index < MaxBytes) THEN BEGIN
    Inc (index);
    Message [index] := #227;
  END;
  AddToArray := index;
END;

FUNCTION FigureMSGsize (bytes: WORD; VAR chunks: WORD): STRING;
VAR
  MsgChunks: STRING [6];
BEGIN
  chunks := (bytes DIV 128);
  IF ((bytes MOD 128) <> 0) THEN Inc (chunks);
  Str (chunks, MsgChunks);
  MsgChunks := RPad (MsgChunks, 6);
  FigureMSGsize := MsgChunks;
END;

PROCEDURE InitConfig (VAR Compressor: PATHSTR);
VAR
  epath: PATHSTR;
  edir : DIRSTR;
  ename: NAMESTR;
  eext : EXTSTR;
  CfgFile: TEXT;
  CfgLine,
  CfgVar, CfgVal: STRING [80];
  equalPos: BYTE;

BEGIN
  FSplit (FExpand (ParamStr (0)), edir, ename, eext); { break up path into components }
  epath := edir + ename + '.cfg';

  Compressor := 'pkzip -# -m';
  UserName := 'USER NAME';
  BBSID := '';
  INDEXPROG := '';

  IF fileexists (epath) THEN
  BEGIN
    Assign (CfgFile, epath);
    Reset (CfgFile); iocheck;
    While NOT EoF (CfgFile) DO BEGIN  { find vars }
      ReadLn (CfgFile, CfgLine);
      equalPos := Pos ('=', CfgLine);
      IF (equalPos > 1) THEN BEGIN

        CfgVar := Trim (Upper (Copy (CfgLine, 1, equalPos - 1)));
        CfgVal := Trim (Copy (CfgLine, equalPos + 1, Length (CfgLine) - equalPos));

        IF (CfgVar = 'COMPRESSOR') THEN
          Compressor := CfgVal

        ELSE IF (CfgVar = 'USERNAME') THEN
          UserName := Copy (CfgVal, 1, 25)

        ELSE IF (CfgVar = 'BBSID') THEN
          BBSID := Copy (CfgVal, 1, 8)

        ELSE IF (CfgVar = 'INDEXPROG') THEN
          INDEXPROG := CfgVal

      END;
    END;  { loop back to read another line }
    Close (CfgFile);
  END;
END;

FUNCTION GetDateTime: STRING;
VAR
  Y, m, D, dow,
  h, i, s, s100: WORD;
  Ys: STRING[4];
BEGIN
  GetDate (Y, m, D, dow);
  GetTime (h, i, s, s100);
  Str (Y, Ys);
  GetDateTime := LeadingZero (M) + '-' +
                 LeadingZero (D) + '-' +
                            (Ys) + ',' +
                 LeadingZero (H) + ':' +
                 LeadingZero (I) + ':' +
                 LeadingZero (S)
END;

PROCEDURE WriteControlDAT (Const CONname: STRING);
VAR
  link: ConfRec;
  CDat: TEXT;
BEGIN
  IF BBSID = '' THEN BEGIN
    BBSID := Copy (Upper (Trim (BBSname)), 1, 8);
    IF Pos (#32, BBSID) <> 0 THEN
      BBSID := Copy (BBSID, 1, Pos (#32, BBSID));
  END;

  Assign (CDat, CONname);
  Rewrite (CDat);
  WriteLn (CDat, BBSname);
  WriteLn (CDat, BBSID, ' City, ST');
  WriteLn (CDat, '000-000-0000');
  WriteLn (CDat, 'Your Sysop, Sysop');
  WriteLn (CDat, '00000,', BBSID);
  WriteLn (CDat, GetDateTime);  {in the format: 10-15-1995,06:44:36}
  WriteLn (CDat, UserName);
  WriteLn (CDat);
  WriteLn (CDat, '0');
  WriteLn (CDat, '0');
  WriteLn (CDat, Conferences - 1);
  WHILE ConfList <> NIL DO BEGIN
    WITH ConfList^ DO BEGIN
      WriteLn (CDat, Num);
      WriteLn (CDat, Name);
    END;
    link := ConfList;
    ConfList := ConfList^. next;
    Dispose (link);
  END;
  Close (CDat);
END;

FUNCTION CompressDAT (CONST QWKfile, DATfile: STRING;
                     CONST Compressor: PATHSTR): BOOLEAN;
VAR
  X, Y, newX: BYTE;
BEGIN
  X := WhereX;
  Y := WhereY;
  IF NOT FileExists (CONname) THEN
    WriteControlDAT (CONname);
  Write ('> ', Compressor);
  newX := WhereX;
  SwapVectors;
    IF INDEXPROG <> '' THEN
      Exec (GetEnv ('COMSPEC'), ' /c ' + INDEXPROG);
    Exec (GetEnv ('COMSPEC'), ' /c '+compressor+' '+QWKfile+' *.*');
  SwapVectors;
  IF DosError <> 0 THEN Halt (5);
  IF (Y = WhereY) and (WhereX >= newX) THEN
  BEGIN  {If we haven't moved to a new line... }
    GotoXY (X, Y);  {return to where we were at start of procedure}
    ClrEol;
  END;
  cursorOff;
  CompressDAT := fileexists (QWKfile)
END;

Function WipeDir: Boolean;
VAR
  CurrDir: PATHSTR;
BEGIN
  GetDir(0, CurrDir);
  IF CurrDir = TXTQ_DIR THEN BEGIN
    EraseAllFiles;
    ChDIR (StartDIR); iocheck;
    RmDir (TXTQ_DIR); iocheck;
  END;
  WipeDir := (NOT DirExists (TXTQ_DIR))
END;

PROCEDURE Cleanup;
BEGIN
  IF NOT WipeDir THEN BEGIN
    Writeln;
    Writeln('*** ABNORMAL PROGRAM TERMINATION, WORK DIRECTORY STILL EXISTS! ***');
    Writeln;
  END;
END;

BEGIN
  GetDir(0, StartDIR);
  If StartDir [length(StartDir)] <> '\'
  THEN TXTQ_DIR := '\'
  ELSE TXTQ_DIR := '';
  TXTQ_DIR := StartDIR + TXTQ_DIR + 'TXTQ_DIR.!!!';
END.
