/******************************************************************/
/* DEINSTAL.CMD Workplace Security deinstallation utility            */
/*                                                                */
/* Workplace Security Copyright (C) 1995 by Maple Valley Software */
/******************************************************************/
  
'@Echo Off'


/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

/* Initialize */
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX


Call SysCls
say ' '
say ' '
say 'Removing Workplace Security... '
Say ' '
Say '** Warning ** Unlock all locked objects'
say 'before removing Workplace Security!'
Say ' '

current_directory = directory() /* get current directory */

/* Find the drive for the d:\OS2\DLL directory */

Drives = SysDriveMap(C,'LOCAL')
   do words(drives)
      parse var drives drive drives
      directory = drive||'\OS2\DLL'
      Result = SysFileTree(Directory,'Dirs','D')
      If Dirs.0 > 0 Then signal ASKDRIVE
      end

/* Ask for the OS/2 boot drive */
ASKDRIVE:
Say 'Please enter the drive letter of your'
Say 'OS/2 boot drive. (default' drive ')'
Say 'or type "Q" to quit the deinstall.'
Parse upper pull bootdrive ':' .

if bootdrive = "Q" Then signal DONE
If bootdrive > "" Then drive  = bootdrive||':'

/* Verify the directory exists. */
Result = SysFileTree( drive||"\OS2\DLL", 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Say ' '
  Say 'OS/2 could not be found on drive' drive||':'
  Say ' '
  Signal ASKDRIVE
  End

Result = SysFileTree(drive||'\OS2\DLL\WPSECURE.DLL', 'Dirs', 'O' )
If Dirs.0 = 0 Then Do 
   /* WPSECURE.DLL not found */
   Say  "Workplace Security is not currently installed"
   exit
   End
Else Do /* build removal cmd */
   fStartupExists = 0
   SAY 'Removing Workplace Security'
   startup_cmd = drive||'\STARTUP.CMD'
   wpsecure_cmd = directory()||"\WPSECURE.CMD"
   callcmd = "call "wpsecure_cmd
   Result = SysFileTree(drive||'\STARTUP.CMD', 'Dirs', 'O' )
   If Dirs.0 <> 0 Then Do
         fStartupExists = 1
         "copy" startup_cmd drive||"\STARTUP.WPS 1>NULL"  /* save current startup.cmd */
         'DEL' startup_cmd "1>NULL"
         End
   rc = lineout(startup_cmd,callcmd)
   'DEL' wpsecure_cmd
   rc = lineout(wpsecure_cmd,'@echo off')
   rc = lineout(wpsecure_cmd,'echo Removing Workplace Security')
   rc = lineout(wpsecure_cmd,'DEL'  drive||'\OS2\DLL\WPSECURE.DLL')
   rc = lineout(wpsecure_cmd,'DEL'  drive||'\OS2\HELP\WPSECURE.HLP')
   if fStartupExists = 1 then do   
         rc = lineout(wpsecure_cmd,'COPY' drive||'\STARTUP.WPS' startup_cmd '1>NULL')
         rc = lineout(wpsecure_cmd,'DEL' drive||'\STARTUP.WPS')
         rc = lineout(wpsecure_cmd,'CALL' startup_cmd)
         End
   else  Do
         rc = lineout(wpsecure_cmd,'DEL' startup_cmd)  
         rc = lineout(wpsecure_cmd,'Exit')
         End
   End

'REMOVE'
say ' '
Say ' '
Say 'Shutdown and Re-boot to complete Workplace Security removal'
Say ' '
Signal DONE

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

DONE:
Exit
