/*** TERM_IO.C ***/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pcl4c.h"
#include "term_io.h"
#include "ascii.h"
#include "dos_io.h"
#include "win_io.h"

#define FALSE 0
#define TRUE !FALSE

static int EchoFlag = FALSE;
static char EnterMsg[] = "Enter Filename:";

#define QUE_MASK 0x0f

static int QueueEnable = FALSE;

static  char Temp[80];

static struct
{int  Head;
 int  Tail;
 char Char[QUE_MASK+1];
 char Cmd[QUE_MASK+1];
} Queue;

void QueueOn(void)
{WinPutString(SCR_WIN,"Queue On\n");
 Queue.Head = 0;
 Queue.Tail = 0;
 QueueEnable = TRUE;
}

void ShowQueue(void)
{int h, t;
 char Cmd;
 WinPutString(SCR_WIN,"ShowQueue\n");
 h = Queue.Head;
 t = Queue.Tail;
 while(1)
   {if(h==t) break;
    Cmd = Queue.Cmd[h];
    if(Cmd=='T') sprintf(Temp,"   T  %2x\n",Queue.Char[h]);
    else sprintf(Temp,"%c     %2x\n",Cmd,Queue.Char[h]);
    h = (h + 1) & QUE_MASK;
    WinPutString(SCR_WIN,Temp);
   }
}

static void EnQueue(char Cmd,char C)
{int t;
 t = (Queue.Tail + 1) & QUE_MASK;
 if(t==Queue.Head)
   {/* must de-queue to make room */
    Queue.Head = (Queue.Head + 1) & QUE_MASK;
   }
 Queue.Cmd[Queue.Tail]  = Cmd;
 Queue.Char[Queue.Tail] = C;
 Queue.Tail = t;
}

void MsgEcho(int Flag)
{EchoFlag = Flag;
}

/* write message to right status line */

void WriteMsg(char *MsgPtr)
{if(EchoFlag)
   {WinPutString(SCR_WIN,MsgPtr);
    WinPutChar(SCR_WIN,'\n');
   }
 WinClear(RGT_WIN);
 WinPutChar(RGT_WIN,' ');
 WinPutString(RGT_WIN,MsgPtr);
 WinGetPos(SCR_WIN,NULL,NULL);
}

/*** write message + integer parm */

void WriteIntMsg(char *MsgPtr, int Parm)
{char Temp[50];
 sprintf(Temp,"%s %d", MsgPtr, Parm);
 WriteMsg(Temp);
}

/*** write message + hexidecimal parm */

void WriteHexMsg(char *MsgPtr, int Parm)
{char Temp[50];
 sprintf(Temp,"%s 0x%x", MsgPtr, Parm);
 WriteMsg(Temp);
}

/*** write message + long parm */

void WriteLongMsg(char *MsgPtr, long Parm)
{char Temp[50];
 sprintf(Temp,"%s %ld", MsgPtr, Parm);
 WriteMsg(Temp);
}

/*** read message */

void ReadMsg(char *Buffer,int Length,int StartCol)
{WinSetPos(RGT_WIN,0,StartCol);
 WinGetString(RGT_WIN,Buffer,Length);
 WinGetPos(SCR_WIN,NULL,NULL);
}

/*** display the error text ***/

void SayError(int Port, char *ptr)
{sprintf(Temp,"ERROR! COM%d : %s",1+Port,ptr);
 WriteMsg(Temp);
 /* cancel remote */
 CharPut(Port,CAN);
 CharPut(Port,CAN);
 CharPut(Port,CAN);
} /* end SayError */

/*** output character to serial port ***/

int CharPut(int Port, char ch)
{int i, rc;
 /* transmit character */
 rc = SioPutc(Port,ch);
 if(QueueEnable) EnQueue('T',ch);
 if(rc<0)
     {sprintf(Temp,"SioPutc Error: COM%d: ",1+Port);
      WinPutString(SCR_WIN,Temp);
      SioError(rc);
      WinPutChar(SCR_WIN,'\n');
      SioDone(Port);
      exit(1);
     }
 return(rc);
}

/*** receive character from serial port ***/

int CharGet(int Port, int Timeout)
{int rc;
 rc = SioGetc(Port,Timeout);
 if(rc<-1)
     {sprintf(Temp,"SioGetc Error: COM%d: ",1+Port);
      WinPutString(SCR_WIN,Temp);
      SioError(rc);
      exit(1);
     }
 if(QueueEnable&&(rc>=0)) EnQueue('R',(char)rc);
 return(rc);
}

/*** fetch name from user if Filespec[] is empty ***/

int FetchName(char *FileName)
{/* already have filename ? */
 if(strlen(FileName) > 0) return TRUE;
 /* get filename from user */
 WriteMsg(EnterMsg);
 ReadMsg(FileName,20,1+strlen(EnterMsg));
 /* got non-NULL name ? */
 if(strlen(FileName)>0) return TRUE;
 else return FALSE;
}

/* display CPS */

void WriteCPS(long StartTics,long FileBytes,char *Filename,int Skipped)
{int  CPS;
 long Tics;
 long Secs;
 char Temp[80];
 if(*Filename=='\0') return;
 if(!Skipped)
   {Secs = (SioTimer() - StartTics) / 18;
    if(Secs>0) CPS = (int)(FileBytes / Secs);
    else Skipped = TRUE;
   }
 if(Skipped) sprintf(Temp,"%s skipped (%ld bytes)\n",Filename,FileBytes);
 else sprintf(Temp,"%s transferred @ %d CPS (%ld bytes)\n",Filename,CPS,FileBytes);
 WinPutString(SCR_WIN,Temp);
}