/* zdate.c */

#include <stdio.h>
#include <string.h>
#include "datetime.h"
#include "zdate.h"

#define BYTE unsigned char
#define WORD unsigned int

#define  K1970  2440588L
#define  K0        1461L
#define  K1      146097L
#define  K2     1721119L

void Greg2Julian(WORD Year,WORD Month,WORD Day,long *Julian)
{long Century;
 long XYear;
 if(Month <= 2)
    {Year--;
     Month += 12;
    }
 Month -= 3;
 Century = Year / 100;
 XYear = Year % 100;
 Century = (Century * K1) >> 2;
 XYear = (XYear * K0) >> 2;
 *Julian = ((((153L * (long)Month) + 2L) / 5L) + (long)Day)
           + K2 + XYear + Century;
}

void Julian2Greg(long Julian,WORD *Year,WORD *Month,WORD *Day)
{long Temp;
 long XYear;
 WORD YYear;
 WORD YMonth;
 WORD YDay;
 Temp = (((Julian - K2) << 2) - 1);
 XYear = (Temp % K1) | 3;
 Julian = Temp / K1;
 YYear = (XYear / K0);
 Temp = ((((XYear % K0) + 4) >> 2) * 5) - 3;
 YMonth = Temp / 153;
 if(YMonth >= 10)
    {YYear++;
     YMonth -= 12;
    }
 YMonth += 3;
 YDay = Temp % 153;
 YDay = (YDay + 5) / 5;
 *Year = YYear + (WORD)(Julian * 100);
 *Month = YMonth;
 *Day = YDay;
}

void Dos2Zdate(WORD Date,WORD Time,char *Text,int Length)
{int  i, n;
 char c;
 BYTE Year;
 BYTE Month;
 BYTE Day;
 BYTE Hour;
 BYTE Minute;
 BYTE Second;
 long SecsPast;
 long Julian;
 long DaysPast;
 /* begin */
 UnpackDate(Date,&Year,&Month,&Day);
 UnpackTime(Time,&Hour,&Minute,&Second);
 Greg2Julian((WORD)(1900+Year),(WORD)Month,(WORD)Day,&Julian);
 DaysPast = Julian - K1970;
 SecsPast = 86400L * DaysPast;
 SecsPast = SecsPast + (long)Hour * 3600L + (long)Minute * 60L
              + (long)Second;
 /* extract octal digits */
 n = 0;
 while( (SecsPast!=0L) && (n<Length) )
   {
    c = (char) ((SecsPast&0x07)+0x30);
    Text[n++] = c;
    SecsPast >>= 3;
   }
 Text[n] = '\0';
 /* reverse digits */
 for(i=0;i<n/2;i++)
   {c = Text[i];
    Text[i] = Text[n-i-1];
    Text[n-i-1] = c;
   }
}

void Z2DosDate(char *Text,WORD *Date, WORD *Time)
{int  n;
 WORD Year;
 WORD Month;
 WORD Day;
 WORD Hour;
 WORD Minute;
 WORD Second;
 long SecsPast;
 long Julian;
 long DaysPast;
 WORD Length;
 Length = strlen(Text);
 SecsPast = 0L;
 for(n=0;n<Length;n++)
   SecsPast = (SecsPast << 3) + (Text[n] - 0x30);
 Julian = (SecsPast / 86400) + K1970;
 Julian2Greg(Julian,&Year,&Month,&Day);
 SecsPast = SecsPast % 86400;
 Hour = SecsPast / 3600;
 SecsPast = SecsPast % 3600;
 Minute = SecsPast / 60;
 Second = SecsPast % 60;
 PackDate((BYTE)(Year-1900),(BYTE)Month,(BYTE)Day,(WORD *)Date);
 PackTime((BYTE)Hour,(BYTE)Minute,(BYTE)Second,(WORD *)Time);
}
