program ShadMenuDemo;
{---------------------------------------------
 A Very Simple Demo of Shadow Menu which  uses
 Shadow Class concepts to fix an undesirable
 feature of the TMenuBox Class in Turbo Vision
 This Version REQUIRES a mouse!
 ---------------------------------------------}
uses Objects, App, Drivers, Views, Menus
		, ShadMenu  {Comment Out This Line to See Undesirable Feature }
		;{Uses}

const
	cmNewWin = 2000;       { Command to insert a New Window }
	cmDoNothing = 2001;    { Just That! }
	cmShowDisabled = 100;  { Used for Disabled Menu Item}
	cmToggleColor = 2002;  { Command to change New Window Palette }
	WinColor:byte = 0;     { Used to Set New Window Palette}
type
	TInsApp = object(TApplication)
		WinCount: Integer;
		procedure HandleEvent(var Event: TEvent); virtual;
		procedure InitMenuBar; virtual;
		end;

	PWindowMenuBar = ^TWindowMenuBar;
	TWindowMenuBar = object(TMenuBar)
		function GetPalette:PPalette; virtual;
		end;
{-----------------------------------------}
{ Creates a test menu to insert in a Window }
	function TestMenu(R:Trect):PmenuBar;
		var
			P:PMenuBar;
		begin
			P := New(PWindowMenuBar, Init(R,
			 NewMenu(
				 NewSubMenu('Sub Menu ~O~ne',hcNoContext,
					 NewMenu(
						 NewItem('Nothing ~H~ere','',0,cmDoNothing,0,
						 NewItem('Just ~D~isabled','',0,cmShowDisabled,0,
						 NewItem('Nothing ~T~here','',0,cmDoNothing,0,
						 nil)))),
				 NewSubMenu('Sub menu ~T~wo',hcNoContext,
					 NewMenu(
						 NewItem('Nothing ~H~ere','',0,cmDoNothing,0,
						 NewItem('Or Here ~E~ither','',0,cmDoNothing,0,
						 nil))),
				 NewItem('This is Disabled','',0,cmShowDisabled,0,
					 nil)))
				)));
			P^.disableCommands([cmShowDisabled]);
			TestMenu := P;
		end;
{-----------------------------------------}
{ Traps our NewWindow and ToggleColor commands }
	procedure TInsApp.HandleEvent(var Event: TEvent);
		var
			R: TRect;
			PW:Pwindow;
		begin
			inherited HandleEvent(Event);
			if Event.What = evCommand then
				if Event.Command = cmNewWin then
					begin
					Inc(WinCount);
					Desktop^.GetExtent(R);
					PW := New(PWindow, Init(R, 'Test window', WinCount));
					PW^.Palette := WinColor;
					R.assign(1,1,R.B.X-2,2);
					PW^.insert(TestMenu(R));
					Desktop^.Insert(PW);
					end
				else
					if Event.Command = cmToggleColor then
						if 	WinColor<2 then inc(WinColor) else WinColor := 0;
		end;
{-----------------------------------------}
	procedure TInsApp.InitMenuBar;
		var
			R: TRect;
		begin
			GetExtent(R);
			R.B.Y := R.A.Y + 1;
			MenuBar := New(PMenuBar, Init(R, NewMenu(
				NewItem('~A~dd window', 'F3', kbF3, cmNewWin, hcNoContext,
				NewItem('~T~oggle Color','F2',kbF2,cmToggleColor, hcNoContext,
				NewItem('E~x~it', 'ALT-X',kbALTX,cmQuit, hcNoContext,
				nil))))));
		end;
{-----------------------------------------}
{ Provides a better Palette for Menus in Windows }
	function TWindowMenuBar.GetPalette:PPalette;
		const 	WindowMenuBarPalette:array[0..6] of byte =(6,2,1,3,4,7,4);
		begin
			GetPalette := @WindowMenuBarPalette;
		end;
{-----------------------------------------}
var
	InsApp: TInsApp;
begin
	InsApp.Init;
	InsApp.Run;
	InsApp.Done;
end.
