program Shadow_Demo;
{ Very Simple Demonstration of Shadow Class Concepts
	 TPerson's FullName method places the name in Last,First
	 order.  This is not how we want it to behave.  We want
	 First Last order. So we create a Shadow Class with the
	 desired behavior.        }
uses shadow;
type
	PPerson = ^TPerson;
	TPerson = object
		Last,First: string[40];
		constructor init(FirstName,LastName:string);
		destructor  done;
		function    FullName:string; virtual 100;
		end;

{ This is the Shadow Class }
	TPersonShadow = object(TPerson)
		function FullName:string; virtual 100;
		end;

	TRaceCar = object
		Driver: PPerson;
		Model: string[40];
		Number: word;
		constructor init(TheDriver:PPerson; MakeOfCar:string; CarNumber:word);
		destructor  done;
		function    Roster:string;
		end;

	{--------------------------------}
		constructor TPerson.init(FirstName,LastName:string);
			begin
			First := FirstName;
			Last := LastName;
			end;
	{--------------------------------}
		destructor  Tperson.done;
			begin
			{ abstract method }
			end;
	{--------------------------------}
		function Tperson.FullName:string;
			begin
			FullName := Last + ', '+First;
			end;
	{--------------------------------}
		function TPersonShadow.FullName:string;
			begin
			FullName := First+' '+Last;
			end;
	{--------------------------------}
		constructor TRaceCar.init(TheDriver:PPerson; MakeOfCar:string; CarNumber:word);
			begin
			if VALIDVMT(typeof(TheDriver^)) then
				begin
				Driver := TheDriver;
				Model := MakeOfCar;
				Number := CarNumber;
				end
			else
				fail;
			end;
	{--------------------------------}
		destructor  TraceCar.done;
			begin
			{ Here just in case clean up is required }
			end;
	{--------------------------------}
		function    TRaceCar.Roster:string;
			var Temp: string[5];
			begin
			str(Number,Temp);
			Roster:='Car Number '+Temp+', a '+Model+', is driven by '+
							 driver^.FullName+'.';
			end;
	{--------------------------------}
var
	Person: PPerson;
	Car: TRaceCar;
begin
{ Create an Object of TRaceCar and PPerson Class }
	Person := new(PPerson, init('Jenny','Quay'));
	Car.init(Person,'Nissan Stanza',1);
{ Use their methods }
	writeln('-- Original FullName Method --');
	writeln(Car.Roster);
	writeln(Person^.FullName);
{ Now replace the FULLNAME method with Shadow Method }
	if ReplaceMethod (typeof(TPerson),@TPerson.FullName,@TPersonShadow.FullName)
	 then writeln('-- Shadow Class Installed --')
	 else writeln('-- Shadow Class NotInstalled --');
{ Now use the new Shadow Method }
	writeln('-- Shadow FullName Method --');
	writeln(Car.Roster);
	writeln(Person^.FullName);
{ Clean Up }
	Car.done;
	dispose(Person ,done);
end.
