		--------------------
		-- Mouse Routines --
		--------------------
-- You need DOS mouse support for these routines.
-- Using a mouse in SVGA graphics modes is not supported by DOS.

-- Mouse Event Numbers:
global constant MOVE = 1,       -- track every movement of the mouse
		LEFT_DOWN = 2,  -- the rest are button pressing/releasing
		LEFT_UP = 4,
		RIGHT_DOWN = 8,
		RIGHT_UP = 16,
		MIDDLE_DOWN = 32,
		MIDDLE_UP = 64

constant M_GET_MOUSE = 14,
	 M_MOUSE_EVENTS = 15,
	 M_MOUSE_POINTER = 24

global function get_mouse()
-- report mouse events,
-- returns -1 if no mouse event,
-- otherwise returns {event#, x-coord, y-coord}
    return machine_func(M_GET_MOUSE, 0)
end function

global procedure mouse_events(integer events)
-- select the mouse events to be reported by get_mouse()
-- e.g. mouse_events(LEFT_UP + LEFT_DOWN + RIGHT_DOWN)
    machine_proc(M_MOUSE_EVENTS, events)
end procedure

global procedure mouse_pointer(integer show_it)
-- show (1) or hide (0) the mouse pointer
    machine_proc(M_MOUSE_POINTER, show_it)
end procedure

