/*====================================================================
This file is part of the Blackout screen saver.       v0.93 1995-06-01
Copyright (C) 1995 by Staffan Ulfberg.    See README file for details.
====================================================================*/
#define INCL_WIN
#define INCL_DOSPROCESS
#include <stdlib.h>
#include <os2.h>
#include <graph.h>
#include <sys/hw.h>
#include "vga.h"
#include <stdio.h>

#define MAX_PAL_SIZE 256

extern void ErrMsg(char *s);

static char newtable[MAX_PAL_SIZE * 3], oldtable[MAX_PAL_SIZE * 3];
static ULONG gpioldtable[MAX_PAL_SIZE];

void setpalette(char *p) {
  _portaccess(FIRST_PORT, LAST_PORT);  
  _wait01(IS1_R, 0x08);
  _outp8(PEL_IW, 0);
  _outps8dac(PEL_D, p, 3 * 256);
}

int checkpalettemgr(HWND hwnd) {
  HAB hab;
  HDC hdc;
  ULONG caps;

  hab = WinQueryAnchorBlock(hwnd);
  hdc = WinOpenWindowDC(hwnd);

  DevQueryCaps(hdc, CAPS_ADDITIONAL_GRAPHICS, 1, &caps);
  if (caps & CAPS_PALETTE_MANAGER)
    return 1;
  else
    return 0;
}

void getpalette(HWND hwnd, char *p) {
  int i;
  static HAB hab;
  static HDC hdc;
  static HPS hps;
  static SIZEL sizl = { 0L, 0L };
  LONG pal_size;

  hab = WinQueryAnchorBlock(hwnd);
  hdc = WinOpenWindowDC(hwnd);

  DevQueryCaps(hdc, CAPS_COLORS, 1, &pal_size);
  pal_size = pal_size > MAX_PAL_SIZE ? MAX_PAL_SIZE : pal_size;

  hps = GpiCreatePS(hab, hdc, &sizl, PU_PELS | GPIF_DEFAULT |
		    GPIT_MICRO | GPIA_ASSOC);

  GpiQueryRealColors(hps, 0, 0, pal_size, gpioldtable);

  for (i = 0; i < pal_size; i++) {
    p[3*i+2] = (gpioldtable[i] & 0xff) >> 2;
    p[3*i+1] = (gpioldtable[i] & 0xff00) >> 10;
    p[3*i+0] = (gpioldtable[i] & 0xff0000) >> 18;
  }
  GpiDestroyPS(hps);

/*  {
    FILE *f;
    
    f = fopen("pelle", "a");
    for (i = 0; i < 32; i++)
      fprintf(f, "gpioldtable[%2x]=%08lx\n", i, gpioldtable[i]);
    fclose(f);
  } */
}


void restorepalette(HWND hwnd) {
  HAB hab;
  HDC hdc;
  HPS hps;
  HPAL hpal;
  ULONG trash, caps;
  SIZEL sizl = { 0L, 0L };
  LONG pal_size;
  int i;

  hab = WinQueryAnchorBlock(hwnd);
  hdc = WinOpenWindowDC(hwnd);

  DevQueryCaps(hdc, CAPS_COLORS, 1, &pal_size);
  pal_size = pal_size > MAX_PAL_SIZE ? MAX_PAL_SIZE : pal_size;
  DevQueryCaps(hdc, CAPS_ADDITIONAL_GRAPHICS, 1, &caps);
  if (!(caps & CAPS_PALETTE_MANAGER)) {
    ErrMsg("No Palette Manager");
    return;
  }

  hps = GpiCreatePS(hab, hdc, &sizl, PU_PELS | GPIF_DEFAULT |
		    GPIT_MICRO | GPIA_ASSOC );

  for (i = 0; i < 256; i++) {
    gpioldtable[i] = 0;
    gpioldtable[i] |= oldtable[3*i+0] << 18;
    gpioldtable[i] |= oldtable[3*i+1] << 10;
    gpioldtable[i] |= oldtable[3*i+2] << 2;
    gpioldtable[i] |= PC_RESERVED << 24;
  }
  {
    FILE *f;
    
    f = fopen("pelle", "a");
    for (i = 0; i < 32; i++)
      fprintf(f, "gpioldtable[%2x]=%08lx\n", i, gpioldtable[i]);
    fclose(f);
  } 

  hpal = GpiCreatePalette(hab,
			  LCOL_PURECOLOR | LCOL_OVERRIDE_DEFAULT_COLORS,
			  LCOLF_CONSECRGB, pal_size, gpioldtable);

  GpiSelectPalette(hps, hpal);
  WinRealizePalette(hwnd, hps, &trash);

/*  GpiDeletePalette(hpal);
  GpiDestroyPS(hps);  */


}

void grey_blank(HWND hwnd) {
  int i;

  getpalette(hwnd, oldtable);
  for (i = 0; i < 256 * 3; i++) 
    newtable[i] = oldtable[i] / 2;
  setpalette(newtable);

  WinShowPointer(HWND_DESKTOP, 0);
}

void grey_unblank(HWND hwnd) {

  setpalette(oldtable);
/*  restorepalette(hwnd); DOESN'T WORK !!!  */
  WinShowPointer(HWND_DESKTOP, 1);
}















