/*      SMIXC is Copyright 1995 by Ethan Brodsky.  All rights reserved      */

/*  DETECT.C  */

#define TRUE  1
#define FALSE 0

int detect_settings(int *baseio, int *irq, int *dma, int *dma16);
  /* Detects sound card settings using BLASTER environment variable */
  /* Parameters:                                                    */
  /*   baseio    Sound card base IO address                         */
  /*   irq       Sound card IRQ                                     */
  /*   dma       Sound card 8-bit DMA channel                       */
  /*   dma16     Sound card 16-bit DMA channel (0 if none)          */
  /* Returns:                                                       */
  /*   TRUE      Sound card settings detected successfully          */
  /*   FALSE     Sound card settings could not be detected          */

/*  */

#include <ctype.h>
#include <dos.h>
#include <stdlib.h>
#include <string.h>

int get_setting(char *str, char id, int hex)
  {
    char temp[128];
    char *endptr;

    strcpy(temp, str);
    if (strchr(temp, id) != NULL)
      {
        strcpy(temp, strchr(temp, id)+1);          /* Cut off begining      */
        if (strchr(temp, ' ') != NULL)
          *(strchr(temp, ' ')) = '\0';             /* Cut off end           */

        if (hex) strcpy(temp, strcat("0x", temp)); /* Insert a "0x" for hex */

        return(strtoul(temp, &endptr, 0));
      }
    else
      return(0);
  }

int detect_settings(int *baseio, int *irq, int *dma, int *dma16)
  {
    char blaster[128];

    strcpy(blaster, strupr(getenv("BLASTER")));

    *baseio  = get_setting(blaster, 'A', TRUE);   /* Hex     */
    *irq     = get_setting(blaster, 'I', FALSE);  /* Decimal */
    *dma     = get_setting(blaster, 'D', FALSE);  /* Decimal */
    *dma16   = get_setting(blaster, 'H', FALSE);  /* Decimal */

    if (blaster == "") return(FALSE);
    if (baseio  == 0)  return(FALSE);
    if (irq     == 0)  return(FALSE);
    if (dma     == 0)  return(FALSE);
    return(TRUE);
  }