;
; TERMINATOR TEXT INTRO
; Coded '95 by Paradise, 1995.III.3
; Lublin, Poland
; paradise@bachus.umcs.lublin.pl
;
.286

Code  SEGMENT PARA PUBLIC 'CODE'
      ASSUME CS:Code, DS:Code
      Org 100h


Body  PROC FAR
      ; set 400 scan lines
      mov ax, 1202h
      mov bl, 30h
      int 10h
      ; set text mode
      mov ax, 3h
      int 10h
      ; load 8x8 font
      mov ax, 1112h
      mov bl, 0
      int 10h
      ; move screen from data
      push cs
      pop ds
      mov si, offset Piccy
      mov dx, 0b800h
      mov es, dx
      xor di, di
      mov cx, (8000*4-160)/2
      cld
      rep movsw
      ; Show!
      call SetOffs
Repeat:
      in al,60h
      cmp al,1
      je EscPressed
      add Y,3
      
      call SetOffs
      mov ax,Y 
      cmp ax,24*3*16
      jg EscPressed 
      jmp Repeat
EscPressed:
      ; set 25-lines mode
      mov ax, 3h
      int 10h
      ; return to dos
      mov ah, 4ch
      int 21h
Body  ENDP


SetOffs PROC FAR
   push  ds
   push  si
   push  es
   push  di
   pusha
   mov   ax,40h           ; Segment 40h
   mov   es,ax
   mov   cl,es:49h        ; Port 49h = Video BIOS data area
   mov   ax,X             ; AX := X coordinate.
   mov   bx,Y             ; BX := Y coordinate.
   cmp   cl,7             ; Jump if graphics mode.
   ja    @l01
   je    @l02             ; Jump if monocrome text.
   test  byte ptr es:89h,1; If there's 1 in port 89h , we have a VGA
   jnz   @l02             ; Jump if VGA present
   jmp   @l03
@L01:
   mov   cx,8             ; CL := 8 pixels by byte.
                          ; CH := 0(Line sweep preselection.
   div   cl               ; AH := bit displacement in byte.
                          ; AL := Byte displacement in pixels row.
   mov   cl,ah            ; CL := Horizontal pixel panoramic.
   xor   ah,ah
   xchg  ax,bx            ; AX := Y
                          ; BX := Byte displacement in pixels row.
   mov   dx,160           ; DX := Chars row shown
   mul   dx               ; AX := Byte displacement in row begin.
   jmp   @L05
@L02:
   mov   cx,9             ; CL := 9 pixels by byte.
   div   cl               ; AH := bit displacement in byte.
                          ; AL := byte displacement in pixels row.
   dec   ah               ; AH := -1, 0-7
   jns   @l04             ; Jump if AL = 0-7
   mov   ah,8             ; AH := 8
   jmp   @L04
@L03:
   mov   cx,8             ; CL := 8 pixels by byte.
   div   cl               ; AH := bit displacement in byte.
                          ; AL := byte displacement in pixels row.
@L04:
   mov   cl,ah            ; Horizontal pixel panoramic value.
   xor   ah,ah
   xchg  ax,bx            ; AX := Y
                          ; BX := byte displacement in row.
   div   byte ptr es:85h  ; AL := Char`s row
                          ; AH := Sweep line in characters matrix.
   xchg  ah,ch            ; AX := Char`s row.
                          ; CH := Sweep line.
   mov   dx,160           ; DX := chars row shown
   mul   dx               ; AX := Byte displacement in char`s row.
   shr   ax,1             ; AX := Word displacement in char`s row.
                          ; Here the operations end. Now, this is the routine that really do all.
                          ; Assembler registers must have these valours :
                          ;  AX : Char`s row displacement.
                          ;  BX : Byte displacement in the row.
                          ;  CH : Line sweep preselection
                          ;  CL : Horizontal pixel panoramic
@L05:
   add   bx,ax
   mov   dx,es:63h        ; Puerto 63h = E/S del CRTC
   add   dl,6             ; Puerto del estado de video
@L20:                     ; Wait for vertical retrace.
   in    al,dx
   test  al,8
   jz    @L20
@L21:                     ; Wait until vertical retrace ends.
   in    al,dx
   test  al,8
   jnz   @L21
   cli                    ; Stop interrupts.
   sub   dl,6             ; DX := 3B4H or 3D4H.
   mov   ah,bh            ; AH := High value for begin direction.
   mov   al,0ch           ; AL := Register to modify.
   out   dx,ax
   mov   ah,bl            ; AH := Low  value for begin direction.
   inc   al               ; AL := Register to modify.
   out   dx,ax
   sti                    ; Enable interrupts.
   add   dl,6             ; DX := Video status port.
@L22:                     ; Wait for vertical retrace.
   in    al,dx
   test  al,8
   jz    @l22
   cli                    ; Stop interrupts.
   sub   dl,6             ; DX := 3B4h or 3D4H
   mov   ah,ch            ; AH := Value for line sweep preselection register.
   mov   al,8             ; AL := Register to change.
   out   dx,ax
   mov   dl,0C0h          ; Atributes controller port.
   mov   al,13h OR 20h    ; Horizontal pixel panoramic register.
   out   dx,al
   mov   al,cl            ; Horizontal pixel panoramic value.
   out   dx,al
   sti                    ; Enable interrupts.
   popa
   pop   di
   pop   es
   pop   si
   pop   ds
   ret
SetOffs ENDP


X     DW 0
Y     DW 0


Piccy LABEL WORD
include terminat.m


Code  ENDS
      END Body