
/*--------------------------------------------
    TASK.C -- Displays task list
    By Philippe Jounin (March-May 95)
 ----------------------------------------------*/

/* 
Note: This program should not be compiled with Borland C++ 3.1
      since BC 3.1 ignores the "_loadds" keyword.


Thanks to: Matt Pietrek   (author of NukeDll)
           Andreas Furrer (use of SwitchToThisWindow)
*/

/* ---------------------------------- */
/* Ask which program you want         */
/* ---------------------------------- */
#define CTL3D        +   // Use 3d look
#define ICONVIEW         // display icon of selected task
#define ICONHANDLE   +   // display icons handles
#define ONE_INSTANCE +   // do not allow more than one instance
//#define TASK_MANAGER +   // terminate when switching to another task


/* Differents Names of the switch DLL/Wnd */
#define  CHOICE_DLL     "DLLs"
#define  CHOICE_WND     "Wnds"
                         
                         

/* ---------------------------------- */
/* includes                           */
/* ---------------------------------- */
#include <windows.h>
#include <toolhelp.h>
#include <stdlib.h>     // declaration of atoi
#include <string.h>     // declaration of strrchr

#include "resource.h"   // dialog box items
#ifdef CTL3D
#  include "ctl3d.h"
#endif /* Ctrl 3d */



#define  INVALID_TASK   NULL  /* when task function returns an error */  
#define  MIN_ICON       1024  /* do not use icon handler under 1024  */
#define  MBox(x,y)      MessageBox (hMainWnd, x, "Task View", y)
/* converts .RC coordinates into physical coordinates */
#define  SCALE_X(Log_X)   (unsigned) ((7*(Log_X))/4)
#define  SCALE_Y(Log_Y)   (unsigned) ((13*(Log_Y))/8)


/* -------------------------------------------------------------- */
/* Global variables                                               */
/* -------------------------------------------------------------- */
HINSTANCE hThisInst;                     /* Instance of this task */
HWND      hMainWnd;                /* Handle of the dialog Window */
HTASK     hThisTask;                   /* Task handle of TaskView */

HWND      hTaskMainWnd; /* Handle of main window of selected task */
HWND      hTaskMainWndJoker;           /* 2nd to find main window */
HINSTANCE hTaskInstance;             /* Instance of selected Task */
HICON     hTaskIcon;              /* Icon handle of selected task */
HICON     hTaskIconJoker;      /* 2nd way to find the task's icon */
HICON     hTaskIconJokerBis;   /* 3rd way to find the task's icon */



/* if switch's title is DLL, the windows of selected task are displayed */
char szStrB[10];                /* Buffer used by following macro */
#define  IS_CHOICEWND (GetDlgItemText (hMainWnd, IDC_DLLWNDSWITCH,\
                       szStrB, sizeof szStrB)!=0 &&               \
                       lstrcmp (CHOICE_DLL, szStrB)==0 )

/* -------------------------------------------------------------- */
/* Prototypes                                                     */
/* -------------------------------------------------------------- */
long FAR PASCAL WndProc (HWND, WORD, WORD, LONG);
long FAR PASCAL ListProc (HWND, WORD, WORD, LONG);
int  TaskList (void);

/* undocumented function */
int PASCAL FAR SwitchToThisWindow (HWND, int); /* int must be 1 */


/*--------------------------------------------
   NotifyRegisterCallBack : Send a Redraw to the window
 ----------------------------------------------*/
BOOL CALLBACK _loadds NotifyRegisterCallBack (WORD wID, DWORD d)
{
  if (    GetCurrentTask() != hThisTask
      &&  (wID==NFY_EXITTASK  || wID==NFY_STARTTASK) )
        PostMessage (hMainWnd, WM_PAINT, 0, 0l);
return 0;
} /* NotifyRegisterCallBack */



/*--------------------------------------------
   Displays opened windows for a given task
   Searchs the highest level windows (in hTaskMainWnd or hTaskMainWndJoker)
   Searchs the icon handler : if a window reply to the WM_QUERYDRAGICON 
           we put its answer in hTaskIcon;
           then search for a top level window (No parent, but owned by
           the application) which has a title (hTaskIconJoker) 
           then serach for any top level window (hTaskIconJokerBis)
   Note that taskman only search the highest level window
           which has a title.
 ----------------------------------------------*/
BOOL CALLBACK _export EnumProcFunction (HWND hTaskWnd, LPARAM Ark)
{
char   Line [128], szTitle[128], szClassName[128];
LPSTR lpszId;
WNDCLASS  ClassInfo; 

   if (hTaskWnd==INVALID_TASK)  return FALSE;
   /* read the title of the window */
   szTitle[0]=0;
   GetWindowText (hTaskWnd, szTitle, sizeof szTitle);
   
   /* displays '>' if the window has no parent            */
   /* displays 3 '>' or '-' if this is a top level window */
   if (GetWindowWord (hTaskWnd, GWW_HINSTANCE)==hTaskInstance)
       lpszId = GetWindowWord (hTaskWnd, GWW_HWNDPARENT)==NULL ?
               lpszId=(LPSTR)">>>" : (LPSTR) "---";
   else
       lpszId = GetWindowWord (hTaskWnd, GWW_HWNDPARENT)==NULL ?
              lpszId=(LPSTR)">>" : (LPSTR) "--";

   /* read class name and add it */
   GetClassName (hTaskWnd, szClassName, sizeof szClassName);
   wsprintf ((LPSTR) Line,(LPSTR) "%c%5u  %s %s <%s>", 
              IsWindowVisible (hTaskWnd) ? ' ' : '#', hTaskWnd, 
              lpszId, (LPSTR) szTitle, (LPSTR) szClassName);
   SendDlgItemMessage (hMainWnd, IDC_LISTWINDOWS, LB_ADDSTRING, 0, (LPARAM)(LPSTR) Line);

   /* the text to be displayed is the text of the last top window */
   /* which is own by the selected task                           */
   if (    GetWindowWord (hTaskWnd, GWW_HINSTANCE)==hTaskInstance 
        && GetWindowWord (hTaskWnd, GWW_HWNDPARENT)==NULL)
     {   
       if (szTitle[0]!=0) 
          {
             SetDlgItemText (hMainWnd, IDC_MAINWND, (LPSTR) szTitle);
             hTaskMainWnd      = hTaskWnd;   
             GetClassInfo (hTaskInstance, szClassName, & ClassInfo);
             if (ClassInfo.hIcon >= MIN_ICON)  hTaskIconJoker=ClassInfo.hIcon;
          }  /* window has a title */ 
       else   hTaskMainWndJoker = hTaskWnd;   
     }  /* top level window */

   /* get Task Icon : if application answer to a WM_QUERYDRAGICON */
   /* take this icon, otherwise use the highest icon handler      */
   /* returned in ClassInfo.hIcon                                 */
   hTaskIcon = (HTASK) SendMessage (hTaskWnd, WM_QUERYDRAGICON, 0, 0l);
   if (szClassName[0]!='#')
     {
      GetClassInfo (hTaskInstance, szClassName, & ClassInfo);
      if (hTaskIconJokerBis < ClassInfo.hIcon)   
                hTaskIconJokerBis = ClassInfo.hIcon;
     }
return TRUE;
} /* EnumProcWindow */

 

/*--------------------------------------------
   WindowList : Initiate list of all windows
                Find Task icon
 ----------------------------------------------*/
int WindowList (HTASK hTask, HICON hDefIcon)
{
WNDENUMPROC  EnumProcInstance;
TASKENTRY    TaskEntry;

   /* reset contents of left window */
   SendDlgItemMessage (hMainWnd, IDC_LISTWINDOWS, LB_RESETCONTENT, 0, 0l);
   SetDlgItemText (hMainWnd, IDC_MAINWND, (LPSTR) "");
   if (hTask==INVALID_TASK)  return -1;

   /* forget last read icon */
   hTaskIcon = hTaskIconJoker = hTaskIconJokerBis = hDefIcon;
   /* read instance of selected task in hTaskInstance */ 
   TaskEntry.dwSize = sizeof TaskEntry;    
   TaskFindHandle (& TaskEntry, hTask);        
   hTaskInstance = TaskEntry.hInst;  
   /* EnumProcInstance will be called once per window owned by hTask */
   EnumProcInstance = MakeProcInstance ((FARPROC) EnumProcFunction, hThisInst);
   if (EnumProcInstance==NULL)  return -1;
   EnumTaskWindows (hTask, EnumProcInstance, (LONG) hTask);
   FreeProcInstance (EnumProcInstance);
   /* if no high level window has a title, take one without title */
   if (hTaskMainWnd == NULL)  hTaskMainWnd = hTaskMainWndJoker;
return 0;
} /* WindowList */



/*--------------------------------------------
   DLLList : Initiate list of all DLLs used by hTask
 ----------------------------------------------*/
static int IsAlreadyInList (LPSTR szStr)
{
LPSTR p;
BOOL  bRc;
    p = _fstrrchr (szStr, ',');  /* remove name of module */
    if (p==NULL) return TRUE;    /* should not happen */
    *p=0;
    /* search on beginning of string */
    bRc = SendDlgItemMessage (hMainWnd, IDC_LISTWINDOWS, 
                       LB_FINDSTRING, (WORD)-1, (LPARAM)(LPSTR) szStr)==LB_ERR ?  
        FALSE : TRUE;
    *p=',';
return bRc; 
} /* IsAlreadyInList */


static int AddModules (HMODULE hModule, LPSTR szModule)
{
MODULEENTRY  MdInfo;        /* module used by selected task */
int          nModRefCount;  /* nb of modules used by selected task */
WORD         npModRefTable; /* offset to find lpModRefTable  */
HMODULE far *lpModRefTable; /* pointer on hModules used by selected task */
int          Ark;
char         szFullDLLName [sizeof MdInfo.szExePath + 20];

  /* get information in hModule segment :           */
  /* This is the header of the executable           */
  /* hModule:1E : number of DLL used by a task      */
  /* hModule:28 : Adresse of table of DLLS hModules */
  MemoryRead ((WORD) hModule, 0x1E, & nModRefCount,  sizeof nModRefCount);
  MemoryRead ((WORD) hModule, 0x28, & npModRefTable, sizeof npModRefTable);
  lpModRefTable = MAKELP (hModule, npModRefTable);
  for ( Ark = 0 ;   Ark < nModRefCount ;   Ark++ )
    {
       /* Get info about the module */
       MdInfo.dwSize= sizeof MdInfo;
       if (ModuleFindHandle (& MdInfo, lpModRefTable [Ark])!=NULL)
        {
         wsprintf (szFullDLLName, "%s  <%d, %d, %s>", 
                   AnsiUpper (MdInfo.szExePath), /* full name                     */
                   MdInfo.wcUsage,               /* reference count of the module */
                   lpModRefTable[Ark],           /* Ident of module handler       */
                   szModule);                    /* parent module                 */
         if (! IsAlreadyInList (szFullDLLName))
          {         
            SendDlgItemMessage (hMainWnd, IDC_LISTWINDOWS, LB_ADDSTRING, 0, (LPARAM)(LPSTR) szFullDLLName);
            AddModules (lpModRefTable[Ark], MdInfo.szModule); /* increase Depth */
          }
        } /* Module has been found */
    } /* for each DLL used by module */
return nModRefCount;
} /* AddModules */
 
 
int DLLList (HTASK hTask)
{
TASKENTRY    TaskEntry;     /* info on selected task */
MODULEENTRY  MdInfo;        /* module used by selected task */
char         szFullDLLName [sizeof MdInfo.szExePath + 20];

   if (hTask==INVALID_TASK)  return -1;
   /* reset contents of left window */
   WindowList (hTask, 0); /* Get Title of main window */
   SendDlgItemMessage (hMainWnd, IDC_LISTWINDOWS, LB_RESETCONTENT, 0, 0l);
   /* Get hModule of current task, Get Module information */
   TaskEntry.dwSize = sizeof TaskEntry;
   if (TaskFindHandle (& TaskEntry, hTask)==0)               return -1;
   MdInfo.dwSize = sizeof MdInfo;
   if (ModuleFindHandle (& MdInfo, TaskEntry.hModule)==NULL) return -1;
   /* Find all DLL, Drv and libraries used by this task */
   AddModules (TaskEntry.hModule, MdInfo.szModule); 
   /* Add the path and ident of executable at top of list */
   wsprintf (szFullDLLName, "%s  <%d, %u>", 
             AnsiUpper(MdInfo.szExePath),
             MdInfo.wcUsage,
             TaskEntry.hModule);
   SendDlgItemMessage (hMainWnd, IDC_LISTWINDOWS, LB_INSERTSTRING, 0, (LPARAM)(LPSTR) szFullDLLName);
return 0;
} /* DLLList */


/* ------------------------------------------------------- */
/* Show task icon                                          */
/* ------------------------------------------------------- */

int ShowIcon (HICON hIcon1, HICON hIcon2, HICON hIcon3)
{
#ifdef ICONVIEW
HBRUSH hBR, hBROld;
HDC   hDC;
HWND  hIconWnd;
HICON hIconToBeShown;
char szIco [50];

#ifdef ICONHANDLE /* dispaly handle of icons */
     wsprintf ((LPSTR) szIco, (LPSTR) "%u / %u / %u", hIcon1, hIcon2, hIcon3);
     SetDlgItemText (hMainWnd, IDC_HICON, (LPSTR) szIco);
#endif     
     /* hIconWnd : handle of window to put the icon in */
     hIconWnd = GetDlgItem (hMainWnd, IDC_TASKICON);
     if ( (hDC=GetDC (hIconWnd)) == NULL ) return -1;
     SetMapMode (hDC, MM_TEXT); /* size given in pixels */
     /* erase the previous icon */
     hBR = CreateSolidBrush(GetSysColor (COLOR_WINDOW));
     hBROld = SelectObject (hDC, hBR); /* backgrd color */
     Rectangle (hDC, 0, 0, 32, 32);    /* clear zone */
     SelectObject (hDC, hBROld);       /* return to default brush */
     DeleteObject (hBR);
     /* put hIcon1, if it is NULL, hIcon2, if it NULL hIcon3 */
     hIconToBeShown = hIcon1!=0 ? hIcon1 : hIcon2!=0 ? hIcon2 : hIcon3 ;
     if (hIconToBeShown > MIN_ICON) /* do not display to low handler */
            DrawIcon  (hDC, 0, 0, hIconToBeShown);
     ReleaseDC (hMainWnd, hDC);
#endif /* ICONVIEW */
return 0;
} /* ShowIcon */



/*--------------------------------------------
   Lists all tasks
 ----------------------------------------------*/
int  TaskList (void)
{
WORD            nCur;
char            szLine [80];
TASKENTRY       TaskEntry;
BOOL            bNew ;          /* TRUE if tasks have changed   */
static HTASK    AllTask [256];  /* contains tha previous HTASKs */
static WORD     NbTask;         /* number of tasks              */
static BOOL     bSwitch;

   /* determine if the tasks has changed, if a redraw is needed     */
   if (NbTask == GetNumTasks ())  /* Number of task has not changed */
     {                            /* is a new display necessary     */  
       TaskEntry.dwSize = sizeof TaskEntry;
       TaskFirst (& TaskEntry);
       do
         { /* search for TaskEntry.hTask in AllTask array    */
           /* we can not assume that Windows give the handle */
           /* always in the same order thus                  */
           /* bNew =    TaskEntry.hTask!=AllTask[nCur++]     */
           /* is to be replaced by :                         */
           for (nCur=0 ; nCur<NbTask  &&  TaskEntry.hTask!=AllTask[nCur] ; nCur++);
           bNew = nCur==NbTask; /* search not aborted because hTask in Array */
         }
       while (TaskNext (& TaskEntry));
       if (! bNew)  return 0; /* do not update listbox */
     } 

   /* displays the number of task at top of TaskView's window */
   NbTask = GetNumTasks ();
   SendDlgItemMessage (hMainWnd, IDC_LISTTASK, LB_RESETCONTENT, 0, 0);
   wsprintf ((LPSTR) szLine, 
             (LPSTR) "%u current task%s %s", 
             NbTask, 
             NbTask==1 ? (LPSTR) "" : (LPSTR) "s",
             bSwitch ?  (LPSTR) "..." : (LPSTR) "---");
   bSwitch = ! bSwitch;
   SetDlgItemText (hMainWnd, IDC_SUMWND, szLine);
   /* memorize the tasks */
   TaskEntry.dwSize = sizeof TaskEntry;
   TaskFirst (& TaskEntry );
   nCur=0;
   do
     { 
         wsprintf ((LPSTR) szLine, (LPSTR) "%5u -> hInst %5u Module %9.9s",
                   TaskEntry.hTask, TaskEntry.hInst,(LPSTR)TaskEntry.szModule);
         SendDlgItemMessage (hMainWnd, IDC_LISTTASK, LB_ADDSTRING, 
                             0, (LPARAM) (LPSTR) szLine);
         AllTask [nCur++] = TaskEntry.hTask;
     }
   while (TaskNext (& TaskEntry) );
return nCur;
} /* TaskList */


/* ------------------------------------------ */
/* Ask for confirmation before Killing a task */
/* ------------------------------------------ */
int KillTask (HTASK hTask, UINT wMsg)
{
char Line [50];

  if (hTask==INVALID_TASK)  return -1;
  wsprintf ((LPSTR) Line, (LPSTR) "Kill Task %u ?", hTask);
  if (MBox (Line, MB_YESNO)==IDYES)  
    {
      PostAppMessage (hTask, wMsg, 0, 0);
      TerminateApp (hTask, NO_UAE_BOX);
    }
     
  hTask = INVALID_TASK;  /* force a new paint */
return 0;
} /* ChangeStatus */


/* ------------------------------------------------- */
/* Return the task id of the selected task           */
/* ------------------------------------------------- */
HTASK ReadSelectedTask (void)
{
int Ark;
char   szBuffer [128];
    Ark = (WORD) SendDlgItemMessage (hMainWnd, IDC_LISTTASK, LB_GETCURSEL, 0, 0L);
    /* No task has been selected -> can not return anything */
    if (Ark==LB_ERR)    return INVALID_TASK;
    SendDlgItemMessage (hMainWnd, IDC_LISTTASK, LB_GETTEXT, Ark, (LONG) (LPSTR) szBuffer);
return (HTASK) atoi (szBuffer);
}


/* -------------------------------------------------- */
/* Return the id of the selected window (left window) */
/* -------------------------------------------------- */
HWND ReadSelectedWnd (void)
{
int i;
char   szBuffer [128];
  /* DLL are displayed */
  if (! IS_CHOICEWND) return hTaskMainWnd;  
  i=(WORD) SendDlgItemMessage (hMainWnd, IDC_LISTWINDOWS, LB_GETCURSEL, 0, 0L);
  /* No windows has been selected -> return highest level window */
  if (i==LB_ERR)      return hTaskMainWnd; 
  /* a window has been selected return its handler */
  SendDlgItemMessage (hMainWnd, IDC_LISTWINDOWS, LB_GETTEXT,
                      i, (LONG)(LPSTR) szBuffer);
return (HWND) atoi (szBuffer);
} /* ReadSelectedWnd */


/* ------------------------------------------------- */
/* About box                                         */
/* ------------------------------------------------- */
long FAR PASCAL _export AboutProc (HWND hWnd, WORD message, WORD wParam, LONG lParam)
{
char szBuf[24];
  if (message==WM_COMMAND && wParam==IDOK)  EndDialog (hWnd, 0);
  if (message==WM_INITDIALOG)  
     {  
        wsprintf((LPSTR) szBuf, (LPSTR) "%d k", GetFreeSpace (0) / 1024);
        SetDlgItemText (hWnd, IDC_FREEMEM, szBuf);
        wsprintf((LPSTR) szBuf, (LPSTR) "%d %%",
                        GetFreeSystemResources (GFSR_SYSTEMRESOURCES));
        SetDlgItemText (hWnd, IDC_FREESYS, szBuf);
        wsprintf((LPSTR) szBuf, (LPSTR) "%d %%", 
                        GetFreeSystemResources (GFSR_GDIRESOURCES));
        SetDlgItemText (hWnd, IDC_FREEGDI, szBuf);
        wsprintf((LPSTR) szBuf, (LPSTR) "%d %%", 
                        GetFreeSystemResources (GFSR_USERRESOURCES));
        SetDlgItemText (hWnd, IDC_FREEUSER, szBuf);
     } /* initidialog */
return FALSE;
} /* AboutProc */

void AboutBox (void)
{
DLGPROC lpfnDlgProc;
     /* we create a top level window : it will appear as a task in */
     /* taskman, and as a window in TaskView                       */
     lpfnDlgProc = MakeProcInstance ((FARPROC) AboutProc, hThisInst);
     DialogBox (hThisInst,(LPSTR) "ABOUT", NULL, (DLGPROC) lpfnDlgProc);
     FreeProcInstance (lpfnDlgProc);
} /* AboutBox */



/* -------------------------------- */
/* Resize the dlg window            */
/* -------------------------------- */
int ResizeWindow (HWND hDlgWnd, unsigned nWidth, unsigned nHeight)
{
RECT    Rect;
unsigned     Scale50X, Scale50Y;


  Scale50X = (50u * nWidth)  / SCALE_X(280);
  Scale50Y = (50u * nHeight) / SCALE_Y(155);

  GetWindowRect (GetDlgItem (hDlgWnd, IDC_LISTWINDOWS), & Rect);
  /* resize right windows */
  MoveWindow   (GetDlgItem (hDlgWnd, IDC_LISTWINDOWS),
                SCALE_X(155), SCALE_Y(40),
                nWidth - SCALE_X(155) - SCALE_X(5), 
                nHeight - SCALE_Y(40) - SCALE_Y(45),
                TRUE);
  /* resizing left Window (Y only)  */              
  MoveWindow   (GetDlgItem (hDlgWnd, IDC_LISTTASK),
                SCALE_X(5), SCALE_Y(20),
                SCALE_X(145),  
                nHeight - SCALE_Y(20) - SCALE_Y(45),
                TRUE);
  /* Move switch button (hWnd/DLL) */              
  MoveWindow   (GetDlgItem (hDlgWnd, IDC_DLLWNDSWITCH),
                SCALE_X(183) + (SCALE_X (65)*Scale50X) / 50, 
                SCALE_Y (7),
                (SCALE_X (27)*Scale50X) / 50, 
                SCALE_Y(28),
                TRUE);
  /* Resize title of main wnd */
  MoveWindow   (GetDlgItem (hDlgWnd, IDC_MAINWND),
                SCALE_X(180),
                SCALE_Y (15),
                (SCALE_X (65)*Scale50X) / 50, 
                SCALE_Y(16),
                TRUE);
  /* buttons : First Raw */
  MoveWindow   (GetDlgItem (hDlgWnd, ID_END),
                (SCALE_X(10) * Scale50X) / 50,
                 nHeight - SCALE_Y(35),
                (SCALE_X(45) * Scale50X) / 50,
                 SCALE_Y(14),
                 TRUE);
  MoveWindow   (GetDlgItem (hDlgWnd, ID_SWITCHTO),
                (SCALE_X(66) * Scale50X) / 50,
                 nHeight - SCALE_Y(35),
                (SCALE_X(45) * Scale50X) / 50,
                 SCALE_Y(14),
                 TRUE);
  MoveWindow   (GetDlgItem (hDlgWnd, ID_VISIBLE),
                (SCALE_X(121) * Scale50X) / 50,
                 nHeight - SCALE_Y(35),
                (SCALE_X(45) * Scale50X) / 50,
                 SCALE_Y(14),
                 TRUE);
  MoveWindow   (GetDlgItem (hDlgWnd, ID_ONTOP),
                (SCALE_X(175) * Scale50X) / 50,
                 nHeight - SCALE_Y(35),
                (SCALE_X(45) * Scale50X) / 50,
                 SCALE_Y(14),
                 TRUE);
  /* buttons : Second Raw */
  MoveWindow   (GetDlgItem (hDlgWnd, ID_ABOUT),
                (SCALE_X(10) * Scale50X) / 50,
                 nHeight - SCALE_Y(20),
                (SCALE_X(45) * Scale50X) / 50,
                 SCALE_Y(14),
                 TRUE);
  MoveWindow   (GetDlgItem (hDlgWnd, ID_KILL),
                (SCALE_X(66) * Scale50X) / 50,
                 nHeight - SCALE_Y(20),
                (SCALE_X(45) * Scale50X) / 50,
                 SCALE_Y(14),
                 TRUE);
  MoveWindow   (GetDlgItem (hDlgWnd, ID_INVISIBLE),
                (SCALE_X(121) * Scale50X) / 50,
                 nHeight - SCALE_Y(20),
                (SCALE_X(45) * Scale50X) / 50,
                 SCALE_Y(14),
                 TRUE);
  MoveWindow   (GetDlgItem (hDlgWnd, ID_NOTONTOP),
                (SCALE_X(175) * Scale50X) / 50,
                 nHeight - SCALE_Y(20),
                (SCALE_X(45) * Scale50X) / 50,
                 SCALE_Y(14),
                 TRUE);
  /* Button Ok */
  MoveWindow   (GetDlgItem (hDlgWnd, IDOK),
                (SCALE_X(230) * Scale50X) / 50,
                 nHeight - SCALE_Y(35),
                (SCALE_X(35) * Scale50X) / 50,
                 SCALE_Y(30),
                 TRUE);
return TRUE;
} /* ResizeWindow */


/* -------------------------------- */
/* Win.INI changes                  */
/* -------------------------------- */
/* Save new width/height  */
int SaveNewPos (unsigned nLeft, unsigned nTop, unsigned nWidth, unsigned nHeight) 
{
char szLine [10];
  wsprintf (szLine, "%d", nLeft);
  WriteProfileString ("PJ-TaskMngr", "nLeftPos", szLine);
  wsprintf (szLine, "%d", nTop);
  WriteProfileString ("PJ-TaskMngr", "nTopPos", szLine);
  wsprintf (szLine, "%d", nWidth);
  WriteProfileString ("PJ-TaskMngr", "nWidth", szLine);
  wsprintf (szLine, "%d", nHeight);
  WriteProfileString ("PJ-TaskMngr", "nHeight", szLine);
return 0;
} /* SaveNewPos */


/* Get Previous Pos */
int GetPrevPos (unsigned *npLeft, unsigned *npTop, unsigned *npWidth, unsigned *npHeight) 
{
  *npLeft   = GetProfileInt ("PJ-TaskMngr", "nLeftPos", 10);
  *npTop    = GetProfileInt ("PJ-TaskMngr", "nTopPos",  10);
  *npWidth  = GetProfileInt ("PJ-TaskMngr", "nWidth",   SCALE_X(280));
  *npHeight = GetProfileInt ("PJ-TaskMngr", "nHeight",  SCALE_X(155));
return 0;
} /* SaveNewPos */


/* -------------------------------- */
/* Main Loop                        */
/* -------------------------------- */
long FAR PASCAL _export WndProc (HWND hWnd, WORD message, WORD wParam, LONG lParam)
{
static HICON  hIcon;     
static HTASK  nSelectedTask=INVALID_TASK; /* selected Task */
HWND   hCurWnd;     

  switch (message)
    {
             
       case WM_INITDIALOG :
          {unsigned nLeft, nTop;
             hMainWnd = hWnd;
             hIcon = LoadIcon  (hThisInst, "TASK_ICO");
             SetDlgItemText (hWnd, IDC_DLLWNDSWITCH, CHOICE_DLL);
             /* use lParam to store both width and Height of main window */
             GetPrevPos (& nLeft, & nTop, & (WORD) lParam, (& (WORD) lParam) + 1);
             MoveWindow (hWnd, nLeft, nTop, LOWORD(lParam), HIWORD(lParam), FALSE);
             break;
          }
       case WM_GETMINMAXINFO :
             ((MINMAXINFO far *) lParam)->ptMinTrackSize.x = SCALE_X(160);
             ((MINMAXINFO far *) lParam)->ptMinTrackSize.y = SCALE_X(120);
             break;            

       case WM_SIZE :
             if (wParam==SIZE_RESTORED)
               {RECT Rect; 
                 GetWindowRect (hWnd, & Rect);
                 SaveNewPos (Rect.left, Rect.top,Rect.right-Rect.left,Rect.bottom-Rect.top);
                 return ResizeWindow (hWnd, LOWORD (lParam), HIWORD (lParam));
               }
             break;  
             
       case WM_MOVE :
          {RECT Rect; 
             GetWindowRect (hWnd, & Rect);
             SaveNewPos (Rect.left, Rect.top,Rect.right-Rect.left,Rect.bottom-Rect.top);
             break;  
          }

       /* prevent blinking icon */
       case WM_ERASEBKGND:
            return IsIconic(hWnd);   

       /* Our app should at least answer properly to this message !! */
       case WM_QUERYDRAGICON :
            return hIcon;

#ifdef TASK_MANAGER
       case WM_ACTIVATEAPP : /* task is being desctivated */
            if (!wParam  &&  LOWORD(lParam)!=hThisTask) 
                { DestroyIcon (hIcon); EndDialog (hWnd, 0); }
            break;    
#endif

       case WM_CLOSE :
       case WM_DESTROY :
            DestroyIcon (hIcon);
            EndDialog (hWnd, 0);
            break;


       case WM_COMMAND :
            switch (wParam)
              {
                 case IDC_LISTTASK :
                    if (HIWORD(lParam) == LBN_SELCHANGE)  
                        { 
                          hTaskIcon = hTaskIconJoker = hTaskIconJokerBis = 0; 
                          nSelectedTask = ReadSelectedTask ();
                          if (nSelectedTask!=INVALID_TASK)
                           {
                             if (IS_CHOICEWND)  WindowList (nSelectedTask, 0);
                             else               DLLList (nSelectedTask);
                             ShowIcon ( hTaskIcon, hTaskIconJoker, hTaskIconJokerBis );
                           }
                        }
                    else if (HIWORD(lParam) == LBN_DBLCLK)  /* Double Click */
                         SwitchToThisWindow (ReadSelectedWnd (), 1);
                    break;

                 case IDC_LISTWINDOWS :
                    if (HIWORD(lParam) == LBN_DBLCLK)  /* Double Click */  
                         SwitchToThisWindow (ReadSelectedWnd (), 1);
                    break;

                 case IDOK :
                    DestroyIcon (hIcon);
                    EndDialog (hWnd, 0);
                    break;

                 case ID_ABOUT :
                    AboutBox ();
                    break;

                 case ID_VISIBLE :
                 case ID_INVISIBLE :
                    if ((hCurWnd=ReadSelectedWnd ()) == NULL)  break;
                    SetWindowPos (hCurWnd, 
                                  HWND_BOTTOM,
                                  0, 0, 0, 0, 
                                  SWP_NOMOVE | SWP_NOSIZE
                                  | (wParam==ID_VISIBLE ? SWP_SHOWWINDOW : 
                                  SWP_HIDEWINDOW) );
                    break;
                                      

                 case ID_SWITCHTO :
                    SwitchToThisWindow (ReadSelectedWnd (), 1);
                    break;
                    
                 case ID_KILL :
                    KillTask (ReadSelectedTask(), WM_QUIT);
                    break;

                 case ID_END : 
                    hCurWnd = ReadSelectedWnd ();
                    PostMessage (hCurWnd, WM_CLOSE, 0, 0l);
                    break;                    
                 
                 case ID_ONTOP :
                 case ID_NOTONTOP :
                    SetWindowPos (ReadSelectedWnd (), 
                                  wParam==ID_ONTOP ? HWND_TOPMOST : HWND_NOTOPMOST,
                                  0, 0, 0, 0, 
                                  SWP_NOMOVE | SWP_NOREDRAW | SWP_NOSIZE );
                    break;  
                    
                 case IDC_DLLWNDSWITCH :
                    SetDlgItemText (hWnd, IDC_DLLWNDSWITCH, IS_CHOICEWND ? CHOICE_WND : CHOICE_DLL);
                    PostMessage (hWnd, WM_PAINT, 0, 0l);
                    break;
                    
              } /* switch WM_COMMAND */
            break; 

       case WM_PAINT:
            if(IsIconic(hWnd)) /* we draw our icon */
               {PAINTSTRUCT ps;
                  BeginPaint(hWnd, &ps);
                  SendMessage (hWnd, WM_ICONERASEBKGND, ps.hdc, 0L);
                  DrawIcon(ps.hdc, 1, 1, 0);
                  EndPaint(hWnd, &ps);
                  return TRUE;  /* do not let windows draw something */
               }  /* draw icon */
            if (TaskList () > 0) /* if task windows has been updated */
               {
                  SendDlgItemMessage (hWnd, IDC_LISTWINDOWS, LB_RESETCONTENT, 0, 0l);
                  SetDlgItemText (hWnd, IDC_MAINWND, (LPSTR) "");
                  nSelectedTask=INVALID_TASK; /* suppress selection */
               }
            /* force new display */
            if (nSelectedTask!=INVALID_TASK)
               {
                  if (IS_CHOICEWND)  WindowList (nSelectedTask, hIcon);
                  else               DLLList (nSelectedTask);
                  ShowIcon (hTaskIcon, hTaskIconJoker, hTaskIconJokerBis);
               }
            break;
                       
   }
return FALSE;
} /* MAIN Callback */




/* ----------------------------- */
/* WinMain                       */
/* ----------------------------- */
int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
FARPROC lpfnNotifyProc;
DLGPROC lpfnDlgProc;

#ifdef ONE_INSTANCE
HWND   hFirstInstWnd;
    if (hPrevInstance!=NULL)
      {
      
        hFirstInstWnd = FindWindow (NULL, "Task Viewer");
        SwitchToThisWindow (hFirstInstWnd, 1);
        return FALSE;  /* stop now */
      } /* an instance is already running */
#endif /* ifdef ONE_INSTANCE */

     hThisInst = hInstance;
     hThisTask=GetCurrentTask ();
#ifdef CTL3D     
     Ctl3dRegister (hInstance);
     Ctl3dAutoSubclass (hInstance);
#endif /* Ctrl 3d */
    

     lpfnNotifyProc = MakeProcInstance ((FARPROC) NotifyRegisterCallBack, hInstance);
     NotifyRegister (0, (LPFNNOTIFYCALLBACK) lpfnNotifyProc, NF_NORMAL);
     lpfnDlgProc = MakeProcInstance ((FARPROC) WndProc, hInstance);
     DialogBox (hInstance,(LPSTR) "TASKVIEWER", 0, (DLGPROC) lpfnDlgProc);
     FreeProcInstance (lpfnDlgProc);
     NotifyUnRegister (0);
     FreeProcInstance (lpfnNotifyProc);


#ifdef CTL3D     
     Ctl3dUnregister (hInstance);
#endif /* Ctrl 3d */
return 0;
} /* WinMain */

