{********************************************}
{*                                          *}
{*   KNOB25.PAS generated from KNOB25.VBX   *}
{*                                          *}
{********************************************}

unit Knob25;

interface

uses SysUtils, Classes, Graphics, Forms, Controls, VBXCtrl, BIVBX;

{ $DEFINE InitTKnob}
{^- Remove space to enable default init data -- See documentation. }

type
  TKnobTurnEvent = procedure (Sender: TObject) of object;

  { TKnob }

  TKnob = class(TVBXControl)
  protected
    FOnTurn: TKnobTurnEvent;
    { Event handler }
    procedure HandleVBXEvent(var Message: TWMVBXFireEvent); override;
    procedure DefineProperties(Filer: TFiler); override;
  public
    constructor Create(AOwner: TComponent); override;

    property Index: TVBInteger index 0 read GetIntProp;
    property FontName: TVBString index 13 read GetStringProp write
      SetStringProp;
    property FontBold: Boolean index 14 read GetBoolProp write SetBoolProp;
    property FontItalic: Boolean index 15 read GetBoolProp write SetBoolProp;
    property FontStrikethru: Boolean index 16 read GetBoolProp write
      SetBoolProp;
    property FontUnderline: Boolean index 17 read GetBoolProp write
      SetBoolProp;
    property FontSize: Single index 18 read GetSingleProp write SetSingleProp;
    property AVersion: Single index 19 read GetSingleProp write SetSingleProp;
    property ZLoad: TVBInteger index 20 read GetIntProp write SetIntProp;
    property Angle: Single index 39 read GetSingleProp write SetSingleProp;
    property XScale: Single index 40 read GetSingleProp write SetSingleProp;
    property YScale: Single index 41 read GetSingleProp write SetSingleProp;
    property Radius: Single index 42 read GetSingleProp write SetSingleProp;
    property Value: Single index 43 read GetSingleProp write SetSingleProp;
    property Redraw: Boolean index 103 read GetBoolProp write SetBoolProp;
    property RedrawStatic: Boolean index 104 read GetBoolProp write
      SetBoolProp;
  published
    property Enabled;
    property Visible;
    property MousePointer: TVBEnum index 8 read GetEnumProp write SetEnumProp
      default 0;
    property TabOrder;
    property TabStop;
    property About: TVBString index 21 read GetStringProp {NoRT}write
      SetStringProp stored False;
    property BorderType: TVBEnum index 22 read GetEnumProp write SetEnumProp;
    property BevelWidth: TVBInteger index 23 read GetIntProp write SetIntProp;
    property BevelInner: TVBEnum index 24 read GetEnumProp write SetEnumProp;
    property BevelOuter: TVBEnum index 25 read GetEnumProp write SetEnumProp;
    property BorderWidth: TVBInteger index 26 read GetIntProp write
      SetIntProp;
    property OutlineTitle: TVBString index 27 read GetStringProp write
      SetStringProp;
    property OutlineColor: TColor index 28 read GetColorProp write
      SetColorProp;
    property OutlineWidth: TVBInteger index 29 read GetIntProp write
      SetIntProp;
    property OutlineAlign: TVBEnum index 30 read GetEnumProp write
      SetEnumProp;
    property FrameStyle: TVBEnum index 31 read GetEnumProp write SetEnumProp;
    property FrameScaleX: Single index 32 read GetSingleProp write
      SetSingleProp;
    property FrameScaleY: Single index 33 read GetSingleProp write
      SetSingleProp;
    property FrameColor: TColor index 34 read GetColorProp write SetColorProp;
    property FramePicture: TVBPic index 35 read GetPictureProp write
      SetPictureProp stored False;
    property BackgroundColor: TColor index 36 read GetColorProp write
      SetColorProp;
    property BackgroundPicture: TVBPic index 37 read GetPictureProp write
      SetPictureProp stored False;
    property MouseControl: Boolean index 38 read GetBoolProp write
      SetBoolProp;
    property ScaleStartAngle: Single index 44 read GetSingleProp write
      SetSingleProp stored False;
    property ScaleStopAngle: Single index 45 read GetSingleProp write
      SetSingleProp stored False;
    property ScaleMinValue: Single index 46 read GetSingleProp write
      SetSingleProp stored False;
    property ScaleMaxValue: Single index 47 read GetSingleProp write
      SetSingleProp stored False;
    property ScaleDirection: TVBEnum index 48 read GetEnumProp write
      SetEnumProp stored False;
    property ScaleOriginX: Single index 49 read GetSingleProp write
      SetSingleProp stored False;
    property ScaleOriginY: Single index 50 read GetSingleProp write
      SetSingleProp stored False;
    property Tics: TVBInteger index 51 read GetIntProp write SetIntProp
      stored False;
    property TicID: TVBInteger index 52 read GetIntProp write SetIntProp
      stored False;
    property TicStyle: TVBEnum index 53 read GetEnumProp write SetEnumProp
      stored False;
    property TicInnerRadius: Single index 54 read GetSingleProp write
      SetSingleProp stored False;
    property TicOuterRadius: Single index 55 read GetSingleProp write
      SetSingleProp stored False;
    property TicLabelRadius: Single index 56 read GetSingleProp write
      SetSingleProp stored False;
    property TicWidth: Single index 57 read GetSingleProp write SetSingleProp
      stored False;
    property TicStartValue: Single index 58 read GetSingleProp write
      SetSingleProp stored False;
    property TicStopValue: Single index 59 read GetSingleProp write
      SetSingleProp stored False;
    property TicDeltaValue: Single index 60 read GetSingleProp write
      SetSingleProp stored False;
    property TicLabel: Boolean index 61 read GetBoolProp write SetBoolProp
      stored False;
    property TicColor: TColor index 62 read GetColorProp write SetColorProp
      stored False;
    property TicFontID: TVBInteger index 63 read GetIntProp write SetIntProp
      stored False;
    property Annulars: TVBInteger index 64 read GetIntProp write SetIntProp
      stored False;
    property AnnularID: TVBInteger index 65 read GetIntProp write SetIntProp
      stored False;
    property AnnularStartValue: Single index 66 read GetSingleProp write
      SetSingleProp stored False;
    property AnnularStopValue: Single index 67 read GetSingleProp write
      SetSingleProp stored False;
    property AnnularColor: TColor index 68 read GetColorProp write
      SetColorProp stored False;
    property AnnularInnerRadius: Single index 69 read GetSingleProp write
      SetSingleProp stored False;
    property AnnularOuterRadius: Single index 70 read GetSingleProp write
      SetSingleProp stored False;
    property Captions: TVBInteger index 71 read GetIntProp write SetIntProp
      stored False;
    property CaptionID: TVBInteger index 72 read GetIntProp write SetIntProp
      stored False;
    property Caption: TVBString index 73 read GetStringProp write
      SetStringProp stored False;
    property CaptionX: Single index 74 read GetSingleProp write SetSingleProp
      stored False;
    property CaptionY: Single index 75 read GetSingleProp write SetSingleProp
      stored False;
    property CaptionColor: TColor index 76 read GetColorProp write
      SetColorProp stored False;
    property CaptionFontID: TVBInteger index 77 read GetIntProp write
      SetIntProp stored False;
    property KnobStyle: TVBEnum index 78 read GetEnumProp write SetEnumProp;
    property KnobUserDefined: TVBString index 79 read GetStringProp write
      SetStringProp;
    property KnobRadius: Single index 80 read GetSingleProp write
      SetSingleProp;
    property KnobValue: Single index 81 read GetSingleProp write
      SetSingleProp;
    property KnobColor: TColor index 82 read GetColorProp write SetColorProp;
    property KnobMultiTurn: Boolean index 83 read GetBoolProp write
      SetBoolProp;
    property KnobMultiTurnValue: Single index 84 read GetSingleProp write
      SetSingleProp;
    property KnobSnap: Boolean index 85 read GetBoolProp write SetBoolProp;
    property KnobSnapIncrement: Single index 86 read GetSingleProp write
      SetSingleProp;
    property KnobPicture: TVBPic index 87 read GetPictureProp write
      SetPictureProp stored False;
    property MarkStyle: TVBEnum index 88 read GetEnumProp write SetEnumProp
      stored False;
    property MarkUserDefined: TVBString index 89 read GetStringProp write
      SetStringProp;
    property MarkColor: TColor index 90 read GetColorProp write SetColorProp
      stored False;
    property MarkInnerRadius: Single index 91 read GetSingleProp write
      SetSingleProp stored False;
    property MarkOuterRadius: Single index 92 read GetSingleProp write
      SetSingleProp stored False;
    property MarkWidth: Single index 93 read GetSingleProp write
      SetSingleProp stored False;
    property Digital: Boolean index 94 read GetBoolProp write SetBoolProp;
    property DigitalX: Single index 95 read GetSingleProp write SetSingleProp;
    property DigitalY: Single index 96 read GetSingleProp write SetSingleProp;
    property DigitalDecimals: TVBInteger index 97 read GetIntProp write
      SetIntProp;
    property DigitalColor: TColor index 98 read GetColorProp write
      SetColorProp;
    property DigitalFontID: TVBInteger index 99 read GetIntProp write
      SetIntProp;
    property FontID: TVBInteger index 100 read GetIntProp write SetIntProp;
    property Fonts: TVBInteger index 101 read GetIntProp write SetIntProp
      stored False;
    property AutoRedraw: Boolean index 102 read GetBoolProp write SetBoolProp;
    property FontDialog_: TVBString index 105 read GetStringProp {NoRT}write
      SetStringProp stored False;
    property OnClick;
    property OnDragDrop;
    property OnEndDrag;
    property OnDragOver;
    property OnEnter;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnTurn: TKnobTurnEvent read FOnTurn write FOnTurn;
  end;

procedure Register;

implementation

{ Default form data for TKnob }

{$IFDEF InitTKnob}

const
  TKnobInitLen = 332;

procedure TKnobInitData; near; assembler;
asm
	DB	$00,$00,$00,$02,$06,$FF,$FF,$07,$FF,$FF,$08,$00,$09,$00,$00,$0A
	DB	$00,$00,$0B,$00,$0C,$04,$4B,$6E,$6F,$62,$13,$00,$00,$20,$40,$14
	DB	$01,$00,$00,$00,$00,$00,$00,$00,$5C,$43,$00,$00,$0C,$43,$00,$00
	DB	$00,$00,$00,$00,$20,$41,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$E0,$41,$00,$00,$E0,$41,$00,$00,$5C,$43,$00,$00,$FA,$43
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DB	$00,$00,$00,$00,$33,$33,$33,$3F,$9A,$99,$59,$3F,$00,$00,$80,$3F
	DB	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$20,$41,$00,$00,$80,$3F
	DB	$01,$00,$00,$00,$00,$00,$00,$00,$00,$00,$01,$00,$10,$00,$07,$00
	DB	$00,$00,$00,$00,$BC,$02,$00,$00,$00,$00,$01,$02,$02,$22,$53,$79
	DB	$73,$74,$65,$6D,$00,$00,$53,$65,$72,$69,$66,$00,$80,$0C,$0C,$0C
	DB	$26,$6C,$74,$0A,$02,$00,$36,$F5,$02,$00,$97,$05,$00,$00,$16,$01
	DB	$17,$02,$00,$18,$01,$19,$02,$1A,$02,$00,$1B,$00,$1C,$00,$00,$00
	DB	$00,$1D,$00,$00,$1E,$00,$1F,$00,$20,$00,$00,$00,$00,$21,$00,$00
	DB	$00,$00,$22,$00,$00,$00,$00,$24,$C0,$C0,$C0,$00,$26,$FF,$FF,$27
	DB	$00,$00,$00,$00,$28,$00,$00,$00,$00,$29,$00,$00,$00,$00,$2A,$00
	DB	$00,$00,$00,$2B,$00,$00,$00,$00,$4E,$02,$4F,$00,$50,$9A,$99,$19
	DB	$3F,$51,$00,$00,$00,$00,$52,$80,$80,$80,$00,$53,$00,$00,$54,$00
	DB	$00,$00,$00,$55,$00,$00,$56,$00,$00,$80,$3F,$59,$00,$5E,$00,$00
	DB	$5F,$00,$00,$00,$00,$60,$00,$00,$00,$00,$61,$00,$00,$62,$00,$00
	DB	$00,$00,$63,$00,$00,$64,$00,$00,$66,$FF,$FF,$FF
end;

{$ENDIF}

{ TKnob }

constructor TKnob.Create(AOwner: TComponent);
begin
  FVBXFile := StrNew('KNOB25.VBX');
  FVBXClass := StrNew('KNOB');
  SetBounds(0, 0, 80, 32);
  inherited Create(AOwner);
  ControlStyle := ControlStyle - [csCaptureMouse, csClickEvents];
  TabStop := True;
  FVBXFlags := [vfLoadMessage];
  {$IFDEF InitTKnob}
  FHForm := VBXCreateFormFile(TKnobInitLen, @TKnobInitData);
  {$ENDIF}
end;

procedure TKnob.HandleVBXEvent(var Message: TWMVBXFireEvent);
begin
  case Message.VBXEvent^.EventIndex of
    0: DispatchNotifyEvent(OnClick);
    1: begin end; { VCL Handles OnDragDrop }
    2: begin end; { VCL Handles OnDragOver }
    3: begin end; { VCL Handles OnGotFocus }
    4: DispatchKeyEvent(OnKeyDown, Message);
    5: DispatchKeyPressedEvent(OnKeyPress, Message);
    6: DispatchKeyEvent(OnKeyUp, Message);
    7: begin end; { VCL Handles OnLostFocus }
    8: DispatchMouseEvent(OnMouseDown, Message);
    9: DispatchMouseMoveEvent(OnMouseMove, Message);
    10: DispatchMouseEvent(OnMouseUp, Message);
    11: DispatchCustomEvent(FOnTurn, Message, 11);
  end;
end;

procedure TKnob.DefineProperties(Filer: TFiler);
begin
  inherited DefineProperties(Filer);
  HandleProperty('AVersion', Filer, 19);
  HandleBinaryProperty('ZLoad', Filer, 20);
  HandleBinaryProperty('FramePicture_Data', Filer, 35);
  HandleBinaryProperty('BackgroundPicture_Data', Filer, 37);
  HandleProperty('Angle', Filer, 39);
  HandleProperty('XScale', Filer, 40);
  HandleProperty('YScale', Filer, 41);
  HandleProperty('Radius', Filer, 42);
  HandleProperty('Value', Filer, 43);
  HandleBinaryProperty('KnobPicture_Data', Filer, 87);
end;

{ Designer registration }
procedure Register;
begin
  RegisterComponents('VBX', [
    TKnob]);
end;

end.
