/* CATALA.CMD: Installaci de MEMSIZE en catal */

"@Echo Off"
'CHCP 850'

/* Crregar REXXUTIL */

Call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
Call SysLoadFuncs


/* Initialize */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say "Installaci de MEMSIZE..."
Say ""


/* Verify the existence of the various component files. */

Language = "CATALA"

Result = SysFileTree( "MEMSIZE.EXE", "Files", "F" )
If Files.0 = 0 Then
  Do
  Say "ERROR: No se troba el MEMSIZE.EXE!"
  Signal DONE
  End

Result = SysFileTree( Language".DLL", "Files", "F" )
If Files.0 = 0 Then
  Do
  Say "ERROR: No se troba el "Language".DLL!"
  Signal DONE
  End

Result = SysFileTree( Language".HLP", "Files", "F" )
If Files.0 = 0 Then
  Do
  Say "ERROR: No se troba el "Language".HLP!"
  Signal DONE
  End

/* Ask for the target directory name. */

Say "Si us plau, escribiu el nom complet del directori on voleu"
Say "  installar el programa MEMSIZE (per defecte s C:\OS2\APPS): "
Parse Pull Directory
If Directory = "" Then Directory = "C:\OS2\APPS"


/* Create the target directory if necessary. */

Result = SysFileTree( Directory, "Dirs", "D" )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say "ERROR: No se pot crear el directori dest."
    Signal DONE
    End
  End
Say ""


/* Ask for the target folder. */

Say "Voleu installar-lo de forma que s'executi automticament a l'arrencar? (S/N)"
Pull YesNo
If YesNo = "S" Then
  Do
  Folder = "<WP_START>"
  Say "L'objecte es copiar a la carpeta Inici."
  End
Else
  Do
  Folder = "<WP_DESKTOP>"
  Say "L'objecte es copiar a l'escriptori."
  End
Say ""


/* Destroy the old object, if present. */

Call SysDestroyObject( '<MEMSIZE>' )
Call SysSleep( 5 )


/* Perform the installation. */

Say "Copiant MEMSIZE al directori " Directory "..."
Copy MEMSIZE.EXE Directory                  "1>NUL"
Copy Language".DLL" Directory"\MEMSIZE.DLL" "1>NUL"
Copy Language".HLP" Directory"\MEMSIZE.HLP" "1>NUL"
Copy Language".DOC" Directory"\MEMSIZE.DOC" "1>NUL"

Result = SysFileTree( "HLP2INF.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Result = SysFileTree( Directory"\MEMSIZE.INF", 'Files', 'F' )
   If Files.0 > 0 Then
      Do
      "Erase" Directory"\MEMSIZE.INF"
      End
   "HLP2INF" Directory"\MEMSIZE.HLP"
   End

Result = SysFileTree( "SNAPSHOT.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Copy "SNAPSHOT.EXE" Directory"\SNAPSHOT.EXE"  '1>NUL'
   End

Say "Creant l'objecte del programa..."
Type = "WPProgram"
Title = "Recursos del Sistema"
Parms = "OPEN=DEFAULT;MINWIN=DESKTOP;PROGTYPE=PM;EXENAME="Directory"\MEMSIZE.EXE;STARTUPDIR="Directory";OBJECTID=<MEMSIZE>;NOPRINT=YES;"
Result = SysCreateObject( Type, Title, Folder, Parms, "ReplaceIfExists" )

If Result = 1 Then
  Say "L'objecte s'ha creat.  Final"
Else
  Say "ERROR: No s'ha pogut crear l'objecte!"

Signal DONE

FAILURE:
Say "Errada del REXX."
Signal DONE

HALT:
Say "S'atura el REXX."
Signal DONE

SYNTAX:
Say "Error de sntaxi del REXX."
Signal DONE

DONE:
Exit
