/* NORSK.CMD: Installerer MEMSIZE p norsk. */

'@Echo Off'
'CHCP 850'

/* Hent REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialiser */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installerer MEMSIZE...'
Say ''


/* Sjekk eksistensen av de forskjellige komponentfilene. */

Language = 'NORSK'

Result = SysFileTree( 'MEMSIZE.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEIL: MEMSIZE.EXE ikke funnet!'
  Signal DONE
  End

Result = SysFileTree( Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEIL: 'Language'.DLL ikke funnet!'
  Signal DONE
  End

Result = SysFileTree( Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'FEIL: 'Language'.HLP ikke funnet!'
  Signal DONE
  End

/* Spr etter installasjonskatalogen. */

Say 'Vennligst oppgi fullt navn for den katalogen hvor du nsker'
Say '  MEMSIZE installert (standard C:\OS2\APPS): '
Parse Pull Directory
If Directory = "" Then Directory = 'C:\OS2\APPS'


/* Lag installasjonskatalogen om ndvendig. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'FEIL: Kan ikke opprette installasjonskatalogen.'
    Signal DONE
    End
  End
Say ''


/* Spr etter ml-katalog. */

Say 'nsker du  plassere MEMSIZE i oppstart-katalogen? (J/N)'
Pull YesNo
If YesNo = "J" Then
  Do
  Folder = '<WP_START>'
  Say 'Programobjekt plasseres i oppstart-katalogen.'
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say 'Programobjekt plasseres p arbeidsomrdet.'
  End
Say ''


/* Destroy the old object, if present. */

Call SysDestroyObject( '<MEMSIZE>' )
Call SysSleep( 5 )


/* Gjr installasjonen. */

Say 'Kopierer MEMSIZE til ' Directory '...'
Copy MEMSIZE.EXE Directory                  '1>NUL'
Copy Language".DLL" Directory"\MEMSIZE.DLL" '1>NUL'
Copy Language".HLP" Directory"\MEMSIZE.HLP" '1>NUL'
Copy Language".DOC" Directory"\MEMSIZE.DOC" "1>NUL"

Result = SysFileTree( "HLP2INF.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Result = SysFileTree( Directory"\MEMSIZE.INF", 'Files', 'F' )
   If Files.0 > 0 Then
      Do
      "Erase" Directory"\MEMSIZE.INF"
      End
   "HLP2INF" Directory"\MEMSIZE.HLP"
   End

Result = SysFileTree( "SNAPSHOT.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Copy "SNAPSHOT.EXE" Directory"\SNAPSHOT.EXE"  '1>NUL'
   End

Say 'Oppretter programobjekt...'
Type = 'WPProgram'
Title = 'Systemressurser'
Parms = 'OPEN=DEFAULT;MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\MEMSIZE.EXE;STARTUPDIR='Directory';OBJECTID=<MEMSIZE>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
  Say 'Objekt opprettet!  Ferdig.'
Else
  Say 'FEIL: Objekt ikke opprettet.'

Signal DONE

FAILURE:
Say 'REXX feil.'
Signal DONE

HALT:
Say 'REXX stoppet.'
Signal DONE

SYNTAX:
Say 'REXX syntaks feil.'
Signal DONE

DONE:
Exit
