#include <dos.h>
#include <stdlib.h>
#include <process.h>
#include <conio.h>
#include <string.h>
#include <stdio.h>

#include "mouse.h"

int numgames=0;
int azi,tilt;

int currentangle=0;
int currenttilt=0;
int buttonstate;

int xmickeys;
int ymickeys;
unsigned short int buttons;
int tiltdiff;
int tiltsign;
int subfunction;
int joybits;

#define      VR_RUNBUTTON           (0)
#define      VR_STRAFELEFTBUTTON    (1)
#define      VR_STRAFERIGHTBUTTON   (2)
#define      VR_ATTACKBUTTON        (3)
#define      VR_LOOKUPBUTTON        (4)
#define      VR_LOOKDOWNBUTTON      (5)
#define      VR_SWAPWEAPONBUTTON    (6)
#define      VR_USEBUTTON           (7)
#define      VR_HORIZONUPBUTTON     (8)
#define      VR_HORIZONDOWNBUTTON   (9)
#define      VR_MAPBUTTON           (10)
#define      VR_PISTOLBUTTON        (11)
#define      VR_DUALPISTOLBUTTON    (12)
#define      VR_MP40BUTTON          (13)
#define      VR_MISSILEWEAPONBUTTON (14)
#define      VR_RECORDBUTTON        (15)

void far interrupt (*oldmouse)();
void gettrackerstatus ( void );

void mousehandler
   (
   void
   )

   {
   subfunction = _AX;
   xmickeys = 0;
   ymickeys = 0;
   buttons = 0;
   switch (subfunction)
      {
      case 0:
	      _AX = 0xffff;
         _BX = 2;
         goto mouseexit;
      case 0x30:
         currentangle = _BX;
         currenttilt = _CX;
         gettrackerstatus();
         xmickeys = (currentangle - 512 - azi)&2047;
         if (xmickeys > 1024)
            xmickeys -= 2048;
         if (abs(xmickeys)<6)
            xmickeys = 0;
         else
            xmickeys *= 3;

         tiltdiff = (tilt - currenttilt)&2047;
         if (tiltdiff > 1024)
            tiltdiff -= 2048;

         tiltsign = (tiltdiff<0);

         if (abs(tiltdiff) > 60)
            {
            buttons |= (1<<VR_LOOKUPBUTTON)<<tiltsign;
            }
         else if (abs(tiltdiff) > 6)
            {
            buttons |= (1<<VR_HORIZONUPBUTTON)<<tiltsign;
            }

         joybits = inp (0x201);  // Get all the joystick buttons
         joybits >>= 4;          // only the high bits are useful
         joybits ^= 15;          // return with 1=pressed
         buttons |= ((joybits&1)<<VR_ATTACKBUTTON);
         buttons |= ( ( (joybits>>1) & 1 ) << VR_USEBUTTON );
         if ((joybits>>2) & 1 )
            {
            ymickeys = -128;
            }
         else if ((joybits>>3) & 1 )
            {
            ymickeys = 128;
            }
         break;
      case 0x31:
      default:
         _AX = 0;
         _BX = 0;
         _CX = 0;
         _DX = 0;
         goto mouseexit;
      }
   _AX = 0;
   _BX = buttons;
   _DX = ymickeys;
   _CX = xmickeys;
mouseexit:
   }

void mouse_set()
{
	oldmouse = getvect( 0x33);
	setvect( 0x33,mousefn);
}

void mouse_restore()
{
	setvect( 0x33, oldmouse);
}

char *s="O1,4,1\n";


void main ()
{

	int i;


	printf("\n\nHead_Tracker: Init Device Drivers\n");

	mouse_set();


   for (i=0;i<7;i++)
	{
		outportb(0x300,s[i]);
		delay(50);
	}

	numgames = -1;
	system("rott.exe now silly enablevr timelimit 360 maxtimelimit 1000");

	mouse_restore();
	printf("Head_Tracker: Restore Device State\n");
	printf("\n# of games played %d\n", numgames);

}
