/* MPVGA.C main module of MPVGA lib, contains common IO functions, the
   high level functions and variable declarations.

   Copyright (c) 1995 Lin Ke-Fong, Ethereal Software.
*/

#include <conio.h>
#include <dos.h>
#include "mpvga.h"

/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
/* variable declarations: */
int IOAdr; /* IO address used by some chips */
int CRTC;  /* CRTC address */

int MPVGA_ChipType;   /* chip number */
int MPVGA_ChipVer;    /* version number */

int MPVGA_VideoRAMSize; /* size of the video RAM */
int MPVGA_BiosVRAMSize;
/* video RAM size reported by BIOS functions if available
   note: MPVGA functions only use MPVGA_VideoRAMSize. Trust no one !
   	 The truth is out there ! */

/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */

/* === high level functions === */

void MPVGA_SetActivePage (int PageNumber)
/* Select the current writing/reading page. */

{
  MPVGA_SetWriteBank(PageNumber);
  MPVGA_SetReadBank(PageNumber);

  return;
}


void MPVGA_SetVisualPage (int PageNumber)
/* Select the current visual (displayed on screen) page. */

{
  int XPosition, YPosition;

  XPosition = ((256 * PageNumber) % 320);
  YPosition = (204 * PageNumber) + ((256 * PageNumber) / 320);

  MPVGA_SetVStart(XPosition, YPosition);

  return;
}

/* ====================================================================== */

/* === low level functions === */

int rdinx(int pt, int inx)

{
  if (pt == 0x03C0) inp(CRTC+6);
  outp(pt,inx);
  return inp(pt+1);
}

void wrinx (int pt, int inx, int val)

{
  if (pt == 0x03C0) {
    inp(CRTC+6);
    outp(0x3C0,inx);
    outp(0x3C0,val);
  } else {
    outp(pt,inx);
    outp(pt+1,val);
  }
  return;
}

void wrinx3 (int pt, int inx, long val)

{
  wrinx(pt,inx,val & 0xFF);
  wrinx(pt,inx+1,(val >> 8) & 0xFF);
  wrinx(pt,inx+2,val >> 16);

  return;
}

void modinx(int pt, int inx, int mask, int nwv)
{
  unsigned char temp;
  temp = (rdinx(pt,inx) & (~mask))+(nwv & mask);
  wrinx(pt,inx,temp);
  return;
}

void setinx(int pt, int inx, int val)

{
  int x;

  x = rdinx(pt,inx);
  wrinx(pt,inx,x | val);
  return;
}

void clrinx(int pt, int inx, int val)

{
  int x;
  x = rdinx(pt,inx);
  wrinx(pt,inx,x & (~val));
  return;
}

int tstrg(int pt, int msk)

{
  int old,nw1,nw2;

  old = inp(pt);
  outp(pt,old & (~msk));
  nw1 = inp(pt) & msk;
  outp(pt,old | msk);
  nw2 = inp(pt) & msk;
  outp(pt,old);
  return ((nw1 == 0) && (nw2 == msk));
}

int testinx2(int pt, int rg, int msk)

{
  int old,nw1,nw2;

  old = rdinx(pt,rg);
  wrinx(pt,rg,old & (~msk));
  nw1 = rdinx(pt,rg) & msk;
  wrinx(pt,rg,old | msk);
  nw2 = rdinx(pt,rg) & msk;
  wrinx(pt,rg,old);

  return (nw1 == 0) && (nw2 == msk);
}

int testinx(int pt, int rg)

{
  return testinx2(pt,rg,0x0FF);
}

void HalfCRTC (void)

{
  int r0,r1,r2,r3,r4,r5,old;

  old = rdinx(CRTC,0x11);
  clrinx(CRTC,0x11,0x80);
  r0 = rdinx(CRTC,0)+5;
  r1 = rdinx(CRTC,1)+1;
  r2 = rdinx(CRTC,2);
  r3 = rdinx(CRTC,3) & 0x1F;
  r4 = rdinx(CRTC,4);
  r5 = rdinx(CRTC,5) & 0x1F;
  if ((rdinx(CRTC,5) & 0x80) > 0) r3 += 0x20;
  r3 = (r2 & 0xFFC0)+r3;
  if (r3 <= r2) r3 += 0x40;
  r5 = (r4 & 0xFFE0)+r5;
  if (r5 <= r4) r5 += 0x20;

  r0 = r0 / 2;
  r1 = r1 / 2;
  r2 = r2 / 2;
  r3 = r3 / 2;
  r4 = r4 / 2;
  r5 = r5 / 2;
  if (r3 >= r0-1) r3 -= 1;
  wrinx (CRTC,0,r0-5);
  wrinx (CRTC,1,r1-1);
  wrinx (CRTC,2,r2);
  modinx(CRTC,3,0x1F,r3);
  wrinx (CRTC,4,r4);
  modinx(CRTC,5,0x1F,r5);
  modinx(CRTC,5,0x80,r3 << 2);
  wrinx(CRTC,0x11,old);

}