/* fl.cmd - A FILELIST clone                                   960214 */

/* Work in progress :
 *
 * implementing 'CURSOR ...';
 * new options: (Append and (File;
 * using REXXUTILS instead of REXXLIB;
 */

'@echo off'; trace off

call main_init arg(1)
bg = VioReadCellStr(0,0)
w0 = 0 0;                     w0_x = word(w0,1); w0_y = word(w0,2)
w1 = 1 + (commandLine = 1) 6; w1_x = word(w1,1); w1_y = word(w1,2)
w3 = 1 + (commandLine = 1) 0; w3_x = word(w3,1); w3_y = word(w3,2)
w2 = commandLine 0;           w2_x = word(w2,1); w2_y = word(w2,2)
w4 = height+2 0;              w4_x = word(w4,1); w4_y = word(w4,2)
call drawall

/* main loop */
do until quit
   if file.level._CURRENT \= commandLine then do
      item = file.level._TOP + file.level._CURRENT - 1
      if item > file.level.0 then do
         item = file.level.0
         if item < file.level._TOP then do
            file.level._TOP = max(1, item - file.level._CURRENT + 1)
            file.level._CURRENT = 0
            call show
            end
         file.level._CURRENT = item - file.level._TOP + 1
         end
      else
      if item < 2 then do
         item = 2
         file.level._CURRENT = 3 - file.level._TOP
         end
      if file.level._WIDE then do
         if file.level._COL = 1 then file.level._COL = 7
         if file.level._COL = 6 then file.level._COL = width
         item = (item-2)*file.level._NCOL + 2 + (file.level._COL-7) % file.level._MAXWIDTH
         if item > file.level.0 then do
            item = file.level.0
            file.level._CURRENT = 3 + (item - file.level._TOP*file.level._NCOL) % file.level._NCOL
            end
         end
      end
   else do
      if redrawCL then do
         call VioWrtCharStr w2_x, w2_y+6, left(command_line, fwidth)
         redrawCL = 0
         end
      item = 2 + (file.level._TOP + currentLine - 3) * file.level._NCOL
      if file.level._COL = 1 then file.level._COL = 7
      if file.level._COL = 6 then file.level._COL = width
      end
   if olditem \= item then do
      call VioWrtCharStr 0, itemnumber, right(item-1,4)
      olditem = item
      end
   call SysCurPos file.level._CURRENT, file.level._COL-1
   key = inkey()
   select
      when symbol('keys._'c2x(key)) = 'VAR' then call execute 'CMDKEY', value('keys._'c2x(key)), item
      when key = CURD then do
         file.level._CURRENT = file.level._CURRENT // (height + 1) + 1
         if file.level._WIDE = 0 & file.level._TOP + file.level._CURRENT - 1 > file.level.0 then file.level._CURRENT = commandLine
         if file.level._WIDE = 1 & (file.level._TOP + file.level._CURRENT - 3) * file.level._NCOL + 2 > file.level.0 then file.level._CURRENT = commandLine
         if file.level._CURRENT = commandLine then file.level._COL = 7
         end
      when key = CURU then do
         if file.level._CURRENT = 1 | file.level._TOP + file.level._CURRENT - 1 <= 2 then do
            file.level._CURRENT = commandLine
            file.level._COL = 7
            end
         else file.level._CURRENT = file.level._CURRENT - 1
         end
      when key = CURR then
         file.level._COL = 1 + file.level._COL // width
      when key = CURL then
         file.level._COL = 1 + (width+file.level._COL-2) // width
      when key = HOME then do
         if file.level._CURRENT = commandLine then do
            file.level._CURRENT = file.level._OLDCURRENT
            file.level._COL = file.level._OLDCOL
            end
         else do
            file.level._OLDCURRENT = file.level._CURRENT
            file.level._OLDCOL = file.level._COL
            file.level._CURRENT = commandLine
            file.level._COL = 7
            end
         end
      when key = ENTER then do
         if file.level._CURRENT = commandLine then do
            if command_line = '' then iterate
            command.cmdnum = command_line
            cmdpos = cmdnum
            cmdnum = cmdnum + 1
            call execute 'CMDLINE', command_line, item
            parse value '1 7' with redrawCL file.level._COL command_line
            end
         else do
            executed = 0
            do idCmd = 1 to file.level.0+1
               if symbol('file.'level'.PCMD.'idCmd) = 'VAR' & file.level.PCMD.idCmd \= '' then do
                  if file.level.PCMD.idCmd = '*' then do
                     drop file.level.PCMD.idCmd
                     iterate
                     end
                  if file.level.PCMD.idCmd \= '"' then
                     cl = file.level.PCMD.idCmd
                  call execute 'PREFIX', cl, idCmd
                  if cmdrc = 0 then
                     file.level.PCMD.idCmd = '*'
                  end
            end /* do */
            if executed then do
               say
               say 'Press any key to continue.'
               call inkey
               call VioWrtCellStr 0, 0, saved_screen
               end
            call show
            end
         if showlevel \= level then do
            level = showlevel
            call redraw
            end
         end
      when length(key) = 1 then call execute 'CMDKEY', 'TEXT 'key
      when key = F2 then
         if list_files(file.level._CURDIR) = 0 then
            call redraw
      when key = F10 then do
         command_line = command.cmdpos
         if cmdpos > 0 then cmdpos = cmdpos - 1
         else if cmdnum > 0 then cmdpos = cmdnum - 1
         call VioWrtCharStr w2_x, w2_y+6, left(command_line, fwidth)
         end
      when key = A_F10 then do
         if cmdnum > 0 then
            cmdpos = (cmdpos + 1) // cmdnum
         command_line = command.cmdpos
         call VioWrtCharStr w2_x, w2_y+6, left(command_line, fwidth)
         end
   otherwise
   end /* select */
end /* do */

call SysCurPos row, col
call VioWrtCellStr 0, 0, bg
exit

/* redraw current line */
redrawline:
   l = length(file.level.PCMD.item)
   if l < 6 then
      call VioWrtCharStrAttr file.level._CURRENT, 0, file.level._PREFIX.num.item ,,prefixattr
   else
   if l < width then
      if file.level._CURRENT = currentLine then
         call VioWrtCharStrAttr file.level._CURRENT, l, substr(file.level.item,l-2,1) ,,currentattr
      else
         call VioWrtCharStrAttr file.level._CURRENT, l, substr(file.level.item,l-2,1) ,,attr
   call VioWrtCharStrAttr file.level._CURRENT, 0, file.level.PCMD.item ,,prefixcmdattr
   return

/* redraw current screen */
drawall:
   call VioScrollUp w2_x, w2_y, w2_x, w2_y+width-1,255,, cmdattr
   do i = 1 to 12
      call w_put w4, 1, (i-1)*8 + 1, i//10, ,attr
      call w_put w4, 1, (i-1)*8 + 2, keyname.i, 7, msgattr
      end
redraw:
   fmode = left(filespec('D',file.level._CURDIR),1)
   fpath = filespec('P',file.level._CURDIR)
   call VioWrtCharStrAttr w2_x, 0, overlay('['wordpos(level,allLevels)']','====> '), ,arrowattr
   call VioWrtCharStrAttr w0_x, w0_y, left(left(file.level._CURDIR,width-23)||,
        right(word(SysDriveInfo(fmode),2)%1024,6)'K disk',width-11)||right(item-1,4)' of'right(file.level.0-1,4), ,msgattr
   call show
   return

/* execute CMDLINE, CMDKEY or PREFIX commands */
execute:
   cmd = arg(2)
   parse value '0 1 0' cmd with cmdrc ret nowait verb rest
   verb = alias(verb)
   if verb = 'SET' then do
      parse var rest verb rest
      verb = alias(verb)
      end
   select
      when verb = 'TEXT' then do
         rest = translate(rest,case,xrange('A','Z')xrange('a','z'))
         if file.level._CURRENT = commandLine then do
            command_line = insert(rest, command_line, file.level._COL - 7)
            redrawCL = 1
            end
         else do
            if symbol('file.'level'.PCMD.'item) = 'BAD' then iterate
            if symbol('file.'level'.PCMD.'item) = 'LIT' | file.level.PCMD.item = '*' then do
               file.level.PCMD.item = rest
               file.level._COL = 1
               end
            else
               file.level.PCMD.item = insert(rest, file.level.PCMD.item, file.level._COL - 1)
            call VioWrtCharStrAttr file.level._CURRENT, 0, file.level.PCMD.item ,,prefixcmdattr
            end
         file.level._COL = file.level._COL + length(rest)
         end
      when verb = 'SOS' then
         select
            when abbrev('DELBACK',translate(rest),5) then
               if file.level._CURRENT = commandLine then do
                  if file.level._COL <= 7 then return
                  file.level._COL = file.level._COL - 1
                  command_line = delstr(command_line, file.level._COL - 6, 1)
                  redrawCL = 1
                  end
               else
               if (file.level._COL > 1) & (symbol('file.'level'.PCMD.'item) = 'VAR') then do
                  file.level._COL = file.level._COL - 1
                  file.level.PCMD.item = delstr(file.level.PCMD.item, file.level._COL, 1)
                  call redrawline
                  end
            when abbrev('DELCHAR',translate(rest),4) then
               if file.level._CURRENT = commandLine then do
                  command_line = delstr(command_line, file.level._COL - 6, 1)
                  redrawCL = 1
                  end
               else
               if symbol('file.'level'.PCMD.'item) = 'VAR' then do
                  file.level.PCMD.item = delstr(file.level.PCMD.item, file.level._COL, 1)
                  call redrawline
                  end
            when abbrev('TABFIELDF',translate(rest),8) then
               select
                  when file.level._CURRENT = commandLine then do
                     file.level._CURRENT = 1
                     file.level._COL = 1+file.level._WIDE*6
                     end
                  when file.level._WIDE & file.level._COL-7 < file.level._MAXWIDTH*(file.level._NCOL-1) & item < file.level.0 then
                     file.level._COL = 7+(1+(file.level._COL-7)%file.level._MAXWIDTH)*file.level._MAXWIDTH
               otherwise
                  file.level._CURRENT = file.level._CURRENT // (height + 1) + 1
                  if file.level._WIDE = 0 & file.level._TOP + file.level._CURRENT - 1 > file.level.0 then file.level._CURRENT = commandLine
                  if file.level._WIDE = 1 & (file.level._TOP + file.level._CURRENT - 3) * file.level._NCOL + 2 > file.level.0 then file.level._CURRENT = commandLine
                  file.level._COL = 1+file.level._WIDE*6
               end  /* select */
            when translate(rest) = 'TABFIELDB' then
               select
                  when file.level._CURRENT = commandLine & file.level._COL = 7 then do
                     file.level._CURRENT = file.level._CURRENT - 1
                     file.level._COL = 1+file.level._WIDE*(6+(file.level._NCOL-1)*file.level._MAXWIDTH)
                     end
                  when file.level._COL = 1+6*file.level._WIDE & (file.level._CURRENT = 1 | file.level._TOP + file.level._CURRENT - 1 <= 2) then do
                     file.level._COL = 7
                     file.level._CURRENT = commandLine
                     end
                  when file.level._WIDE & file.level._COL > 7 then
                     file.level._COL = max(7,7+min(file.level._NCOL-1,(file.level._COL+file.level._MAXWIDTH-8)%file.level._MAXWIDTH-1)*file.level._MAXWIDTH)
                  when \file.level._WIDE & file.level._COL > 1 then file.level._COL = 1
               otherwise
                  file.level._CURRENT = file.level._CURRENT - 1
                  file.level._COL = 1+file.level._WIDE*(6+(file.level._NCOL-1)*file.level._MAXWIDTH)
               end  /* select */
            when abbrev('STARTENDCHAR',translate(rest),9) then do
               if file.level._CURRENT = commandLine then
                  len = length(command_line)
               else
                  len = length(file.level.item) - 3
               if file.level._COL = 7 + len then
                  file.level._COL = 7
               else
                  file.level._COL = 7 + len
               end
            when translate(rest) = 'UNDO' then do
               if file.level._CURRENT = commandLine then
                  parse value '1 7' with redrawCL file.level._COL command_line
               else do
                  drop file.level.PCMD.item
                  call VioWrtCharStrAttr file.level._CURRENT, 0, file.level._PREFIX.num.item ,,prefixattr
                  if file.level._CURRENT = currentLine then
                     call VioWrtCharStrAttr file.level._CURRENT, 6, left(substr(file.level.item,4),fwidth),, currentattr
                  else
                     call VioWrtCharStrAttr file.level._CURRENT, 6, left(substr(file.level.item,4),fwidth),, attr
                  end
               end
         otherwise
            call errormsg 'Error 0041: Invalid SOS command:' rest
         end  /* select */
      when verb = 'FLIST' & (arg(1) \= 'CMDLINE' | rest \= '') then do
         if rest = '' then rest = filename(arg(3))
         else if word(rest,1) = '/' then rest = filename(arg(3))'\*.*' subword(rest,2)
         iExec = 1
         do while wordpos(iExec, allLevels) \= 0
            iExec = iExec + 1
         end /* do */
         opath = fpath; omode = fmode; olevel = level
         level = iExec
         if list_files(rest) = 0 then do
            allLevels = subword(allLevels,1,wordpos(olevel, allLevels)) iExec subword(allLevels,wordpos(olevel,allLevels)+1)
            showlevel = iExec
            end
         fpath = opath; fmode = omode; level = olevel
         end
      when verb = 'HELP' then do
         iExec = 1
         do while wordpos(iExec, allLevels) \= 0
            iExec = iExec + 1
         end /* do */
         allLevels = subword(allLevels,1,wordpos(level, allLevels)) iExec subword(allLevels,wordpos(level,allLevels)+1)
         level = iExec
         count = 2
         helpFile = SysSearchPath('DPATH','fl.hlp')
         do while lines(helpFile)
            file.level.count = '   'linein(helpFile)
            file.level._PREFIX.0.count = left(fill,6)
            file.level._PREFIX.1.count = left(right(count-1,length(fill),'0'),6)
            count = count + 1
         end /* do */
         call stream helpFile, 'c', 'close'
         call initlevel helpFile, 'Help', 0, fwidth
         call redraw
         showlevel = level
         end
      when verb = 'TOP' then call execute arg(1), 'BACKWARD *'
      when verb = 'BOTTOM' then call execute arg(1), 'FORWARD *'
      when verb = 'FORWARD' | verb = 'BACKWARD' then do
         if rest = ''  then rest = 1
         if rest = '*' then do
            rest = file.level.0
            if file.level._CURRENT \= commandLine then file.level._CURRENT = currentLine
            end
         if verb = 'FORWARD' then do
            if file.level._TOP = file.level.0 - currentLine + 1 then return
            file.level._TOP = min(file.level._TOP + rest * height, file.level.0 - currentLine + 1)
            if file.level._WIDE then
               file.level._TOP = min(file.level._TOP, (file.level.0-2) % file.level._NCOL - currentLine + 3)
            end
         else do
            if file.level._TOP = -currentLine + 3 then return
            file.level._TOP = max(file.level._TOP - rest * height, -currentLine + 3)
            end
         call show
         end
      /* SET commands */
      when verb = 'COLOR' | verb = 'COLOUR' then do
         parse upper value rest with area rest
         select
            when abbrev('ARROW',area,1) then arrowattr = color(rest,arrowattr)
            when abbrev('CMDLINE',area,1) then cmdattr = color(rest,cmdattr)
            when abbrev('CURLINE',area,2) then currentattr = color(rest,currentattr)
            when abbrev('FILEAREA',area,1) then attr = color(rest,attr)
            when abbrev('IDLINE',area,1) then msgattr = color(rest,msgattr)
            when abbrev('MSGLINE',area,1) then error_attr = color(rest,error_attr)
            when abbrev('PENDING',area,1) then prefixcmdattr = color(rest,prefixcmdattr)
            when abbrev('PREFIX',area,2) then prefixattr = color(rest,prefixattr)
            when abbrev('STATAREA',area,2) then call color rest,0
            when abbrev('TOFEOF',area,2) then call color rest,0
         otherwise
            call errormsg 'Error 0001: Invalid operand:' area
         end  /* select */
         if \inprofile then
            call drawall
         end
      when verb = 'CASE' then
         select
            when abbrev('UPPER',translate(rest),1) then case = xrange('A','Z')xrange('A','Z')
            when abbrev('LOWER',translate(rest),1) then case = xrange('a','z')xrange('a','z')
            when abbrev('MIXED',translate(rest),1) then case = xrange('A','Z')xrange('a','z')
         otherwise
            call errormsg 'Error 0001: Invalid operand:' rest
         end  /* select */
      when verb = 'IMPOS' | abbrev('IMPCMSCP',verb,3) then
         if wordpos(translate(rest),'ON OFF') > 0 then
            impos = 2 - wordpos(translate(rest),'ON OFF')
         else
            call errormsg 'Error 0001: Invalid operand:' rest
      when abbrev('MSGLINE',verb,4) then interpret 'hLine =' subword(rest,2) '; IF hLine < 0 THEN hLine = 2 + height + hLine'
      when abbrev('NUMBER',verb,3) then
         if wordpos(translate(rest),'ON OFF') > 0 then do
            num = 2 - wordpos(translate(rest),'ON OFF')
            if \inprofile then
               call show
            end
         else
            call errormsg 'Error 0001: Invalid operand:' rest
      when abbrev('CURLINE',verb,4) then do
         interpret 'rest =' rest '; IF rest < 0 THEN rest = 1 + height + rest'
         if \inprofile then
            file.level._TOP = file.level._TOP + currentLine - rest
         currentLine = rest
         if \inprofile then
            call show
         end
      /* end of SET commands */
      when verb = 'QUIT' then do
         if words(allLevels) = 1 then do
            quit = 1
            return
            end
         drop file.level.
         level = wordpos(level,allLevels)
         allLevels = delword(allLevels,level,1)
         level = level - 1
         if level = 0 then level = words(allLevels)
         level = word(allLevels,level)
         showlevel = level
         call redraw
         end
      when verb = 'OSNOWAIT' | verb = 'DOSNOWAIT' then
         parse value '0 1' rest with ret nowait cmd
      when verb = 'RUN' | verb = 'OS' | verb = 'DOS' then do
         if rest = '' | translate(rest) = '/O' then
            cmd = value('comspec',,'OS2ENVIRONMENT') '/o'
         else
            cmd = rest
         ret = 0
         end
      when verb = 'NEXTWINDOW' | (verb = 'FLIST' & rest = '' & arg(1) = 'CMDLINE') then do
         nlevel = 1 + wordpos(level,allLevels)
         if nlevel > words(allLevels) then nlevel = 1
         showlevel = word(allLevels,nlevel)
         if level \= showlevel then do
            level = showlevel
            call redraw
            end
         end
      when verb = 'RESET' then do
         rest = translate(rest)
         if (rest = 'ALL') | abbrev('PREFIX',rest,1) then
            do idx = 1 to file.level.0+1
               drop file.level.PCMD.idx
            end /* do */
         call show
         end
      when verb = 'CCANCEL' & arg(1) = 'CMDLINE' then quit = 1
      when verb = '/' then file.level._TOP = item - currentLine + 1
      when verb = 'NEXT' | verb = 'DOWN' then do
         if rest = '' then rest = 1
         if rest = '*' then
            file.level._TOP = file.level.0 - currentLine + 1
         else
            file.level._TOP = min(file.level._TOP + rest, file.level.0 - currentLine + 1)
         if file.level._WIDE then
            file.level._TOP = min(file.level._TOP, (file.level.0-2) % file.level._NCOL - currentLine + 3)
         call show
         end
      when verb = 'UP' then do
         if rest = '' then rest = 1
         if rest = '*' then
            file.level._TOP = -currentLine+3
         else
            file.level._TOP = max(file.level._TOP - rest, -currentLine+3)
         call show
         end
      when verb = 'DEFINE' then do
         parse var rest key rest
         if length(key) > 1 then
            key = value(translate(key,'_','-'))
         if rest \= '' then
            call value 'keys._'c2x(key), rest
         else
            interpret 'drop keys._'c2x(key)
         end
      when verb = 'SHOWKEY' then do
         msg = 'Press the key to be translated...spacebar to exit'
         do forever
            key = errormsg(msg)
            if key = ' ' then leave
            if symbol('keys._'c2x(key)) = 'VAR' then
               msg = 'Key: 'key' - assigned to '''value('keys._'c2x(key))''''
            else
               msg = 'Key: 'key' - unassigned'
         end /* do */
         end
   otherwise
      if impos then
         ret = 0
      else
         call errormsg 'Error 0000: Invalid command: 'cmd
   end /* select */
   if ret then
      return
   if arg(1) \= 'PREFIX' | \ executed then do
      saved_screen = VioReadCellStr(0,0,(height+3)*width*2)
      call SysCls
      executed = 1
      end
   prompt = prompt()
   signal on halt
   if arg(1) \= 'CMDLINE' then
      cmd = substitute(cmd,arg(3))
   else
      cmd = substitute(cmd '/o',arg(3))
   say prompt||cmd
   address cmd cmd
   cmdrc = rc
after_halt:
   if arg(1) \= 'PREFIX' then do
      if \ nowait then do
         say
         say 'Press any key to continue.'
         call inkey
         end
      call VioWrtCellStr 0, 0, saved_screen
      end
   return

/* handle control break */
/* this should be activated only from the 'execute' routine */
halt:
   signal after_halt

/* parse command line & perform substitutions */
substitute: procedure expose file. fmode fpath level
   parse arg verb rest, item
   if verb = '/' then do
      parse arg rest, item
      verb = ''
      end
   parse value '0 0' with state subst tail
   parse var file.level.item 4 fdate ftime fsize fileid
   fileid = strip(fileid)
   if pos('.',fileid) \= 0 then do
      fn = substr(fileid,1,lastpos('.',fileid)-1)
      ft = substr(fileid,lastpos('.',fileid)+1)
      end
   else do
      fn = fileid
      ft = ''
      end
   do i = 1 to length(rest)
      c = translate(substr(rest,i,1))
      select
         when state = 0 then do
            if c = '/' then state = 1
            else tail = tail||substr(rest,i,1)
            end
         when state = 1 then do
            select
               when c = 'N' then do
                  tail = tail||fn
                  subst = 1
                  end
               when c = 'T' | c = 'E' then do
                  tail = tail||ft
                  subst = 1
                  end
               when c = 'D' | c = 'M' then do
                  tail = tail||fmode':'
                  subst = 1
                  end
               when c = 'P' then do
                  tail = tail||fpath
                  subst = 1
                  end
               when c == ' ' then do
                  tail = tail||filename(item)||' '
                  subst = 1
                  end
               when c = 'O' then do
                  subst = 1
                  end
            otherwise do
               tail = tail||substr(rest,i,1)
               end
            end /* inner select */
            state = 0
            end /* do group */
      end /* outer select */
   end /* outer loop */

   if state then tail = tail||filename(item)

   if \subst then do
      fname = filename(item)
      if tail \== '' then
         tail = tail fname
      else
         tail = fname
      end

   verb = alias(verb)
   return verb tail

/* compute a file name */
filename: procedure expose file. fmode fpath level
   arg item
   parse var file.level.item 4 fdate ftime fsize fileid
   fileid = fmode':'||fpath||strip(fileid)

   if pos(' ',fileid) \= 0 then
      return '"'fileid'"'
   else
      return fileid

/* expand the OS/2 prompt */
prompt: procedure
   prmpt = value('PROMPT',,'OS2ENVIRONMENT')
   if (prmpt == '') then
      prmpt = '[$p]'

   str = ''

   do i = 1 to length(prmpt)
      key = substr(prmpt,i,1)
      if (key = '$') then
         do
         i = i+1; key = translate(substr(prmpt,i,1))
         select
            when key = '$' then str = str||'$'
            when key = 'A' then str = str||'&'
            when key = 'B' then str = str||'|'
            when key = 'C' then str = str||'('
            when key = 'D' then str = str||date()
            when key = 'E' then str = str||'1b'x
            when key = 'F' then str = str||')'
            when key = 'G' then str = str||'>'
            when key = 'H' then str = str||'08'x
            when key = 'I' then nop
            when key = 'L' then str = str||'<'
            when key = 'N' then str = str||filespec("d",directory())
            when key = 'P' then str = str||directory()
            when key = 'Q' then str = str||'='
            when key = 'R' then str = str||rc
            when key = 'S' then str = str||' '
            when key = 'T' then str = str||time()
            when key = 'V' then str = str||'Operating System/2 version' SysOS2Ver()
            when key = '_' then str = str||'0d'x
         otherwise
            str = str||substr(prmpt,i,1)
         end  /* select */
         end
      else
         str = str||key
   end /* do */
   return str

/* compute a command alias */
alias:
   word = translate(arg(1))
   do i = 1 by 1 while symbol('abbr.i.name') = 'VAR'
      if abbrev(abbr.i.name,word,abbr.i.min) then
         return abbr.i.name
   end /* do */
   return word

/* expand file spec */
expandspec:
   fmode = filespec('d',arg(1))
   fpath = filespec('p',arg(1))
   fname = filespec('n',arg(1))
   if fmode = '' then
      fmode = filespec('d',directory())
   if fpath = '' then
      fpath = doscd(substr(fmode,1,1))
   if right(fpath,1) \= '\' then
      fpath = fpath||'\'
   if fname = '' then
      fname = '*'
   if pos('*',fname) = 0 then
      fname = fname||'\*'
   if \fileexists then do
      fileexists = stream(fmode||fpath||fname,'c','query exists') \= ''
      if \fileexists then do
         call SysFileTree fmode||fpath||fname, FEXIST.
         fileexists = (FEXIST.0 \= 0)
         end
      end
   return fmode||fpath||fname

/* build the list of files */
list_files:
   drop file.level.
   parse arg list '(' options
   if list = '' then
      list = '*'
   filespec = ''
   fileexists = 0
   do while list \= ''
      parse value list with pre '"' main '"' list
      do i = 1 to words(pre)
         filespec = filespec expandspec(word(pre,i))
      end /* do */
      if main \= '' then
         filespec = filespec '"'expandspec(main)'"'
   end /* do */
   filespec = strip(filespec)

   /* scan options */
   parse value '0 0' translate(options) with tree_option sort_option options
   do i = 1 to words(options)
      opt = word(options,i)
      if abbrev('TREE',opt,2) then
         tree_option = 1
      else if abbrev('SORTD',opt,4) | abbrev('SORTA',opt,4) then
         sort_option = 1
   end /* do */

   if \tree_option & \fileexists then do
      call errormsg 'Error 0009: Files not found:' filespec
      return 2
      end

   if sort_option then
      sort = ''
   else do
      if tree_option then
         sort = 'sort path sortd d'
      else
         sort = 'sort n'
      end

   call listfile filespec '(' sort options
   count = file.level.0
   if rc \= 0 then
      return 1
   return 0

/* show the list of files */
show:
   if file.level._WIDE \= 1 then
      do i = 0 to height-1
         index = file.level._TOP + i; delta = w1_x+i /* = w3_x+i */
         if index < 1 | index > 1 + file.level.0 then do
            call VioWrtCharStrAttr delta, w3_y, prefixSpace,,prefixattr
            call VioWrtCharStrAttr delta, w1_y, mainSpace,,attr
            iterate
            end
         call VioWrtCharStrAttr delta, w3_y, file.level._PREFIX.num.index,,prefixattr
         if i+1 = currentLine then
            call VioWrtCharStrAttr delta, w1_y, left(substr(file.level.index,4),fwidth) ,,currentattr
         else
            call VioWrtCharStrAttr delta, w1_y, left(substr(file.level.index,4),fwidth) ,,attr
         if (symbol('file.'level'.PCMD.'index) = 'VAR') then
            call VioWrtCharStrAttr delta, 0, file.level.PCMD.index ,,prefixcmdattr
      end /* do */
   else
      do i = 1 to height
         index = file.level._TOP + i - 1
         if index <= 1 | 3+(index-2)*file.level._NCOL > 1 + file.level.0 then do
            call w_put w3, i, 1, '      ', ,prefixattr
            if index < 1 | 3+(index-3)*file.level._NCOL > 1 + file.level.0 then call w_put w1, i, 1, '', fwidth, attr
            else
            if index = 1 then call w_put w1, i, 1, substr(file.level.1,4), fwidth, attr
            else
               call w_put w1, i, 1, substr(value('file.level.'file.level.0+1),4), fwidth, attr
            iterate
            end
         index = 2+(index-2)*file.level._NCOL
         shortnames = ''
         call w_put w3, i, 1, file.level._PREFIX.num.index, ,prefixattr
         do j = index to index+file.level._NCOL-1
            if substr(file.level.j,31,1) = '>' then
               shortnames = shortnames||'['substr(file.level.j']',34,file.level._MAXWIDTH-1)
            else
               shortnames = shortnames||substr(file.level.j,34,file.level._MAXWIDTH)
         end /* do */
         if i = currentLine then
            call w_put w1, i, 1, shortnames, fwidth, currentAttr
         else
            call w_put w1, i, 1, shortnames, fwidth, attr
      end /* do */
   return

/* show error messages */
errormsg:
   if inprofile then do
      say arg(1)
      return
      end
   save1 = VioReadCellStr(hline-1,0,width*2)
   call VioWrtCharStrAttr hline-1, 0, left(arg(1),width), width, error_attr
   key = inkey()
   call VioWrtCellStr hline-1, 0, save1
   return key

/* simulate listfile command */
listfile: procedure expose file. rc height fill level currentLine commandLine olevel fwidth
   parse arg names '(' options
   parse value '0 0 /NAME /EXT /SIZE /DATE' with wide sorts sort_types
   do i = 1 to words(options)
      opt = translate(word(options, i))
      select
         when opt = 'SORT' | opt = 'SORTA' then do
            if i = words(options) then
               break
            i = i + 1
            sorts = sorts + 1
            x = pos('/'translate(word(options, i)), sort_types)
            parse var sort_types =(x) '/' sortype .
            sort.sorts = sortype 'a'
            end
         when opt = 'SORTD' then do
            if i = words(options) then
               break
            i = i + 1
            sorts = sorts + 1
            x = pos('/'translate(word(options, i)), sort_types)
            parse var sort_types =(x) '/' sortype .
            sort.sorts = sortype 'd'
            end
         when abbrev('WIDE',opt,1) | abbrev('(WIDE',opt,2) then wide = 1
         when opt = 'APPEND' | opt = '(APPEND' then nop
      otherwise
      end /* select */
   end /* do */

   count = 1
   do while names \= ''
      parse value names with file _ '"' main '"' names
      select
         when file = '' & main = '' then iterate
         when file = '' then file = main
         when main = '' then names = _ names
      otherwise
         names = _ '"'main'"' names
      end  /* select */
      lastfile = file

      /* SysFileTree is broken when used w/ TVFS, so I've to check... */
      if word(SysDriveInfo(filespec('D',file)),4) = 'TVFS' then
         call SysFileTree file, 'temp', 'D'
      else
         call SysFileTree file, 'temp'

      maxwidth = 0
      do j = 1 to temp.0
         parse var temp.j dt tm sz at fid
         count = count + 1
         fspec = filespec('n', fid)
         x = lastpos('.', fspec)
         if x = 0 then do
            fn = fspec
            ft = ''
            end
         else do
            fn = left(fspec, x-1)
            ft = substr(fspec, x+1)
            end
         if pos('D',at) \= 0 then do
            sz = '<dir>'
            end
         file.level.count = left(ft,3)right(dt, 8)'  'right(tm,6)'  'right(sz,10)'  'fspec
         maxwidth = max(maxwidth,length(fspec)+2*(pos('D',at) \= 0))
         file.level._PREFIX.0.count = left(fill,6)
         file.level._PREFIX.1.count = left(right(count-1,length(fill),'0'),6)
      end /* do */
   end /* do */
   count = count+1
   call initlevel lastfile, "List", wide, maxwidth

   /* build an arglist for arraysort */
   sortspec = ''
   do i = 1 to sorts
      parse var sort.i type direction
      select
         when type = 'DATE' then
            sortspec = sortspec||'10,2,"'direction'","c",4,5,"'direction'","c",'
         when type = 'NAME' then
            sortspec = sortspec||'34,,"'direction'","c",'
         when type = 'EXT' then
            sortspec = sortspec||'1,3,"'direction'","c",34,,"a","c",'
         when type = 'SIZE' then
            sortspec = sortspec||'22,10,"'direction'","c",'
      otherwise
      end /* select */
   end /* do */
/*   interpret 'call arraysort "file."level,2,count-2,'strip(sortspec,'t',',') */
   rc = 0
   return

/* initialize level data  --  arg(1) is level title & arg(2) is level type */
initlevel:
   file.level.1 = "    Top Of "arg(2)" "
   file.level._PREFIX.0.1 = '      '
   file.level._PREFIX.1.1 = '      '
   file.level.count = "    Bottom Of "arg(2)" "
   file.level._PREFIX.0.count = '      '
   file.level._PREFIX.1.count = '      '
   file.level._TOP = -currentLine+3
   file.level._CURRENT = commandLine
   file.level._COL = 7
   file.level._OLDCOL = 7
   file.level._OLDCURRENT = 2
   file.level._CURDIR = arg(1)
   file.level._WIDE = arg(3)
   file.level._MAXWIDTH = arg(4)+2
   if arg(3) then
      file.level._NCOL = fwidth % (arg(4)+2)
   else
      file.level._NCOL = 1
   file.level.0 = count-1
   return

/* initialize data and global variables */
main_init:

   if RxFuncQuery("SysLoadFuncs") then
      do
      call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
      call SysLoadFuncs
      end

   if RxFuncQuery("VioLoadFuncs") then
      do
      call RxFuncAdd 'VioLoadFuncs', 'REXXVIO', 'VioLoadFuncs'
      call VioLoadFuncs
      end

   ESC = '1b'x;                     keys._1B   = 'sos undo'
   ENTER = '0d'x
   BKSP = '08'x;                    keys._08   = 'sos delback'
   TAB = '09'x;                     keys._09   = 'sos tabfieldf'
   S_TAB = '000F'x;                 keys._000F = 'sos tabfieldb'
   DEL = '0053'x;                   keys._0053 = 'sos delchar'
   CURU = '0048'x
   CURD = '0050'x
   CURL = '004b'x
   CURR = '004d'x
   PGUP = '0049'x;                  keys._0049 = 'backward 1'
   PGDN = '0051'x;                  keys._0051 = 'forward 1'
   C_PGUP = '0084'x;                keys._0084 = 'backward *'
   C_PGDN = '0076'x;                keys._0076 = 'forward *'
   HOME = '0047'x
   END = '004F'x;                   keys._004F = 'sos startendchar'
   F1 = '003b'x;                    keys._003B = 'help'
   F2 = '003c'x
   F3 = '003d'x;                    keys._003D = 'quit'
   F4 = '003e'x;                    keys._003E = 'the'
   F5 = '003f'x;                    keys._003F = 'copy / a:'
   F6 = '0040'x;                    keys._0040 = 'copy / b:'
   F7 = '0041'x
   F8 = '0042'x;                    keys._0042 = 'os'
   F9 = '0043'x;                    keys._0043 = 'osnowait call less'
   F10 = '0044'x
   F11 = '0085'x
   F12 = '0086'x;                   keys._0086 = 'nextwindow'
   A_F10 = '0071'x

   /* abbreviations */
   abbr.1.name = 'FB';              abbr.1.min = 1
   abbr.2.name = 'BROWSE';          abbr.2.min = 1
   abbr.3.name = 'FLIST';           abbr.3.min = 2
   abbr.4.name = 'RESET';           abbr.4.min = 3
   abbr.5.name = 'NEXTWINDOW';      abbr.5.min = 5
   abbr.6.name = 'CCANCEL';         abbr.6.min = 2
   abbr.7.name = 'BOTTOM';          abbr.7.min = 3
   abbr.8.name = 'BACKWARD';        abbr.8.min = 2
   abbr.9.name = 'FORWARD';         abbr.9.min = 2
   abbr.10.name = 'NEXT';           abbr.10.min = 1
   abbr.11.name = 'UP';             abbr.11.min = 1
   abbr.12.name = 'DOWN';           abbr.12.min = 1
   abbr.13.name = 'SHOWKEY';        abbr.13.min = 4
   abbr.14.name = 'DEFINE';         abbr.14.min = 3
   abbr.15.name = 'OSNOWAIT';       abbr.15.min = 3
   abbr.16.name = 'DOSNOWAIT';      abbr.16.min = 4

   parse value '1 1 1' SysTextScreenSize() SysCurPos(),
         with showlevel level allLevels height width row col command_line command.

   height = height - 3

   parse value height%2 width-11 '2 0 0 0 0 0 0 ======',
         with M itemnumber item olevel cmdpos cmdnum redrawCL quit executed fill

   /* main area color */
   parse value '116 23 49 49 49 113 116 31',
         with error_attr attr cmdattr arrowattr prefixattr msgattr prefixcmdattr currentattr

   /* SETtable values */
   parse value xrange('A','Z')xrange('a','z') width-6 height+1 '0 1 7 2',
         with case fwidth commandLine num impos currentLine hLine

   prefixSpace = '      '
   mainSpace = copies(' ',fwidth)

   /* key names */
   keyname.1 = 'Help'
   keyname.2 = 'Refresh'
   keyname.3 = 'Exit'
   keyname.4 = 'Xedit'
   keyname.5 = 'Copy A'
   keyname.6 = 'Copy B'
   keyname.7 = ''
   keyname.8 = 'Shell'
   keyname.9 =  'FB'
   keyname.10 = 'Recall'
   keyname.11 = ''
   keyname.12 = 'NextW'

   /* profile support */
   profileName = 'profile.fl'

   parse upper value arg(1) with _ '(N' +0 profile
   if abbrev('(NOPROFILE',word(profile,1),2) then
      profileName = ''

   parse upper value arg(1) with _ '(P' +0 profile
   if abbrev('(PROFILE',word(profile,1),2) then
      profileName = word(profile,2)

   inprofile = 1
   if profileName \= '' then
      profileFile = SysSearchPath('DPATH',profileName)
   if profileFile \= '' then do
      do while lines(profileFile)
         line = linein(profileFile)
         if left(line,1) = "'" | left(line,1) = '"' then
            call execute 'CMDLINE', strip(line,,left(line,1))
         else
            interpret line
      end /* do */
      call stream profileFile, 'c', 'close'
      end
   if list_files(arg(1)) \= 0 then
      exit 3
   inprofile = 0

   return

/* convert color name */
color: procedure expose hline width error_attr inprofile
   arg word1 rest
   parse value '0 0 BLACK BLUE GREEN CYAN RED MAGENTA YELLOW WHITE' with col bg name
   do while word1 \= ''
      select
         when \bg & word1 = 'BLINK' then col = col + 128
         when \bg & wordpos(word1,'BOLD BRIGHT HIGH') > 0 then col = col + 8
         when \bg & wordpos(word1,name) > 0 then do
            col = col + wordpos(word1,name) - 1
            bg = 1
            end
         when bg & wordpos(word1,name) > 0 then col = col + 16 * (wordpos(word1,name)-1)
      otherwise
         call errormsg 'Error 0001: Invalid operand:' word1
         return arg(2)
      end  /* select */
      parse value rest with word1 rest
   end /* do */
   return col

/* quick and dirty rexxlib replacement funcs */
doscd: procedure
  arg drive
  current = directory()
  specified = directory(drive':')
  call directory current
  return substr(specified,3)

w_put:
  if arg(5) = '' then
    return VioWrtCharStrAttr(word(arg(1),1)+arg(2)-1,word(arg(1),2)+arg(3)-1,arg(4),,arg(6))
  else
    return VioWrtCharStrAttr(word(arg(1),1)+arg(2)-1,word(arg(1),2)+arg(3)-1,left(arg(4),arg(5)),arg(5),arg(6))

inkey: procedure
  key  = SysGetKey("NOECHO")
                         
  if (key = "E0"x) | (key = "00"x) then        
    return "00"x || SysGetKey("NOECHO")
  else
    return key
