/**************************************************************************/
/* This REXX command file is an example of how to use CALLDLL.DLL to      */
/* call a 16 bit program, compiled with Micro Focus COBOL.  It uses       */
/* CALLDLL.DLL to call EXAMPLE.DLL.  EXAMPLE.DLL has two 01 level         */
/* records in it's linkage section.  Two numbers are passed in first      */
/* 01 level.  The two numbers are divided and the quotient and remainder  */
/* are placed in the second parameter.                                    */
/**************************************************************************/

if RXFUNCQUERY('CallDLLLoadFuncs') then do
    call RXFUNCADD 'CallDLLLoadFuncs', 'CALLDLL', 'CallDLLLoadFuncs'
    call CallDLLLoadFuncs
end

numerator = '00100'
denominator = '00030'
FirstParameter = numerator denominator
SecondParameter = left('', 11)

call CallDLL 'EXAMPLE', 'FirstParameter', 'SecondParameter'

parse var SecondParameter quotient remainder

say
say numerator 'divided by' denominator 'results in:'
say
say '    quotient =' quotient
say '   remainder =' remainder

numerator = '99999'
denominator = '03333'
FirstParameter = numerator denominator

call CallDLL 'EXAMPLE', 'FirstParameter', 'SecondParameter'

parse var SecondParameter quotient remainder

say
say numerator 'divided by' denominator 'results in:'
say
say '    quotient =' quotient
say '   remainder =' remainder

call CallDLLDropFuncs

exit
