/*****************************************************************
*
* PROJECT:        Swiss Perfect 3
*
* FILE:           l_types.h
*
* DESCRIPTION:    General type definitions.
*
* AUTHOR:         Robert Rozycki   rozycki@perth.dialix.oz.au
*
* PORTABILITY:    ANSI C++
*
* $Revision: 1.2 $
*
* $Date: 1996/03/30 11:09:24 $
*
*******************************************************************/

#ifndef _L_TYPES_H
#define _L_TYPES_H

typedef unsigned long         Uint32;
typedef long                  Sint32;
typedef unsigned long         Ulong;

typedef unsigned short int    Uint16;
typedef short int             Sint16;
typedef unsigned short int    word;
typedef unsigned int		      Uint;

typedef unsigned char 	      Uint8;
typedef char                  Sint8;
typedef unsigned char 	      byte;

#define  TRUE           1
#define  FALSE          0

typedef int 	         boolean;

#define SUCCESS         0
#define FAIL            -1
#define FAILURE         FAIL
#define OUT_OF_MEM     -2

#define SYSTEM_ERROR   -100

#define min(a,b) (((a) < (b)) ? (a) : (b))
#define max(a,b) (((a) > (b)) ? (a) : (b))

#endif _L_TYPES_H

