/*****************************************************************
*
* PROJECT:        Swiss Perfect 3
*
*                 Copyright (C) 1996 Robert Rozycki
*                 SwissPerfect General Public Licence
*
* FILE:           sp3rtg.h
*
* DESCRIPTION:
*
* AUTHOR:         Robert Rozycki   rozycki@perth.dialix.oz.au
*
* PORTABILITY:    ANSI C++
*
* $Revision: 1.1 $
*
* $Date: 1996/03/30 11:11:12 $
*
* $Log: sp3rtg.h $
 * Revision 1.1  1996/03/30  11:11:12  robert
 * Initial revision
 *
*
*******************************************************************/

#ifndef _SP3RTG_H
#define _SP3RTG_H

#include "l_types.h"
#include "sp3sctyp.h"

typedef struct
{
   int  rtg_sys;
   int  low_thresh;
   int  low_women_thresh;
   int  max_diff_up;
   int  max_diff_dn;
   int  ignore_forfeits;
   int  played_only;
} RtgOptions_t;


typedef struct
{
   int oppon_no;
   int oppon_rtg;
   int score;
   int type;
   int games;
} RtgRes_t;


typedef struct {
   int  rated;
   int  score;
   int  games;
   long exp_score;
   int  own_rtg;
   int  perf_rtg;
   int  aver_rtg;
   int  gain;
   long rtg_sum;
} RtgSummary_t;


class Ratings_c
{
protected:
   RtgOptions_t Options;

public:
   Ratings_c();
  ~Ratings_c();

   RtgSummary_t CalcFromResults( int own_rtg, RtgRes_t *scores, int count,
                           int incl );
   RtgSummary_t Calculate( RtgSummary_t & );

   RtgOptions_t GetOptions() { return Options; };
   void         SetOptions( RtgOptions_t options ) { Options = options; };

protected:
   void PrepRtgInfo( RtgSummary_t&, int rtg, RtgRes_t *, int count, int incl );
   int  AverageRtg( int system, int player, RtgSummary_t *summary );
   int  PerformDelta( int score, int games );
   int  ExpectedScore( int rtg_diff );
   int  AddGameResult( RtgRes_t *res, int& score, int& games );
   int  UnratedPerformance( RtgSummary_t& rtg_summ );
   int  AdjustOpponRating( int own_rtg, int oppon_rtg );
   int  ValidGame( RtgRes_t *res );
};


class RoRoRatings_c : public Ratings_c
{
public:
   RoRoRatings_c();
  ~RoRoRatings_c();
   void CalcAllFromResults( RtgSummary_t *, RtgRes_t **, int players,
                           int rounds );
   void CalculateAll( RtgSummary_t *summ, int players,
                      int avers_in = FALSE );

protected:
   int  AverRtgForUnrated ( RtgSummary_t *, int players );
   int  AverRtgForUnrated ( RtgSummary_t *, RtgRes_t *, int rounds,
                            int& games, int own_rtg = 0);

   void AverRtgForAllRated( RtgSummary_t *, int players );
   void AverRtgForAllRated( RtgSummary_t *, RtgRes_t **, int rounds,
                            int players );

   void GetAversIn( RtgSummary_t *summ, int players );

   int RoRoTrnAver;
};

#endif