/*****************************************************************
*
* PROJECT:        Swiss Perfect 3
*
* FILE:           sp3sctyp.h
*
* DESCRIPTION:    Definitions for scores/results.
*
* AUTHOR:         Robert Rozycki   rozycki@perth.dialix.oz.au
*
* PORTABILITY:    ANSI C++
*
* $Revision: 1.1 $
*
* $Date: 1996/03/30 11:09:45 $
*
*******************************************************************/

#ifndef _SP3SCTYP_H
#define _SP3SCTYP_H

//////////////////////////////////////////////////////////
// score types definitions

#define FORFEIT_FLAG       0x80 // for easy forfeit detection

#define NOT_PLAYED         0
#define NORMAL_PLAYED      1
#define WHITE_FORFEIT    ( 2 | FORFEIT_FLAG )
#define BLACK_FORFEIT    ( 3 | FORFEIT_FLAG )
#define DOUBLE_FORFEIT   ( 4 | FORFEIT_FLAG )
#define BYE                5
#define PAUSE              6

//////////////////////////////////////////////////////////
// game result as stored RoundTab

#define MAX_SCORE_STR   10
#define MAX_HALF_SCORE  ( MAX_SCORE_STR / 2 )

typedef struct {
   char w_str[ MAX_HALF_SCORE ];
   char b_str[ MAX_HALF_SCORE ];
   char separ;
} DISP_SCORE;

#endif
