/*****************************************************************
*
* PROJECT:        Swiss Perfect 3
*
* FILE:           sp3util.cpp
*
* DESCRIPTION:    Programming utilities.
*
* AUTHOR:         Robert Rozycki   rozycki@perth.dialix.oz.au
*
* PORTABILITY:    ANSI C++
*
* $Revision: 1.2 $
*
* $Date: 1996/03/30 11:15:05 $
*
*******************************************************************/

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "sp3util.h"

///////////////////////////////////////////////////////////////////
//
// Converts a string to upper case.
// Returns pointer to the string.
//
char *uUpperString( char *str )
{
   int i, len;

   len = strlen( str );
   for( i = 0; i < len; i++ )
      str[i] = (char)toupper( str[i] ); 
   return str;
}

//////////////////////////////////////////////////////////////////
//
// Int division with different rounding methods.
//

enum { DD_POS_DS_NEG, DD_POS_DS_POS, DD_NEG_DS_POS, DD_NEG_DS_NEG };

long uIntDiv( long dividend, long divisor, int mode )
{
   long result, int_result, remainder;
   int status;


   if( dividend == 0 || divisor == 0 )
      return 0;
   if( dividend > 0 )
   {
      if( divisor > 0 )
         status = DD_POS_DS_POS;
      else
         status = DD_POS_DS_NEG;
   }
   else
   {
      if( divisor > 0 )
         status = DD_NEG_DS_POS;
      else
         status = DD_NEG_DS_NEG;
   }
   int_result = dividend / divisor;
   remainder  = dividend % divisor;

   if( mode == ROUND_NEAREST )
   {
      if( ( abs(remainder) * 2 >= abs(divisor) ) )
      {
         if( status == DD_POS_DS_POS || status == DD_NEG_DS_NEG )
            mode = ROUND_UP;
         else
            mode = ROUND_DOWN;
      }
      else
      {
         if( status == DD_POS_DS_POS || status == DD_NEG_DS_NEG )
            mode = ROUND_DOWN;
         else
            mode = ROUND_UP;
      }
   }

   switch( mode )
   {
      case ROUND_DOWN:
         if( remainder == 0 ||
                  status == DD_POS_DS_POS || status == DD_NEG_DS_NEG )
            result = int_result;
         else
            result = int_result - 1;
         break;
      case ROUND_UP:
         if( remainder == 0 ||
                  status == DD_NEG_DS_POS ||status == DD_POS_DS_NEG )
            result = int_result;
         else
            result = int_result+1;
         break;
      default:
         result = 0;
   }
   return result;
}

///////////////////////////////////////////////////////////////////
//
// Converts points in a result to a string
//
void uPoints2Str( int points, char *points_str, char draw_symbol )
{
   int points_int;
   int points_fra;
   char *p;

   points_int = points / 2;
   points_fra = (points % 2) * 5;

   sprintf( points_str, "%d", points_int );
   if( points == 1 && draw_symbol != 0 )
      points_str[0] = '\0';
   p = points_str + strlen( points_str );

   if( points_fra )
   {
      if( draw_symbol != '\0' )
      {
         p[0] = draw_symbol;
         p[1] = '\0';
      }
      else
         strcpy( p, ".5" );
   }
   else
   {
      if( draw_symbol == '\0' )
         strcpy( p, ".0" );
   }
}


///////////////////////////////////////////////////////////////////
//
// Converts string to result points
//
int uStrBuf2Points( char *buf )
{
   int points;
   char *p;

   if( buf == NULL )
      return 0;
   points = atoi( buf );
   points <<= 1;
   p = strchr( buf, '.' );
   if( (p != NULL) && (*(p+1) == '5' ) )
      points++;
   return points;
}

