/*****************************************************************
*
* PROJECT:        Rating Module Tester
*
*                 Copyright (C) 1996 Robert Rozycki
*                 SwissPerfect General Public Licence
*
* FILE:           trn_data.h
*
* DESCRIPTION:
*
* AUTHOR:         Robert Rozycki   rozycki@perth.dialix.oz.au
*
* PORTABILITY:    ANSI C++
*
* $Revision: 1.1 $
*
* $Date: 1996/03/30 11:08:37 $
*
*******************************************************************/

#ifndef _TRN_DATA_H
#define _TRN_DATA_H

#include "sp3rtg.h"    // for RtgOptions_t

typedef struct
{
   int oppon;
   int score;
   int type;
} Res_t;

#define MAX_RTG_SYSTEMS   2

typedef struct
{
   int   start_no;
   int   rtg[ MAX_RTG_SYSTEMS ];
   int   aver_rtg;
   int   rounds;
   int   score;
   Res_t *results;
} PlayerData_t;

enum { UNKNOWN_LINE, COMMENT_LINE, DATA_LINE, CONFIG_LINE, BEGIN_LINE };

enum { RESULTS_DATA, TOT_SCORES_DATA };
enum { TRNTYP_SWISS, TRNTYP_ROUND_ROBIN };

enum { ERR_NONE, ERR_NO_MEMORY, ERR_DUPL_STARTNO,
       ERR_UNKNOWN_TOKEN, ERR_UNKNOWN_PARAM, ERR_OUT_OF_SEQ,
       ERR_MIXED_FORMATS };

#define MAX_PARAMS         30
#define MAX_PARAM_NAME     25
#define MAX_PARAM_STRLEN   20


typedef struct {
   char name[ MAX_PARAM_NAME+1 ];
   int  value;
   char string[ MAX_PARAM_STRLEN ];
} Param_t;


typedef struct {
   int  line_type;
   int  data_mode;
   int  item_no;
   int  error;
} LineStat_t;


class TrnData_c {

public:
   TrnData_c();
   LineStat_t   ProcessLine( char *line );

   int   GetPlayerRtg( int player, int sys );
   int   GetAverRtg( int player, int sys = 0 );
   int   GetPlayerTotScore( int player );
   int   GetPlayerGames( int player );

   int   GetRoundsPlayed() { return RoundsPlayed; };
   int   GetPlayersCount() { return PlayersCount; };

   Res_t GetPlayerResult( int player, int round );

   int   GetDataMode() { return DataMode; };
   int   GetMultiGames();
   void  SetMultiGames( int multi_games ) { MultiGames = multi_games; };

   int   GetTrnType();
   void  SetTrnType( int trn_type ) { TrnType = trn_type; };

   int   GetParamValue( char *param_name, int *int_val, char **str_val );


protected:
   LineStat_t ParseDataLine( char *line, PlayerData_t& player );
   LineStat_t ParseConfigLine( char *line );

   int   GetLineType( char *line );
   int   IdentifyToken( char *token );
   int   ReadStartNo( char *token );
   int   ReadRtg( char *token );
   Res_t ReadResult( char *token );
   int   ReadTotScore( char *token, int& games );
   int   ReadIntParam( char *token );

   int   StrToScore( char *str, int& type, char draw_symb = '=' );

   int Allocated;
   int PlayersCount;
   int RoundsPlayed;
   int ByeEquiv;
   int DataMode;  // RESULTS or TOT_SCORES
   int TrnType;   // Swiss or Round-Robin
   int MultiGames;

   PlayerData_t PlayerData;
   PlayerData_t *CrossTab;
   Param_t      Params[ MAX_PARAMS ];

   RtgOptions_t  RtgOptions;

};

#endif
