// Last Updated 10/30/95
// Version: 2.1

#include "log.h"

void main(int argc, char *argv[])
{
	switch (argc)
	{  case 2:  if (strcmp(strupr(argv[1]),"/?") == 0)
				  displayhelp();
				else
				  if (strcmp(strupr(argv[1]),"/ND") == 0)
					DISPLAY = NO;
				  else
					strcpy(FILENAME,argv[1]);
				break;
	   case 3:  if (strcmp(strupr(argv[2]),"/?") == 0)
				  displayhelp();
				else
				  if (strcmp(strupr(argv[2]),"/ND") == 0)
					DISPLAY = NO;
				strcpy(FILENAME,argv[1]);
				break;
	   default: break;
	}
	initmainnwcalls();
	initnwcalls();
	getconninfo(connNumber);
	outputinfo();
} //main


void initmainnwcalls()
//initialize the main 3 nwcalls
{ WORD nwrc;

	nwrc = (NWCallsInit(NULL, NULL));
	if (nwrc != 0x0000)
	  {  clrscr();
		 printf("\nNWCallsInit failed: %04x",nwrc);
		 printf("\nCheck to make sure your NIC card initilized.");
		 printf("\nMake sure you can see the login directory on the server.");
		 exit(1);
	  }

	nwrc = (NWGetDefaultConnectionID(&connHandle));
	if (nwrc != 0x0000)
	  {  printf("\nNWGetDefaultConnectionID failed: %04x",nwrc);
		 printf("\nYou have an invalid connection, try rebooting.");
		 exit(1);
	  }

	nwrc = (NWGetConnectionNumber(connHandle, &connNumber));
	if (nwrc != 0x0000)
	  {  printf("\nNWGetConnectionNumber failed: %04x",nwrc);
		 printf("\nInvalid connection number.");
		 printf("\nYou might have lost your link to the server, reboot.");
		 exit(1);
	  }
} //initmainnwcalls

void initnwcalls()
//initialize other nwcalls
{  WORD nwrc;

	nwrc = (NWGetInetAddr(connHandle, connNumber,(NWINET_ADDR NWFAR *)&inetAddr));
	if (nwrc != 0x0000)
	  {  printf("\nNWGetInetAddr failed: %04x",nwrc);
		 printf("\nInvalid network address.");
		 printf("\nLogin to the server again.");
		 exit(1);
	  }

} //initnwcalls

int getconninfo(int cnum)
//get connection information based on connection number and connhandle
{  WORD nwrc;

	nwrc = NWGetConnectionInformation(connHandle, cnum, (char FAR *)objname, (WORD FAR *)&objtype, (DWORD FAR *)&objID,
												(BYTE FAR *)logintime);
	if (nwrc != 0x0000)
	  {  //printf("\nNWGetConnectionInformation failed: %04x",nwrc);
		   return(1);
	  }

  return(0);
} // getconninfo

void displayhelp()
{  clrscr();
   printf("\n\nLOG.EXE: Track users as the login to the network.\n");
   printf("\nSyntax: log PATH [/nd]");
   printf("\nPATH is the path to where you want the files created.");
   printf("\nIf no PATH is given, the directory where LOG.EXE was executed from is where");
   printf("\nthe files will be created.  All file names will be the date in YMD format.");
   printf("\nIf /nd is used, no output will be displayed on the screen.");
   printf("\nUse LOG.EXE in the system login script: #F:\\PUBLIC\\LOG.EXE F:\\PUBLIC\\\n");
   exit(1);
} // displayhelp

void outputinfo()
//output information gathered from function calls
{ FILE *outfile;
  char temp[3], tempfile[12];

  struct date d;

	getdate(&d);
	itoa(d.da_year,tempfile,10);
	itoa(d.da_mon,temp,10);
	strncat(tempfile,temp,2);
	itoa(d.da_day,temp,10);
	strncat(tempfile,temp,2);
//      strncat(FILENAME,"\\",1);
	strncat(FILENAME,tempfile);
	strncat(FILENAME,".LOG",4);

	if ((outfile = (fopen(FILENAME,"a+"))) == NULL)
	  {  printf("\nError opening %s",FILENAME);
		 printf("\nMake sure you have sufficient rights to the file.");
		 printf("\nMake sure the path exists. . .\n");
		 exit(1);
	  }

	if (DISPLAY == YES)
	  printf("\n%-10s on Conn. #%2d on %02d/%02d/%02d @ %02d:%02d:%02d     [%02X%02X%02X%02X]:[%02X%02X%02X%02X%02X%02X]\n",
	objname, connNumber, (int)logintime[1], (int)logintime[2],
	(int)logintime[0],(int)logintime[3],(int)logintime[4],(int)logintime[5],
	inetAddr.networkAddr[0],
	inetAddr.networkAddr[1],inetAddr.networkAddr[2],inetAddr.networkAddr[3],
	inetAddr.netNodeAddr[0],inetAddr.netNodeAddr[1],inetAddr.netNodeAddr[2],
	inetAddr.netNodeAddr[3],inetAddr.netNodeAddr[4],inetAddr.netNodeAddr[5]);

	fprintf(outfile,"\n%-10s on Conn. #%2d on %02d/%02d/%02d @ %02d:%02d:%02d     [%02X%02X%02X%02X]:[%02X%02X%02X%02X%02X%02X]",
	objname, connNumber, (int)logintime[1], (int)logintime[2],
	(int)logintime[0],(int)logintime[3],(int)logintime[4],(int)logintime[5],
	inetAddr.networkAddr[0],inetAddr.networkAddr[1],inetAddr.networkAddr[2],
	inetAddr.networkAddr[3],inetAddr.netNodeAddr[0],inetAddr.netNodeAddr[1],
	inetAddr.netNodeAddr[2],inetAddr.netNodeAddr[3],inetAddr.netNodeAddr[4],inetAddr.netNodeAddr[5]);

	fclose(outfile);

} //outputinfo
